/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.sprite.SpriteContainerEmpty;
import net.sourceforge.plantuml.project.LabelStrategy;
import net.sourceforge.plantuml.project.ToTaskDraw;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.core.TaskAttribute;
import net.sourceforge.plantuml.project.draw.AbstractTaskDraw;
import net.sourceforge.plantuml.project.draw.FingerPrint;
import net.sourceforge.plantuml.project.lang.CenterBorderColor;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.StyleSignatureBasic;

public class TaskDrawGroup
extends AbstractTaskDraw {
    private final Day end;
    private final double height = 10.0;

    public TaskDrawGroup(TimeScale timeScale, Real y, String prettyDisplay, Day start, Day end, Task task, ToTaskDraw toTaskDraw, StyleBuilder styleBuilder) {
        super(timeScale, y, prettyDisplay, start, task, toTaskDraw, styleBuilder);
        this.end = end;
    }

    @Override
    protected double getShapeHeight(StringBounder stringBounder) {
        TextBlock title;
        XDimension2D dim;
        Style style = this.getStyle();
        ClockwiseTopRightBottomLeft padding = style.getPadding();
        double pos1 = this.timeScale.getStartingPosition(this.start) + 6.0;
        double pos2 = this.timeScale.getEndingPosition(this.end) - 6.0;
        if (pos2 - pos1 > (dim = (title = this.getTitle()).calculateDimension(stringBounder)).getWidth()) {
            return dim.getHeight() + 2.0;
        }
        return dim.getHeight();
    }

    @Override
    public void drawTitle(UGraphic ug, LabelStrategy labelStrategy, double colTitles, double colBars) {
        double y;
        double pos;
        TextBlock title = this.getTitle();
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dim = title.calculateDimension(stringBounder);
        Style style = this.getStyleSignature().getMergedStyle(this.getStyleBuilder());
        ClockwiseTopRightBottomLeft margin = style.getMargin();
        ClockwiseTopRightBottomLeft padding = style.getPadding();
        double pos1 = this.timeScale.getStartingPosition(this.start) + 6.0;
        double pos2 = this.timeScale.getEndingPosition(this.end) - 6.0;
        if (pos2 - pos1 > dim.getWidth()) {
            pos = pos1 + (pos2 - pos1 - dim.getWidth()) / 2.0;
            y = 0.0;
        } else {
            pos = pos2 + 6.0;
            y = this.getFullHeightTask(stringBounder) - dim.getHeight();
        }
        title.drawU(ug.apply(new UTranslate(pos, y)));
    }

    @Override
    protected TextBlock getTitle() {
        return Display.getWithNewlines(this.prettyDisplay).create(this.getFontConfiguration(), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
    }

    @Override
    StyleSignature getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.ganttDiagram, SName.task);
    }

    @Override
    public void drawU(UGraphic ug) {
        ug = this.applyColors(ug);
        this.drawShape(ug);
    }

    @Override
    public double getHeightMax(StringBounder stringBounder) {
        return this.getFullHeightTask(stringBounder);
    }

    @Override
    public FingerPrint getFingerPrint(StringBounder stringBounder) {
        double h2 = this.getFullHeightTask(stringBounder);
        double startPos = this.timeScale.getStartingPosition(this.start);
        double endPos = this.timeScale.getEndingPosition(this.end);
        return new FingerPrint(startPos, this.getY(stringBounder).getCurrentValue(), endPos - startPos, h2);
    }

    @Override
    public FingerPrint getFingerPrintNote(StringBounder stringBounder) {
        return null;
    }

    private UGraphic applyColors(UGraphic ug) {
        CenterBorderColor col = this.getColors();
        if (col != null && col.isOk()) {
            return col.apply(ug);
        }
        return ug.apply(this.getLineColor()).apply(this.getBackgroundColor().bg());
    }

    @Override
    public double getX1(TaskAttribute taskAttribute) {
        Style style = this.getStyleSignature().getMergedStyle(this.getStyleBuilder());
        ClockwiseTopRightBottomLeft margin = style.getMargin();
        double startPos = taskAttribute == TaskAttribute.START ? this.timeScale.getStartingPosition(this.start) : this.timeScale.getStartingPosition(this.end) + margin.getLeft();
        return startPos;
    }

    @Override
    public double getX2(TaskAttribute taskAttribute) {
        Style style = this.getStyleSignature().getMergedStyle(this.getStyleBuilder());
        ClockwiseTopRightBottomLeft margin = style.getMargin();
        double endPos = taskAttribute == TaskAttribute.START ? this.timeScale.getEndingPosition(this.start) : this.timeScale.getEndingPosition(this.end) - margin.getLeft();
        return endPos;
    }

    private void drawShape(UGraphic ug) {
        Style style = this.getStyleSignature().getMergedStyle(this.getStyleBuilder());
        ClockwiseTopRightBottomLeft margin = style.getMargin();
        double startPos = this.timeScale.getStartingPosition(this.start) + margin.getLeft();
        double endPos = this.timeScale.getEndingPosition(this.end) - margin.getRight();
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        ug = ug.apply(UTranslate.dy(this.getFullHeightTask(ug.getStringBounder()) - 10.0));
        ug = ug.apply(HColors.BLACK).apply(HColors.BLACK.bg());
        ug.draw(this.getShape(startPos, endPos));
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    private UPath getShape(double startPos, double endPos) {
        UPath rect = UPath.none();
        double thick = 2.0;
        double y1 = 4.0;
        double y2 = 6.0;
        double dx = 6.0;
        rect.moveTo(startPos, 0.0);
        rect.lineTo(startPos + 6.0, 4.0);
        rect.lineTo(endPos - 6.0, 4.0);
        rect.lineTo(endPos, 0.0);
        rect.lineTo(endPos, 10.0);
        rect.lineTo(endPos - 6.0, 6.0);
        rect.lineTo(startPos + 6.0, 6.0);
        rect.lineTo(startPos, 10.0);
        rect.lineTo(startPos, 0.0);
        rect.closePath();
        return rect;
    }

    private UPath getShapeOld2(double startPos, double endPos) {
        UPath rect = UPath.none();
        double height1 = 9.0;
        double height2 = 7.0;
        double dx = 6.0;
        rect.moveTo(startPos, 0.0);
        rect.lineTo(startPos + 6.0, 7.0);
        rect.lineTo(endPos - 6.0, 7.0);
        rect.lineTo(endPos, 0.0);
        rect.lineTo(endPos, 9.0);
        rect.lineTo(startPos, 9.0);
        rect.lineTo(startPos, 0.0);
        rect.closePath();
        return rect;
    }

    private UPath getShapeOld(double startPos, double endPos) {
        UPath rect = UPath.none();
        double height1 = 9.0;
        double height2 = 2.0;
        double dx = 6.0;
        rect.moveTo(startPos, 0.0);
        rect.lineTo(endPos, 0.0);
        rect.lineTo(endPos, 9.0);
        rect.lineTo(endPos - 6.0, 2.0);
        rect.lineTo(startPos + 6.0, 2.0);
        rect.lineTo(startPos, 9.0);
        rect.lineTo(startPos, 0.0);
        rect.closePath();
        return rect;
    }
}

