/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.Objects;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.graphic.Arrow;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.sequencediagram.graphic.Segment;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowComponent;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.url.Url;

class MessageArrow
extends Arrow {
    private final LivingParticipantBox p1;
    private final LivingParticipantBox p2;
    private final Component compAliveBox;

    public MessageArrow(double startingY, Rose skin, ArrowComponent arrow, LivingParticipantBox p1, LivingParticipantBox p2, Url url, Component compAliveBox) {
        super(startingY, skin, arrow, url);
        if (p1 == p2) {
            throw new IllegalArgumentException();
        }
        this.p1 = Objects.requireNonNull(p1);
        this.p2 = Objects.requireNonNull(p2);
        this.compAliveBox = compAliveBox;
    }

    @Override
    public double getActualWidth(StringBounder stringBounder) {
        double r = this.getRightEndInternal(stringBounder) - this.getLeftStartInternal(stringBounder);
        assert (r > 0.0);
        return r;
    }

    private double getLeftStartInternal(StringBounder stringBounder) {
        return this.getParticipantAt(stringBounder, NotePosition.LEFT).getLiveThicknessAt(stringBounder, this.getArrowYStartLevel(stringBounder)).getSegment().getPos2();
    }

    private double getRightEndInternal(StringBounder stringBounder) {
        Segment segment = this.getParticipantAt(stringBounder, NotePosition.RIGHT).getLiveThicknessAt(stringBounder, this.getArrowYStartLevel(stringBounder)).getSegment();
        if (segment.getLength() == 0.0) {
            return segment.getPos1();
        }
        double rectWidth = this.compAliveBox.getPreferredWidth(stringBounder);
        return segment.getPos2() - rectWidth;
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getArrowComponent().getPreferredHeight(stringBounder);
    }

    @Override
    public double getStartingX(StringBounder stringBounder) {
        return this.getLeftStartInternal(stringBounder);
    }

    @Override
    public int getDirection(StringBounder stringBounder) {
        double x2;
        double x1 = this.p1.getParticipantBox().getCenterX(stringBounder);
        if (x1 < (x2 = this.p2.getParticipantBox().getCenterX(stringBounder))) {
            return 1;
        }
        return -1;
    }

    @Override
    public LivingParticipantBox getParticipantAt(StringBounder stringBounder, NotePosition position) {
        int direction = this.getDirection(stringBounder);
        if (direction == 1 && position == NotePosition.RIGHT) {
            return this.p2;
        }
        if (direction == 1 && position == NotePosition.LEFT) {
            return this.p1;
        }
        if (direction == -1 && position == NotePosition.RIGHT) {
            return this.p1;
        }
        if (direction == -1 && position == NotePosition.LEFT) {
            return this.p2;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getArrowComponent().getPreferredWidth(stringBounder);
    }

    @Override
    protected void drawInternalU(UGraphic ug, double maxX, Context2D context) {
        StringBounder stringBounder = ug.getStringBounder();
        ug = ug.apply(new UTranslate(this.getStartingX(stringBounder), this.getStartingY()));
        this.startUrl(ug);
        this.getArrowComponent().drawU(ug, new Area(this.getActualDimension(stringBounder)), context);
        this.endUrl(ug);
    }

    private XDimension2D getActualDimension(StringBounder stringBounder) {
        return new XDimension2D(this.getActualWidth(stringBounder) - this.getPaddingArrowHead(), this.getArrowComponent().getPreferredHeight(stringBounder));
    }

    @Override
    public double getArrowYStartLevel(StringBounder stringBounder) {
        if (this.getArrowComponent() instanceof ArrowComponent) {
            ArrowComponent arrowComponent = this.getArrowComponent();
            XDimension2D dim = new XDimension2D(arrowComponent.getPreferredWidth(stringBounder), arrowComponent.getPreferredHeight(stringBounder));
            return this.getStartingY() + arrowComponent.getStartPoint(stringBounder, dim).getY();
        }
        return this.getStartingY();
    }

    @Override
    public double getArrowYEndLevel(StringBounder stringBounder) {
        if (this.getArrowComponent() instanceof ArrowComponent) {
            ArrowComponent arrowComponent = this.getArrowComponent();
            XDimension2D dim = new XDimension2D(arrowComponent.getPreferredWidth(stringBounder), arrowComponent.getPreferredHeight(stringBounder));
            return this.getStartingY() + arrowComponent.getEndPoint(stringBounder, dim).getY();
        }
        return this.getStartingY() + this.getArrowComponent().getPreferredHeight(stringBounder);
    }

    @Override
    public double getMaxX(StringBounder stringBounder) {
        return this.getRightEndInternal(stringBounder);
    }

    @Override
    public double getMinX(StringBounder stringBounder) {
        return this.getLeftStartInternal(stringBounder);
    }

    @Override
    public String toString(StringBounder stringBounder) {
        return this.getMinX(stringBounder) + "-" + this.getMaxX(stringBounder);
    }
}

