/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.util.List;
import net.sourceforge.plantuml.abel.DisplayPositioned;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.GroupType;
import net.sourceforge.plantuml.activitydiagram3.ftile.EntityImageLegend;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.decoration.symbol.USymbol;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.DecorateEntityImage;

public final class ClusterHeader {
    private int titleAndAttributeWidth = 0;
    private int titleAndAttributeHeight = 0;
    private final TextBlock title;
    private final TextBlock stereo;

    public ClusterHeader(Entity g2, ISkinParam skinParam, PortionShower portionShower, StringBounder stringBounder) {
        this.title = this.getTitleBlock(g2, skinParam);
        this.stereo = this.getStereoBlock(g2, skinParam, portionShower);
        TextBlock stereoAndTitle = TextBlockUtils.mergeTB(this.stereo, this.title, HorizontalAlignment.CENTER);
        XDimension2D dimLabel = stereoAndTitle.calculateDimension(stringBounder);
        if (dimLabel.getWidth() > 0.0) {
            XDimension2D dimAttribute = g2.getStateHeader(skinParam).calculateDimension(stringBounder);
            double attributeHeight = dimAttribute.getHeight();
            double attributeWidth = dimAttribute.getWidth();
            double marginForFields = attributeHeight > 0.0 ? 5.0 : 0.0;
            USymbol uSymbol = g2.getUSymbol();
            int suppHeightBecauseOfShape = uSymbol == null ? 0 : uSymbol.suppHeightBecauseOfShape();
            int suppWidthBecauseOfShape = uSymbol == null ? 0 : uSymbol.suppWidthBecauseOfShape();
            this.titleAndAttributeWidth = (int)Math.max(dimLabel.getWidth(), attributeWidth) + suppWidthBecauseOfShape;
            this.titleAndAttributeHeight = (int)(dimLabel.getHeight() + attributeHeight + marginForFields + (double)suppHeightBecauseOfShape);
        }
    }

    public final int getTitleAndAttributeWidth() {
        return this.titleAndAttributeWidth;
    }

    public final int getTitleAndAttributeHeight() {
        return this.titleAndAttributeHeight;
    }

    public final TextBlock getTitle() {
        return this.title;
    }

    public final TextBlock getStereo() {
        return this.stereo;
    }

    private TextBlock getTitleBlock(Entity g2, ISkinParam skinParam) {
        Display label = g2.getDisplay();
        if (label == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        SName sname = skinParam.getUmlDiagramType().getStyleName();
        USymbol uSymbol = g2.getUSymbol();
        StyleSignatureBasic signature = g2.getGroupType() == GroupType.STATE ? StyleSignatureBasic.of(SName.root, SName.element, SName.stateDiagram, SName.state, SName.composite, SName.title) : (uSymbol != null ? StyleSignatureBasic.of(SName.root, SName.element, sname, uSymbol.getSName(), SName.composite, SName.title) : (g2.getGroupType() == GroupType.PACKAGE ? StyleSignatureBasic.of(SName.root, SName.element, sname, SName.package_, SName.title) : StyleSignatureBasic.of(SName.root, SName.element, sname, SName.composite, SName.title)));
        Style style = signature.withTOBECHANGED(g2.getStereotype()).with(g2.getStereostyles()).getMergedStyle(skinParam.getCurrentStyleBuilder());
        FontConfiguration fontConfiguration = style.getFontConfiguration(skinParam.getIHtmlColorSet(), g2.getColors());
        HorizontalAlignment alignment = HorizontalAlignment.CENTER;
        return label.create(fontConfiguration, alignment, skinParam);
    }

    private TextBlock getStereoBlock(Entity g2, ISkinParam skinParam, PortionShower portionShower) {
        TextBlock stereo = this.getStereoBlockWithoutLegend(g2, portionShower, skinParam);
        DisplayPositioned legend = g2.getLegend();
        if (legend == null || legend.isNull()) {
            return stereo;
        }
        TextBlock legendBlock = EntityImageLegend.create(legend.getDisplay(), skinParam);
        return DecorateEntityImage.add(legendBlock, stereo, legend.getHorizontalAlignment(), legend.getVerticalAlignment());
    }

    private TextBlock getStereoBlockWithoutLegend(Entity g2, PortionShower portionShower, ISkinParam skinParam) {
        Stereotype stereotype = g2.getStereotype();
        if (stereotype == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        TextBlock tmp = stereotype.getSprite(skinParam);
        if (tmp != null) {
            return tmp;
        }
        List<String> stereos = stereotype.getLabels(skinParam.guillemet());
        if (stereos == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        List<String> visibleStereotypes = portionShower.getVisibleStereotypeLabels(g2);
        if (visibleStereotypes == null || visibleStereotypes.isEmpty()) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        Style style = Cluster.getDefaultStyleDefinition(skinParam.getUmlDiagramType().getStyleName(), g2.getUSymbol(), g2.getGroupType()).forStereotypeItself(g2.getStereotype()).getMergedStyle(skinParam.getCurrentStyleBuilder());
        FontConfiguration fontConfiguration = style.getFontConfiguration(skinParam.getIHtmlColorSet());
        return Display.create(visibleStereotypes).create(fontConfiguration, HorizontalAlignment.CENTER, skinParam);
    }
}

