/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.util.List;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.FontParam;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.skin.ColorParam;
import net.sourceforge.plantuml.skin.SkinParamUtils;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.SvekEdge;
import net.sourceforge.plantuml.svek.image.ConnectedCircle;
import net.sourceforge.plantuml.url.Url;

public class EntityImageLollipopInterfaceEye1
extends AbstractEntityImage {
    private static final int SIZE = 24;
    private final TextBlock desc;
    private final Bibliotekon bibliotekon;
    private final Url url;

    public EntityImageLollipopInterfaceEye1(Entity entity, ISkinParam skinParam, Bibliotekon bibliotekon) {
        super(entity, skinParam);
        this.bibliotekon = bibliotekon;
        Stereotype stereotype = entity.getStereotype();
        this.desc = entity.getDisplay().create(FontConfiguration.create(this.getSkinParam(), FontParam.CLASS, stereotype), HorizontalAlignment.CENTER, skinParam);
        this.url = entity.getUrl99();
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new XDimension2D(24.0, 24.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        ug = ug.apply(SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.classBorder));
        ug = ug.apply(SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.classBackground).bg());
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        double sizeSmall = 14.0;
        double diff = 5.0;
        UEllipse circle1 = UEllipse.build(14.0, 14.0);
        if (this.getSkinParam().shadowing(this.getEntity().getStereotype())) {
            // empty if block
        }
        ug.apply(UStroke.withThickness(1.5)).apply(new UTranslate(5.0, 5.0)).draw(circle1);
        ug = ug.apply(HColors.none().bg());
        XPoint2D pos = this.bibliotekon.getNode(this.getEntity()).getPosition();
        List<SvekEdge> lines = this.bibliotekon.getAllLineConnectedTo(this.getEntity());
        UTranslate reverse = UTranslate.point(pos).reverse();
        ConnectedCircle connectedCircle = new ConnectedCircle(12.0);
        for (SvekEdge line : lines) {
            XPoint2D pt = line.getMyPoint(this.getEntity());
            pt = reverse.getTranslated(pt);
            connectedCircle.addSecondaryConnection(pt);
        }
        connectedCircle.drawU(ug);
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.CIRCLE;
    }
}

