/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim.iterator;

import java.util.List;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.text.TLineType;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.EaterForeach;
import net.sourceforge.plantuml.tim.ExecutionContextForeach;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.TVariableScope;
import net.sourceforge.plantuml.tim.expression.TValue;
import net.sourceforge.plantuml.tim.iterator.AbstractCodeIterator;
import net.sourceforge.plantuml.tim.iterator.CodeIterator;

public class CodeIteratorForeach
extends AbstractCodeIterator {
    private final TContext context;
    private final TMemory memory;
    private final List<StringLocated> logs;

    public CodeIteratorForeach(CodeIterator source, TContext context, TMemory memory, List<StringLocated> logs) {
        super(source);
        this.context = context;
        this.memory = memory;
        this.logs = logs;
    }

    @Override
    public StringLocated peek() throws EaterException {
        StringLocated result;
        int level = 0;
        while (true) {
            if ((result = this.source.peek()) == null) {
                return null;
            }
            ExecutionContextForeach foreach = this.memory.peekForeach();
            if (foreach != null && foreach.isSkipMe()) {
                if (result.getType() == TLineType.FOREACH) {
                    ++level;
                } else if (result.getType() == TLineType.ENDFOREACH && --level == -1) {
                    this.memory.pollForeach();
                    level = 0;
                }
                this.next();
                continue;
            }
            if (result.getType() == TLineType.FOREACH) {
                this.logs.add(result);
                this.executeForeach(this.memory, result.getTrimmed());
                this.next();
                continue;
            }
            if (result.getType() != TLineType.ENDFOREACH) break;
            this.logs.add(result);
            if (foreach == null) {
                throw new EaterException("No foreach related to this endforeach", result);
            }
            foreach.inc();
            if (foreach.isSkipMe()) {
                this.memory.pollForeach();
            } else {
                this.setLoopVariable(this.memory, foreach, result);
                this.source.jumpToCodePosition(foreach.getStartForeach(), result);
            }
            this.next();
        }
        return result;
    }

    private void executeForeach(TMemory memory, StringLocated s2) throws EaterException {
        EaterForeach condition = new EaterForeach(s2);
        condition.analyze(this.context, memory);
        ExecutionContextForeach foreach = ExecutionContextForeach.fromValue(condition.getVarname(), condition.getJsonArray(), this.source.getCodePosition());
        if (condition.isSkip()) {
            foreach.skipMeNow();
        } else {
            this.setLoopVariable(memory, foreach, s2);
        }
        memory.addForeach(foreach);
    }

    private void setLoopVariable(TMemory memory, ExecutionContextForeach foreach, StringLocated position) throws EaterException {
        JsonValue first = foreach.getJsonArray().get(foreach.currentIndex());
        memory.putVariable(foreach.getVarname(), TValue.fromJson(first), TVariableScope.GLOBAL, position);
    }
}

