import { createChangeToEdit, getEdgeStr, getGraphKeywordStr } from "./common.js";
export function create(edgeOffsets, changeEdgesTo, graphOffset, changeFromGraph, changeGraphTo) {
    const toGraph = getGraphKeywordStr(changeGraphTo);
    const title = changeGraphTo === changeFromGraph
        ? `Fix all edges to match ${toGraph}`
        : `Convert ${getGraphKeywordStr(changeFromGraph)} to ${toGraph}`;
    const edgeStr = getEdgeStr(changeEdgesTo);
    return {
        title,
        command: "DOT.convertGraphType",
        arguments: [edgeOffsets, edgeStr, graphOffset, toGraph],
    };
}
export function execute(doc, _sourceFile, cmd) {
    if (!isChangeAllOtherEdgeOpsAndFixGraphCommand(cmd))
        return undefined;
    const [edgeOffsets, changeEdgeTo, graphOffset, changeGraphTo] = cmd.arguments;
    const edits = edgeOffsets.map(o => {
        const startPos = doc.positionAt(o.start);
        const endPos = doc.positionAt(o.end);
        return createChangeToEdit(startPos, endPos, changeEdgeTo);
    });
    const graphStart = doc.positionAt(graphOffset.start);
    const graphEnd = doc.positionAt(graphOffset.end);
    edits.push(createChangeToEdit(graphStart, graphEnd, changeGraphTo));
    return {
        label: `Convert graph to "${changeGraphTo}"`,
        edit: {
            changes: {
                [doc.uri]: edits,
            }
        }
    };
}
function isChangeAllOtherEdgeOpsAndFixGraphCommand(cmd) {
    return cmd.command === "DOT.convertGraphType" && !!cmd.arguments && cmd.arguments.length === 4;
}
//# sourceMappingURL=ChangeAllOtherEdgeOpsAndFixGraphCommand.js.map