/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.AlgorithmParameters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.java.security.BCCryptoPrimitive;
import org.bouncycastle.jsse.provider.FipsUtils;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.NamedGroupInfo;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.SignatureScheme;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class SignatureSchemeInfo {
    private static final Logger LOG = Logger.getLogger(SignatureSchemeInfo.class.getName());
    static final int historical_dsa_sha1 = 514;
    static final int historical_dsa_sha224 = 770;
    static final int historical_dsa_sha256 = 1026;
    static final int historical_ecdsa_sha224 = 771;
    static final int historical_rsa_md5 = 257;
    static final int historical_rsa_sha224 = 769;
    private static final String PROPERTY_CLIENT_SIGNATURE_SCHEMES = "jdk.tls.client.SignatureSchemes";
    private static final String PROPERTY_SERVER_SIGNATURE_SCHEMES = "jdk.tls.server.SignatureSchemes";
    private static final int[] CANDIDATES_DEFAULT = SignatureSchemeInfo.createCandidatesDefault();
    private final All all;
    private final AlgorithmParameters algorithmParameters;
    private final NamedGroupInfo namedGroupInfo;
    private final boolean enabled;
    private final boolean disabled13;

    static PerConnection createPerConnectionClient(PerContext perContext, ProvSSLParameters provSSLParameters, ProtocolVersion[] protocolVersionArray, NamedGroupInfo.PerConnection perConnection) {
        ProtocolVersion protocolVersion = ProtocolVersion.getLatestTLS(protocolVersionArray);
        if (!TlsUtils.isSignatureAlgorithmsExtensionAllowed(protocolVersion)) {
            return new PerConnection(null);
        }
        ProtocolVersion protocolVersion2 = ProtocolVersion.getEarliestTLS(protocolVersionArray);
        return SignatureSchemeInfo.createPerConnection(perContext, false, provSSLParameters, protocolVersion2, protocolVersion, perConnection);
    }

    static PerConnection createPerConnectionServer(PerContext perContext, ProvSSLParameters provSSLParameters, ProtocolVersion protocolVersion, NamedGroupInfo.PerConnection perConnection) {
        if (!TlsUtils.isSignatureAlgorithmsExtensionAllowed(protocolVersion)) {
            return new PerConnection(null);
        }
        return SignatureSchemeInfo.createPerConnection(perContext, true, provSSLParameters, protocolVersion, protocolVersion, perConnection);
    }

    private static PerConnection createPerConnection(PerContext perContext, boolean bl, ProvSSLParameters provSSLParameters, ProtocolVersion protocolVersion, ProtocolVersion protocolVersion2, NamedGroupInfo.PerConnection perConnection) {
        String[] stringArray = provSSLParameters.getSignatureSchemes();
        int[] nArray = stringArray == null ? (bl ? perContext.candidatesServer : perContext.candidatesClient) : SignatureSchemeInfo.createCandidates(perContext.index, stringArray, "SSLParameters.signatureSchemes");
        BCAlgorithmConstraints bCAlgorithmConstraints = provSSLParameters.getAlgorithmConstraints();
        boolean bl2 = TlsUtils.isTLSv13(protocolVersion2);
        boolean bl3 = !TlsUtils.isTLSv13(protocolVersion);
        int n = nArray.length;
        ArrayList<SignatureSchemeInfo> arrayList = new ArrayList<SignatureSchemeInfo>(n);
        for (int i = 0; i < n; ++i) {
            Integer n2 = Integers.valueOf((int)nArray[i]);
            SignatureSchemeInfo signatureSchemeInfo = (SignatureSchemeInfo)perContext.index.get(n2);
            if (null == signatureSchemeInfo || !signatureSchemeInfo.isActiveCerts(bCAlgorithmConstraints, bl2, bl3, perConnection)) continue;
            arrayList.add(signatureSchemeInfo);
        }
        arrayList.trimToSize();
        return new PerConnection(arrayList);
    }

    static PerContext createPerContext(boolean bl, JcaTlsCrypto jcaTlsCrypto, NamedGroupInfo.PerContext perContext) {
        Map<Integer, SignatureSchemeInfo> map = SignatureSchemeInfo.createIndex(bl, jcaTlsCrypto, perContext);
        int[] nArray = SignatureSchemeInfo.createCandidatesFromProperty(map, PROPERTY_CLIENT_SIGNATURE_SCHEMES);
        int[] nArray2 = SignatureSchemeInfo.createCandidatesFromProperty(map, PROPERTY_SERVER_SIGNATURE_SCHEMES);
        return new PerContext(map, nArray, nArray2);
    }

    static String[] getJcaSignatureAlgorithms(Collection<SignatureSchemeInfo> collection) {
        if (null == collection) {
            return TlsUtils.EMPTY_STRINGS;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SignatureSchemeInfo signatureSchemeInfo : collection) {
            arrayList.add(signatureSchemeInfo.getJcaSignatureAlgorithm());
        }
        return arrayList.toArray(TlsUtils.EMPTY_STRINGS);
    }

    static String[] getJcaSignatureAlgorithmsBC(Collection<SignatureSchemeInfo> collection) {
        if (null == collection) {
            return TlsUtils.EMPTY_STRINGS;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SignatureSchemeInfo signatureSchemeInfo : collection) {
            arrayList.add(signatureSchemeInfo.getJcaSignatureAlgorithmBC());
        }
        return arrayList.toArray(TlsUtils.EMPTY_STRINGS);
    }

    static SignatureAndHashAlgorithm getSignatureAndHashAlgorithm(int n) {
        if (!TlsUtils.isValidUint16(n)) {
            throw new IllegalArgumentException();
        }
        return SignatureScheme.getSignatureAndHashAlgorithm(n);
    }

    static Vector<SignatureAndHashAlgorithm> getSignatureAndHashAlgorithms(List<SignatureSchemeInfo> list) {
        if (null == list || list.isEmpty()) {
            return null;
        }
        int n = list.size();
        Vector<SignatureAndHashAlgorithm> vector = new Vector<SignatureAndHashAlgorithm>(n);
        for (SignatureSchemeInfo signatureSchemeInfo : list) {
            if (null == signatureSchemeInfo) continue;
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = signatureSchemeInfo.getSignatureAndHashAlgorithm();
            vector.add(signatureAndHashAlgorithm);
        }
        if (vector.isEmpty()) {
            return null;
        }
        vector.trimToSize();
        return vector;
    }

    static List<SignatureSchemeInfo> getSignatureSchemes(PerContext perContext, Vector<SignatureAndHashAlgorithm> vector) {
        if (null == vector || vector.isEmpty()) {
            return null;
        }
        int n = vector.size();
        ArrayList<SignatureSchemeInfo> arrayList = new ArrayList<SignatureSchemeInfo>(n);
        for (int i = 0; i < n; ++i) {
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = vector.elementAt(i);
            if (null == signatureAndHashAlgorithm) continue;
            int n2 = SignatureScheme.from(signatureAndHashAlgorithm);
            SignatureSchemeInfo signatureSchemeInfo = (SignatureSchemeInfo)perContext.index.get(n2);
            if (null == signatureSchemeInfo) continue;
            arrayList.add(signatureSchemeInfo);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        arrayList.trimToSize();
        return Collections.unmodifiableList(arrayList);
    }

    private static void addSignatureScheme(boolean bl, JcaTlsCrypto jcaTlsCrypto, NamedGroupInfo.PerContext perContext, Map<Integer, SignatureSchemeInfo> map, All all) {
        int n = all.signatureScheme;
        if (bl && !FipsUtils.isFipsSignatureScheme(n)) {
            return;
        }
        NamedGroupInfo namedGroupInfo = null;
        boolean bl2 = false;
        int n2 = all.namedGroup13;
        if (!(n2 < 0 || null != (namedGroupInfo = NamedGroupInfo.getNamedGroup(perContext, n2)) && namedGroupInfo.isEnabled() && namedGroupInfo.isSupportedPost13())) {
            bl2 = true;
        }
        boolean bl3 = jcaTlsCrypto.hasSignatureScheme(n);
        AlgorithmParameters algorithmParameters = null;
        if (bl3) {
            try {
                algorithmParameters = jcaTlsCrypto.getSignatureSchemeAlgorithmParameters(n);
            }
            catch (Exception exception) {
                bl3 = false;
            }
        }
        SignatureSchemeInfo signatureSchemeInfo = new SignatureSchemeInfo(all, algorithmParameters, namedGroupInfo, bl3, bl2);
        if (null != map.put(n, signatureSchemeInfo)) {
            throw new IllegalStateException("Duplicate entries for SignatureSchemeInfo");
        }
    }

    private static int[] createCandidatesFromProperty(Map<Integer, SignatureSchemeInfo> map, String string) {
        String[] stringArray = PropertyUtils.getStringArraySystemProperty(string);
        if (null == stringArray) {
            return CANDIDATES_DEFAULT;
        }
        return SignatureSchemeInfo.createCandidates(map, stringArray, string);
    }

    private static int[] createCandidates(Map<Integer, SignatureSchemeInfo> map, String[] stringArray, String string) {
        int[] nArray = new int[stringArray.length];
        int n = 0;
        for (String string2 : stringArray) {
            int n2 = SignatureSchemeInfo.getSignatureSchemeByName(string2);
            if (n2 < 0) {
                LOG.warning("'" + string + "' contains unrecognised SignatureScheme: " + string2);
                continue;
            }
            SignatureSchemeInfo signatureSchemeInfo = map.get(n2);
            if (null == signatureSchemeInfo) {
                LOG.warning("'" + string + "' contains unsupported SignatureScheme: " + string2);
                continue;
            }
            if (!signatureSchemeInfo.isEnabled()) {
                LOG.warning("'" + string + "' contains disabled SignatureScheme: " + string2);
                continue;
            }
            nArray[n++] = n2;
        }
        if (n < nArray.length) {
            nArray = Arrays.copyOf((int[])nArray, (int)n);
        }
        if (nArray.length < 1) {
            LOG.severe("'" + string + "' contained no usable SignatureScheme values");
        }
        return nArray;
    }

    private static int[] createCandidatesDefault() {
        All[] allArray = All.values();
        int[] nArray = new int[allArray.length];
        for (int i = 0; i < allArray.length; ++i) {
            nArray[i] = allArray[i].signatureScheme;
        }
        return nArray;
    }

    private static Map<Integer, SignatureSchemeInfo> createIndex(boolean bl, JcaTlsCrypto jcaTlsCrypto, NamedGroupInfo.PerContext perContext) {
        TreeMap<Integer, SignatureSchemeInfo> treeMap = new TreeMap<Integer, SignatureSchemeInfo>();
        for (All all : All.values()) {
            SignatureSchemeInfo.addSignatureScheme(bl, jcaTlsCrypto, perContext, treeMap, all);
        }
        return treeMap;
    }

    private static int getSignatureSchemeByName(String string) {
        for (All all : All.values()) {
            if (!all.name.equalsIgnoreCase(string)) continue;
            return all.signatureScheme;
        }
        return -1;
    }

    private static boolean isECDSA(int n) {
        switch (n) {
            case 515: 
            case 771: 
            case 1027: 
            case 1283: 
            case 1539: 
            case 2074: 
            case 2075: 
            case 2076: {
                return true;
            }
        }
        return false;
    }

    SignatureSchemeInfo(All all, AlgorithmParameters algorithmParameters, NamedGroupInfo namedGroupInfo, boolean bl, boolean bl2) {
        this.all = all;
        this.algorithmParameters = algorithmParameters;
        this.namedGroupInfo = namedGroupInfo;
        this.enabled = bl;
        this.disabled13 = bl2;
    }

    short getHashAlgorithm() {
        return SignatureScheme.getHashAlgorithm(this.all.signatureScheme);
    }

    String getJcaSignatureAlgorithm() {
        return this.all.jcaSignatureAlgorithm;
    }

    String getJcaSignatureAlgorithmBC() {
        return this.all.jcaSignatureAlgorithmBC;
    }

    String getKeyType() {
        return this.all.keyAlgorithm;
    }

    String getKeyType13() {
        return this.all.keyType13;
    }

    String getName() {
        return this.all.name;
    }

    NamedGroupInfo getNamedGroupInfo() {
        return this.namedGroupInfo;
    }

    short getSignatureAlgorithm() {
        return SignatureScheme.getSignatureAlgorithm(this.all.signatureScheme);
    }

    SignatureAndHashAlgorithm getSignatureAndHashAlgorithm() {
        return SignatureSchemeInfo.getSignatureAndHashAlgorithm(this.all.signatureScheme);
    }

    int getSignatureScheme() {
        return this.all.signatureScheme;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    boolean isSupportedPost13() {
        return !this.disabled13 && this.all.supportedPost13;
    }

    boolean isSupportedPre13() {
        return this.all.supportedPre13;
    }

    boolean isSupportedCerts13() {
        return !this.disabled13 && this.all.supportedCerts13;
    }

    public String toString() {
        return this.all.text;
    }

    private boolean isActiveCerts(BCAlgorithmConstraints bCAlgorithmConstraints, boolean bl, boolean bl2, NamedGroupInfo.PerConnection perConnection) {
        return this.enabled && this.isNamedGroupOK(bl && this.isSupportedCerts13(), bl2 && this.isSupportedPre13(), perConnection) && this.isPermittedBy(bCAlgorithmConstraints);
    }

    private boolean isNamedGroupOK(boolean bl, boolean bl2, NamedGroupInfo.PerConnection perConnection) {
        if (null != this.namedGroupInfo) {
            return bl && NamedGroupInfo.hasLocal(perConnection, this.namedGroupInfo.getNamedGroup()) || bl2 && NamedGroupInfo.hasAnyECDSALocal(perConnection);
        }
        return !(!bl && !bl2 || SignatureSchemeInfo.isECDSA(this.all.signatureScheme) && !NamedGroupInfo.hasAnyECDSALocal(perConnection));
    }

    private boolean isPermittedBy(BCAlgorithmConstraints bCAlgorithmConstraints) {
        Set<BCCryptoPrimitive> set = JsseUtils.SIGNATURE_CRYPTO_PRIMITIVES_BC;
        return bCAlgorithmConstraints.permits(set, this.all.name, null) && bCAlgorithmConstraints.permits(set, this.all.keyAlgorithm, null) && bCAlgorithmConstraints.permits(set, this.all.jcaSignatureAlgorithm, this.algorithmParameters);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class PerConnection {
        private final List<SignatureSchemeInfo> localSigSchemes;
        private final List<SignatureSchemeInfo> localSigSchemesCert;
        private final AtomicReference<List<SignatureSchemeInfo>> peerSigSchemes;
        private final AtomicReference<List<SignatureSchemeInfo>> peerSigSchemesCert;

        PerConnection(List<SignatureSchemeInfo> list) {
            this.localSigSchemes = list;
            this.localSigSchemesCert = null;
            this.peerSigSchemes = new AtomicReference();
            this.peerSigSchemesCert = new AtomicReference();
        }

        String[] getLocalJcaSignatureAlgorithms() {
            return SignatureSchemeInfo.getJcaSignatureAlgorithms(this.getLocalJcaSigSchemesCert());
        }

        String[] getLocalJcaSignatureAlgorithmsBC() {
            return SignatureSchemeInfo.getJcaSignatureAlgorithmsBC(this.getLocalJcaSigSchemesCert());
        }

        Vector<SignatureAndHashAlgorithm> getLocalSignatureAndHashAlgorithms() {
            return SignatureSchemeInfo.getSignatureAndHashAlgorithms(this.localSigSchemes);
        }

        Vector<SignatureAndHashAlgorithm> getLocalSignatureAndHashAlgorithmsCert() {
            return SignatureSchemeInfo.getSignatureAndHashAlgorithms(this.localSigSchemesCert);
        }

        String[] getPeerJcaSignatureAlgorithms() {
            return SignatureSchemeInfo.getJcaSignatureAlgorithms(this.getPeerJcaSigSchemesCert());
        }

        String[] getPeerJcaSignatureAlgorithmsBC() {
            return SignatureSchemeInfo.getJcaSignatureAlgorithmsBC(this.getPeerJcaSigSchemesCert());
        }

        Iterable<SignatureSchemeInfo> getPeerSigSchemes() {
            return this.peerSigSchemes.get();
        }

        boolean hasLocalSignatureScheme(SignatureSchemeInfo signatureSchemeInfo) {
            return this.localSigSchemes.contains(signatureSchemeInfo);
        }

        void notifyPeerData(List<SignatureSchemeInfo> list, List<SignatureSchemeInfo> list2) {
            this.peerSigSchemes.set(list);
            this.peerSigSchemesCert.set(list2);
        }

        private List<SignatureSchemeInfo> getLocalJcaSigSchemesCert() {
            return this.localSigSchemesCert == null ? this.localSigSchemes : this.localSigSchemesCert;
        }

        private List<SignatureSchemeInfo> getPeerJcaSigSchemesCert() {
            List<SignatureSchemeInfo> list = this.peerSigSchemesCert.get();
            return list == null ? this.peerSigSchemes.get() : list;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class PerContext {
        private final Map<Integer, SignatureSchemeInfo> index;
        private final int[] candidatesClient;
        private final int[] candidatesServer;

        PerContext(Map<Integer, SignatureSchemeInfo> map, int[] nArray, int[] nArray2) {
            this.index = map;
            this.candidatesClient = nArray;
            this.candidatesServer = nArray2;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static enum All {
        ed25519(2055, "Ed25519", "Ed25519"),
        ed448(2056, "Ed448", "Ed448"),
        ecdsa_secp256r1_sha256(1027, "SHA256withECDSA", "EC"),
        ecdsa_secp384r1_sha384(1283, "SHA384withECDSA", "EC"),
        ecdsa_secp521r1_sha512(1539, "SHA512withECDSA", "EC"),
        ecdsa_brainpoolP256r1tls13_sha256(2074, "SHA256withECDSA", "EC"),
        ecdsa_brainpoolP384r1tls13_sha384(2075, "SHA384withECDSA", "EC"),
        ecdsa_brainpoolP512r1tls13_sha512(2076, "SHA512withECDSA", "EC"),
        rsa_pss_pss_sha256(2057, "SHA256withRSAandMGF1", "RSASSA-PSS"),
        rsa_pss_pss_sha384(2058, "SHA384withRSAandMGF1", "RSASSA-PSS"),
        rsa_pss_pss_sha512(2059, "SHA512withRSAandMGF1", "RSASSA-PSS"),
        rsa_pss_rsae_sha256(2052, "SHA256withRSAandMGF1", "RSA"),
        rsa_pss_rsae_sha384(2053, "SHA384withRSAandMGF1", "RSA"),
        rsa_pss_rsae_sha512(2054, "SHA512withRSAandMGF1", "RSA"),
        rsa_pkcs1_sha256(1025, "SHA256withRSA", "RSA", true),
        rsa_pkcs1_sha384(1281, "SHA384withRSA", "RSA", true),
        rsa_pkcs1_sha512(1537, "SHA512withRSA", "RSA", true),
        sm2sig_sm3(1800, "SM3withSM2", "EC"),
        dsa_sha256(1026, "dsa_sha256", "SHA256withDSA", "DSA"),
        ecdsa_sha224(771, "ecdsa_sha224", "SHA224withECDSA", "EC"),
        rsa_sha224(769, "rsa_sha224", "SHA224withRSA", "RSA"),
        dsa_sha224(770, "dsa_sha224", "SHA224withDSA", "DSA"),
        ecdsa_sha1(515, "SHA1withECDSA", "EC", true),
        rsa_pkcs1_sha1(513, "SHA1withRSA", "RSA", true),
        dsa_sha1(514, "dsa_sha1", "SHA1withDSA", "DSA"),
        rsa_md5(257, "rsa_md5", "MD5withRSA", "RSA");

        private final int signatureScheme;
        private final String name;
        private final String text;
        private final String jcaSignatureAlgorithm;
        private final String jcaSignatureAlgorithmBC;
        private final String keyAlgorithm;
        private final String keyType13;
        private final boolean supportedPost13;
        private final boolean supportedPre13;
        private final boolean supportedCerts13;
        private final int namedGroup13;

        private All(int n2, String string2, String string3) {
            this(n2, string2, string3, true, true, SignatureScheme.getNamedGroup(n2));
        }

        private All(int n2, String string2, String string3, boolean bl) {
            this(n2, string2, string3, false, bl, -1);
        }

        private All(int n2, String string2, String string3, boolean bl, boolean bl2, int n3) {
            this(n2, SignatureScheme.getName(n2), string2, string3, bl, bl2, n3);
        }

        private All(int n2, String string2, String string3, String string4) {
            this(n2, string2, string3, string4, false, false, -1);
        }

        private All(int n2, String string2, String string3, String string4, boolean bl, boolean bl2, int n3) {
            String string5 = JsseUtils.getKeyType13(string4, n3);
            String string6 = JsseUtils.getJcaSignatureAlgorithmBC(string3, string4);
            this.signatureScheme = n2;
            this.name = string2;
            this.text = string2 + "(0x" + Integer.toHexString(n2) + ")";
            this.jcaSignatureAlgorithm = string3;
            this.jcaSignatureAlgorithmBC = string6;
            this.keyAlgorithm = string4;
            this.keyType13 = string5;
            this.supportedPost13 = bl;
            this.supportedPre13 = n3 < 0 || NamedGroup.canBeNegotiated(n3, ProtocolVersion.TLSv12);
            this.supportedCerts13 = bl2;
            this.namedGroup13 = n3;
        }
    }
}

