/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.RemoveAxiom;

public class ClassDefinitionExtractor {
    @Nonnull
    private final OWLClass cls;
    @Nonnull
    private final OWLDataFactory dataFactory;
    @Nonnull
    private final OWLOntology ontology;

    public ClassDefinitionExtractor(@Nonnull OWLClass cls, @Nonnull OWLOntology ontology, @Nonnull OWLDataFactory dataFactory) {
        this.cls = (OWLClass)Preconditions.checkNotNull((Object)cls);
        this.dataFactory = (OWLDataFactory)Preconditions.checkNotNull((Object)dataFactory);
        this.ontology = (OWLOntology)Preconditions.checkNotNull((Object)ontology);
    }

    @Nonnull
    public List<OWLOntologyChange> getChangesToRemoveDefinition() {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        this.generateChangesToRemoveDefinitionFromOntology(this.ontology, changes);
        return changes;
    }

    @Nonnull
    public Set<OWLAxiom> getDefiningAxioms() {
        HashSet<OWLAxiom> result = new HashSet<OWLAxiom>();
        result.addAll(this.ontology.getSubClassAxiomsForSubClass(this.cls));
        result.addAll(this.ontology.getEquivalentClassesAxioms(this.cls));
        result.addAll(this.ontology.getDisjointClassesAxioms(this.cls));
        result.addAll(this.ontology.getHasKeyAxioms(this.cls));
        result.addAll(this.ontology.getDisjointUnionAxioms(this.cls));
        return result;
    }

    private void generateChangesToRemoveDefinitionFromOntology(@Nonnull OWLOntology o, @Nonnull List<OWLOntologyChange> changes) {
        o.getSubClassAxiomsForSubClass(this.cls).forEach(ax -> changes.add((OWLOntologyChange)new RemoveAxiom(o, (OWLAxiom)ax)));
        o.getEquivalentClassesAxioms(this.cls).forEach(ax -> changes.add((OWLOntologyChange)new RemoveAxiom(o, (OWLAxiom)ax)));
        o.getDisjointClassesAxioms(this.cls).forEach(ax -> {
            changes.add((OWLOntologyChange)new RemoveAxiom(o, (OWLAxiom)ax));
            Set remainingDisjointClasses = ax.getClassExpressionsMinus(new OWLClassExpression[]{this.cls});
            if (remainingDisjointClasses.size() > 1) {
                OWLDisjointClassesAxiom freshAx = this.dataFactory.getOWLDisjointClassesAxiom(remainingDisjointClasses, ax.getAnnotations());
                changes.add((OWLOntologyChange)new AddAxiom(o, (OWLAxiom)freshAx));
            }
        });
        o.getHasKeyAxioms(this.cls).forEach(ax -> new RemoveAxiom(o, (OWLAxiom)ax));
        o.getDisjointUnionAxioms(this.cls).forEach(ax -> new RemoveAxiom(o, (OWLAxiom)ax));
    }
}

