
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was MauiManConfig.cmake.in.6                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib/cmake/MauiMan4" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

include(CMakeFindDependencyMacro)
find_dependency(Qt6Core 6.4)

# Any changes in this ".cmake" file will be overwritten by CMake, the source is the ".cmake.in" file.

foreach(PKG IN LISTS MauiMan4_FIND_COMPONENTS)
    find_package(MauiMan4${PKG})
    if(MauiMan_FIND_REQUIRED_${PKG})
        set_package_properties(MauiMan4${PKG} PROPERTIES TYPE REQUIRED)
    else()
        set_package_properties(MauiMan4${PKG} PROPERTIES TYPE OPTIONAL)
    endif()

    set(MauiMan46_${PKG}_FOUND ${MauiMan4${PKG}_FOUND})
endforeach()

include("${CMAKE_CURRENT_LIST_DIR}/MauiMan4Targets.cmake")

set(MauiMan4_INSTALL_PREFIX "${PACKAGE_PREFIX_DIR}")


