/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.charts;

import org.graalvm.visualvm.lib.charts.ChartItem;

public interface ItemSelection {
    public static final int DISTANCE_UNKNOWN = Integer.MAX_VALUE;

    public ChartItem getItem();

    public int getDistance();

    public static class Default
    implements ItemSelection {
        private ChartItem item;
        private int distance;

        public Default(ChartItem item) {
            this(item, Integer.MAX_VALUE);
        }

        public Default(ChartItem item, int distance) {
            this.item = item;
            this.distance = distance;
        }

        @Override
        public ChartItem getItem() {
            return this.item;
        }

        @Override
        public int getDistance() {
            return this.distance;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ItemSelection)) {
                return false;
            }
            ItemSelection selection = (ItemSelection)o;
            return selection.getItem() == this.item;
        }

        public int hashCode() {
            return this.item.hashCode();
        }
    }
}

