/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.uisupport;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.UIManager;
import org.graalvm.visualvm.lib.ui.UIUtils;

public class JExtendedSpinner
extends JSpinner {
    private static int defaultSpinnerHeight = -1;

    public static int getDefaultSpinnerHeight() {
        if (defaultSpinnerHeight == -1) {
            defaultSpinnerHeight = new JTextField().getPreferredSize().height;
        }
        return defaultSpinnerHeight;
    }

    public JExtendedSpinner() {
        ((JSpinner.DefaultEditor)this.getEditor()).getTextField().setFont(UIManager.getFont("Label.font"));
        ((JSpinner.DefaultEditor)this.getEditor()).getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    JExtendedSpinner.this.processKeyEvent(e);
                }
            }
        });
        this.configureWheelListener();
    }

    public JExtendedSpinner(SpinnerModel model) {
        super(model);
        ((JSpinner.DefaultEditor)this.getEditor()).getTextField().setFont(UIManager.getFont("Label.font"));
        ((JSpinner.DefaultEditor)this.getEditor()).getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    JExtendedSpinner.this.processKeyEvent(e);
                }
            }
        });
        this.configureWheelListener();
    }

    @Override
    public void setModel(SpinnerModel model) {
        Font font = ((JSpinner.DefaultEditor)this.getEditor()).getTextField().getFont();
        String accessibleName = ((JSpinner.DefaultEditor)this.getEditor()).getTextField().getAccessibleContext().getAccessibleName();
        String accessibleDescription = ((JSpinner.DefaultEditor)this.getEditor()).getTextField().getAccessibleContext().getAccessibleDescription();
        super.setModel(model);
        ((JSpinner.DefaultEditor)this.getEditor()).getTextField().setFont(font);
        ((JSpinner.DefaultEditor)this.getEditor()).getTextField().getAccessibleContext().setAccessibleName(accessibleName);
        ((JSpinner.DefaultEditor)this.getEditor()).getTextField().getAccessibleContext().setAccessibleDescription(accessibleDescription);
    }

    public void fixAccessibility() {
        if (this.getAccessibleContext() != null) {
            ((JSpinner.DefaultEditor)this.getEditor()).getTextField().getAccessibleContext().setAccessibleName(this.getAccessibleContext().getAccessibleName());
            ((JSpinner.DefaultEditor)this.getEditor()).getTextField().getAccessibleContext().setAccessibleDescription(this.getAccessibleContext().getAccessibleDescription());
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (UIUtils.isWindowsClassicLookAndFeel()) {
            return new Dimension(super.getPreferredSize().width, JExtendedSpinner.getDefaultSpinnerHeight());
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        if (UIUtils.isWindowsClassicLookAndFeel()) {
            return this.getPreferredSize();
        }
        return super.getMinimumSize();
    }

    private void configureWheelListener() {
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                Object newValue;
                if (e.getScrollType() != 0) {
                    return;
                }
                Object object = newValue = e.getWheelRotation() < 0 ? JExtendedSpinner.this.getNextValue() : JExtendedSpinner.this.getPreviousValue();
                if (newValue != null) {
                    JExtendedSpinner.this.setValue(newValue);
                }
            }
        });
    }
}

