/*
 * Decompiled with CFR 0.152.
 */
package scala.math;

import java.math.BigInteger;
import scala.math.BigDecimal;
import scala.math.BigInt$;
import scala.math.Ordered;
import scala.math.ScalaNumber;
import scala.math.ScalaNumericAnyConversions;
import scala.math.ScalaNumericConversions;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public final class BigInt
extends ScalaNumber
implements Ordered<BigInt>,
ScalaNumericConversions {
    private BigInteger _bigInteger;
    private final long _long;

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean $less$eq(Object that) {
        void var1_1;
        return Ordered.$less$eq$(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compareTo(Object that) {
        void var1_1;
        return Ordered.compareTo$(this, var1_1);
    }

    @Override
    public final byte toByte() {
        return ScalaNumericAnyConversions.toByte$(this);
    }

    @Override
    public final short toShort() {
        return ScalaNumericAnyConversions.toShort$(this);
    }

    @Override
    public final int toInt() {
        return ScalaNumericAnyConversions.toInt$(this);
    }

    @Override
    public final long toLong() {
        return ScalaNumericAnyConversions.toLong$(this);
    }

    @Override
    public final float toFloat() {
        return ScalaNumericAnyConversions.toFloat$(this);
    }

    @Override
    public final double toDouble() {
        return ScalaNumericAnyConversions.toDouble$(this);
    }

    @Override
    public final int unifiedPrimitiveHashcode() {
        return ScalaNumericAnyConversions.unifiedPrimitiveHashcode$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean unifiedPrimitiveEquals(Object x) {
        void var1_1;
        return ScalaNumericAnyConversions.unifiedPrimitiveEquals$(this, var1_1);
    }

    private BigInteger _bigInteger() {
        return this._bigInteger;
    }

    /*
     * WARNING - void declaration
     */
    private void _bigInteger_$eq(BigInteger x$1) {
        void var1_1;
        this._bigInteger = var1_1;
    }

    private long _long() {
        return this._long;
    }

    private boolean longEncoding() {
        return this._long() != Long.MIN_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public final BigInteger bigInteger() {
        void var1_1;
        BigInteger read = this._bigInteger();
        if (read != null) {
            return read;
        }
        BigInteger write = BigInteger.valueOf(this._long());
        this._bigInteger_$eq(write);
        return var1_1;
    }

    public final int hashCode() {
        if (this.isValidLong()) {
            return ScalaNumericAnyConversions.unifiedPrimitiveHashcode$(this);
        }
        return Statics.anyHash(this.bigInteger());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object that2) {
        void var1_1;
        if (that2 instanceof BigInt) {
            that2 = (BigInt)that2;
            return this.equals((BigInt)that2);
        }
        if (that2 instanceof BigDecimal) {
            return ((BigDecimal)that2).equals(this);
        }
        if (that2 instanceof Double) {
            double d = BoxesRunTime.unboxToDouble(that2);
            return this.isValidDouble() && this.doubleValue() == d;
        }
        if (that2 instanceof Float) {
            float that2 = BoxesRunTime.unboxToFloat(that2);
            return this.isValidFloat() && this.floatValue() == that2;
        }
        return this.isValidLong() && ScalaNumericAnyConversions.unifiedPrimitiveEquals$(this, var1_1);
    }

    @Override
    public final boolean isValidByte() {
        return this._long() >= -128L && this._long() <= 127L;
    }

    @Override
    public final boolean isValidShort() {
        return this._long() >= -32768L && this._long() <= 32767L;
    }

    @Override
    public final boolean isValidChar() {
        return this._long() >= 0L && this._long() <= 65535L;
    }

    @Override
    public final boolean isValidInt() {
        return this._long() >= Integer.MIN_VALUE && this._long() <= Integer.MAX_VALUE;
    }

    public final boolean isValidLong() {
        return this.longEncoding() || BoxesRunTime.equalsNumNum(this._bigInteger(), BigInt$.MODULE$.scala$math$BigInt$$longMinValueBigInteger());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isValidFloat() {
        block5: {
            block4: {
                void var2_2;
                void var1_1;
                int bitLen = this.bitLength();
                if (bitLen <= 24) break block4;
                int lowest = this.lowestSetBit();
                if (bitLen > 128 || lowest < var1_1 - 24 || var2_2 >= 128) break block5;
            }
            if (!this.bitLengthOverflow()) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isValidDouble() {
        block5: {
            block4: {
                void var2_2;
                void var1_1;
                int bitLen = this.bitLength();
                if (bitLen <= 53) break block4;
                int lowest = this.lowestSetBit();
                if (bitLen > 1024 || lowest < var1_1 - 53 || var2_2 >= 1024) break block5;
            }
            if (!this.bitLengthOverflow()) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean bitLengthOverflow() {
        void var1_1;
        BigInteger shifted = this.bigInteger().shiftRight(Integer.MAX_VALUE);
        return shifted.signum() != 0 && !var1_1.equals(BigInt$.MODULE$.scala$math$BigInt$$minusOne());
    }

    @Override
    public final boolean isWhole() {
        return true;
    }

    @Override
    public final BigInteger underlying() {
        return this.bigInteger();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(BigInt that) {
        void var1_1;
        if (this.longEncoding()) {
            return that.longEncoding() && this._long() == that._long();
        }
        return !that.longEncoding() && BoxesRunTime.equalsNumNum(this._bigInteger(), super._bigInteger());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compare(BigInt that) {
        void var1_1;
        if (this.longEncoding()) {
            if (that.longEncoding()) {
                return Long.compare(this._long(), that._long());
            }
            return -that._bigInteger().signum();
        }
        if (that.longEncoding()) {
            return this._bigInteger().signum();
        }
        return this._bigInteger().compareTo(super._bigInteger());
    }

    /*
     * WARNING - void declaration
     */
    public final BigInt $plus(BigInt that) {
        void var1_1;
        long z;
        void var2_2;
        long y;
        long x;
        if (this.longEncoding() && that.longEncoding() && (((x = this._long()) ^ (y = that._long()) ^ 0xFFFFFFFFFFFFFFFFL) & (var2_2 ^ (z = x + y))) >= 0L) {
            return BigInt$.MODULE$.apply(z);
        }
        return BigInt$.MODULE$.apply(this.bigInteger().add(var1_1.bigInteger()));
    }

    /*
     * WARNING - void declaration
     */
    public final BigInt $minus(BigInt that) {
        void var1_1;
        long z;
        void var2_2;
        long y;
        long x;
        if (this.longEncoding() && that.longEncoding() && (((x = this._long()) ^ (y = that._long())) & (var2_2 ^ (z = x - y))) >= 0L) {
            return BigInt$.MODULE$.apply(z);
        }
        return BigInt$.MODULE$.apply(this.bigInteger().subtract(var1_1.bigInteger()));
    }

    /*
     * WARNING - void declaration
     */
    public final BigInt $times(BigInt that) {
        void var1_1;
        if (this.longEncoding() && that.longEncoding()) {
            void var2_2;
            long x = this._long();
            long y = that._long();
            long z = x * y;
            if (x == 0L || y == z / var2_2) {
                return BigInt$.MODULE$.apply(z);
            }
        }
        return BigInt$.MODULE$.apply(this.bigInteger().multiply(var1_1.bigInteger()));
    }

    /*
     * WARNING - void declaration
     */
    public final BigInt $div(BigInt that) {
        void var1_1;
        if (this.longEncoding() && that.longEncoding()) {
            return BigInt$.MODULE$.apply(this._long() / that._long());
        }
        return BigInt$.MODULE$.apply(this.bigInteger().divide(var1_1.bigInteger()));
    }

    /*
     * WARNING - void declaration
     */
    public final BigInt $percent(BigInt that) {
        void var1_1;
        if (this.longEncoding() && that.longEncoding()) {
            return BigInt$.MODULE$.apply(this._long() % that._long());
        }
        return BigInt$.MODULE$.apply(this.bigInteger().remainder(var1_1.bigInteger()));
    }

    public final BigInt unary_$minus() {
        if (this.longEncoding()) {
            return BigInt$.MODULE$.apply(-this._long());
        }
        return BigInt$.MODULE$.apply(this.bigInteger().negate());
    }

    public final int lowestSetBit() {
        if (this.longEncoding()) {
            if (this._long() == 0L) {
                return -1;
            }
            return Long.numberOfTrailingZeros(this._long());
        }
        return this.bigInteger().getLowestSetBit();
    }

    public final int bitLength() {
        if (this.longEncoding()) {
            if (this._long() < 0L) {
                return 64 - Long.numberOfLeadingZeros(-(this._long() + 1L));
            }
            return 64 - Long.numberOfLeadingZeros(this._long());
        }
        return this._bigInteger().bitLength();
    }

    @Override
    public final byte byteValue() {
        return (byte)this.intValue();
    }

    @Override
    public final short shortValue() {
        return (short)this.intValue();
    }

    @Override
    public final int intValue() {
        if (this.longEncoding()) {
            return (int)this._long();
        }
        return this.bigInteger().intValue();
    }

    @Override
    public final long longValue() {
        if (this.longEncoding()) {
            return this._long();
        }
        return this._bigInteger().longValue();
    }

    @Override
    public final float floatValue() {
        return this.bigInteger().floatValue();
    }

    @Override
    public final double doubleValue() {
        if (this.isValidLong() && -9007199254740992L <= this._long() && this._long() <= 0x20000000000000L) {
            return this._long();
        }
        return this.bigInteger().doubleValue();
    }

    public final String toString() {
        if (this.longEncoding()) {
            return Long.toString(this._long());
        }
        return this._bigInteger().toString();
    }

    /*
     * WARNING - void declaration
     */
    public BigInt(BigInteger _bigInteger, long _long) {
        void var2_2;
        void var1_1;
        this._bigInteger = var1_1;
        this._long = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public BigInt(BigInteger bigInteger) {
        void var1_1;
        BigInteger bigInteger2 = bigInteger;
        this(bigInteger2, bigInteger2.bitLength() <= 63 ? var1_1.longValue() : Long.MIN_VALUE);
    }
}

