/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.pool2.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.tomcat.dbcp.pool2.BaseObject;
import org.apache.tomcat.dbcp.pool2.PooledObject;
import org.apache.tomcat.dbcp.pool2.PooledObjectState;
import org.apache.tomcat.dbcp.pool2.SwallowedExceptionListener;
import org.apache.tomcat.dbcp.pool2.impl.AbandonedConfig;
import org.apache.tomcat.dbcp.pool2.impl.BaseObjectPoolConfig;
import org.apache.tomcat.dbcp.pool2.impl.EvictionPolicy;
import org.apache.tomcat.dbcp.pool2.impl.EvictionTimer;
import org.apache.tomcat.dbcp.pool2.impl.PoolImplUtils;

public abstract class BaseGenericObjectPool<T>
extends BaseObject
implements AutoCloseable {
    public static final int MEAN_TIMING_STATS_CACHE_SIZE = 100;
    private static final String EVICTION_POLICY_TYPE_NAME = EvictionPolicy.class.getName();
    private static final Duration DEFAULT_REMOVE_ABANDONED_TIMEOUT = Duration.ofSeconds(Integer.MAX_VALUE);
    private volatile int maxTotal = -1;
    private volatile boolean blockWhenExhausted = true;
    private volatile Duration maxWaitDuration = BaseObjectPoolConfig.DEFAULT_MAX_WAIT;
    private volatile boolean lifo = true;
    private final boolean fairness;
    private volatile boolean testOnCreate = false;
    private volatile boolean testOnBorrow = false;
    private volatile boolean testOnReturn = false;
    private volatile boolean testWhileIdle = false;
    private volatile Duration durationBetweenEvictionRuns = BaseObjectPoolConfig.DEFAULT_DURATION_BETWEEN_EVICTION_RUNS;
    private volatile int numTestsPerEvictionRun = 3;
    private volatile Duration minEvictableIdleDuration = BaseObjectPoolConfig.DEFAULT_MIN_EVICTABLE_IDLE_DURATION;
    private volatile Duration softMinEvictableIdleDuration = BaseObjectPoolConfig.DEFAULT_SOFT_MIN_EVICTABLE_IDLE_DURATION;
    private volatile EvictionPolicy<T> evictionPolicy;
    private volatile Duration evictorShutdownTimeoutDuration = BaseObjectPoolConfig.DEFAULT_EVICTOR_SHUTDOWN_TIMEOUT;
    final Object closeLock = new Object();
    volatile boolean closed;
    final Object evictionLock = new Object();
    private Evictor evictor;
    EvictionIterator evictionIterator;
    private final WeakReference<ClassLoader> factoryClassLoader;
    private final ObjectName objectName;
    private final String creationStackTrace;
    private final AtomicLong borrowedCount = new AtomicLong();
    private final AtomicLong returnedCount = new AtomicLong();
    final AtomicLong createdCount = new AtomicLong();
    final AtomicLong destroyedCount = new AtomicLong();
    final AtomicLong destroyedByEvictorCount = new AtomicLong();
    final AtomicLong destroyedByBorrowValidationCount = new AtomicLong();
    private final StatsStore activeTimes = new StatsStore(100);
    private final StatsStore idleTimes = new StatsStore(100);
    private final StatsStore waitTimes = new StatsStore(100);
    private final AtomicReference<Duration> maxBorrowWaitDuration = new AtomicReference<Duration>(Duration.ZERO);
    private volatile SwallowedExceptionListener swallowedExceptionListener;
    private volatile boolean messageStatistics;
    protected volatile AbandonedConfig abandonedConfig;

    public BaseGenericObjectPool(BaseObjectPoolConfig<T> baseObjectPoolConfig, String string, String string2) {
        this.objectName = baseObjectPoolConfig.getJmxEnabled() ? this.jmxRegister(baseObjectPoolConfig, string, string2) : null;
        this.creationStackTrace = this.getStackTrace(new Exception());
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.factoryClassLoader = classLoader == null ? null : new WeakReference<ClassLoader>(classLoader);
        this.fairness = baseObjectPoolConfig.getFairness();
    }

    String appendStats(String string) {
        return this.messageStatistics ? string + ", " + this.getStatsString() : string;
    }

    final void assertOpen() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("Pool not open");
        }
    }

    @Override
    public abstract void close();

    ArrayList<PooledObject<T>> createRemoveList(AbandonedConfig abandonedConfig, Map<IdentityWrapper<T>, PooledObject<T>> map) {
        Instant instant = Instant.now().minus(abandonedConfig.getRemoveAbandonedTimeoutDuration());
        ArrayList arrayList = new ArrayList();
        map.values().forEach(pooledObject -> {
            PooledObject pooledObject2 = pooledObject;
            synchronized (pooledObject2) {
                if (pooledObject.getState() == PooledObjectState.ALLOCATED && pooledObject.getLastUsedInstant().compareTo(instant) <= 0) {
                    pooledObject.markAbandoned();
                    arrayList.add((PooledObject)pooledObject);
                }
            }
        });
        return arrayList;
    }

    abstract void ensureMinIdle() throws Exception;

    public abstract void evict() throws Exception;

    public final boolean getBlockWhenExhausted() {
        return this.blockWhenExhausted;
    }

    public final long getBorrowedCount() {
        return this.borrowedCount.get();
    }

    public final long getCreatedCount() {
        return this.createdCount.get();
    }

    public final String getCreationStackTrace() {
        return this.creationStackTrace;
    }

    public final long getDestroyedByBorrowValidationCount() {
        return this.destroyedByBorrowValidationCount.get();
    }

    public final long getDestroyedByEvictorCount() {
        return this.destroyedByEvictorCount.get();
    }

    public final long getDestroyedCount() {
        return this.destroyedCount.get();
    }

    public final Duration getDurationBetweenEvictionRuns() {
        return this.durationBetweenEvictionRuns;
    }

    public EvictionPolicy<T> getEvictionPolicy() {
        return this.evictionPolicy;
    }

    public final String getEvictionPolicyClassName() {
        return this.evictionPolicy.getClass().getName();
    }

    @Deprecated
    public final Duration getEvictorShutdownTimeout() {
        return this.evictorShutdownTimeoutDuration;
    }

    public final Duration getEvictorShutdownTimeoutDuration() {
        return this.evictorShutdownTimeoutDuration;
    }

    @Deprecated
    public final long getEvictorShutdownTimeoutMillis() {
        return this.evictorShutdownTimeoutDuration.toMillis();
    }

    public final boolean getFairness() {
        return this.fairness;
    }

    public final ObjectName getJmxName() {
        return this.objectName;
    }

    public final boolean getLifo() {
        return this.lifo;
    }

    public boolean getLogAbandoned() {
        AbandonedConfig abandonedConfig = this.abandonedConfig;
        return abandonedConfig != null && abandonedConfig.getLogAbandoned();
    }

    public final Duration getMaxBorrowWaitDuration() {
        return this.maxBorrowWaitDuration.get();
    }

    @Deprecated
    public final long getMaxBorrowWaitTimeMillis() {
        return this.maxBorrowWaitDuration.get().toMillis();
    }

    public final int getMaxTotal() {
        return this.maxTotal;
    }

    public final Duration getMaxWaitDuration() {
        return this.maxWaitDuration;
    }

    @Deprecated
    public final long getMaxWaitMillis() {
        return this.maxWaitDuration.toMillis();
    }

    public final Duration getMeanActiveDuration() {
        return this.activeTimes.getMeanDuration();
    }

    @Deprecated
    public final long getMeanActiveTimeMillis() {
        return this.activeTimes.getMean();
    }

    public final Duration getMeanBorrowWaitDuration() {
        return this.waitTimes.getMeanDuration();
    }

    @Deprecated
    public final long getMeanBorrowWaitTimeMillis() {
        return this.waitTimes.getMean();
    }

    public final Duration getMeanIdleDuration() {
        return this.idleTimes.getMeanDuration();
    }

    @Deprecated
    public final long getMeanIdleTimeMillis() {
        return this.idleTimes.getMean();
    }

    public boolean getMessageStatistics() {
        return this.messageStatistics;
    }

    public final Duration getMinEvictableIdleDuration() {
        return this.minEvictableIdleDuration;
    }

    @Deprecated
    public final Duration getMinEvictableIdleTime() {
        return this.minEvictableIdleDuration;
    }

    @Deprecated
    public final long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleDuration.toMillis();
    }

    public abstract int getNumIdle();

    public final int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public boolean getRemoveAbandonedOnBorrow() {
        AbandonedConfig abandonedConfig = this.abandonedConfig;
        return abandonedConfig != null && abandonedConfig.getRemoveAbandonedOnBorrow();
    }

    public boolean getRemoveAbandonedOnMaintenance() {
        AbandonedConfig abandonedConfig = this.abandonedConfig;
        return abandonedConfig != null && abandonedConfig.getRemoveAbandonedOnMaintenance();
    }

    @Deprecated
    public int getRemoveAbandonedTimeout() {
        return (int)this.getRemoveAbandonedTimeoutDuration().getSeconds();
    }

    public Duration getRemoveAbandonedTimeoutDuration() {
        AbandonedConfig abandonedConfig = this.abandonedConfig;
        return abandonedConfig != null ? abandonedConfig.getRemoveAbandonedTimeoutDuration() : DEFAULT_REMOVE_ABANDONED_TIMEOUT;
    }

    public final long getReturnedCount() {
        return this.returnedCount.get();
    }

    public final Duration getSoftMinEvictableIdleDuration() {
        return this.softMinEvictableIdleDuration;
    }

    @Deprecated
    public final Duration getSoftMinEvictableIdleTime() {
        return this.softMinEvictableIdleDuration;
    }

    @Deprecated
    public final long getSoftMinEvictableIdleTimeMillis() {
        return this.softMinEvictableIdleDuration.toMillis();
    }

    private String getStackTrace(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        return ((Object)stringWriter).toString();
    }

    String getStatsString() {
        return String.format("activeTimes=%s, blockWhenExhausted=%s, borrowedCount=%,d, closed=%s, createdCount=%,d, destroyedByBorrowValidationCount=%,d, destroyedByEvictorCount=%,d, evictorShutdownTimeoutDuration=%s, fairness=%s, idleTimes=%s, lifo=%s, maxBorrowWaitDuration=%s, maxTotal=%s, maxWaitDuration=%s, minEvictableIdleDuration=%s, numTestsPerEvictionRun=%s, returnedCount=%s, softMinEvictableIdleDuration=%s, testOnBorrow=%s, testOnCreate=%s, testOnReturn=%s, testWhileIdle=%s, durationBetweenEvictionRuns=%s, waitTimes=%s", this.activeTimes.getValues(), this.blockWhenExhausted, this.borrowedCount.get(), this.closed, this.createdCount.get(), this.destroyedByBorrowValidationCount.get(), this.destroyedByEvictorCount.get(), this.evictorShutdownTimeoutDuration, this.fairness, this.idleTimes.getValues(), this.lifo, this.maxBorrowWaitDuration.get(), this.maxTotal, this.maxWaitDuration, this.minEvictableIdleDuration, this.numTestsPerEvictionRun, this.returnedCount, this.softMinEvictableIdleDuration, this.testOnBorrow, this.testOnCreate, this.testOnReturn, this.testWhileIdle, this.durationBetweenEvictionRuns, this.waitTimes.getValues());
    }

    public final SwallowedExceptionListener getSwallowedExceptionListener() {
        return this.swallowedExceptionListener;
    }

    public final boolean getTestOnBorrow() {
        return this.testOnBorrow;
    }

    public final boolean getTestOnCreate() {
        return this.testOnCreate;
    }

    public final boolean getTestOnReturn() {
        return this.testOnReturn;
    }

    public final boolean getTestWhileIdle() {
        return this.testWhileIdle;
    }

    @Deprecated
    public final Duration getTimeBetweenEvictionRuns() {
        return this.durationBetweenEvictionRuns;
    }

    @Deprecated
    public final long getTimeBetweenEvictionRunsMillis() {
        return this.durationBetweenEvictionRuns.toMillis();
    }

    public boolean isAbandonedConfig() {
        return this.abandonedConfig != null;
    }

    public final boolean isClosed() {
        return this.closed;
    }

    private ObjectName jmxRegister(BaseObjectPoolConfig<T> baseObjectPoolConfig, String string, String string2) {
        ObjectName objectName = null;
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        int n = 1;
        boolean bl = false;
        String string3 = baseObjectPoolConfig.getJmxNameBase();
        if (string3 == null) {
            string3 = string;
        }
        while (!bl) {
            try {
                ObjectName objectName2 = n == 1 ? new ObjectName(string3 + string2) : new ObjectName(string3 + string2 + n);
                if (!mBeanServer.isRegistered(objectName2)) {
                    mBeanServer.registerMBean(this, objectName2);
                    objectName = objectName2;
                    bl = true;
                    continue;
                }
                ++n;
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                if ("pool".equals(string2) && string.equals(string3)) {
                    bl = true;
                    continue;
                }
                string2 = "pool";
                string3 = string;
            }
            catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                ++n;
            }
            catch (MBeanRegistrationException | NotCompliantMBeanException jMException) {
                bl = true;
            }
        }
        return objectName;
    }

    final void jmxUnregister() {
        if (this.objectName != null) {
            try {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.objectName);
            }
            catch (InstanceNotFoundException | MBeanRegistrationException jMException) {
                this.swallowException(jMException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markReturningState(PooledObject<T> pooledObject) {
        PooledObject<T> pooledObject2 = pooledObject;
        synchronized (pooledObject2) {
            if (pooledObject.getState() != PooledObjectState.ALLOCATED) {
                throw new IllegalStateException("Object has already been returned to this pool or is invalid");
            }
            pooledObject.markReturning();
        }
    }

    public void setAbandonedConfig(AbandonedConfig abandonedConfig) {
        this.abandonedConfig = AbandonedConfig.copy(abandonedConfig);
    }

    public final void setBlockWhenExhausted(boolean bl) {
        this.blockWhenExhausted = bl;
    }

    protected void setConfig(BaseObjectPoolConfig<T> baseObjectPoolConfig) {
        this.setLifo(baseObjectPoolConfig.getLifo());
        this.setMaxWait(baseObjectPoolConfig.getMaxWaitDuration());
        this.setBlockWhenExhausted(baseObjectPoolConfig.getBlockWhenExhausted());
        this.setTestOnCreate(baseObjectPoolConfig.getTestOnCreate());
        this.setTestOnBorrow(baseObjectPoolConfig.getTestOnBorrow());
        this.setTestOnReturn(baseObjectPoolConfig.getTestOnReturn());
        this.setTestWhileIdle(baseObjectPoolConfig.getTestWhileIdle());
        this.setNumTestsPerEvictionRun(baseObjectPoolConfig.getNumTestsPerEvictionRun());
        this.setMinEvictableIdleDuration(baseObjectPoolConfig.getMinEvictableIdleDuration());
        this.setDurationBetweenEvictionRuns(baseObjectPoolConfig.getDurationBetweenEvictionRuns());
        this.setSoftMinEvictableIdleDuration(baseObjectPoolConfig.getSoftMinEvictableIdleDuration());
        EvictionPolicy<T> evictionPolicy = baseObjectPoolConfig.getEvictionPolicy();
        if (evictionPolicy == null) {
            this.setEvictionPolicyClassName(baseObjectPoolConfig.getEvictionPolicyClassName());
        } else {
            this.setEvictionPolicy(evictionPolicy);
        }
        this.setEvictorShutdownTimeout(baseObjectPoolConfig.getEvictorShutdownTimeoutDuration());
    }

    public final void setDurationBetweenEvictionRuns(Duration duration) {
        this.durationBetweenEvictionRuns = PoolImplUtils.nonNull(duration, BaseObjectPoolConfig.DEFAULT_DURATION_BETWEEN_EVICTION_RUNS);
        this.startEvictor(this.durationBetweenEvictionRuns);
    }

    public void setEvictionPolicy(EvictionPolicy<T> evictionPolicy) {
        this.evictionPolicy = evictionPolicy;
    }

    private void setEvictionPolicy(String string, ClassLoader classLoader) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> clazz = Class.forName(string, true, classLoader);
        Object obj = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        this.evictionPolicy = (EvictionPolicy)obj;
    }

    public final void setEvictionPolicyClassName(String string) {
        this.setEvictionPolicyClassName(string, Thread.currentThread().getContextClassLoader());
    }

    public final void setEvictionPolicyClassName(String string, ClassLoader classLoader) {
        Class<EvictionPolicy> clazz = EvictionPolicy.class;
        ClassLoader classLoader2 = clazz.getClassLoader();
        try {
            try {
                this.setEvictionPolicy(string, classLoader);
            }
            catch (ClassCastException | ClassNotFoundException exception) {
                this.setEvictionPolicy(string, classLoader2);
            }
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Class " + string + " from class loaders [" + classLoader + ", " + classLoader2 + "] do not implement " + EVICTION_POLICY_TYPE_NAME);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            throw new IllegalArgumentException("Unable to create " + EVICTION_POLICY_TYPE_NAME + " instance of type " + string, reflectiveOperationException);
        }
    }

    public final void setEvictorShutdownTimeout(Duration duration) {
        this.evictorShutdownTimeoutDuration = PoolImplUtils.nonNull(duration, BaseObjectPoolConfig.DEFAULT_EVICTOR_SHUTDOWN_TIMEOUT);
    }

    @Deprecated
    public final void setEvictorShutdownTimeoutMillis(long l) {
        this.setEvictorShutdownTimeout(Duration.ofMillis(l));
    }

    public final void setLifo(boolean bl) {
        this.lifo = bl;
    }

    public final void setMaxTotal(int n) {
        this.maxTotal = n;
    }

    public final void setMaxWait(Duration duration) {
        this.maxWaitDuration = PoolImplUtils.nonNull(duration, BaseObjectPoolConfig.DEFAULT_MAX_WAIT);
    }

    @Deprecated
    public final void setMaxWaitMillis(long l) {
        this.setMaxWait(Duration.ofMillis(l));
    }

    public void setMessagesStatistics(boolean bl) {
        this.messageStatistics = bl;
    }

    @Deprecated
    public final void setMinEvictableIdle(Duration duration) {
        this.minEvictableIdleDuration = PoolImplUtils.nonNull(duration, BaseObjectPoolConfig.DEFAULT_MIN_EVICTABLE_IDLE_DURATION);
    }

    public final void setMinEvictableIdleDuration(Duration duration) {
        this.minEvictableIdleDuration = PoolImplUtils.nonNull(duration, BaseObjectPoolConfig.DEFAULT_MIN_EVICTABLE_IDLE_DURATION);
    }

    @Deprecated
    public final void setMinEvictableIdleTime(Duration duration) {
        this.minEvictableIdleDuration = PoolImplUtils.nonNull(duration, BaseObjectPoolConfig.DEFAULT_MIN_EVICTABLE_IDLE_DURATION);
    }

    @Deprecated
    public final void setMinEvictableIdleTimeMillis(long l) {
        this.setMinEvictableIdleTime(Duration.ofMillis(l));
    }

    public final void setNumTestsPerEvictionRun(int n) {
        this.numTestsPerEvictionRun = n;
    }

    @Deprecated
    public final void setSoftMinEvictableIdle(Duration duration) {
        this.softMinEvictableIdleDuration = PoolImplUtils.nonNull(duration, BaseObjectPoolConfig.DEFAULT_SOFT_MIN_EVICTABLE_IDLE_DURATION);
    }

    public final void setSoftMinEvictableIdleDuration(Duration duration) {
        this.softMinEvictableIdleDuration = PoolImplUtils.nonNull(duration, BaseObjectPoolConfig.DEFAULT_SOFT_MIN_EVICTABLE_IDLE_DURATION);
    }

    @Deprecated
    public final void setSoftMinEvictableIdleTime(Duration duration) {
        this.softMinEvictableIdleDuration = PoolImplUtils.nonNull(duration, BaseObjectPoolConfig.DEFAULT_SOFT_MIN_EVICTABLE_IDLE_DURATION);
    }

    @Deprecated
    public final void setSoftMinEvictableIdleTimeMillis(long l) {
        this.setSoftMinEvictableIdleTime(Duration.ofMillis(l));
    }

    public final void setSwallowedExceptionListener(SwallowedExceptionListener swallowedExceptionListener) {
        this.swallowedExceptionListener = swallowedExceptionListener;
    }

    public final void setTestOnBorrow(boolean bl) {
        this.testOnBorrow = bl;
    }

    public final void setTestOnCreate(boolean bl) {
        this.testOnCreate = bl;
    }

    public final void setTestOnReturn(boolean bl) {
        this.testOnReturn = bl;
    }

    public final void setTestWhileIdle(boolean bl) {
        this.testWhileIdle = bl;
    }

    @Deprecated
    public final void setTimeBetweenEvictionRuns(Duration duration) {
        this.durationBetweenEvictionRuns = PoolImplUtils.nonNull(duration, BaseObjectPoolConfig.DEFAULT_DURATION_BETWEEN_EVICTION_RUNS);
        this.startEvictor(this.durationBetweenEvictionRuns);
    }

    @Deprecated
    public final void setTimeBetweenEvictionRunsMillis(long l) {
        this.setTimeBetweenEvictionRuns(Duration.ofMillis(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void startEvictor(Duration duration) {
        Object object = this.evictionLock;
        synchronized (object) {
            boolean bl = PoolImplUtils.isPositive(duration);
            if (this.evictor == null) {
                if (bl) {
                    this.evictor = new Evictor();
                    EvictionTimer.schedule(this.evictor, duration, duration);
                }
            } else if (bl) {
                Class<EvictionTimer> clazz = EvictionTimer.class;
                synchronized (EvictionTimer.class) {
                    EvictionTimer.cancel(this.evictor, this.evictorShutdownTimeoutDuration, true);
                    this.evictor = null;
                    this.evictionIterator = null;
                    this.evictor = new Evictor();
                    EvictionTimer.schedule(this.evictor, duration, duration);
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                }
            } else {
                EvictionTimer.cancel(this.evictor, this.evictorShutdownTimeoutDuration, false);
            }
            {
            }
        }
    }

    void stopEvictor() {
        this.startEvictor(Duration.ofMillis(-1L));
    }

    final void swallowException(Exception exception) {
        SwallowedExceptionListener swallowedExceptionListener = this.getSwallowedExceptionListener();
        if (swallowedExceptionListener == null) {
            return;
        }
        try {
            swallowedExceptionListener.onSwallowException(exception);
        }
        catch (VirtualMachineError virtualMachineError) {
            throw virtualMachineError;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    protected void toStringAppendFields(StringBuilder stringBuilder) {
        stringBuilder.append("maxTotal=");
        stringBuilder.append(this.maxTotal);
        stringBuilder.append(", blockWhenExhausted=");
        stringBuilder.append(this.blockWhenExhausted);
        stringBuilder.append(", maxWaitDuration=");
        stringBuilder.append(this.maxWaitDuration);
        stringBuilder.append(", lifo=");
        stringBuilder.append(this.lifo);
        stringBuilder.append(", fairness=");
        stringBuilder.append(this.fairness);
        stringBuilder.append(", testOnCreate=");
        stringBuilder.append(this.testOnCreate);
        stringBuilder.append(", testOnBorrow=");
        stringBuilder.append(this.testOnBorrow);
        stringBuilder.append(", testOnReturn=");
        stringBuilder.append(this.testOnReturn);
        stringBuilder.append(", testWhileIdle=");
        stringBuilder.append(this.testWhileIdle);
        stringBuilder.append(", durationBetweenEvictionRuns=");
        stringBuilder.append(this.durationBetweenEvictionRuns);
        stringBuilder.append(", numTestsPerEvictionRun=");
        stringBuilder.append(this.numTestsPerEvictionRun);
        stringBuilder.append(", minEvictableIdleTimeDuration=");
        stringBuilder.append(this.minEvictableIdleDuration);
        stringBuilder.append(", softMinEvictableIdleTimeDuration=");
        stringBuilder.append(this.softMinEvictableIdleDuration);
        stringBuilder.append(", evictionPolicy=");
        stringBuilder.append(this.evictionPolicy);
        stringBuilder.append(", closeLock=");
        stringBuilder.append(this.closeLock);
        stringBuilder.append(", closed=");
        stringBuilder.append(this.closed);
        stringBuilder.append(", evictionLock=");
        stringBuilder.append(this.evictionLock);
        stringBuilder.append(", evictor=");
        stringBuilder.append(this.evictor);
        stringBuilder.append(", evictionIterator=");
        stringBuilder.append(this.evictionIterator);
        stringBuilder.append(", factoryClassLoader=");
        stringBuilder.append(this.factoryClassLoader);
        stringBuilder.append(", oname=");
        stringBuilder.append(this.objectName);
        stringBuilder.append(", creationStackTrace=");
        stringBuilder.append(this.creationStackTrace);
        stringBuilder.append(", borrowedCount=");
        stringBuilder.append(this.borrowedCount);
        stringBuilder.append(", returnedCount=");
        stringBuilder.append(this.returnedCount);
        stringBuilder.append(", createdCount=");
        stringBuilder.append(this.createdCount);
        stringBuilder.append(", destroyedCount=");
        stringBuilder.append(this.destroyedCount);
        stringBuilder.append(", destroyedByEvictorCount=");
        stringBuilder.append(this.destroyedByEvictorCount);
        stringBuilder.append(", destroyedByBorrowValidationCount=");
        stringBuilder.append(this.destroyedByBorrowValidationCount);
        stringBuilder.append(", activeTimes=");
        stringBuilder.append(this.activeTimes);
        stringBuilder.append(", idleTimes=");
        stringBuilder.append(this.idleTimes);
        stringBuilder.append(", waitTimes=");
        stringBuilder.append(this.waitTimes);
        stringBuilder.append(", maxBorrowWaitDuration=");
        stringBuilder.append(this.maxBorrowWaitDuration);
        stringBuilder.append(", swallowedExceptionListener=");
        stringBuilder.append(this.swallowedExceptionListener);
    }

    final void updateStatsBorrow(PooledObject<T> pooledObject, Duration duration) {
        Duration duration2;
        this.borrowedCount.incrementAndGet();
        this.idleTimes.add(pooledObject.getIdleDuration());
        this.waitTimes.add(duration);
        while ((duration2 = this.maxBorrowWaitDuration.get()).compareTo(duration) < 0 && !this.maxBorrowWaitDuration.compareAndSet(duration2, duration)) {
        }
    }

    final void updateStatsReturn(Duration duration) {
        this.returnedCount.incrementAndGet();
        this.activeTimes.add(duration);
    }

    private static class StatsStore {
        private static final int NONE = -1;
        private final AtomicLong[] values;
        private final int size;
        private int index;

        StatsStore(int n2) {
            this.size = n2;
            this.values = new AtomicLong[n2];
            Arrays.setAll(this.values, n -> new AtomicLong(-1L));
        }

        void add(Duration duration) {
            this.add(duration.toMillis());
        }

        synchronized void add(long l) {
            this.values[this.index].set(l);
            ++this.index;
            if (this.index == this.size) {
                this.index = 0;
            }
        }

        public long getMean() {
            double d = 0.0;
            int n = 0;
            for (int i = 0; i < this.size; ++i) {
                long l = this.values[i].get();
                if (l == -1L) continue;
                d = d * ((double)(++n - 1) / (double)n) + (double)l / (double)n;
            }
            return (long)d;
        }

        Duration getMeanDuration() {
            return Duration.ofMillis(this.getMean());
        }

        synchronized List<AtomicLong> getValues() {
            return Arrays.stream(this.values, 0, this.index).collect(Collectors.toList());
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("StatsStore [");
            stringBuilder.append(this.getValues());
            stringBuilder.append("], size=");
            stringBuilder.append(this.size);
            stringBuilder.append(", index=");
            stringBuilder.append(this.index);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }

    class Evictor
    implements Runnable {
        private ScheduledFuture<?> scheduledFuture;

        Evictor() {
        }

        void cancel() {
            this.scheduledFuture.cancel(false);
        }

        BaseGenericObjectPool<T> owner() {
            return BaseGenericObjectPool.this;
        }

        @Override
        public void run() {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                if (BaseGenericObjectPool.this.factoryClassLoader != null) {
                    ClassLoader classLoader2 = (ClassLoader)BaseGenericObjectPool.this.factoryClassLoader.get();
                    if (classLoader2 == null) {
                        this.cancel();
                        return;
                    }
                    Thread.currentThread().setContextClassLoader(classLoader2);
                }
                try {
                    BaseGenericObjectPool.this.evict();
                }
                catch (Exception exception) {
                    BaseGenericObjectPool.this.swallowException(exception);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    outOfMemoryError.printStackTrace(System.err);
                }
                try {
                    BaseGenericObjectPool.this.ensureMinIdle();
                }
                catch (Exception exception) {
                    BaseGenericObjectPool.this.swallowException(exception);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }

        void setScheduledFuture(ScheduledFuture<?> scheduledFuture) {
            this.scheduledFuture = scheduledFuture;
        }

        public String toString() {
            return this.getClass().getName() + " [scheduledFuture=" + this.scheduledFuture + "]";
        }
    }

    class EvictionIterator
    implements Iterator<PooledObject<T>> {
        private final Deque<PooledObject<T>> idleObjects;
        private final Iterator<PooledObject<T>> idleObjectIterator;

        EvictionIterator(Deque<PooledObject<T>> deque) {
            this.idleObjects = deque;
            this.idleObjectIterator = BaseGenericObjectPool.this.getLifo() ? deque.descendingIterator() : deque.iterator();
        }

        public Deque<PooledObject<T>> getIdleObjects() {
            return this.idleObjects;
        }

        @Override
        public boolean hasNext() {
            return this.idleObjectIterator.hasNext();
        }

        @Override
        public PooledObject<T> next() {
            return this.idleObjectIterator.next();
        }

        @Override
        public void remove() {
            this.idleObjectIterator.remove();
        }
    }

    static class IdentityWrapper<T> {
        private final T instance;

        IdentityWrapper(T t) {
            this.instance = t;
        }

        public boolean equals(Object object) {
            return object instanceof IdentityWrapper && ((IdentityWrapper)object).instance == this.instance;
        }

        public T getObject() {
            return this.instance;
        }

        public int hashCode() {
            return System.identityHashCode(this.instance);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("IdentityWrapper [instance=");
            stringBuilder.append(this.instance);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }
}

