/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.commons.stats.eval.impl;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.opensearch.performanceanalyzer.commons.stats.eval.Statistics;
import org.opensearch.performanceanalyzer.commons.stats.eval.impl.IStatistic;
import org.opensearch.performanceanalyzer.commons.stats.eval.impl.vals.AggregateValue;

public class Sum
implements IStatistic<AggregateValue> {
    private AtomicLong sum = new AtomicLong(0L);
    private boolean empty = true;

    @Override
    public Statistics type() {
        return Statistics.SUM;
    }

    @Override
    public void calculate(String key, Number value) {
        this.sum.addAndGet(value.longValue());
        this.empty = false;
    }

    @Override
    public List<AggregateValue> get() {
        return Collections.singletonList(new AggregateValue(this.sum, this.type()));
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }
}

