/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.securityconf;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.EventBusBuilder;
import org.opensearch.client.Client;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.DefaultObjectMapper;
import org.opensearch.security.auditlog.config.AuditConfig;
import org.opensearch.security.auth.internal.InternalAuthenticationBackend;
import org.opensearch.security.configuration.ClusterInfoHolder;
import org.opensearch.security.configuration.ConfigurationChangeListener;
import org.opensearch.security.configuration.ConfigurationRepository;
import org.opensearch.security.configuration.StaticResourceException;
import org.opensearch.security.hasher.PasswordHasher;
import org.opensearch.security.securityconf.ConfigModel;
import org.opensearch.security.securityconf.ConfigModelV6;
import org.opensearch.security.securityconf.ConfigModelV7;
import org.opensearch.security.securityconf.DynamicConfigModel;
import org.opensearch.security.securityconf.DynamicConfigModelV6;
import org.opensearch.security.securityconf.DynamicConfigModelV7;
import org.opensearch.security.securityconf.Initializable;
import org.opensearch.security.securityconf.InternalUsersModel;
import org.opensearch.security.securityconf.NodesDnModel;
import org.opensearch.security.securityconf.impl.AllowlistingSettings;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.NodesDn;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.securityconf.impl.WhitelistingSettings;
import org.opensearch.security.securityconf.impl.v6.ActionGroupsV6;
import org.opensearch.security.securityconf.impl.v6.ConfigV6;
import org.opensearch.security.securityconf.impl.v6.InternalUserV6;
import org.opensearch.security.securityconf.impl.v6.RoleMappingsV6;
import org.opensearch.security.securityconf.impl.v6.RoleV6;
import org.opensearch.security.securityconf.impl.v7.ActionGroupsV7;
import org.opensearch.security.securityconf.impl.v7.ConfigV7;
import org.opensearch.security.securityconf.impl.v7.InternalUserV7;
import org.opensearch.security.securityconf.impl.v7.RoleMappingsV7;
import org.opensearch.security.securityconf.impl.v7.RoleV7;
import org.opensearch.security.securityconf.impl.v7.TenantV7;
import org.opensearch.security.support.WildcardMatcher;
import org.opensearch.threadpool.ThreadPool;

public class DynamicConfigFactory
implements Initializable,
ConfigurationChangeListener {
    public static final EventBusBuilder EVENT_BUS_BUILDER = EventBus.builder();
    private static SecurityDynamicConfiguration<RoleV7> staticRoles = SecurityDynamicConfiguration.empty();
    private static SecurityDynamicConfiguration<ActionGroupsV7> staticActionGroups = SecurityDynamicConfiguration.empty();
    private static SecurityDynamicConfiguration<TenantV7> staticTenants = SecurityDynamicConfiguration.empty();
    private static final WhitelistingSettings defaultWhitelistingSettings = new WhitelistingSettings();
    private static final AllowlistingSettings defaultAllowlistingSettings = new AllowlistingSettings();
    private static final AuditConfig defaultAuditConfig = AuditConfig.from(Settings.EMPTY);
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final ConfigurationRepository cr;
    private final AtomicBoolean initialized = new AtomicBoolean();
    private final EventBus eventBus = EVENT_BUS_BUILDER.build();
    private final Settings opensearchSettings;
    private final Path configPath;
    private final InternalAuthenticationBackend iab;
    private final ClusterInfoHolder cih;
    SecurityDynamicConfiguration<?> config;

    static void resetStatics() {
        staticRoles = SecurityDynamicConfiguration.empty();
        staticActionGroups = SecurityDynamicConfiguration.empty();
        staticTenants = SecurityDynamicConfiguration.empty();
    }

    private void loadStaticConfig() throws IOException {
        JsonNode staticRolesJsonNode = DefaultObjectMapper.YAML_MAPPER.readTree(DynamicConfigFactory.class.getResourceAsStream("/static_config/static_roles.yml"));
        staticRoles = SecurityDynamicConfiguration.fromNode(staticRolesJsonNode, CType.ROLES, 2, 0L, 0L);
        JsonNode staticActionGroupsJsonNode = DefaultObjectMapper.YAML_MAPPER.readTree(DynamicConfigFactory.class.getResourceAsStream("/static_config/static_action_groups.yml"));
        staticActionGroups = SecurityDynamicConfiguration.fromNode(staticActionGroupsJsonNode, CType.ACTIONGROUPS, 2, 0L, 0L);
        JsonNode staticTenantsJsonNode = DefaultObjectMapper.YAML_MAPPER.readTree(DynamicConfigFactory.class.getResourceAsStream("/static_config/static_tenants.yml"));
        staticTenants = SecurityDynamicConfiguration.fromNode(staticTenantsJsonNode, CType.TENANTS, 2, 0L, 0L);
    }

    public static final SecurityDynamicConfiguration<?> addStatics(SecurityDynamicConfiguration<?> original) {
        if (original.getCType() == CType.ACTIONGROUPS && !staticActionGroups.getCEntries().isEmpty()) {
            original.add(staticActionGroups.deepClone());
        }
        if (original.getCType() == CType.ROLES && !staticRoles.getCEntries().isEmpty()) {
            original.add(staticRoles.deepClone());
        }
        if (original.getCType() == CType.TENANTS && !staticTenants.getCEntries().isEmpty()) {
            original.add(staticTenants.deepClone());
        }
        return original;
    }

    public DynamicConfigFactory(ConfigurationRepository cr, Settings opensearchSettings, Path configPath, Client client, ThreadPool threadPool, ClusterInfoHolder cih, PasswordHasher passwordHasher) {
        this.cr = cr;
        this.opensearchSettings = opensearchSettings;
        this.configPath = configPath;
        this.cih = cih;
        this.iab = new InternalAuthenticationBackend(passwordHasher);
        if (opensearchSettings.getAsBoolean("plugins.security.unsupported.load_static_resources", Boolean.valueOf(true)).booleanValue()) {
            try {
                this.loadStaticConfig();
            }
            catch (IOException e) {
                throw new StaticResourceException("Unable to load static resources due to " + e, e, new Object[0]);
            }
        } else {
            this.log.info("Static resources will not be loaded.");
        }
        if (opensearchSettings.getAsBoolean("plugins.security.unsupported.load_static_resources", Boolean.valueOf(true)).booleanValue()) {
            try {
                this.loadStaticConfig();
            }
            catch (IOException e) {
                throw new StaticResourceException("Unable to load static resources due to " + e, e, new Object[0]);
            }
        } else {
            this.log.info("Static resources will not be loaded.");
        }
        this.registerDCFListener(this.iab);
        this.cr.subscribeOnChange(this);
    }

    @Override
    public void onChange(Map<CType, SecurityDynamicConfiguration<?>> typeToConfig) {
        ConfigModel cm;
        InternalUsersModel ium;
        DynamicConfigModel dcm;
        SecurityDynamicConfiguration<ActionGroupsV6> actionGroups = this.cr.getConfiguration(CType.ACTIONGROUPS);
        this.config = this.cr.getConfiguration(CType.CONFIG);
        SecurityDynamicConfiguration<InternalUserV6> internalusers = this.cr.getConfiguration(CType.INTERNALUSERS);
        SecurityDynamicConfiguration<RoleV6> roles = this.cr.getConfiguration(CType.ROLES);
        SecurityDynamicConfiguration<RoleMappingsV6> rolesmapping = this.cr.getConfiguration(CType.ROLESMAPPING);
        SecurityDynamicConfiguration<TenantV7> tenants = this.cr.getConfiguration(CType.TENANTS);
        SecurityDynamicConfiguration<?> nodesDn = this.cr.getConfiguration(CType.NODESDN);
        SecurityDynamicConfiguration<?> whitelistingSetting = this.cr.getConfiguration(CType.WHITELIST);
        SecurityDynamicConfiguration<?> allowlistingSetting = this.cr.getConfiguration(CType.ALLOWLIST);
        if (this.log.isDebugEnabled()) {
            String logmsg = "current config (because of " + typeToConfig.keySet() + ")\n actionGroups: " + actionGroups.getImplementingClass() + " with " + actionGroups.getCEntries().size() + " entries\n config: " + this.config.getImplementingClass() + " with " + this.config.getCEntries().size() + " entries\n internalusers: " + internalusers.getImplementingClass() + " with " + internalusers.getCEntries().size() + " entries\n roles: " + roles.getImplementingClass() + " with " + roles.getCEntries().size() + " entries\n rolesmapping: " + rolesmapping.getImplementingClass() + " with " + rolesmapping.getCEntries().size() + " entries\n tenants: " + tenants.getImplementingClass() + " with " + tenants.getCEntries().size() + " entries\n nodesdn: " + nodesDn.getImplementingClass() + " with " + nodesDn.getCEntries().size() + " entries\n whitelist " + whitelistingSetting.getImplementingClass() + " with " + whitelistingSetting.getCEntries().size() + " entries\n allowlist " + allowlistingSetting.getImplementingClass() + " with " + allowlistingSetting.getCEntries().size() + " entries\n";
            this.log.debug(logmsg);
        }
        NodesDnModelImpl nm = new NodesDnModelImpl(nodesDn);
        WhitelistingSettings whitelist = (WhitelistingSettings)this.cr.getConfiguration(CType.WHITELIST).getCEntry("config");
        AllowlistingSettings allowlist = (AllowlistingSettings)this.cr.getConfiguration(CType.ALLOWLIST).getCEntry("config");
        AuditConfig audit = (AuditConfig)this.cr.getConfiguration(CType.AUDIT).getCEntry("config");
        if (this.config.getImplementingClass() == ConfigV7.class) {
            if (roles.containsAny(staticRoles)) {
                throw new StaticResourceException("Cannot override static roles", new Object[0]);
            }
            if (!roles.add(staticRoles) && !staticRoles.getCEntries().isEmpty()) {
                throw new StaticResourceException("Unable to load static roles", new Object[0]);
            }
            this.log.debug("Static roles loaded ({})", (Object)staticRoles.getCEntries().size());
            if (actionGroups.containsAny(staticActionGroups)) {
                throw new StaticResourceException("Cannot override static action groups", new Object[0]);
            }
            if (!actionGroups.add(staticActionGroups) && !staticActionGroups.getCEntries().isEmpty()) {
                throw new StaticResourceException("Unable to load static action groups", new Object[0]);
            }
            this.log.debug("Static action groups loaded ({})", (Object)staticActionGroups.getCEntries().size());
            if (tenants.containsAny(staticTenants)) {
                throw new StaticResourceException("Cannot override static tenants", new Object[0]);
            }
            if (!tenants.add(staticTenants) && !staticTenants.getCEntries().isEmpty()) {
                throw new StaticResourceException("Unable to load static tenants", new Object[0]);
            }
            this.log.debug("Static tenants loaded ({})", (Object)staticTenants.getCEntries().size());
            this.log.debug("Static configuration loaded (total roles: {}/total action groups: {}/total tenants: {})", (Object)roles.getCEntries().size(), (Object)actionGroups.getCEntries().size(), (Object)tenants.getCEntries().size());
            dcm = new DynamicConfigModelV7(DynamicConfigFactory.getConfigV7(this.config), this.opensearchSettings, this.configPath, this.iab, this.cih);
            ium = new InternalUsersModelV7(internalusers, roles, rolesmapping);
            cm = new ConfigModelV7(roles, rolesmapping, actionGroups, tenants, dcm, this.opensearchSettings);
        } else {
            dcm = new DynamicConfigModelV6(DynamicConfigFactory.getConfigV6(this.config), this.opensearchSettings, this.configPath, this.iab);
            ium = new InternalUsersModelV6(internalusers);
            cm = new ConfigModelV6(roles, actionGroups, rolesmapping, dcm, this.opensearchSettings);
        }
        this.eventBus.post((Object)cm);
        this.eventBus.post((Object)dcm);
        this.eventBus.post((Object)ium);
        this.eventBus.post((Object)nm);
        this.eventBus.post((Object)(whitelist == null ? defaultWhitelistingSettings : whitelist));
        this.eventBus.post((Object)(allowlist == null ? defaultAllowlistingSettings : allowlist));
        if (this.cr.isAuditHotReloadingEnabled()) {
            this.eventBus.post((Object)(audit == null ? defaultAuditConfig : audit));
        }
        this.initialized.set(true);
    }

    private static ConfigV6 getConfigV6(SecurityDynamicConfiguration<?> sdc) {
        SecurityDynamicConfiguration<?> c = sdc;
        return (ConfigV6)c.getCEntry("opendistro_security");
    }

    private static ConfigV7 getConfigV7(SecurityDynamicConfiguration<?> sdc) {
        SecurityDynamicConfiguration<?> c = sdc;
        return (ConfigV7)c.getCEntry("config");
    }

    @Override
    public final boolean isInitialized() {
        return this.initialized.get();
    }

    public void registerDCFListener(Object listener) {
        this.eventBus.register(listener);
    }

    public void unregisterDCFListener(Object listener) {
        this.eventBus.unregister(listener);
    }

    private static class NodesDnModelImpl
    extends NodesDnModel {
        SecurityDynamicConfiguration<NodesDn> configuration;

        public NodesDnModelImpl(SecurityDynamicConfiguration<?> configuration) {
            this.configuration = null == configuration.getCType() ? SecurityDynamicConfiguration.empty() : configuration;
        }

        @Override
        public Map<String, WildcardMatcher> getNodesDn() {
            return (Map)this.configuration.getCEntries().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> WildcardMatcher.from(((NodesDn)entry.getValue()).getNodesDn(), false)));
        }
    }

    private static class InternalUsersModelV6
    extends InternalUsersModel {
        SecurityDynamicConfiguration<InternalUserV6> configuration;

        public InternalUsersModelV6(SecurityDynamicConfiguration<InternalUserV6> configuration) {
            this.configuration = configuration;
        }

        @Override
        public boolean exists(String user) {
            return this.configuration.exists(user);
        }

        @Override
        public List<String> getBackenRoles(String user) {
            InternalUserV6 tmp = this.configuration.getCEntry(user);
            return tmp == null ? null : tmp.getRoles();
        }

        @Override
        public Map<String, String> getAttributes(String user) {
            InternalUserV6 tmp = this.configuration.getCEntry(user);
            return tmp == null ? null : tmp.getAttributes();
        }

        @Override
        public String getDescription(String user) {
            return null;
        }

        @Override
        public String getHash(String user) {
            InternalUserV6 tmp = this.configuration.getCEntry(user);
            return tmp == null ? null : tmp.getHash();
        }

        @Override
        public List<String> getSecurityRoles(String user) {
            return Collections.emptyList();
        }
    }

    private static class InternalUsersModelV7
    extends InternalUsersModel {
        private final SecurityDynamicConfiguration<InternalUserV7> internalUserV7SecurityDynamicConfiguration;
        private final SecurityDynamicConfiguration<RoleV7> rolesV7SecurityDynamicConfiguration;
        private final SecurityDynamicConfiguration<RoleMappingsV7> rolesMappingsV7SecurityDynamicConfiguration;

        public InternalUsersModelV7(SecurityDynamicConfiguration<InternalUserV7> internalUserV7SecurityDynamicConfiguration, SecurityDynamicConfiguration<RoleV7> rolesV7SecurityDynamicConfiguration, SecurityDynamicConfiguration<RoleMappingsV7> rolesMappingsV7SecurityDynamicConfiguration) {
            this.internalUserV7SecurityDynamicConfiguration = internalUserV7SecurityDynamicConfiguration;
            this.rolesV7SecurityDynamicConfiguration = rolesV7SecurityDynamicConfiguration;
            this.rolesMappingsV7SecurityDynamicConfiguration = rolesMappingsV7SecurityDynamicConfiguration;
        }

        @Override
        public boolean exists(String user) {
            return this.internalUserV7SecurityDynamicConfiguration.exists(user);
        }

        @Override
        public List<String> getBackenRoles(String user) {
            InternalUserV7 tmp = this.internalUserV7SecurityDynamicConfiguration.getCEntry(user);
            return tmp == null ? null : tmp.getBackend_roles();
        }

        @Override
        public Map<String, String> getAttributes(String user) {
            InternalUserV7 tmp = this.internalUserV7SecurityDynamicConfiguration.getCEntry(user);
            return tmp == null ? null : tmp.getAttributes();
        }

        @Override
        public String getDescription(String user) {
            InternalUserV7 tmp = this.internalUserV7SecurityDynamicConfiguration.getCEntry(user);
            return tmp == null ? null : tmp.getDescription();
        }

        @Override
        public String getHash(String user) {
            InternalUserV7 tmp = this.internalUserV7SecurityDynamicConfiguration.getCEntry(user);
            return tmp == null ? null : tmp.getHash();
        }

        @Override
        public List<String> getSecurityRoles(String user) {
            InternalUserV7 tmp = this.internalUserV7SecurityDynamicConfiguration.getCEntry(user);
            return tmp == null ? ImmutableList.of() : (List)tmp.getOpendistro_security_roles().stream().filter(role -> !this.isRolesMappingHidden((String)role) && this.rolesV7SecurityDynamicConfiguration.exists((String)role)).collect(ImmutableList.toImmutableList());
        }

        private boolean isRolesMappingHidden(String rolename) {
            RoleMappingsV7 roleMapping = this.rolesMappingsV7SecurityDynamicConfiguration.getCEntry(rolename);
            return roleMapping != null && roleMapping.isHidden();
        }
    }
}

