/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.rewriter.subquery;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLExistsExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import org.opensearch.sql.legacy.rewriter.subquery.RewriterContext;
import org.opensearch.sql.legacy.rewriter.subquery.rewriter.Rewriter;
import org.opensearch.sql.legacy.rewriter.subquery.rewriter.RewriterFactory;
import org.opensearch.sql.legacy.rewriter.subquery.utils.FindSubQuery;

public class SubQueryRewriter {
    private final RewriterContext ctx = new RewriterContext();

    public void convert(SQLSelect query) {
        SQLSelectQuery queryExpr = query.getQuery();
        if (queryExpr instanceof MySqlSelectQueryBlock) {
            MySqlSelectQueryBlock queryBlock = (MySqlSelectQueryBlock)queryExpr;
            this.ctx.addTable(queryBlock.getFrom());
            queryBlock.setWhere(this.convertWhere(queryBlock.getWhere()));
            queryBlock.setFrom(this.convertFrom(queryBlock.getFrom()));
        }
    }

    private SQLTableSource convertFrom(SQLTableSource expr) {
        SQLTableSource join = this.ctx.popJoin();
        if (join != null) {
            return join;
        }
        return expr;
    }

    private SQLExpr convertWhere(SQLExpr expr) {
        if (expr instanceof SQLExistsExpr) {
            this.ctx.setExistsSubQuery((SQLExistsExpr)expr);
            this.rewriteSubQuery(expr, ((SQLExistsExpr)expr).getSubQuery());
            return this.ctx.popWhere();
        }
        if (expr instanceof SQLInSubQueryExpr) {
            this.ctx.setInSubQuery((SQLInSubQueryExpr)expr);
            this.rewriteSubQuery(expr, ((SQLInSubQueryExpr)expr).getSubQuery());
            return this.ctx.popWhere();
        }
        if (expr instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr binaryOpExpr = (SQLBinaryOpExpr)expr;
            SQLExpr left = this.convertWhere(binaryOpExpr.getLeft());
            left.setParent((SQLObject)binaryOpExpr);
            binaryOpExpr.setLeft(left);
            SQLExpr right = this.convertWhere(binaryOpExpr.getRight());
            right.setParent((SQLObject)binaryOpExpr);
            binaryOpExpr.setRight(right);
        }
        return expr;
    }

    private void rewriteSubQuery(SQLExpr subQueryExpr, SQLSelect subQuerySelect) {
        if (this.containSubQuery(subQuerySelect)) {
            this.convert(subQuerySelect);
        } else if (this.isSupportedSubQuery(this.ctx)) {
            for (Rewriter rewriter : RewriterFactory.createRewriterList(subQueryExpr, this.ctx)) {
                if (!rewriter.canRewrite()) continue;
                rewriter.rewrite();
                return;
            }
        }
        throw new IllegalStateException("Unsupported subquery");
    }

    private boolean containSubQuery(SQLSelect query) {
        FindSubQuery findSubQuery = new FindSubQuery().continueVisitWhenFound(false);
        query.accept((SQLASTVisitor)findSubQuery);
        return findSubQuery.hasSubQuery();
    }

    private boolean isSupportedSubQuery(RewriterContext ctx) {
        return ctx.getSqlInSubQueryExprs().size() == 1 && ctx.getSqlExistsExprs().size() == 0 || ctx.getSqlInSubQueryExprs().size() == 0 && ctx.getSqlExistsExprs().size() == 1;
    }
}

