/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sampler.truffle;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.sampler.truffle.ProxyTruffleMBean;
import org.graalvm.visualvm.tools.jmx.JmxModel;
import org.graalvm.visualvm.tools.jmx.JmxModelFactory;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInfo;
import org.openide.modules.Modules;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public abstract class TruffleDataProvider {
    protected static final Logger LOGGER = Logger.getLogger(TruffleDataProvider.class.getName());
    private static String AGENT_PATH = "modules/ext/stagent.jar";
    protected String status;
    protected ProxyTruffleMBean tbean;

    protected static String initJMXConn(Application application) {
        if (application.getState() != 1) {
            return NbBundle.getMessage(TruffleDataProvider.class, (String)"MSG_Unavailable");
        }
        JmxModel jmxModel = JmxModelFactory.getJmxModelFor((Application)application);
        if (jmxModel == null) {
            return NbBundle.getMessage(TruffleDataProvider.class, (String)"MSG_Unavailable_init_jmx");
        }
        if (jmxModel.getConnectionState() != JmxModel.ConnectionState.CONNECTED) {
            return NbBundle.getMessage(TruffleDataProvider.class, (String)"MSG_Unavailable_create_jmx");
        }
        return null;
    }

    public String getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkAndLoadJMX(Application app) throws MalformedObjectNameException, IOException, InterruptedException {
        Application application = app;
        synchronized (application) {
            JmxModel jmxModel = JmxModelFactory.getJmxModelFor((Application)app);
            this.tbean = new ProxyTruffleMBean(jmxModel.getMBeanServerConnection());
            if (this.tbean.isRegistered()) {
                return true;
            }
            if (this.loadAgent(app)) {
                for (int i = 0; i < 10; ++i) {
                    if (this.tbean.isRegistered()) {
                        return true;
                    }
                    Thread.sleep(300L);
                }
            }
            return this.tbean.isRegistered();
        }
    }

    private boolean loadAgent(Application app) {
        String pid = String.valueOf(app.getPid());
        String agentPath = this.getAgentPath();
        LOGGER.warning("Agent " + agentPath);
        try {
            VirtualMachine vm = VirtualMachine.attach(pid);
            LOGGER.warning(vm.toString());
            TruffleDataProvider.loadAgentIntoTargetJVM(vm, agentPath, null);
            vm.detach();
            LOGGER.warning("Agent loaded");
            return true;
        }
        catch (AttachNotSupportedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (AgentLoadException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (AgentInitializationException ex) {
            LOGGER.log(Level.INFO, "loadAgent()", ex);
        }
        return false;
    }

    private static void loadAgentIntoTargetJVM(VirtualMachine virtualMachine, String jar, String options) throws IOException, AgentLoadException, AgentInitializationException {
        try {
            virtualMachine.loadAgent(jar, options);
        }
        catch (AgentLoadException ex) {
            if ("0".equals(ex.getMessage())) {
                return;
            }
            throw ex;
        }
        catch (IOException ex) {
            if ("readInt".equals(ex.getStackTrace()[0].getMethodName())) {
                return;
            }
            throw ex;
        }
    }

    private String getAgentPath() {
        InstalledFileLocator loc = InstalledFileLocator.getDefault();
        ModuleInfo info = Modules.getDefault().ownerOf(this.getClass());
        File jar = loc.locate(AGENT_PATH, info.getCodeNameBase(), false);
        return jar.getAbsolutePath();
    }
}

