/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.wireprotocol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.AsyncMessageCommand;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.CalibrationDataResponse;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.ClassLoadedCommand;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.CodeRegionCPUResultsResponse;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.Command;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.DefiningLoaderResponse;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.DumpResultsResponse;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.EventBufferDumpedCommand;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.GetClassFileBytesCommand;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.GetClassFileBytesResponse;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.GetClassIdCommand;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.GetClassIdResponse;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.GetDefiningClassLoaderCommand;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.GetMethodNamesForJMethodIdsCommand;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.HeapHistogramResponse;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.InitiateProfilingCommand;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.InstrumentMethodGroupCommand;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.InstrumentMethodGroupResponse;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.InternalStatsResponse;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.MethodInvokedFirstTimeCommand;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.MethodLoadedCommand;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.MethodNamesResponse;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.MonitoredNumbersResponse;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.ObjectAllocationResultsResponse;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.Response;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.RootClassLoadedCommand;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.SetChangeableInstrParamsCommand;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.SetUnchangeableInstrParamsCommand;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.TakeHeapDumpCommand;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.ThreadDumpResponse;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.ThreadLivenessStatusResponse;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.VMPropertiesResponse;

public class WireIO {
    static final boolean DEBUG = System.getProperty("org.graalvm.visualvm.lib.jfluid.wireprotocol.WireIO") != null;
    private static final int IS_SIMPLE_COMMAND = 1;
    private static final int IS_COMPLEX_COMMAND = 2;
    private static final int IS_SIMPLE_RESPONSE = 3;
    private static final int IS_COMPLEX_RESPONSE = 4;
    private ObjectInputStream in;
    private ObjectOutputStream out;
    private long wasAlive;

    public WireIO(ObjectOutputStream pout, ObjectInputStream pin) {
        this.out = pout;
        this.in = pin;
    }

    public Object receiveCommandOrResponse() throws IOException {
        int code = this.in.read();
        this.wasAlive = System.currentTimeMillis();
        switch (code) {
            case 1: {
                Command c = new Command(this.in.read());
                if (DEBUG) {
                    System.out.println("WireIO.DEBUG: received simple command: " + c);
                }
                return c;
            }
            case 2: {
                int cmdType = this.in.read();
                if (DEBUG) {
                    System.out.println("WireIO.DEBUG: received complex command type: " + Command.cmdTypeToString(cmdType));
                }
                Command cmd = null;
                switch (cmdType) {
                    case 23: {
                        cmd = new MethodInvokedFirstTimeCommand();
                        break;
                    }
                    case 3: {
                        cmd = new ClassLoadedCommand();
                        break;
                    }
                    case 14: {
                        cmd = new AsyncMessageCommand();
                        break;
                    }
                    case 22: {
                        cmd = new MethodLoadedCommand();
                        break;
                    }
                    case 17: {
                        cmd = new RootClassLoadedCommand();
                        break;
                    }
                    case 13: {
                        cmd = new InitiateProfilingCommand();
                        break;
                    }
                    case 4: {
                        cmd = new SetChangeableInstrParamsCommand();
                        break;
                    }
                    case 5: {
                        cmd = new SetUnchangeableInstrParamsCommand();
                        break;
                    }
                    case 26: {
                        cmd = new EventBufferDumpedCommand();
                        break;
                    }
                    case 7: {
                        cmd = new InstrumentMethodGroupCommand();
                        break;
                    }
                    case 31: {
                        cmd = new GetMethodNamesForJMethodIdsCommand();
                        break;
                    }
                    case 35: {
                        cmd = new GetDefiningClassLoaderCommand();
                        break;
                    }
                    case 41: {
                        cmd = new TakeHeapDumpCommand();
                        break;
                    }
                    case 42: {
                        cmd = new GetClassIdCommand();
                        break;
                    }
                    case 47: {
                        cmd = new GetClassFileBytesCommand();
                        break;
                    }
                    default: {
                        throw new IOException("JFluid wire protocol error: received unknown command type. Value: " + cmdType);
                    }
                }
                cmd.readObject(this.in);
                if (DEBUG) {
                    System.out.println("WireIO.DEBUG:         command is: " + cmd);
                }
                return cmd;
            }
            case 3: {
                Response simpleResp = new Response(this.in.readBoolean());
                if (this.in.read() != 0) {
                    simpleResp.setErrorMessage(this.in.readUTF());
                } else {
                    simpleResp.setErrorMessage(null);
                }
                if (DEBUG) {
                    System.out.println("WireIO.DEBUG: received simple response " + simpleResp);
                }
                return simpleResp;
            }
            case 4: {
                int respType = this.in.read();
                if (DEBUG) {
                    System.out.println("WireIO.DEBUG: received complex response " + Response.respTypeToString(respType));
                }
                Response resp = null;
                switch (respType) {
                    case 1: {
                        resp = new CodeRegionCPUResultsResponse();
                        break;
                    }
                    case 2: {
                        resp = new InstrumentMethodGroupResponse();
                        break;
                    }
                    case 3: {
                        resp = new InternalStatsResponse();
                        break;
                    }
                    case 4: {
                        resp = new VMPropertiesResponse();
                        break;
                    }
                    case 5: {
                        resp = new DumpResultsResponse();
                        break;
                    }
                    case 6: {
                        resp = new ObjectAllocationResultsResponse();
                        break;
                    }
                    case 7: {
                        resp = new MethodNamesResponse();
                        break;
                    }
                    case 8: {
                        resp = new ThreadLivenessStatusResponse();
                        break;
                    }
                    case 9: {
                        resp = new MonitoredNumbersResponse();
                        break;
                    }
                    case 10: {
                        resp = new DefiningLoaderResponse();
                        break;
                    }
                    case 11: {
                        resp = new CalibrationDataResponse();
                        break;
                    }
                    case 12: {
                        resp = new GetClassIdResponse();
                        break;
                    }
                    case 13: {
                        resp = new HeapHistogramResponse();
                        break;
                    }
                    case 14: {
                        resp = new ThreadDumpResponse();
                        break;
                    }
                    case 15: {
                        resp = new GetClassFileBytesResponse();
                        break;
                    }
                    default: {
                        throw new IOException("JFluid wire protocol error: received unknown response type. Value: " + respType);
                    }
                }
                resp.setYes(this.in.readBoolean());
                if (this.in.read() != 0) {
                    resp.setErrorMessage(this.in.readUTF());
                } else {
                    resp.setErrorMessage(null);
                }
                resp.readObject(this.in);
                if (DEBUG) {
                    System.out.println("WireIO.DEBUG:    response is: " + resp);
                }
                return resp;
            }
        }
        if (DEBUG) {
            System.out.println("WireIO.DEBUG: received unknown code: " + code);
        }
        throw new IOException("JFluid wire protocol error: code does not correspond to command or response. Value " + code);
    }

    public synchronized void sendComplexCommand(Command cmd) throws IOException {
        if (DEBUG) {
            System.out.println("WireIO.DEBUG: gonna send complex command: " + cmd);
        }
        this.out.write(2);
        this.out.write(cmd.getType());
        cmd.writeObject(this.out);
        this.out.flush();
    }

    public synchronized void sendComplexResponse(Response resp) throws IOException {
        if (DEBUG) {
            System.out.println("WireIO.DEBUG: gonna send response: " + resp);
        }
        this.out.write(4);
        this.out.write(resp.getType());
        this.out.writeBoolean(resp.yes());
        String errorMessage = resp.getErrorMessage();
        if (errorMessage == null) {
            this.out.write(0);
        } else {
            this.out.write(1);
            this.out.writeUTF(errorMessage);
        }
        resp.writeObject(this.out);
        this.out.flush();
    }

    public synchronized void sendSimpleCommand(int cmdType) throws IOException {
        if (DEBUG) {
            System.out.println("WireIO.DEBUG: gonna send simple command:" + Command.cmdTypeToString(cmdType));
        }
        this.out.write(1);
        this.out.write(cmdType);
        this.out.flush();
    }

    public synchronized void sendSimpleResponse(boolean yes, String errorMessage) throws IOException {
        if (DEBUG) {
            System.out.println("WireIO.DEBUG: gonna send simple response: yes: " + yes + ", errorMessage: " + errorMessage);
        }
        this.out.write(3);
        this.out.writeBoolean(yes);
        if (errorMessage == null) {
            this.out.write(0);
        } else {
            this.out.write(1);
            this.out.writeUTF(errorMessage);
        }
        this.out.flush();
    }

    public long wasAlive() {
        return this.wasAlive;
    }
}

