/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.activities;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.osmand.Location;
import net.osmand.PlatformUtil;
import net.osmand.data.LatLon;
import net.osmand.plus.GPXUtilities;
import net.osmand.plus.GpxSelectionHelper;
import net.osmand.plus.OsmAndLocationProvider;
import net.osmand.plus.OsmandSettings;
import net.osmand.plus.api.SQLiteAPI;
import net.sourceforge.offroad.OsmWindow;
import net.sourceforge.offroad.data.SQLiteOpenHelper;
import org.apache.commons.logging.Log;

public class SavingTrackHelper
extends SQLiteOpenHelper {
    public static final String DATABASE_NAME = "tracks";
    public static final int DATABASE_VERSION = 5;
    public static final String TRACK_NAME = "track";
    public static final String TRACK_COL_DATE = "date";
    public static final String TRACK_COL_LAT = "lat";
    public static final String TRACK_COL_LON = "lon";
    public static final String TRACK_COL_ALTITUDE = "altitude";
    public static final String TRACK_COL_SPEED = "speed";
    public static final String TRACK_COL_HDOP = "hdop";
    public static final String POINT_NAME = "point";
    public static final String POINT_COL_DATE = "date";
    public static final String POINT_COL_LAT = "lat";
    public static final String POINT_COL_LON = "lon";
    public static final String POINT_COL_NAME = "pname";
    public static final String POINT_COL_CATEGORY = "category";
    public static final String POINT_COL_DESCRIPTION = "description";
    public static final String POINT_COL_COLOR = "color";
    public static final Log log = PlatformUtil.getLog(SavingTrackHelper.class);
    private String updateScript;
    private String insertPointsScript;
    private long lastTimeUpdated = 0L;
    private final OsmWindow ctx;
    private LatLon lastPoint;
    private float distance = 0.0f;
    private GpxSelectionHelper.SelectedGpxFile currentTrack;
    private int points;

    public SavingTrackHelper(OsmWindow ctx) {
        super(ctx, DATABASE_NAME, null, 5);
        this.ctx = ctx;
        this.currentTrack = new GpxSelectionHelper.SelectedGpxFile();
        this.currentTrack.setShowCurrentTrack(true);
        GPXUtilities.GPXFile gx = new GPXUtilities.GPXFile();
        gx.showCurrentTrack = true;
        this.currentTrack.setGpxFile(gx);
        this.prepareCurrentTrackForRecording();
        this.updateScript = "INSERT INTO track (lat, lon, altitude, speed, hdop, date) VALUES (?, ?, ?, ?, ?, ?)";
        this.insertPointsScript = "INSERT INTO point VALUES (?, ?, ?, ?, ?, ?, ?)";
    }

    @Override
    public void onCreate(SQLiteAPI.SQLiteConnection db) {
        this.createTableForTrack(db);
        this.createTableForPoints(db);
    }

    private void createTableForTrack(SQLiteAPI.SQLiteConnection db) {
        db.execSQL("CREATE TABLE track (lat double, lon double, altitude double, speed double, hdop double, date long )");
    }

    private void createTableForPoints(SQLiteAPI.SQLiteConnection db) {
        try {
            db.execSQL("CREATE TABLE point (lat double, lon double, date long, description text, pname text, category text, color long)");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public void onUpgrade(SQLiteAPI.SQLiteConnection db, int oldVersion, int newVersion) {
        if (oldVersion < 2) {
            this.createTableForPoints(db);
        }
        if (oldVersion < 3) {
            db.execSQL("ALTER TABLE track ADD hdop double");
        }
        if (oldVersion < 4) {
            db.execSQL("ALTER TABLE point ADD pname text");
            db.execSQL("ALTER TABLE point ADD category text");
        }
        if (oldVersion < 5) {
            db.execSQL("ALTER TABLE point ADD color long");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastTrackPointTime() {
        long res;
        block6: {
            res = 0L;
            try {
                SQLiteAPI.SQLiteConnection db = this.getWritableDatabase();
                if (db == null) break block6;
                try {
                    SQLiteAPI.SQLiteCursor query = db.rawQuery("SELECT date FROM track ORDER BY date DESC", null);
                    if (query.moveToFirst()) {
                        res = query.getLong(0);
                    }
                    query.close();
                }
                finally {
                    db.close();
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean hasDataToSave() {
        try {
            SQLiteAPI.SQLiteConnection db = this.getWritableDatabase();
            if (db == null) return false;
            try {
                SQLiteAPI.SQLiteCursor q = db.rawQuery("select * from track", new String[0]);
                boolean has = q.moveToFirst();
                q.close();
                if (has) {
                    boolean bl = true;
                    return bl;
                }
                q = db.rawQuery("select lat, lon from point", null);
                has = q.moveToFirst();
                while (has && q.getDouble(0) == 0.0 && q.getDouble(1) == 0.0) {
                    if (q.moveToNext()) continue;
                    has = false;
                    break;
                }
                q.close();
                if (!has) return false;
                boolean bl = true;
                return bl;
            }
            finally {
                db.close();
            }
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<String> saveDataToGpx(File dir) {
        SQLiteAPI.SQLiteConnection db;
        ArrayList<String> warnings = new ArrayList<String>();
        dir.mkdirs();
        if (dir.getParentFile().canWrite() && dir.exists()) {
            Map<String, GPXUtilities.GPXFile> data = this.collectRecordedData();
            for (String f : data.keySet()) {
                String warn;
                File fout = new File(dir, f + ".gpx");
                if (!data.get(f).isEmpty()) {
                    GPXUtilities.WptPt pt = data.get(f).findPointToShow();
                    String fileName = f + "_" + new SimpleDateFormat("HH-mm_EEE", Locale.US).format(new Date(pt.time));
                    fout = new File(dir, fileName + ".gpx");
                    int ind = 1;
                    while (fout.exists()) {
                        fout = new File(dir, fileName + "_" + ++ind + ".gpx");
                    }
                }
                if ((warn = GPXUtilities.writeGpxFile(fout, data.get(f), this.ctx)) == null) continue;
                warnings.add(warn);
                return warnings;
            }
        }
        if ((db = this.getWritableDatabase()) != null && warnings.isEmpty() && db.isOpen()) {
            try {
                db.execSQL("DELETE FROM track WHERE date <= ?", new Object[]{System.currentTimeMillis()});
                db.execSQL("DELETE FROM point WHERE date <= ?", new Object[]{System.currentTimeMillis()});
            }
            finally {
                db.close();
            }
        }
        this.distance = 0.0f;
        this.points = 0;
        this.currentTrack.getModifiableGpxFile().points.clear();
        this.currentTrack.getModifiableGpxFile().tracks.clear();
        this.currentTrack.getModifiablePointsToDisplay().clear();
        this.currentTrack.getModifiableGpxFile().modifiedTime = System.currentTimeMillis();
        this.prepareCurrentTrackForRecording();
        return warnings;
    }

    public Map<String, GPXUtilities.GPXFile> collectRecordedData() {
        LinkedHashMap<String, GPXUtilities.GPXFile> data = new LinkedHashMap<String, GPXUtilities.GPXFile>();
        SQLiteAPI.SQLiteConnection db = this.getReadableDatabase();
        if (db != null && db.isOpen()) {
            try {
                this.collectDBPoints(db, data);
                this.collectDBTracks(db, data);
            }
            finally {
                db.close();
            }
        }
        return data;
    }

    private void collectDBPoints(SQLiteAPI.SQLiteConnection db, Map<String, GPXUtilities.GPXFile> dataTracks) {
        SQLiteAPI.SQLiteCursor query = db.rawQuery("SELECT lat,lon,date,description,pname,category,color FROM point ORDER BY date ASC", null);
        if (query.moveToFirst()) {
            do {
                GPXUtilities.GPXFile gpx;
                String date;
                long time;
                GPXUtilities.WptPt pt = new GPXUtilities.WptPt();
                pt.lat = query.getDouble(0);
                pt.lon = query.getDouble(1);
                pt.time = time = query.getLong(2);
                pt.desc = query.getString(3);
                pt.name = query.getString(4);
                pt.category = query.getString(5);
                int color2 = query.getInt(6);
                if (color2 != 0) {
                    pt.setColor(color2);
                }
                if (pt.name != null && pt.name.length() > 4 && pt.name.charAt(pt.name.length() - 4) == '.') {
                    pt.link = pt.name;
                }
                if (dataTracks.containsKey(date = this.DateFormatformat("yyyy-MM-dd", time).toString())) {
                    gpx = dataTracks.get(date);
                } else {
                    gpx = new GPXUtilities.GPXFile();
                    dataTracks.put(date, gpx);
                }
                gpx.points.add(pt);
            } while (query.moveToNext());
        }
        query.close();
    }

    private String DateFormatformat(String pFormat, long pTime) {
        return new SimpleDateFormat(pFormat).format(new Date(pTime));
    }

    private void collectDBTracks(SQLiteAPI.SQLiteConnection db, Map<String, GPXUtilities.GPXFile> dataTracks) {
        SQLiteAPI.SQLiteCursor query = db.rawQuery("SELECT lat,lon,altitude,speed,hdop,date FROM track ORDER BY date ASC", null);
        long previousTime = 0L;
        long previousInterval = 0L;
        GPXUtilities.TrkSegment segment = null;
        GPXUtilities.Track track = null;
        if (query.moveToFirst()) {
            do {
                boolean newInterval;
                long time;
                GPXUtilities.WptPt pt = new GPXUtilities.WptPt();
                pt.lat = query.getDouble(0);
                pt.lon = query.getDouble(1);
                pt.ele = query.getDouble(2);
                pt.speed = query.getDouble(3);
                pt.hdop = query.getDouble(4);
                pt.time = time = query.getLong(5);
                long currentInterval = Math.abs(time - previousTime);
                boolean bl = newInterval = pt.lat == 0.0 && pt.lon == 0.0;
                if (!(track == null || newInterval || currentInterval >= 360000L && currentInterval >= 10L * previousInterval)) {
                    segment.points.add(pt);
                } else if (track != null && currentInterval < 0x6DDD00L) {
                    segment = new GPXUtilities.TrkSegment();
                    if (!newInterval) {
                        segment.points.add(pt);
                    }
                    track.segments.add(segment);
                } else {
                    String date;
                    track = new GPXUtilities.Track();
                    segment = new GPXUtilities.TrkSegment();
                    track.segments.add(segment);
                    if (!newInterval) {
                        segment.points.add(pt);
                    }
                    if (dataTracks.containsKey(date = this.DateFormatformat("yyyy-MM-dd", time).toString())) {
                        GPXUtilities.GPXFile gpx = dataTracks.get(date);
                        gpx.tracks.add(track);
                    } else {
                        GPXUtilities.GPXFile file = new GPXUtilities.GPXFile();
                        file.tracks.add(track);
                        dataTracks.put(date, file);
                    }
                }
                previousInterval = currentInterval;
                previousTime = time;
            } while (query.moveToNext());
        }
        query.close();
    }

    public void startNewSegment() {
        this.lastTimeUpdated = 0L;
        this.lastPoint = null;
        this.execWithClose(this.updateScript, new Object[]{0, 0, 0, 0, 0, System.currentTimeMillis()});
        this.addTrackPoint(null, true, System.currentTimeMillis());
    }

    public void updateLocation(Location location) {
        long locationTime = System.currentTimeMillis();
        OsmandSettings settings = this.ctx.getSettings();
        boolean record = false;
        if (!OsmAndLocationProvider.isPointAccurateForRouting(location) || OsmAndLocationProvider.isNotSimulatedLocation(location)) {
            // empty if block
        }
        if (record) {
            this.insertData(location.getLatitude(), location.getLongitude(), location.getAltitude(), location.getSpeed(), location.getAccuracy(), locationTime, settings);
        }
    }

    public void insertData(double lat, double lon, double alt, double speed, double hdop, long time, OsmandSettings settings) {
        this.execWithClose(this.updateScript, new Object[]{lat, lon, alt, speed, hdop, time});
        boolean newSegment = false;
        if (this.lastPoint == null || time - this.lastTimeUpdated > 180000L) {
            this.lastPoint = new LatLon(lat, lon);
            newSegment = true;
        } else {
            float[] lastInterval = new float[1];
            Location.distanceBetween(lat, lon, this.lastPoint.getLatitude(), this.lastPoint.getLongitude(), lastInterval);
            this.distance += lastInterval[0];
            this.lastPoint = new LatLon(lat, lon);
        }
        this.lastTimeUpdated = time;
        GPXUtilities.WptPt pt = new GPXUtilities.WptPt(lat, lon, time, alt, speed, hdop);
        this.addTrackPoint(pt, newSegment, time);
    }

    private void addTrackPoint(GPXUtilities.WptPt pt, boolean newSegment, long time) {
        List<GPXUtilities.TrkSegment> points = this.currentTrack.getModifiablePointsToDisplay();
        GPXUtilities.Track track = this.currentTrack.getGpxFile().tracks.get(0);
        assert (track.segments.size() == points.size());
        if (points.size() == 0 || newSegment) {
            points.add(new GPXUtilities.TrkSegment());
        }
        if (track.segments.size() == 0 || newSegment) {
            track.segments.add(new GPXUtilities.TrkSegment());
        }
        if (pt != null) {
            int ind = points.size() - 1;
            GPXUtilities.TrkSegment last = points.get(ind);
            last.points.add(pt);
            GPXUtilities.TrkSegment lt = track.segments.get(track.segments.size() - 1);
            lt.points.add(pt);
        }
        this.currentTrack.getModifiableGpxFile().modifiedTime = time;
    }

    public GPXUtilities.WptPt insertPointData(double lat, double lon, long time, String description, String name, String category, int color2) {
        GPXUtilities.WptPt pt = new GPXUtilities.WptPt(lat, lon, time, Double.NaN, 0.0, Double.NaN);
        pt.name = name;
        pt.category = category;
        pt.desc = description;
        if (color2 != 0) {
            pt.setColor(color2);
        }
        this.currentTrack.getModifiableGpxFile().points.add(pt);
        this.currentTrack.getModifiableGpxFile().modifiedTime = time;
        ++this.points;
        this.execWithClose(this.insertPointsScript, new Object[]{lat, lon, time, description, name, category, color2});
        return pt;
    }

    public void updatePointData(GPXUtilities.WptPt pt, double lat, double lon, long time, String description, String name, String category, int color2) {
        this.currentTrack.getModifiableGpxFile().modifiedTime = time;
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(lat);
        params.add(lon);
        params.add(time);
        params.add(description);
        params.add(name);
        params.add(category);
        params.add(color2);
        params.add(pt.getLatitude());
        params.add(pt.getLongitude());
        params.add(pt.time);
        StringBuilder sb = new StringBuilder();
        String prefix = "UPDATE point SET lat=?, lon=?, date=?, description=?, pname=?, category=?, color=? WHERE lat=? AND lon=? AND date=?";
        sb.append(prefix);
        if (pt.desc != null) {
            sb.append(" AND ").append(POINT_COL_DESCRIPTION).append("=?");
            params.add(pt.desc);
        } else {
            sb.append(" AND ").append(POINT_COL_DESCRIPTION).append(" IS NULL");
        }
        if (pt.name != null) {
            sb.append(" AND ").append(POINT_COL_NAME).append("=?");
            params.add(pt.name);
        } else {
            sb.append(" AND ").append(POINT_COL_NAME).append(" IS NULL");
        }
        if (pt.category != null) {
            sb.append(" AND ").append(POINT_COL_CATEGORY).append("=?");
            params.add(pt.category);
        } else {
            sb.append(" AND ").append(POINT_COL_CATEGORY).append(" IS NULL");
        }
        this.execWithClose(sb.toString(), params.toArray());
        pt.lat = lat;
        pt.lon = lon;
        pt.time = time;
        pt.desc = description;
        pt.name = name;
        pt.category = category;
        if (color2 != 0) {
            pt.setColor(color2);
        }
    }

    public void deletePointData(GPXUtilities.WptPt pt) {
        this.currentTrack.getModifiableGpxFile().points.remove(pt);
        this.currentTrack.getModifiableGpxFile().modifiedTime = System.currentTimeMillis();
        --this.points;
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(pt.getLatitude());
        params.add(pt.getLongitude());
        params.add(pt.time);
        StringBuilder sb = new StringBuilder();
        String prefix = "DELETE FROM point WHERE lat=? AND lon=? AND date=?";
        sb.append(prefix);
        if (pt.desc != null) {
            sb.append(" AND ").append(POINT_COL_DESCRIPTION).append("=?");
            params.add(pt.desc);
        } else {
            sb.append(" AND ").append(POINT_COL_DESCRIPTION).append(" IS NULL");
        }
        if (pt.name != null) {
            sb.append(" AND ").append(POINT_COL_NAME).append("=?");
            params.add(pt.name);
        } else {
            sb.append(" AND ").append(POINT_COL_NAME).append(" IS NULL");
        }
        if (pt.category != null) {
            sb.append(" AND ").append(POINT_COL_CATEGORY).append("=?");
            params.add(pt.category);
        } else {
            sb.append(" AND ").append(POINT_COL_CATEGORY).append(" IS NULL");
        }
        this.execWithClose(sb.toString(), params.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void execWithClose(String script, Object[] objects) {
        try (SQLiteAPI.SQLiteConnection db = this.getWritableDatabase();){
            if (db != null) {
                db.execSQL(script, objects);
            }
        }
    }

    public void loadGpxFromDatabase() {
        Map<String, GPXUtilities.GPXFile> files = this.collectRecordedData();
        this.currentTrack.getModifiableGpxFile().tracks.clear();
        for (Map.Entry<String, GPXUtilities.GPXFile> entry : files.entrySet()) {
            this.currentTrack.getModifiableGpxFile().points.addAll(entry.getValue().points);
            this.currentTrack.getModifiableGpxFile().tracks.addAll(entry.getValue().tracks);
        }
        this.currentTrack.processPoints();
        this.prepareCurrentTrackForRecording();
        GPXUtilities.GPXTrackAnalysis analysis = this.currentTrack.getModifiableGpxFile().getAnalysis(System.currentTimeMillis());
        this.distance = analysis.totalDistance;
        this.points = analysis.wptPoints;
    }

    private void prepareCurrentTrackForRecording() {
        if (this.currentTrack.getModifiableGpxFile().tracks.size() == 0) {
            this.currentTrack.getModifiableGpxFile().tracks.add(new GPXUtilities.Track());
        }
        while (this.currentTrack.getPointsToDisplay().size() < this.currentTrack.getModifiableGpxFile().tracks.size()) {
            GPXUtilities.TrkSegment trkSegment = new GPXUtilities.TrkSegment();
            this.currentTrack.getModifiablePointsToDisplay().add(trkSegment);
        }
    }

    public boolean getIsRecording() {
        return false;
    }

    public float getDistance() {
        return this.distance;
    }

    public int getPoints() {
        return this.points;
    }

    public long getLastTimeUpdated() {
        return this.lastTimeUpdated;
    }

    public GPXUtilities.GPXFile getCurrentGpx() {
        return this.currentTrack.getGpxFile();
    }

    public GpxSelectionHelper.SelectedGpxFile getCurrentTrack() {
        return this.currentTrack;
    }
}

