/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.HasAnnotationPropertiesInSignature;
import org.semanticweb.owlapi.model.HasClassesInSignature;
import org.semanticweb.owlapi.model.HasContainsEntityInSignature;
import org.semanticweb.owlapi.model.HasDataPropertiesInSignature;
import org.semanticweb.owlapi.model.HasDatatypesInSignature;
import org.semanticweb.owlapi.model.HasGetEntitiesInSignature;
import org.semanticweb.owlapi.model.HasIndividualsInSignature;
import org.semanticweb.owlapi.model.HasObjectPropertiesInSignature;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.parameters.Imports;

public interface OWLSignature
extends HasGetEntitiesInSignature,
HasClassesInSignature,
HasObjectPropertiesInSignature,
HasDataPropertiesInSignature,
HasDatatypesInSignature,
HasIndividualsInSignature,
HasAnnotationPropertiesInSignature,
HasContainsEntityInSignature {
    @Nonnull
    public Set<OWLClass> getClassesInSignature(@Nonnull Imports var1);

    @Nonnull
    public Set<OWLObjectProperty> getObjectPropertiesInSignature(@Nonnull Imports var1);

    @Nonnull
    public Set<OWLDataProperty> getDataPropertiesInSignature(@Nonnull Imports var1);

    @Nonnull
    public Set<OWLNamedIndividual> getIndividualsInSignature(@Nonnull Imports var1);

    @Nonnull
    public Set<OWLAnonymousIndividual> getReferencedAnonymousIndividuals(@Nonnull Imports var1);

    @Nonnull
    public Set<OWLDatatype> getDatatypesInSignature(@Nonnull Imports var1);

    @Nonnull
    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature(@Nonnull Imports var1);

    public boolean containsEntityInSignature(@Nonnull OWLEntity var1, @Nonnull Imports var2);

    public boolean containsEntityInSignature(@Nonnull IRI var1, @Nonnull Imports var2);

    public boolean containsClassInSignature(@Nonnull IRI var1, @Nonnull Imports var2);

    public boolean containsObjectPropertyInSignature(@Nonnull IRI var1, @Nonnull Imports var2);

    public boolean containsDataPropertyInSignature(@Nonnull IRI var1, @Nonnull Imports var2);

    public boolean containsAnnotationPropertyInSignature(@Nonnull IRI var1, @Nonnull Imports var2);

    public boolean containsDatatypeInSignature(@Nonnull IRI var1, @Nonnull Imports var2);

    public boolean containsIndividualInSignature(@Nonnull IRI var1, @Nonnull Imports var2);

    public boolean containsDatatypeInSignature(@Nonnull IRI var1);

    public boolean containsEntityInSignature(@Nonnull IRI var1);

    public boolean containsClassInSignature(@Nonnull IRI var1);

    public boolean containsObjectPropertyInSignature(@Nonnull IRI var1);

    public boolean containsDataPropertyInSignature(@Nonnull IRI var1);

    public boolean containsAnnotationPropertyInSignature(@Nonnull IRI var1);

    public boolean containsIndividualInSignature(@Nonnull IRI var1);

    default public boolean containsEntitiesOfTypeInSignature(EntityType<?> type) {
        if (EntityType.CLASS.equals(type)) {
            return !this.getClassesInSignature().isEmpty();
        }
        if (EntityType.DATA_PROPERTY.equals(type)) {
            return !this.getDataPropertiesInSignature().isEmpty();
        }
        if (EntityType.OBJECT_PROPERTY.equals(type)) {
            return !this.getObjectPropertiesInSignature().isEmpty();
        }
        if (EntityType.ANNOTATION_PROPERTY.equals(type)) {
            return !this.getAnnotationPropertiesInSignature().isEmpty();
        }
        if (EntityType.DATATYPE.equals(type)) {
            return !this.getDatatypesInSignature().isEmpty();
        }
        if (EntityType.NAMED_INDIVIDUAL.equals(type)) {
            return !this.getIndividualsInSignature().isEmpty();
        }
        throw new IllegalArgumentException("Entity type " + type + " is not valid for entity presence check");
    }

    public boolean containsEntitiesOfTypeInSignature(EntityType<?> var1, Imports var2);

    @Nonnull
    public Set<OWLEntity> getEntitiesInSignature(@Nonnull IRI var1, @Nonnull Imports var2);

    public Set<IRI> getPunnedIRIs(@Nonnull Imports var1);

    @Deprecated
    public boolean containsReference(@Nonnull OWLEntity var1, @Nonnull Imports var2);

    @Deprecated
    public boolean containsReference(@Nonnull OWLEntity var1);
}

