# frozen_string_literal: true

# The code was auto-generated by {this script}[https://github.com/cucumber/messages/blob/main/jsonschema/scripts/codegen.rb]
module Cucumber
  module Messages
    ##
    # Represents the Exception message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    ##
    #
    # A simplified representation of an exception
    ##
    class Exception < Message
      ##
      # The type of the exception that caused this result. E.g. "Error" or "org.opentest4j.AssertionFailedError"
      ##
      attr_reader :type

      ##
      # The message of exception that caused this result. E.g. expected: "a" but was: "b"
      ##
      attr_reader :message

      ##
      # The stringified stack trace of the exception that caused this result
      ##
      attr_reader :stack_trace

      def initialize(
        type: '',
        message: nil,
        stack_trace: nil
      )
        @type = type
        @message = message
        @stack_trace = stack_trace
        super()
      end

      ##
      # Returns a new Exception from the given hash.
      # If the hash keys are camelCased, they are properly assigned to the
      # corresponding snake_cased attributes.
      #
      #   Cucumber::Messages::Exception.from_h(some_hash) # => #<Cucumber::Messages::Exception:0x... ...>
      ##
      def self.from_h(hash)
        return nil if hash.nil?

        new(
          type: hash[:type],
          message: hash[:message],
          stack_trace: hash[:stackTrace]
        )
      end
    end
  end
end
