/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.store;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.store.PointStore;
import java.util.Arrays;

public class PointStoreLarge
extends PointStore {
    protected int[] locationList;

    @Override
    void setInfeasiblePointstoreLocationIndex(int index) {
        this.locationList[index] = INFEASIBLE_LOCN;
    }

    @Override
    void extendLocationList(int newCapacity) {
        int oldCapacity = this.locationList.length;
        this.locationList = Arrays.copyOf(this.locationList, newCapacity);
        for (int i = oldCapacity; i < newCapacity; ++i) {
            this.locationList[i] = INFEASIBLE_LOCN;
        }
    }

    @Override
    void setLocation(int index, int location) {
        this.locationList[index] = location / this.baseDimension;
    }

    @Override
    int getLocation(int index) {
        return this.baseDimension * this.locationList[index];
    }

    @Override
    int locationListLength() {
        return this.locationList.length;
    }

    public PointStoreLarge(PointStore.Builder builder) {
        super(builder);
        CommonUtils.checkArgument(this.dimensions * this.capacity < Integer.MAX_VALUE, " incorrect parameters");
        if (builder.locationList != null) {
            this.locationList = Arrays.copyOf(builder.locationList, builder.locationList.length);
        } else {
            this.locationList = new int[this.currentStoreCapacity];
            Arrays.fill(this.locationList, INFEASIBLE_LOCN);
        }
    }

    @Override
    public int size() {
        int count = 0;
        for (int i = 0; i < this.locationList.length; ++i) {
            if (this.locationList[i] == INFEASIBLE_LOCN) continue;
            ++count;
        }
        return count;
    }

    @Override
    protected void checkFeasible(int index) {
        CommonUtils.checkArgument(this.locationList[index] != INFEASIBLE_LOCN, " invalid point");
    }

    @Override
    public int[] getLocationList() {
        return Arrays.copyOf(this.locationList, this.locationList.length);
    }
}

