/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.jpeg;

import com.sun.media.codec.video.jpeg.JPEGFrame;
import javax.media.Buffer;

public class RTPDePacketizer {
    private JPEGFrame currentFrame = null;
    protected byte[] frameBuffer = null;
    protected int sequenceNumber = 0;
    protected int quality = 0;
    protected int type = -1;
    byte[] lastJFIFHeader = null;
    int lastQuality = -2;
    int lastType = -1;
    int lastWidth = -1;
    int lastHeight = -1;

    public int getQuality() {
        return this.quality;
    }

    public int getType() {
        return this.type;
    }

    public int process(Buffer inBuffer, Buffer outBuffer) {
        if (this.currentFrame != null && inBuffer.getTimeStamp() != this.currentFrame.rtptimestamp) {
            this.currentFrame = null;
        }
        if (this.getFragOffset((byte[])inBuffer.getData(), inBuffer.getOffset()) == 0) {
            this.currentFrame = new JPEGFrame(this, inBuffer, (byte[])outBuffer.getData());
        } else if (this.currentFrame != null) {
            this.currentFrame.add(inBuffer, 0);
        } else {
            return 4;
        }
        if ((inBuffer.getFlags() & 0x800) != 0) {
            if (this.currentFrame.gotAllPackets(inBuffer.getSequenceNumber())) {
                this.currentFrame.completeTransfer(inBuffer, outBuffer);
                this.currentFrame = null;
                return 0;
            }
            this.currentFrame = null;
            return 4;
        }
        return 4;
    }

    public int getFragOffset(byte[] data, int doff) {
        int foff = 0;
        foff |= (data[doff + 1] & 0xFF) << 16;
        foff |= (data[doff + 2] & 0xFF) << 8;
        return foff |= data[doff + 3] & 0xFF;
    }
}

