/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.ForClause;
import net.sf.saxon.expr.flwor.TuplePush;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Int64Value;

public class ForMemberClausePush
extends TuplePush {
    protected TuplePush destination;
    protected ForClause forClause;

    public ForMemberClausePush(Outputter outputter, TuplePush destination, ForClause forClause) {
        super(outputter);
        this.destination = destination;
        this.forClause = forClause;
    }

    @Override
    public void processTuple(XPathContext context) throws XPathException {
        Expression sequence = this.forClause.getSequence();
        ArrayItem arrayItem = (ArrayItem)sequence.evaluateItem(context);
        int pos = 0;
        for (GroundedValue member : arrayItem.members()) {
            context.setLocalVariable(this.forClause.getRangeVariable().getLocalSlotNumber(), member);
            if (this.forClause.getPositionVariable() != null) {
                context.setLocalVariable(this.forClause.getPositionVariable().getLocalSlotNumber(), new Int64Value(++pos));
            }
            this.destination.processTuple(context);
        }
    }

    @Override
    public void close() throws XPathException {
        this.destination.close();
    }
}

