/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.mapper;

import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import lombok.Generated;
import org.opensearch.core.common.Strings;
import org.opensearch.knn.index.mapper.Mode;
import org.opensearch.knn.index.query.rescore.RescoreContext;

public enum CompressionLevel {
    NOT_CONFIGURED(-1, "", null, Collections.emptySet()),
    x1(1, "1x", null, Collections.emptySet()),
    x2(2, "2x", null, Collections.emptySet()),
    x4(4, "4x", null, Collections.emptySet()),
    x8(8, "8x", new RescoreContext(2.0f), Set.of(Mode.ON_DISK)),
    x16(16, "16x", new RescoreContext(3.0f), Set.of(Mode.ON_DISK)),
    x32(32, "32x", new RescoreContext(3.0f), Set.of(Mode.ON_DISK));

    public static final String[] NAMES_ARRAY;
    private static final CompressionLevel DEFAULT;
    private final int compressionLevel;
    private final String name;
    private final RescoreContext defaultRescoreContext;
    private final Set<Mode> modesForRescore;

    public static CompressionLevel fromName(String name) {
        if (Strings.isEmpty((CharSequence)name)) {
            return NOT_CONFIGURED;
        }
        for (CompressionLevel config : CompressionLevel.values()) {
            if (config.getName() == null || !config.getName().equals(name)) continue;
            return config;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid compression level: \"[%s]\"", name));
    }

    public int numBitsForFloat32() {
        if (this == NOT_CONFIGURED) {
            return DEFAULT.numBitsForFloat32();
        }
        return 32 / this.compressionLevel;
    }

    public static boolean isConfigured(CompressionLevel compressionLevel) {
        return compressionLevel != null && compressionLevel != NOT_CONFIGURED;
    }

    public RescoreContext getDefaultRescoreContext(Mode mode) {
        if (this.modesForRescore.contains((Object)mode)) {
            return this.defaultRescoreContext;
        }
        return null;
    }

    @Generated
    private CompressionLevel(int compressionLevel, String name, RescoreContext defaultRescoreContext, Set<Mode> modesForRescore) {
        this.compressionLevel = compressionLevel;
        this.name = name;
        this.defaultRescoreContext = defaultRescoreContext;
        this.modesForRescore = modesForRescore;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    static {
        NAMES_ARRAY = new String[]{NOT_CONFIGURED.getName(), x1.getName(), x2.getName(), x4.getName(), x8.getName(), x16.getName(), x32.getName()};
        DEFAULT = x1;
    }
}

