/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner.streaming.windowing.assigner;

import com.google.common.base.Preconditions;
import java.util.LinkedList;
import java.util.List;
import org.opensearch.sql.planner.streaming.windowing.Window;
import org.opensearch.sql.planner.streaming.windowing.assigner.WindowAssigner;
import org.opensearch.sql.utils.DateTimeUtils;

public class SlidingWindowAssigner
implements WindowAssigner {
    private final long windowSize;
    private final long slideSize;

    public SlidingWindowAssigner(long windowSize, long slideSize) {
        Preconditions.checkArgument((windowSize > 0L ? 1 : 0) != 0, (String)"Window size [%s] must be positive number", (long)windowSize);
        Preconditions.checkArgument((slideSize > 0L ? 1 : 0) != 0, (String)"Slide size [%s] must be positive number", (long)slideSize);
        this.windowSize = windowSize;
        this.slideSize = slideSize;
    }

    @Override
    public List<Window> assign(long timestamp) {
        LinkedList<Window> windows = new LinkedList<Window>();
        long startTime = DateTimeUtils.getWindowStartTime(timestamp, this.slideSize);
        Window win = this.window(startTime);
        while (win.maxTimestamp() >= timestamp) {
            windows.addFirst(win);
            win = this.window(startTime -= this.slideSize);
        }
        return windows;
    }

    private Window window(long startTime) {
        return new Window(startTime, startTime + this.windowSize);
    }
}

