/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.datasources.encryptor;

import com.amazonaws.encryptionsdk.AwsCrypto;
import com.amazonaws.encryptionsdk.CommitmentPolicy;
import com.amazonaws.encryptionsdk.CryptoResult;
import com.amazonaws.encryptionsdk.MasterKeyProvider;
import com.amazonaws.encryptionsdk.jce.JceMasterKey;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.sql.datasources.encryptor.Encryptor;

public class EncryptorImpl
implements Encryptor {
    private final String masterKey;

    @Override
    public String encrypt(String plainText) {
        this.validate(this.masterKey);
        AwsCrypto crypto = AwsCrypto.builder().withCommitmentPolicy(CommitmentPolicy.RequireEncryptRequireDecrypt).build();
        JceMasterKey jceMasterKey = JceMasterKey.getInstance((SecretKey)new SecretKeySpec(this.masterKey.getBytes(), "AES"), (String)"Custom", (String)"opensearch.config.master.key", (String)"AES/GCM/NoPadding");
        CryptoResult encryptResult = crypto.encryptData((MasterKeyProvider)jceMasterKey, plainText.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString((byte[])encryptResult.getResult());
    }

    @Override
    public String decrypt(String encryptedText) {
        this.validate(this.masterKey);
        AwsCrypto crypto = AwsCrypto.builder().withCommitmentPolicy(CommitmentPolicy.RequireEncryptRequireDecrypt).build();
        JceMasterKey jceMasterKey = JceMasterKey.getInstance((SecretKey)new SecretKeySpec(this.masterKey.getBytes(), "AES"), (String)"Custom", (String)"opensearch.config.master.key", (String)"AES/GCM/NoPadding");
        CryptoResult decryptedResult = crypto.decryptData((MasterKeyProvider)jceMasterKey, Base64.getDecoder().decode(encryptedText));
        return new String((byte[])decryptedResult.getResult());
    }

    private void validate(String masterKey) {
        if (StringUtils.isEmpty((CharSequence)masterKey)) {
            throw new IllegalStateException("Master key is a required config for using create and update datasource APIs.Please set plugins.query.datasources.encryption.masterkey config in opensearch.yml in all the cluster nodes. More details can be found here: https://github.com/opensearch-project/sql/blob/main/docs/user/ppl/admin/datasources.rst#master-key-config-for-encrypting-credential-information");
        }
    }

    @Generated
    public EncryptorImpl(String masterKey) {
        this.masterKey = masterKey;
    }
}

