/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.util;

import java.io.IOException;
import java.util.Arrays;
import sun.security.util.BitArray;
import sun.security.util.DerOutputStream;

public class KerberosFlags {
    BitArray bits;
    protected static final int BITS_PER_UNIT = 8;

    public KerberosFlags(int length) throws IllegalArgumentException {
        this.bits = new BitArray(length);
    }

    public KerberosFlags(int length, byte[] a) throws IllegalArgumentException {
        this.bits = new BitArray(length, a);
        if (length != 32) {
            this.bits = new BitArray(Arrays.copyOf(this.bits.toBooleanArray(), 32));
        }
    }

    public KerberosFlags(boolean[] bools) {
        this.bits = new BitArray(bools.length == 32 ? bools : Arrays.copyOf(bools, 32));
    }

    public void set(int index, boolean value) {
        this.bits.set(index, value);
    }

    public boolean get(int index) {
        return this.bits.get(index);
    }

    public boolean[] toBooleanArray() {
        return this.bits.toBooleanArray();
    }

    public byte[] asn1Encode() throws IOException {
        DerOutputStream out = new DerOutputStream();
        out.putUnalignedBitString(this.bits);
        return out.toByteArray();
    }

    public String toString() {
        return this.bits.toString();
    }
}

