/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query.filtered;

import java.io.IOException;
import org.apache.lucene.util.BitSet;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.query.SegmentLevelQuantizationInfo;
import org.opensearch.knn.index.query.filtered.FilteredIdsKNNIterator;
import org.opensearch.knn.index.vectorvalues.KNNFloatVectorValues;

public class NestedFilteredIdsKNNIterator
extends FilteredIdsKNNIterator {
    private final BitSet parentBitSet;

    NestedFilteredIdsKNNIterator(BitSet filterIdsArray, float[] queryVector, KNNFloatVectorValues knnFloatVectorValues, SpaceType spaceType, BitSet parentBitSet) {
        this(filterIdsArray, queryVector, knnFloatVectorValues, spaceType, parentBitSet, null, null);
    }

    public NestedFilteredIdsKNNIterator(BitSet filterIdsArray, float[] queryVector, KNNFloatVectorValues knnFloatVectorValues, SpaceType spaceType, BitSet parentBitSet, byte[] quantizedVector, SegmentLevelQuantizationInfo segmentLevelQuantizationInfo) {
        super(filterIdsArray, queryVector, knnFloatVectorValues, spaceType, quantizedVector, segmentLevelQuantizationInfo);
        this.parentBitSet = parentBitSet;
    }

    @Override
    public int nextDoc() throws IOException {
        if (this.docId == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        this.currentScore = Float.NEGATIVE_INFINITY;
        int currentParent = this.parentBitSet.nextSetBit(this.docId);
        int bestChild = -1;
        while (this.docId != Integer.MAX_VALUE && this.docId < currentParent) {
            this.knnFloatVectorValues.advance(this.docId);
            float score = this.computeScore();
            if (score > this.currentScore) {
                bestChild = this.docId;
                this.currentScore = score;
            }
            this.docId = this.bitSetIterator.nextDoc();
        }
        return bestChild;
    }
}

