/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.util.concurrent.Executor;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.FrameworkListener;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardThreadExecutor;
import org.apache.coyote.ProtocolHandler;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;

public class ThreadLocalLeakPreventionListener
extends FrameworkListener {
    private static final Log log = LogFactory.getLog(ThreadLocalLeakPreventionListener.class);
    private volatile boolean serverStopping = false;
    protected static final StringManager sm = StringManager.getManager(ThreadLocalLeakPreventionListener.class);

    @Override
    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        try {
            super.lifecycleEvent(lifecycleEvent);
            Lifecycle lifecycle = lifecycleEvent.getLifecycle();
            if ("before_stop".equals(lifecycleEvent.getType()) && lifecycle instanceof Server) {
                this.serverStopping = true;
            }
            if ("after_stop".equals(lifecycleEvent.getType()) && lifecycle instanceof Context) {
                this.stopIdleThreads((Context)lifecycle);
            }
        }
        catch (Exception exception) {
            String string = sm.getString("threadLocalLeakPreventionListener.lifecycleEvent.error", new Object[]{lifecycleEvent});
            log.error((Object)string, (Throwable)exception);
        }
    }

    @Override
    public void containerEvent(ContainerEvent containerEvent) {
        try {
            super.containerEvent(containerEvent);
        }
        catch (Exception exception) {
            String string = sm.getString("threadLocalLeakPreventionListener.containerEvent.error", new Object[]{containerEvent});
            log.error((Object)string, (Throwable)exception);
        }
    }

    private void stopIdleThreads(Context context) {
        if (this.serverStopping) {
            return;
        }
        if (!(context instanceof StandardContext) || !((StandardContext)context).getRenewThreadsWhenStoppingContext()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Not renewing threads when the context is stopping. It is not configured to do it.");
            }
            return;
        }
        Engine engine = (Engine)context.getParent().getParent();
        Service service = engine.getService();
        Connector[] connectorArray = service.findConnectors();
        if (connectorArray != null) {
            for (Connector connector : connectorArray) {
                Object object;
                ProtocolHandler protocolHandler = connector.getProtocolHandler();
                Executor executor = null;
                if (protocolHandler != null) {
                    executor = protocolHandler.getExecutor();
                }
                if (executor instanceof ThreadPoolExecutor) {
                    object = (ThreadPoolExecutor)executor;
                    object.contextStopping();
                    continue;
                }
                if (!(executor instanceof StandardThreadExecutor)) continue;
                object = (StandardThreadExecutor)executor;
                ((StandardThreadExecutor)object).contextStopping();
            }
        }
    }

    @Override
    protected LifecycleListener createLifecycleListener(Context context) {
        return this;
    }
}

