/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.swing;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTable;

class ProfilerRowSorter
extends TableRowSorter {
    private SortOrder defaultSortOrder = SortOrder.ASCENDING;
    private Map<Integer, SortOrder> defaultSortOrders;
    private int secondarySortColumn = -1;
    private boolean threeStateColumns;
    private boolean filterMode = true;
    private Collection<RowFilter<Object, Object>> filters;
    private static final String SORT_COLUMN_KEY = "ProfilerRowSorter.SortColumn";
    private static final String SORT_ORDER_KEY = "ProfilerRowSorter.SortOrder";

    ProfilerRowSorter(TableModel model) {
        super(model);
    }

    public void setAllowsThreeStateColumns(boolean threeStateColumns) {
        this.threeStateColumns = threeStateColumns;
    }

    public boolean allowsThreeStateColumns() {
        return this.threeStateColumns;
    }

    @Override
    public void toggleSortOrder(int column) {
        if (!this.allowsThreeStateColumns()) {
            super.toggleSortOrder(column);
            return;
        }
        if (this.getSortColumn() != column) {
            super.toggleSortOrder(column);
            return;
        }
        SortOrder so = this.getSortOrder();
        if (Objects.equals((Object)this.getDefaultSortOrder(column), (Object)so)) {
            super.toggleSortOrder(column);
            return;
        }
        if (Objects.equals((Object)SortOrder.UNSORTED, (Object)so)) {
            this.setSortColumn(column);
            return;
        }
        this.setSortColumn(column, SortOrder.UNSORTED);
    }

    @Override
    public void setSortKeys(List newKeys) {
        if (newKeys == null || newKeys.isEmpty()) {
            this.setSortKeysImpl(newKeys);
            return;
        }
        RowSorter.SortKey oldKey = this.getSortKey();
        RowSorter.SortKey newKey = (RowSorter.SortKey)newKeys.get(0);
        if (oldKey == null || oldKey.getColumn() != newKey.getColumn()) {
            this.setSortColumn(newKey.getColumn());
        } else {
            this.setSortKeysImpl(newKeys);
        }
    }

    protected void setSortKeysImpl(List newKeys) {
        super.setSortKeys(newKeys);
    }

    void setSortColumn(int column) {
        this.setSortColumn(column, this.getDefaultSortOrder(column));
    }

    void setSortColumn(int column, SortOrder order) {
        this.setSortKey(new RowSorter.SortKey(column, order));
    }

    void setSortKey(RowSorter.SortKey key) {
        RowSorter.SortKey secondaryKey = this.secondarySortColumn == -1 || this.secondarySortColumn == key.getColumn() ? null : new RowSorter.SortKey(this.secondarySortColumn, this.getDefaultSortOrder(this.secondarySortColumn));
        this.setSortKeysImpl(secondaryKey == null ? Arrays.asList(key) : Arrays.asList(key, secondaryKey));
    }

    int getSortColumn() {
        RowSorter.SortKey key = this.getSortKey();
        return key == null ? -1 : key.getColumn();
    }

    SortOrder getSortOrder() {
        RowSorter.SortKey key = this.getSortKey();
        return key == null ? SortOrder.UNSORTED : key.getSortOrder();
    }

    RowSorter.SortKey getSortKey() {
        List<RowSorter.SortKey> keys = this.getSortKeys();
        return keys == null || keys.isEmpty() ? null : keys.get(0);
    }

    void setSecondarySortColumn(int column) {
        this.secondarySortColumn = column;
    }

    int getSecondarySortColumn() {
        return this.secondarySortColumn;
    }

    void setDefaultSortOrder(SortOrder sortOrder) {
        this.defaultSortOrder = sortOrder;
    }

    void setDefaultSortOrder(int column, SortOrder sortOrder) {
        if (this.defaultSortOrders == null) {
            this.defaultSortOrders = new HashMap<Integer, SortOrder>();
        }
        this.defaultSortOrders.put(column, sortOrder);
    }

    SortOrder getDefaultSortOrder(int column) {
        SortOrder order = this.defaultSortOrders == null ? null : this.defaultSortOrders.get(column);
        return order == null ? this.defaultSortOrder : order;
    }

    void setFiltersMode(boolean mode) {
        this.filterMode = mode;
        if (this.filters != null) {
            this.refreshRowFilter();
        }
    }

    boolean getFiltersMode() {
        return this.filterMode;
    }

    void addRowFilter(RowFilter filter) {
        if (this.filters == null) {
            this.filters = new HashSet<RowFilter<Object, Object>>();
        }
        if (this.filters.contains(filter)) {
            this.filters.remove(filter);
        }
        this.filters.add(filter);
        this.refreshRowFilter();
    }

    void removeRowFilter(RowFilter filter) {
        if (this.filters == null) {
            return;
        }
        this.filters.remove(filter);
        this.refreshRowFilter();
    }

    private void refreshRowFilter() {
        if (this.filters == null || this.filters.isEmpty()) {
            this.setRowFilter(null);
        } else if (this.filters.size() == 1) {
            this.setRowFilter(this.filters.iterator().next());
        } else {
            this.setRowFilter(this.filterMode ? RowFilter.andFilter(this.filters) : RowFilter.orFilter(this.filters));
        }
    }

    void loadFromStorage(Properties properties, ProfilerTable table) {
        String columnS = properties.getProperty(SORT_COLUMN_KEY);
        String orderS = properties.getProperty(SORT_ORDER_KEY);
        if (columnS != null) {
            try {
                int column = Integer.parseInt(columnS);
                SortOrder order = this.getSortOrder(orderS);
                this.setSortColumn(column, order);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    void saveToStorage(Properties properties, ProfilerTable table) {
        RowSorter.SortKey key = this.getSortKey();
        if (key == null) {
            properties.remove(SORT_COLUMN_KEY);
            properties.remove(SORT_ORDER_KEY);
        } else {
            int column = key.getColumn();
            SortOrder order = key.getSortOrder();
            properties.setProperty(SORT_COLUMN_KEY, Integer.toString(column));
            properties.setProperty(SORT_ORDER_KEY, order.toString());
        }
    }

    private SortOrder getSortOrder(String sortOrder) {
        if (SortOrder.ASCENDING.toString().equals(sortOrder)) {
            return SortOrder.ASCENDING;
        }
        if (SortOrder.DESCENDING.toString().equals(sortOrder)) {
            return SortOrder.DESCENDING;
        }
        return SortOrder.UNSORTED;
    }
}

