"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const assert_1 = __importDefault(require("assert"));
const zigbee_herdsman_1 = require("zigbee-herdsman");
const fromZigbee_1 = __importDefault(require("../converters/fromZigbee"));
const toZigbee_1 = __importDefault(require("../converters/toZigbee"));
const exposes = __importStar(require("../lib/exposes"));
const reporting = __importStar(require("../lib/reporting"));
const utils = __importStar(require("../lib/utils"));
const e = exposes.presets;
const ea = exposes.access;
const thermostatPositions = {
    quarter_open: 1,
    half_open: 2,
    three_quarters_open: 3,
    fully_open: 4,
};
const tzLocal = {
    quiet_fan: {
        key: ['quiet_fan'],
        convertSet: async (entity, key, value, meta) => {
            (0, assert_1.default)(typeof value === 'boolean');
            await entity.write('hvacFanCtrl', { 0x1000: { value: value ? 1 : 0, type: 0x10 } }, { manufacturerCode: zigbee_herdsman_1.Zcl.ManufacturerCode.ATLANTIC_GROUP });
            return { state: { quiet_fan: value } };
        },
    },
    ac_louver_position: {
        key: ['ac_louver_position'],
        convertSet: async (entity, key, value, meta) => {
            utils.assertString(value, 'ac_louver_position');
            utils.validateValue(value, Object.keys(thermostatPositions));
            const index = thermostatPositions[value.toLowerCase()];
            await entity.write('hvacThermostat', { 0x4273: { value: index, type: 0x30 } }, { manufacturerCode: zigbee_herdsman_1.Zcl.ManufacturerCode.ATLANTIC_GROUP });
            return { state: { ac_louver_position: value } };
        },
    },
    preset: {
        key: ['preset'],
        convertSet: async (entity, key, value, meta) => {
            utils.assertString(value, 'preset');
            value = value.toLowerCase();
            utils.validateValue(value, ['activity', 'boost', 'eco', 'none']);
            const activity = value === 'activity' ? 1 : 0;
            const boost = value === 'boost' ? 1 : 0;
            const eco = value === 'eco' ? 4 : 0;
            await entity.write('hvacThermostat', { 0x4275: { value: activity, type: 0x30 } }, { manufacturerCode: zigbee_herdsman_1.Zcl.ManufacturerCode.ATLANTIC_GROUP });
            await entity.write('hvacThermostat', { programingOperMode: eco });
            await entity.write('hvacThermostat', { 0x4270: { value: boost, type: 0x10 } }, { manufacturerCode: zigbee_herdsman_1.Zcl.ManufacturerCode.ATLANTIC_GROUP });
            return { state: { preset: value } };
        },
    },
    swingMode: {
        key: ['swing_mode'],
        convertSet: async (entity, key, value, meta) => {
            utils.assertString(value, 'swing_mode');
            value = value.toLowerCase();
            utils.validateValue(value, ['on', 'off']);
            await entity.write('hvacThermostat', { 0x4274: { value: value === 'on' ? 1 : 0, type: 0x10 } }, { manufacturerCode: zigbee_herdsman_1.Zcl.ManufacturerCode.ATLANTIC_GROUP });
            return { state: { swing_mode: value } };
        },
    },
};
const definitions = [
    {
        zigbeeModel: ['Adapter Zigbee FUJITSU'],
        model: 'GW003-AS-IN-TE-FC',
        vendor: 'Atlantic Group',
        description: 'Interface Naviclim for Takao air conditioners',
        fromZigbee: [fromZigbee_1.default.thermostat, fromZigbee_1.default.fan],
        toZigbee: [
            tzLocal.ac_louver_position,
            tzLocal.preset,
            tzLocal.quiet_fan,
            tzLocal.swingMode,
            toZigbee_1.default.fan_mode,
            toZigbee_1.default.thermostat_local_temperature,
            toZigbee_1.default.thermostat_occupied_cooling_setpoint,
            toZigbee_1.default.thermostat_occupied_heating_setpoint,
            toZigbee_1.default.thermostat_programming_operation_mode,
            toZigbee_1.default.thermostat_system_mode,
        ],
        exposes: [
            e.programming_operation_mode(),
            e
                .climate()
                .withLocalTemperature()
                .withSetpoint('occupied_cooling_setpoint', 18, 30, 0.5)
                .withSetpoint('occupied_heating_setpoint', 16, 30, 0.5)
                .withSystemMode(['off', 'heat', 'cool', 'auto', 'dry', 'fan_only'])
                .withPreset(['activity', 'boost', 'eco'])
                .withFanMode(['low', 'medium', 'high', 'auto'])
                .withSwingMode(['on', 'off'], ea.STATE_SET),
            e.binary('quiet_fan', ea.STATE_SET, true, false).withDescription('Fan quiet mode'),
            e.enum('ac_louver_position', ea.STATE_SET, Object.keys(thermostatPositions)).withDescription('Ac louver position of this device'),
        ],
        configure: async (device, coordinatorEndpoint) => {
            const endpoint1 = device.getEndpoint(1);
            const binds1 = ['hvacFanCtrl', 'genIdentify', 'hvacFanCtrl', 'hvacThermostat', 'manuSpecificPhilips2'];
            await reporting.bind(endpoint1, coordinatorEndpoint, binds1);
            await reporting.thermostatTemperature(endpoint1);
            await reporting.thermostatOccupiedCoolingSetpoint(endpoint1);
            await reporting.thermostatSystemMode(endpoint1);
            const endpoint232 = device.getEndpoint(232);
            await reporting.bind(endpoint232, coordinatorEndpoint, ['haDiagnostic']);
        },
    },
];
exports.default = definitions;
module.exports = definitions;
//# sourceMappingURL=atlantic.js.map