/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchException;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.alerting.WorkflowMetadataService;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.client.Client;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.model.CompositeInput;
import org.opensearch.commons.alerting.model.Workflow;
import org.opensearch.commons.alerting.model.WorkflowMetadata;
import org.opensearch.commons.alerting.util.AlertingException;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J7\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001b0\u001d2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ\u001b\u0010 \u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010!J&\u0010\"\u001a\u00020#2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011J!\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u001bH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006("}, d2={"Lorg/opensearch/alerting/WorkflowMetadataService;", "Lkotlinx/coroutines/CoroutineScope;", "()V", "client", "Lorg/opensearch/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "indexTimeout", "Lorg/opensearch/common/unit/TimeValue;", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "settings", "Lorg/opensearch/common/settings/Settings;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "createNewWorkflowMetadata", "Lorg/opensearch/commons/alerting/model/WorkflowMetadata;", "workflow", "Lorg/opensearch/commons/alerting/model/Workflow;", "executionId", "", "isTempWorkflow", "", "getOrCreateWorkflowMetadata", "Lkotlin/Pair;", "skipIndex", "(Lorg/opensearch/commons/alerting/model/Workflow;ZLjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getWorkflowMetadata", "(Lorg/opensearch/commons/alerting/model/Workflow;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "initialize", "", "upsertWorkflowMetadata", "metadata", "updating", "(Lorg/opensearch/commons/alerting/model/WorkflowMetadata;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "opensearch-alerting"})
public final class WorkflowMetadataService
implements CoroutineScope {
    @NotNull
    public static final WorkflowMetadataService INSTANCE = new WorkflowMetadataService();
    private final /* synthetic */ CoroutineScope $$delegate_0;
    private static final Logger log = LogManager.getLogger(INSTANCE.getClass());
    private static Client client;
    private static NamedXContentRegistry xContentRegistry;
    private static ClusterService clusterService;
    private static Settings settings;
    private static volatile TimeValue indexTimeout;

    private WorkflowMetadataService() {
        this.$$delegate_0 = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)Dispatchers.getDefault()).plus((CoroutineContext)new CoroutineName("WorkflowMetadataService")));
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.$$delegate_0.getCoroutineContext();
    }

    public final void initialize(@NotNull Client client, @NotNull ClusterService clusterService, @NotNull NamedXContentRegistry xContentRegistry, @NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        WorkflowMetadataService.clusterService = clusterService;
        WorkflowMetadataService.client = client;
        WorkflowMetadataService.xContentRegistry = xContentRegistry;
        WorkflowMetadataService.settings = settings;
        Object object = AlertingSettings.Companion.getINDEX_TIMEOUT().get(settings);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"AlertingSettings.INDEX_TIMEOUT.get(settings)");
        indexTimeout = (TimeValue)object;
        ClusterService clusterService2 = WorkflowMetadataService.clusterService;
        if (clusterService2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clusterService");
            clusterService2 = null;
        }
        clusterService2.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getINDEX_TIMEOUT(), WorkflowMetadataService::initialize$lambda$0);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object upsertWorkflowMetadata(@NotNull WorkflowMetadata var1_1, boolean var2_2, @NotNull Continuation<? super WorkflowMetadata> var3_3) {
        if (!(var3_3 instanceof upsertWorkflowMetadata.1)) ** GOTO lbl-1000
        var8_4 = var3_3;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ WorkflowMetadataService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.upsertWorkflowMetadata(null, false, (Continuation<? super WorkflowMetadata>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = (IndexRequest)new IndexRequest(".opendistro-alerting-config").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                v1 = XContentFactory.jsonBuilder();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"jsonBuilder()");
                v2 = v0.source(metadata.toXContent(v1, (ToXContent.Params)new ToXContent.MapParams(MapsKt.mapOf((Pair)TuplesKt.to((Object)"with_type", (Object)"true"))))).id(metadata.getId()).routing(metadata.getWorkflowId());
                v3 = WorkflowMetadataService.indexTimeout;
                if (v3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"indexTimeout");
                    v3 = null;
                }
                indexRequest = (IndexRequest)v2.timeout(v3);
                if (updating) {
                    indexRequest.id(metadata.getId());
                } else {
                    indexRequest.opType(DocWriteRequest.OpType.CREATE);
                }
                if ((v4 = WorkflowMetadataService.client) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                    v4 = null;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = metadata;
                $continuation.Z$0 = updating;
                $continuation.label = 1;
                v5 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)v4), (Function2)((Function2)new Function2<Client, ActionListener<IndexResponse>, Unit>(indexRequest){
                    final /* synthetic */ IndexRequest $indexRequest;
                    {
                        this.$indexRequest = $indexRequest;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<IndexResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.index(this.$indexRequest, it);
                    }
                }), (Continuation)$continuation);
                ** if (v5 != var9_6) goto lbl39
lbl38:
                // 1 sources

                return var9_6;
lbl39:
                // 1 sources

                ** GOTO lbl48
            }
            case 1: {
                updating = $continuation.Z$0;
                metadata = (WorkflowMetadata)$continuation.L$1;
                this = (WorkflowMetadataService)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v5 = $result;
lbl48:
                    // 2 sources

                    response = (IndexResponse)v5;
                    v6 = response.getResult();
                    switch (v6 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[v6.ordinal()]) {
                        case -1: 
                        case 1: 
                        case 2: 
                        case 3: {
                            v7 = response.getResult();
                            failureReason = "The upsert metadata call failed with a " + (v7 != null ? v7.getLowercase() : null) + " result";
                            WorkflowMetadataService.log.error(failureReason);
                            throw new AlertingException(failureReason, RestStatus.INTERNAL_SERVER_ERROR, (Exception)new IllegalStateException(failureReason));
                        }
                        case 4: 
                        case 5: {
                            WorkflowMetadataService.log.debug("Successfully upserted WorkflowMetadata:" + metadata.getId() + " ");
                        }
                    }
                    return metadata;
                }
                catch (Exception e) {
                    if (!(e instanceof OpenSearchException) || ((OpenSearchException)e).status() != RestStatus.CONFLICT || updating) break;
                    WorkflowMetadataService.log.debug("Metadata with " + metadata.getId() + " for workflow " + metadata.getWorkflowId() + " already exist. Instead of creating new, updating existing metadata will be performed");
                    $continuation.L$0 = null;
                    $continuation.L$1 = null;
                    $continuation.label = 2;
                    v8 = this.upsertWorkflowMetadata(metadata, true, (Continuation<? super WorkflowMetadata>)$continuation);
                    if (v8 == var9_6) {
                        return var9_6;
                    }
                    ** GOTO lbl72
                }
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v8 = $result;
lbl72:
                // 2 sources

                return v8;
            }
        }
        WorkflowMetadataService.log.error("Error saving metadata", (Throwable)e);
        throw AlertingException.Companion.wrap(e);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getOrCreateWorkflowMetadata(@NotNull Workflow var1_1, boolean var2_2, @NotNull String var3_3, @NotNull Continuation<? super Pair<WorkflowMetadata, Boolean>> var4_4) {
        if (!(var4_4 instanceof getOrCreateWorkflowMetadata.1)) ** GOTO lbl-1000
        var9_5 = var4_4;
        if ((var9_5.label & -2147483648) != 0) {
            var9_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                Object L$2;
                boolean Z$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ WorkflowMetadataService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getOrCreateWorkflowMetadata(null, false, null, (Continuation<? super Pair<WorkflowMetadata, Boolean>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                created = 1;
                $continuation.L$0 = this;
                $continuation.L$1 = workflow;
                $continuation.L$2 = executionId;
                $continuation.Z$0 = skipIndex;
                $continuation.I$0 = created;
                $continuation.label = 1;
                v0 = this.getWorkflowMetadata(workflow, (Continuation<? super WorkflowMetadata>)$continuation);
                ** if (v0 != var10_7) goto lbl24
lbl23:
                // 1 sources

                return var10_7;
lbl24:
                // 1 sources

                ** GOTO lbl35
            }
            case 1: {
                created = $continuation.I$0;
                skipIndex = $continuation.Z$0;
                executionId = (String)$continuation.L$2;
                workflow = (Workflow)$continuation.L$1;
                this = (WorkflowMetadataService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl35:
                // 2 sources

                if ((metadata = (WorkflowMetadata)v0) == null) ** GOTO lbl38
                v1 = TuplesKt.to((Object)metadata, (Object)Boxing.boxBoolean((boolean)(created == 0)));
                ** GOTO lbl58
lbl38:
                // 1 sources

                newMetadata = this.createNewWorkflowMetadata(workflow, executionId, skipIndex != false);
                if (!skipIndex) ** GOTO lbl42
                v1 = TuplesKt.to((Object)newMetadata, (Object)Boxing.boxBoolean((boolean)(created != 0)));
                ** GOTO lbl58
lbl42:
                // 1 sources

                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.I$0 = created;
                $continuation.label = 2;
                v2 = this.upsertWorkflowMetadata(newMetadata, false, (Continuation<? super WorkflowMetadata>)$continuation);
                ** if (v2 != var10_7) goto lbl50
lbl49:
                // 1 sources

                return var10_7;
lbl50:
                // 1 sources

                ** GOTO lbl57
            }
            case 2: {
                created = $continuation.I$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl57:
                    // 2 sources

                    v1 = TuplesKt.to((Object)v2, (Object)Boxing.boxBoolean((boolean)(created != 0)));
lbl58:
                    // 3 sources

                    return v1;
                }
                catch (Exception e) {
                    throw AlertingException.Companion.wrap(e);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object getOrCreateWorkflowMetadata$default(WorkflowMetadataService workflowMetadataService, Workflow workflow, boolean bl, String string, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return workflowMetadataService.getOrCreateWorkflowMetadata(workflow, bl, string, (Continuation<? super Pair<WorkflowMetadata, Boolean>>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    private final Object getWorkflowMetadata(Workflow var1_1, Continuation<? super WorkflowMetadata> var2_2) {
        if (!(var2_2 instanceof getWorkflowMetadata.1)) ** GOTO lbl-1000
        var8_3 = var2_2;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ WorkflowMetadataService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return WorkflowMetadataService.access$getWorkflowMetadata(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                metadataId = WorkflowMetadata.Companion.getId(workflow.getId());
                getRequest = new GetRequest(".opendistro-alerting-config", metadataId).routing(workflow.getId());
                v0 = WorkflowMetadataService.client;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                    v0 = null;
                }
                $continuation.label = 1;
                v1 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)v0), (Function2)((Function2)new Function2<Client, ActionListener<GetResponse>, Unit>(getRequest){
                    final /* synthetic */ GetRequest $getRequest;
                    {
                        this.$getRequest = $getRequest;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<GetResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.get(this.$getRequest, it);
                    }
                }), (Continuation)$continuation);
                ** if (v1 != var9_5) goto lbl24
lbl23:
                // 1 sources

                return var9_5;
lbl24:
                // 1 sources

                ** GOTO lbl30
            }
            case 1: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl30:
                    // 2 sources

                    if ((getResponse = (GetResponse)v1).isExists()) {
                        v2 = WorkflowMetadataService.xContentRegistry;
                        if (v2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"xContentRegistry");
                            v2 = null;
                        }
                        xcp = XContentHelper.createParser((NamedXContentRegistry)v2, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)getResponse.getSourceAsBytesRef(), (MediaType)((MediaType)XContentType.JSON));
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
                        Intrinsics.checkNotNullExpressionValue((Object)xcp, (String)"xcp");
                        v3 = WorkflowMetadata.Companion.parse(xcp);
                    } else {
                        v3 = null;
                    }
                    return v3;
                }
                catch (Exception e) {
                    v4 = e.getMessage();
                    v5 = v4 != null ? StringsKt.contains$default((CharSequence)v4, (CharSequence)"no such index", (boolean)false, (int)2, null) : false;
                    if (v5) {
                        return null;
                    }
                    throw AlertingException.Companion.wrap(e);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final WorkflowMetadata createNewWorkflowMetadata(Workflow workflow, String executionId, boolean isTempWorkflow) {
        String id = isTempWorkflow ? "" + LocalDateTime.now(ZoneOffset.UTC) + UUID.randomUUID() : workflow.getId();
        String string = WorkflowMetadata.Companion.getId(id);
        String string2 = workflow.getId();
        Object e = workflow.getInputs().get(0);
        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.opensearch.commons.alerting.model.CompositeInput");
        List list = ((CompositeInput)e).getMonitorIds();
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        return new WorkflowMetadata(string, string2, list, instant, executionId);
    }

    private static final void initialize$lambda$0(TimeValue it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        indexTimeout = it;
    }

    public static final /* synthetic */ Object access$getWorkflowMetadata(WorkflowMetadataService $this, Workflow workflow, Continuation $completion) {
        return $this.getWorkflowMetadata(workflow, (Continuation<? super WorkflowMetadata>)$completion);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DocWriteResponse.Result.values().length];
            try {
                nArray[DocWriteResponse.Result.DELETED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DocWriteResponse.Result.NOOP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DocWriteResponse.Result.NOT_FOUND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DocWriteResponse.Result.CREATED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DocWriteResponse.Result.UPDATED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

