/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.csv;

import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.RFC4180ParserBuilder;
import com.opencsv.exceptions.CsvValidationException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tribuo.data.columnar.ColumnarIterator;
import org.tribuo.data.csv.CSVDataSource;

public class CSVIterator
extends ColumnarIterator
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(CSVIterator.class.getName());
    public static final char SEPARATOR = ',';
    public static final char QUOTE = '\"';
    private final CSVReader reader;
    private int recordNum = 0;

    public CSVIterator(Reader rdr) {
        this(rdr, ',', '\"');
    }

    public CSVIterator(Reader rdr, char separator, char quote) {
        this(rdr, separator, quote, Collections.emptyList());
    }

    public CSVIterator(URI dataFile) throws IOException {
        this(new InputStreamReader(Files.newInputStream(Paths.get(dataFile), new OpenOption[0]), StandardCharsets.UTF_8));
    }

    public CSVIterator(URI dataFile, char separator, char quote) throws IOException {
        this(new InputStreamReader(Files.newInputStream(Paths.get(dataFile), new OpenOption[0]), StandardCharsets.UTF_8), separator, quote);
    }

    public CSVIterator(URI dataFile, char separator, char quote, String[] fields) throws IOException {
        this((Reader)new InputStreamReader(Files.newInputStream(Paths.get(dataFile), new OpenOption[0]), StandardCharsets.UTF_8), separator, quote, Arrays.asList(fields));
    }

    public CSVIterator(URI dataFile, char separator, char quote, List<String> fields) throws IOException {
        this((Reader)new InputStreamReader(Files.newInputStream(Paths.get(dataFile), new OpenOption[0]), StandardCharsets.UTF_8), separator, quote, fields);
    }

    public CSVIterator(Reader rdr, char separator, char quote, String[] fields) {
        this(rdr, separator, quote, fields == null ? null : Arrays.asList(fields));
    }

    public CSVIterator(Reader rdr, char separator, char quote, List<String> fields) {
        try {
            BufferedReader bomRemoved = new BufferedReader(CSVDataSource.removeBOM(rdr));
            this.reader = new CSVReaderBuilder((Reader)bomRemoved).withCSVParser((ICSVParser)new RFC4180ParserBuilder().withSeparator(separator).withQuoteChar(quote).build()).build();
            try {
                if (fields == null || fields.isEmpty()) {
                    String[] inducedHeader = this.reader.readNext();
                    if (inducedHeader == null) {
                        logger.warning("Given an empty CSV");
                    } else {
                        this.fields = Collections.unmodifiableList(Arrays.asList(inducedHeader));
                    }
                } else {
                    this.fields = Collections.unmodifiableList(fields);
                }
            }
            catch (CsvValidationException | IOException e) {
                try {
                    this.reader.close();
                }
                catch (IOException e2) {
                    logger.log(Level.WARNING, "Error closing reader in another error", e2);
                }
                throw new IllegalArgumentException("Error reading file caused by: " + e.getMessage());
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error reading file caused by: " + e.getMessage());
        }
    }

    private static Map<String, String> zip(List<String> headers, String[] line, long rowNum) {
        if (headers.size() != line.length) {
            throw new IllegalArgumentException("On row " + rowNum + " headers has " + headers.size() + " elements, current line has " + line.length + " elements.");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < headers.size(); ++i) {
            map.put(headers.get(i), line[i]);
        }
        return map;
    }

    @Override
    protected Optional<ColumnarIterator.Row> getRow() {
        try {
            String[] rawRow = this.reader.readNext();
            if (rawRow != null) {
                if (this.reader.getRecordsRead() % 50000L == 0L) {
                    logger.info(String.format("Read %d records on %d lines", this.reader.getRecordsRead(), this.reader.getLinesRead()));
                }
                while (rawRow != null && rawRow.length == 1 && rawRow[0].isEmpty()) {
                    logger.warning("Ignoring extra newline at line " + this.reader.getLinesRead());
                    rawRow = this.reader.readNext();
                }
                if (rawRow == null) {
                    try {
                        this.reader.close();
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Error closing reader at end of file", e);
                    }
                    return Optional.empty();
                }
                return Optional.of(new ColumnarIterator.Row(this.recordNum++, this.fields, CSVIterator.zip(this.fields, rawRow, this.reader.getRecordsRead())));
            }
            try {
                this.reader.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Error closing reader at end of file", e);
            }
            return Optional.empty();
        }
        catch (CsvValidationException | IOException e) {
            long linesRead = this.reader.getLinesRead();
            long recordsRead = this.reader.getRecordsRead();
            try {
                this.reader.close();
            }
            catch (IOException e2) {
                logger.log(Level.WARNING, "Error closing reader in another error", e2);
            }
            throw new IllegalArgumentException(String.format("Error reading CSV on record %d, row %d", recordsRead, linesRead), e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }
}

