/**
 * MIT License
 *
 * Copyright (c) 2017 Microsoft
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof sap.ui.define === 'function')
		sap.ui.define([], factory);
	else if(typeof exports === 'object')
		exports["AdaptiveCards"] = factory();
	else
		root["AdaptiveCards"] = factory();
})(window, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./src/adaptivecards.ts");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./src/activity-request.ts":
/*!*********************************!*\
  !*** ./src/activity-request.ts ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
	var extendStatics = function (d, b) {
		extendStatics = Object.setPrototypeOf ||
			({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
			function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
		return extendStatics(d, b);
	};
	return function (d, b) {
		extendStatics(d, b);
		function __() { this.constructor = d; }
		d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoginRequestResponse = exports.ErrorResponse = exports.SuccessResponse = exports.ActivityResponse = exports.ActivityRequestError = exports.ActivityRequestTrigger = void 0;
var ActivityRequestTrigger;
(function (ActivityRequestTrigger) {
	ActivityRequestTrigger["Automatic"] = "automatic";
	ActivityRequestTrigger["Manual"] = "manual";
})(ActivityRequestTrigger = exports.ActivityRequestTrigger || (exports.ActivityRequestTrigger = {}));
var ActivityRequestError = /** @class */ (function () {
	function ActivityRequestError(code, message) {
		this.code = code;
		this.message = message;
	}
	return ActivityRequestError;
}());
exports.ActivityRequestError = ActivityRequestError;
var ActivityResponse = /** @class */ (function () {
	function ActivityResponse(request) {
		this.request = request;
	}
	return ActivityResponse;
}());
exports.ActivityResponse = ActivityResponse;
var SuccessResponse = /** @class */ (function (_super) {
	__extends(SuccessResponse, _super);
	function SuccessResponse(request, rawContent) {
		var _this = _super.call(this, request) || this;
		_this.request = request;
		_this.rawContent = rawContent;
		return _this;
	}
	return SuccessResponse;
}(ActivityResponse));
exports.SuccessResponse = SuccessResponse;
var ErrorResponse = /** @class */ (function (_super) {
	__extends(ErrorResponse, _super);
	function ErrorResponse(request, error) {
		var _this = _super.call(this, request) || this;
		_this.request = request;
		_this.error = error;
		return _this;
	}
	return ErrorResponse;
}(ActivityResponse));
exports.ErrorResponse = ErrorResponse;
var LoginRequestResponse = /** @class */ (function (_super) {
	__extends(LoginRequestResponse, _super);
	function LoginRequestResponse(request, _auth) {
		var _this = _super.call(this, request) || this;
		_this.request = request;
		_this._auth = _auth;
		for (var _i = 0, _a = _this._auth.buttons; _i < _a.length; _i++) {
			var button = _a[_i];
			if (button.type === "signin" && button.value !== undefined) {
				try {
					new URL(button.value);
					_this.signinButton = button;
					break;
				}
				catch (e) {
					// Ignore parsing error
				}
			}
		}
		return _this;
	}
	Object.defineProperty(LoginRequestResponse.prototype, "tokenExchangeResource", {
		get: function () {
			return this._auth.tokenExchangeResource;
		},
		enumerable: false,
		configurable: true
	});
	return LoginRequestResponse;
}(ActivityResponse));
exports.LoginRequestResponse = LoginRequestResponse;


/***/ }),

/***/ "./src/adaptive-applet.ts":
/*!********************************!*\
  !*** ./src/adaptive-applet.ts ***!
  \********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
	function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
	return new (P || (P = Promise))(function (resolve, reject) {
		function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
		function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
		function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
		step((generator = generator.apply(thisArg, _arguments || [])).next());
	});
};
var __generator = (this && this.__generator) || function (thisArg, body) {
	var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
	return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
	function verb(n) { return function (v) { return step([n, v]); }; }
	function step(op) {
		if (f) throw new TypeError("Generator is already executing.");
		while (_) try {
			if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
			if (y = 0, t) op = [op[0] & 2, t.value];
			switch (op[0]) {
				case 0: case 1: t = op; break;
				case 4: _.label++; return { value: op[1], done: false };
				case 5: _.label++; y = op[1]; op = [0]; continue;
				case 7: op = _.ops.pop(); _.trys.pop(); continue;
				default:
					if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
					if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
					if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
					if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
					if (t[2]) _.ops.pop();
					_.trys.pop(); continue;
			}
			op = body.call(thisArg, _);
		} catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
		if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
	}
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AdaptiveApplet = void 0;
var Enums = __webpack_require__(/*! ./enums */ "./src/enums.ts");
var Utils = __webpack_require__(/*! ./utils */ "./src/utils.ts");
var shared_1 = __webpack_require__(/*! ./shared */ "./src/shared.ts");
var activity_request_1 = __webpack_require__(/*! ./activity-request */ "./src/activity-request.ts");
var strings_1 = __webpack_require__(/*! ./strings */ "./src/strings.ts");
var card_elements_1 = __webpack_require__(/*! ./card-elements */ "./src/card-elements.ts");
var serialization_1 = __webpack_require__(/*! ./serialization */ "./src/serialization.ts");
function logEvent(level, message) {
	var optionalParams = [];
	for (var _i = 2; _i < arguments.length; _i++) {
		optionalParams[_i - 2] = arguments[_i];
	}
	if (shared_1.GlobalSettings.applets.logEnabled) {
		if (shared_1.GlobalSettings.applets.onLogEvent) {
			shared_1.GlobalSettings.applets.onLogEvent(level, message, optionalParams);
		}
		else {
			switch (level) {
				case Enums.LogLevel.Warning:
					console.warn(message, optionalParams);
					break;
				case Enums.LogLevel.Error:
					console.error(message, optionalParams);
					break;
				default:
					console.log(message, optionalParams);
					break;
			}
		}
	}
}
var ActivityRequest = /** @class */ (function () {
	function ActivityRequest(action, trigger, consecutiveRefreshes) {
		this.action = action;
		this.trigger = trigger;
		this.consecutiveRefreshes = consecutiveRefreshes;
		this.attemptNumber = 0;
	}
	ActivityRequest.prototype.retryAsync = function () {
		return __awaiter(this, void 0, void 0, function () {
			return __generator(this, function (_a) {
				if (this.onSend) {
					this.onSend(this);
				}
				return [2 /*return*/];
			});
		});
	};
	return ActivityRequest;
}());
var AdaptiveApplet = /** @class */ (function () {
	function AdaptiveApplet() {
		this._allowAutomaticCardUpdate = false;
		this.renderedElement = document.createElement("div");
		this.renderedElement.className = "aaf-cardHost";
		this.renderedElement.style.position = "relative";
		this.renderedElement.style.display = "flex";
		this.renderedElement.style.flexDirection = "column";
		this._cardHostElement = document.createElement("div");
		this._refreshButtonHostElement = document.createElement("div");
		this._refreshButtonHostElement.className = "aaf-refreshButtonHost";
		this._refreshButtonHostElement.style.display = "none";
		this.renderedElement.appendChild(this._cardHostElement);
		this.renderedElement.appendChild(this._refreshButtonHostElement);
	}
	AdaptiveApplet.prototype.displayCard = function (card) {
		if (card.renderedElement) {
			Utils.clearElementChildren(this._cardHostElement);
			this._refreshButtonHostElement.style.display = "none";
			this._cardHostElement.appendChild(card.renderedElement);
		}
		else {
			throw new Error("displayCard: undefined card.");
		}
	};
	AdaptiveApplet.prototype.showManualRefreshButton = function (refreshAction) {
		var _this = this;
		var displayBuiltInManualRefreshButton = this.onShowManualRefreshButton ? this.onShowManualRefreshButton(this) : true;
		if (displayBuiltInManualRefreshButton) {
			this._refreshButtonHostElement.style.display = "none";
			var renderedRefreshButton = undefined;
			if (this.onRenderManualRefreshButton) {
				renderedRefreshButton = this.onRenderManualRefreshButton(this);
			}
			else {
				var message = strings_1.Strings.runtime.refreshThisCard();
				if (shared_1.GlobalSettings.applets.refresh.mode === Enums.RefreshMode.Automatic) {
					var autoRefreshPausedMessage = strings_1.Strings.runtime.automaticRefreshPaused();
					if (autoRefreshPausedMessage[autoRefreshPausedMessage.length - 1] !== " ") {
						autoRefreshPausedMessage += " ";
					}
					message = strings_1.Strings.runtime.clckToRestartAutomaticRefresh();
				}
				var cardPayload = {
					type: "AdaptiveCard",
					version: "1.2",
					body: [
						{
							type: "RichTextBlock",
							horizontalAlignment: "right",
							inlines: [
								{
									type: "TextRun",
									text: message,
									selectAction: {
										type: "Action.Submit",
										id: "refreshCard"
									}
								}
							]
						}
					]
				};
				var card = new card_elements_1.AdaptiveCard();
				card.parse(cardPayload, new card_elements_1.SerializationContext(serialization_1.Versions.v1_2));
				card.onExecuteAction = function (action) {
					if (action.id === "refreshCard") {
						Utils.clearElementChildren(_this._refreshButtonHostElement);
						_this.internalExecuteAction(refreshAction, activity_request_1.ActivityRequestTrigger.Automatic, 0);
					}
				};
				renderedRefreshButton = card.render();
			}
			if (renderedRefreshButton) {
				Utils.clearElementChildren(this._refreshButtonHostElement);
				this._refreshButtonHostElement.appendChild(renderedRefreshButton);
				this._refreshButtonHostElement.style.removeProperty("display");
			}
		}
	};
	AdaptiveApplet.prototype.createActivityRequest = function (action, trigger, consecutiveRefreshes) {
		var _this = this;
		if (this.card) {
			var request_1 = new ActivityRequest(action, trigger, consecutiveRefreshes);
			request_1.onSend = function (sender) {
				sender.attemptNumber++;
				_this.internalSendActivityRequestAsync(request_1);
			};
			var cancel = this.onPrepareActivityRequest ? !this.onPrepareActivityRequest(this, request_1, action) : false;
			return cancel ? undefined : request_1;
		}
		else {
			throw new Error("createActivityRequest: no card has been set.");
		}
	};
	AdaptiveApplet.prototype.createMagicCodeInputCard = function (attemptNumber) {
		var payload = {
			type: "AdaptiveCard",
			version: "1.0",
			body: [
				{
					type: "TextBlock",
					color: "attention",
					text: attemptNumber === 1 ? undefined : "That didn't work... let's try again.",
					wrap: true,
					horizontalAlignment: "center"
				},
				{
					type: "TextBlock",
					text: "Please login in the popup. You will obtain a magic code. Paste that code below and select \"Submit\"",
					wrap: true,
					horizontalAlignment: "center"
				},
				{
					type: "Input.Text",
					id: "magicCode",
					placeholder: "Enter magic code"
				},
				{
					type: "ActionSet",
					horizontalAlignment: "center",
					actions: [
						{
							type: "Action.Submit",
							id: AdaptiveApplet.submitMagicCodeActionId,
							title: "Submit"
						},
						{
							type: "Action.Submit",
							id: AdaptiveApplet.cancelMagicCodeAuthActionId,
							title: "Cancel"
						}
					]
				}
			]
		};
		var card = new card_elements_1.AdaptiveCard();
		card.parse(payload);
		return card;
	};
	AdaptiveApplet.prototype.cancelAutomaticRefresh = function () {
		if (this._allowAutomaticCardUpdate) {
			logEvent(Enums.LogLevel.Warning, "Automatic card refresh has been cancelled as a result of the user interacting with the card.");
		}
		this._allowAutomaticCardUpdate = false;
	};
	AdaptiveApplet.prototype.createSerializationContext = function () {
		return this.onCreateSerializationContext ? this.onCreateSerializationContext(this) : new card_elements_1.SerializationContext();
	};
	AdaptiveApplet.prototype.internalSetCard = function (payload, consecutiveRefreshes) {
		var _this = this;
		if (typeof payload === "object" && payload["type"] === "AdaptiveCard") {
			this._cardPayload = payload;
		}
		if (this._cardPayload) {
			try {
				var card = new card_elements_1.AdaptiveCard();
				if (this.hostConfig) {
					card.hostConfig = this.hostConfig;
				}
				var serializationContext = this.createSerializationContext();
				card.parse(this._cardPayload, serializationContext);
				var doChangeCard = this.onCardChanging ? this.onCardChanging(this, this._cardPayload) : true;
				if (doChangeCard) {
					this._card = card;
					if (this._card.authentication && this._card.authentication.tokenExchangeResource && this.onPrefetchSSOToken) {
						this.onPrefetchSSOToken(this, this._card.authentication.tokenExchangeResource);
					}
					this._card.onExecuteAction = function (action) {
						// If the user takes an action, cancel any pending automatic refresh
						_this.cancelAutomaticRefresh();
						_this.internalExecuteAction(action, activity_request_1.ActivityRequestTrigger.Manual, 0);
					};
					this._card.onInputValueChanged = function (input) {
						// If the user modifies an input, cancel any pending automatic refresh
						_this.cancelAutomaticRefresh();
					};
					this._card.render();
					if (this._card.renderedElement) {
						this.displayCard(this._card);
						if (this.onCardChanged) {
							this.onCardChanged(this);
						}
						if (this._card.refresh) {
							if (shared_1.GlobalSettings.applets.refresh.mode === Enums.RefreshMode.Automatic && consecutiveRefreshes < shared_1.GlobalSettings.applets.refresh.maximumConsecutiveAutomaticRefreshes) {
								if (shared_1.GlobalSettings.applets.refresh.timeBetweenAutomaticRefreshes <= 0) {
									logEvent(Enums.LogLevel.Info, "Triggering automatic card refresh number " + (consecutiveRefreshes + 1));
									this.internalExecuteAction(this._card.refresh.action, activity_request_1.ActivityRequestTrigger.Automatic, consecutiveRefreshes + 1);
								}
								else {
									logEvent(Enums.LogLevel.Info, "Scheduling automatic card refresh number " + (consecutiveRefreshes + 1) + " in " + shared_1.GlobalSettings.applets.refresh.timeBetweenAutomaticRefreshes + "ms");
									var action_1 = this._card.refresh.action;
									this._allowAutomaticCardUpdate = true;
									window.setTimeout(function () {
										if (_this._allowAutomaticCardUpdate) {
											_this.internalExecuteAction(action_1, activity_request_1.ActivityRequestTrigger.Automatic, consecutiveRefreshes + 1);
										}
									}, shared_1.GlobalSettings.applets.refresh.timeBetweenAutomaticRefreshes);
								}
							}
							else if (shared_1.GlobalSettings.applets.refresh.mode !== Enums.RefreshMode.Disabled) {
								if (consecutiveRefreshes > 0) {
									logEvent(Enums.LogLevel.Warning, "Stopping automatic refreshes after " + consecutiveRefreshes + " consecutive refreshes.");
								}
								else {
									logEvent(Enums.LogLevel.Warning, "The card has a refresh section, but automatic refreshes are disabled.");
								}
								if (shared_1.GlobalSettings.applets.refresh.allowManualRefreshesAfterAutomaticRefreshes || shared_1.GlobalSettings.applets.refresh.mode === Enums.RefreshMode.Manual) {
									logEvent(Enums.LogLevel.Info, "Showing manual refresh button.");
									this.showManualRefreshButton(this._card.refresh.action);
								}
							}
						}
					}
				}
			}
			catch (error) {
				// Ignore all errors
				logEvent(Enums.LogLevel.Error, "setCard: " + error);
			}
		}
	};
	AdaptiveApplet.prototype.internalExecuteAction = function (action, trigger, consecutiveRefreshes) {
		if (action instanceof card_elements_1.ExecuteAction) {
			if (this.channelAdapter) {
				var request = this.createActivityRequest(action, trigger, consecutiveRefreshes);
				if (request) {
					request.retryAsync();
				}
			}
			else {
				throw new Error("internalExecuteAction: No channel adapter set.");
			}
		}
		if (this.onAction) {
			this.onAction(this, action);
		}
	};
	AdaptiveApplet.prototype.createProgressOverlay = function (request) {
		if (!this._progressOverlay) {
			if (this.onCreateProgressOverlay) {
				this._progressOverlay = this.onCreateProgressOverlay(this, request);
			}
			else {
				this._progressOverlay = document.createElement("div");
				this._progressOverlay.className = "aaf-progress-overlay";
				var spinner = document.createElement("div");
				spinner.className = "aaf-spinner";
				spinner.style.width = "28px";
				spinner.style.height = "28px";
				this._progressOverlay.appendChild(spinner);
			}
		}
		return this._progressOverlay;
	};
	AdaptiveApplet.prototype.removeProgressOverlay = function (request) {
		if (this.onRemoveProgressOverlay) {
			this.onRemoveProgressOverlay(this, request);
		}
		if (this._progressOverlay !== undefined) {
			this.renderedElement.removeChild(this._progressOverlay);
			this._progressOverlay = undefined;
		}
	};
	AdaptiveApplet.prototype.activityRequestSucceeded = function (response, parsedContent) {
		if (this.onActivityRequestSucceeded) {
			this.onActivityRequestSucceeded(this, response, parsedContent);
		}
	};
	AdaptiveApplet.prototype.activityRequestFailed = function (response) {
		return this.onActivityRequestFailed ? this.onActivityRequestFailed(this, response) : shared_1.GlobalSettings.applets.defaultTimeBetweenRetryAttempts;
	};
	AdaptiveApplet.prototype.showAuthCodeInputDialog = function (request) {
		var _this = this;
		var showBuiltInAuthCodeInputCard = this.onShowAuthCodeInputDialog ? this.onShowAuthCodeInputDialog(this, request) : true;
		if (showBuiltInAuthCodeInputCard) {
			var authCodeInputCard = this.createMagicCodeInputCard(request.attemptNumber);
			authCodeInputCard.render();
			authCodeInputCard.onExecuteAction = function (submitMagicCodeAction) {
				if (_this.card && submitMagicCodeAction instanceof card_elements_1.SubmitAction) {
					switch (submitMagicCodeAction.id) {
						case AdaptiveApplet.submitMagicCodeActionId:
							var authCode = undefined;
							if (submitMagicCodeAction.data && typeof submitMagicCodeAction.data["magicCode"] === "string") {
								authCode = submitMagicCodeAction.data["magicCode"];
							}
							if (authCode) {
								_this.displayCard(_this.card);
								request.authCode = authCode;
								request.retryAsync();
							}
							else {
								alert("Please enter the magic code you received.");
							}
							break;
						case AdaptiveApplet.cancelMagicCodeAuthActionId:
							logEvent(Enums.LogLevel.Warning, "Authentication cancelled by user.");
							_this.displayCard(_this.card);
							break;
						default:
							logEvent(Enums.LogLevel.Error, "Unespected action taken from magic code input card (id = " + submitMagicCodeAction.id + ")");
							alert(strings_1.Strings.magicCodeInputCard.somethingWentWrong());
							break;
					}
				}
			};
			this.displayCard(authCodeInputCard);
		}
	};
	AdaptiveApplet.prototype.internalSendActivityRequestAsync = function (request) {
		return __awaiter(this, void 0, void 0, function () {
			var overlay, done, _loop_1, this_1, state_1;
			return __generator(this, function (_a) {
				switch (_a.label) {
					case 0:
						if (!this.channelAdapter) {
							throw new Error("internalSendActivityRequestAsync: channelAdapter is not set.");
						}
						overlay = this.createProgressOverlay(request);
						if (overlay !== undefined) {
							this.renderedElement.appendChild(overlay);
						}
						done = false;
						_loop_1 = function () {
							var response, error_1, parsedContent, retryIn_1, attemptOAuth, left, top_1;
							return __generator(this, function (_a) {
								switch (_a.label) {
									case 0:
										response = undefined;
										if (request.attemptNumber === 1) {
											logEvent(Enums.LogLevel.Info, "Sending activity request to channel (attempt " + request.attemptNumber + ")");
										}
										else {
											logEvent(Enums.LogLevel.Info, "Re-sending activity request to channel (attempt " + request.attemptNumber + ")");
										}
										_a.label = 1;
									case 1:
										_a.trys.push([1, 3, , 4]);
										return [4 /*yield*/, this_1.channelAdapter.sendRequestAsync(request)];
									case 2:
										response = _a.sent();
										return [3 /*break*/, 4];
									case 3:
										error_1 = _a.sent();
										logEvent(Enums.LogLevel.Error, "Activity request failed: " + error_1);
										this_1.removeProgressOverlay(request);
										done = true;
										return [3 /*break*/, 4];
									case 4:
										if (!response) return [3 /*break*/, 10];
										if (!(response instanceof activity_request_1.SuccessResponse)) return [3 /*break*/, 5];
										this_1.removeProgressOverlay(request);
										if (response.rawContent === undefined) {
											throw new Error("internalSendActivityRequestAsync: Action.Execute result is undefined");
										}
										parsedContent = response.rawContent;
										try {
											parsedContent = JSON.parse(response.rawContent);
										}
										catch (_b) {
											// Leave parseContent as is
										}
										if (typeof parsedContent === "string") {
											logEvent(Enums.LogLevel.Info, "The activity request returned a string after " + request.attemptNumber + " attempt(s).");
											this_1.activityRequestSucceeded(response, parsedContent);
										}
										else if (typeof parsedContent === "object" && parsedContent["type"] === "AdaptiveCard") {
											logEvent(Enums.LogLevel.Info, "The activity request returned an Adaptive Card after " + request.attemptNumber + " attempt(s).");
											this_1.internalSetCard(parsedContent, request.consecutiveRefreshes);
											this_1.activityRequestSucceeded(response, this_1.card);
										}
										else {
											throw new Error("internalSendActivityRequestAsync: Action.Execute result is of unsupported type (" + typeof response.rawContent + ")");
										}
										done = true;
										return [3 /*break*/, 10];
									case 5:
										if (!(response instanceof activity_request_1.ErrorResponse)) return [3 /*break*/, 9];
										retryIn_1 = this_1.activityRequestFailed(response);
										if (!(retryIn_1 >= 0 && request.attemptNumber < shared_1.GlobalSettings.applets.maximumRetryAttempts)) return [3 /*break*/, 7];
										logEvent(Enums.LogLevel.Warning, "Activity request failed: " + response.error.message + ". Retrying in " + retryIn_1 + "ms");
										request.attemptNumber++;
										return [4 /*yield*/, new Promise(function (resolve, reject) {
												window.setTimeout(function () { resolve(); }, retryIn_1);
											})];
									case 6:
										_a.sent();
										return [3 /*break*/, 8];
									case 7:
										logEvent(Enums.LogLevel.Error, "Activity request failed: " + response.error.message + ". Giving up after " + request.attemptNumber + " attempt(s)");
										this_1.removeProgressOverlay(request);
										done = true;
										_a.label = 8;
									case 8: return [3 /*break*/, 10];
									case 9:
										if (response instanceof activity_request_1.LoginRequestResponse) {
											logEvent(Enums.LogLevel.Info, "The activity request returned a LoginRequestResponse after " + request.attemptNumber + " attempt(s).");
											if (request.attemptNumber <= shared_1.GlobalSettings.applets.maximumRetryAttempts) {
												attemptOAuth = true;
												if (response.tokenExchangeResource && this_1.onSSOTokenNeeded) {
													// Attempt to use SSO. The host will return true if it can handle SSO, in which case
													// we bypass OAuth
													attemptOAuth = !this_1.onSSOTokenNeeded(this_1, request, response.tokenExchangeResource);
												}
												if (attemptOAuth) {
													// Attempt to use OAuth
													this_1.removeProgressOverlay(request);
													if (response.signinButton === undefined) {
														throw new Error("internalSendActivityRequestAsync: the login request doesn't contain a valid signin URL.");
													}
													logEvent(Enums.LogLevel.Info, "Login required at " + response.signinButton.value);
													if (this_1.onShowSigninPrompt) {
														// Bypass the built-in auth prompt if the host app handles it
														this_1.onShowSigninPrompt(this_1, request, response.signinButton);
													}
													else {
														this_1.showAuthCodeInputDialog(request);
														left = window.screenX + (window.outerWidth - shared_1.GlobalSettings.applets.authPromptWidth) / 2;
														top_1 = window.screenY + (window.outerHeight - shared_1.GlobalSettings.applets.authPromptHeight) / 2;
														window.open(response.signinButton.value, response.signinButton.title ? response.signinButton.title : "Sign in", "width=" + shared_1.GlobalSettings.applets.authPromptWidth + ",height=" + shared_1.GlobalSettings.applets.authPromptHeight + ",left=" + left + ",top=" + top_1);
													}
												}
											}
											else {
												logEvent(Enums.LogLevel.Error, "Authentication failed. Giving up after " + request.attemptNumber + " attempt(s)");
												alert(strings_1.Strings.magicCodeInputCard.authenticationFailed());
											}
											return [2 /*return*/, "break"];
										}
										else {
											throw new Error("Unhandled response type: " + response.toString());
										}
										_a.label = 10;
									case 10: return [2 /*return*/];
								}
							});
						};
						this_1 = this;
						_a.label = 1;
					case 1:
						if (!!done) return [3 /*break*/, 3];
						return [5 /*yield**/, _loop_1()];
					case 2:
						state_1 = _a.sent();
						if (state_1 === "break")
							return [3 /*break*/, 3];
						return [3 /*break*/, 1];
					case 3: return [2 /*return*/];
				}
			});
		});
	};
	AdaptiveApplet.prototype.refreshCard = function () {
		if (this._card && this._card.refresh) {
			this.internalExecuteAction(this._card.refresh.action, activity_request_1.ActivityRequestTrigger.Manual, 0);
		}
	};
	AdaptiveApplet.prototype.setCard = function (payload) {
		this.internalSetCard(payload, 0);
	};
	Object.defineProperty(AdaptiveApplet.prototype, "card", {
		get: function () {
			return this._card;
		},
		enumerable: false,
		configurable: true
	});
	AdaptiveApplet.submitMagicCodeActionId = "submitMagicCode";
	AdaptiveApplet.cancelMagicCodeAuthActionId = "cancelMagicCodeAuth";
	return AdaptiveApplet;
}());
exports.AdaptiveApplet = AdaptiveApplet;


/***/ }),

/***/ "./src/adaptivecards.ts":
/*!******************************!*\
  !*** ./src/adaptivecards.ts ***!
  \******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
	if (k2 === undefined) k2 = k;
	Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
	if (k2 === undefined) k2 = k;
	o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
	for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
__exportStar(__webpack_require__(/*! ./serialization */ "./src/serialization.ts"), exports);
__exportStar(__webpack_require__(/*! ./registry */ "./src/registry.ts"), exports);
__exportStar(__webpack_require__(/*! ./card-object */ "./src/card-object.ts"), exports);
__exportStar(__webpack_require__(/*! ./card-elements */ "./src/card-elements.ts"), exports);
__exportStar(__webpack_require__(/*! ./enums */ "./src/enums.ts"), exports);
__exportStar(__webpack_require__(/*! ./host-config */ "./src/host-config.ts"), exports);
__exportStar(__webpack_require__(/*! ./shared */ "./src/shared.ts"), exports);
__exportStar(__webpack_require__(/*! ./utils */ "./src/utils.ts"), exports);
__exportStar(__webpack_require__(/*! ./strings */ "./src/strings.ts"), exports);
__exportStar(__webpack_require__(/*! ./channel-adapter */ "./src/channel-adapter.ts"), exports);
__exportStar(__webpack_require__(/*! ./activity-request */ "./src/activity-request.ts"), exports);
__exportStar(__webpack_require__(/*! ./adaptive-applet */ "./src/adaptive-applet.ts"), exports);


/***/ }),

/***/ "./src/card-elements.ts":
/*!******************************!*\
  !*** ./src/card-elements.ts ***!
  \******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
	var extendStatics = function (d, b) {
		extendStatics = Object.setPrototypeOf ||
			({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
			function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
		return extendStatics(d, b);
	};
	return function (d, b) {
		extendStatics(d, b);
		function __() { this.constructor = d; }
		d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
	var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
	if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
	else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
	return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SerializationContext = exports.GlobalRegistry = exports.AdaptiveCard = exports.Authentication = exports.TokenExchangeResource = exports.AuthCardButton = exports.RefreshDefinition = exports.RefreshActionProperty = exports.ContainerWithActions = exports.ColumnSet = exports.Column = exports.Container = exports.BackgroundImage = exports.StylableCardElementContainer = exports.ActionSet = exports.ShowCardAction = exports.HttpAction = exports.HttpHeader = exports.ToggleVisibilityAction = exports.OpenUrlAction = exports.ExecuteAction = exports.SubmitAction = exports.SubmitActionBase = exports.Action = exports.TimeInput = exports.TimeProperty = exports.DateInput = exports.NumberInput = exports.ChoiceSetInput = exports.Choice = exports.ToggleInput = exports.TextInput = exports.Input = exports.Media = exports.MediaSource = exports.ImageSet = exports.CardElementContainer = exports.Image = exports.FactSet = exports.Fact = exports.RichTextBlock = exports.TextRun = exports.TextBlock = exports.BaseTextBlock = exports.ActionProperty = exports.CardElement = void 0;
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
var Enums = __webpack_require__(/*! ./enums */ "./src/enums.ts");
var shared_1 = __webpack_require__(/*! ./shared */ "./src/shared.ts");
var Utils = __webpack_require__(/*! ./utils */ "./src/utils.ts");
var host_config_1 = __webpack_require__(/*! ./host-config */ "./src/host-config.ts");
var TextFormatters = __webpack_require__(/*! ./text-formatters */ "./src/text-formatters.ts");
var card_object_1 = __webpack_require__(/*! ./card-object */ "./src/card-object.ts");
var serialization_1 = __webpack_require__(/*! ./serialization */ "./src/serialization.ts");
var registry_1 = __webpack_require__(/*! ./registry */ "./src/registry.ts");
var strings_1 = __webpack_require__(/*! ./strings */ "./src/strings.ts");
var CardElement = /** @class */ (function (_super) {
	__extends(CardElement, _super);
	function CardElement() {
		//#region Schema
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this._truncatedDueToOverflow = false;
		return _this;
	}
	Object.defineProperty(CardElement.prototype, "lang", {
		get: function () {
			var lang = this.getValue(CardElement.langProperty);
			if (lang) {
				return lang;
			}
			else {
				if (this.parent) {
					return this.parent.lang;
				}
				else {
					return undefined;
				}
			}
		},
		set: function (value) {
			this.setValue(CardElement.langProperty, value);
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(CardElement.prototype, "isVisible", {
		get: function () {
			return this.getValue(CardElement.isVisibleProperty);
		},
		set: function (value) {
			// If the element is going to be hidden, reset any changes that were due
			// to overflow truncation (this ensures that if the element is later
			// un-hidden it has the right content)
			if (shared_1.GlobalSettings.useAdvancedCardBottomTruncation && !value) {
				this.undoOverflowTruncation();
			}
			if (this.isVisible !== value) {
				this.setValue(CardElement.isVisibleProperty, value);
				this.updateRenderedElementVisibility();
				if (this._renderedElement) {
					raiseElementVisibilityChangedEvent(this);
				}
			}
			if (this._renderedElement) {
				this._renderedElement.setAttribute("aria-expanded", value.toString());
			}
		},
		enumerable: false,
		configurable: true
	});
	CardElement.prototype.internalRenderSeparator = function () {
		var renderedSeparator = Utils.renderSeparation(this.hostConfig, {
			spacing: this.hostConfig.getEffectiveSpacing(this.spacing),
			lineThickness: this.separator ? this.hostConfig.separator.lineThickness : undefined,
			lineColor: this.separator ? this.hostConfig.separator.lineColor : undefined
		}, this.separatorOrientation);
		if (shared_1.GlobalSettings.alwaysBleedSeparators && renderedSeparator && this.separatorOrientation == Enums.Orientation.Horizontal) {
			// Adjust separator's margins if the option to always bleed separators is turned on
			var parentContainer = this.getParentContainer();
			if (parentContainer && parentContainer.getEffectivePadding()) {
				var parentPhysicalPadding = this.hostConfig.paddingDefinitionToSpacingDefinition(parentContainer.getEffectivePadding());
				renderedSeparator.style.marginLeft = "-" + parentPhysicalPadding.left + "px";
				renderedSeparator.style.marginRight = "-" + parentPhysicalPadding.right + "px";
			}
		}
		return renderedSeparator;
	};
	CardElement.prototype.updateRenderedElementVisibility = function () {
		var displayMode = this.isDesignMode() || this.isVisible ? this._defaultRenderedElementDisplayMode : "none";
		if (this._renderedElement) {
			if (displayMode) {
				this._renderedElement.style.display = displayMode;
			}
			else {
				this._renderedElement.style.removeProperty("display");
			}
		}
		if (this._separatorElement) {
			if (this.parent && this.parent.isFirstElement(this)) {
				this._separatorElement.style.display = "none";
			}
			else {
				if (displayMode) {
					this._separatorElement.style.display = displayMode;
				}
				else {
					this._separatorElement.style.removeProperty("display");
				}
			}
		}
	};
	CardElement.prototype.hideElementDueToOverflow = function () {
		if (this._renderedElement && this.isVisible) {
			this._renderedElement.style.visibility = "hidden";
			this.isVisible = false;
			raiseElementVisibilityChangedEvent(this, false);
		}
	};
	CardElement.prototype.showElementHiddenDueToOverflow = function () {
		if (this._renderedElement && !this.isVisible) {
			this._renderedElement.style.removeProperty("visibility");
			this.isVisible = true;
			raiseElementVisibilityChangedEvent(this, false);
		}
	};
	// Marked private to emulate internal access
	CardElement.prototype.handleOverflow = function (maxHeight) {
		if (this.isVisible || this.isHiddenDueToOverflow()) {
			var handled = this.truncateOverflow(maxHeight);
			// Even if we were unable to truncate the element to fit this time,
			// it still could have been previously truncated
			this._truncatedDueToOverflow = handled || this._truncatedDueToOverflow;
			if (!handled) {
				this.hideElementDueToOverflow();
			}
			else if (handled && !this.isVisible) {
				this.showElementHiddenDueToOverflow();
			}
		}
	};
	// Marked private to emulate internal access
	CardElement.prototype.resetOverflow = function () {
		var sizeChanged = false;
		if (this._truncatedDueToOverflow) {
			this.undoOverflowTruncation();
			this._truncatedDueToOverflow = false;
			sizeChanged = true;
		}
		if (this.isHiddenDueToOverflow()) {
			this.showElementHiddenDueToOverflow();
		}
		return sizeChanged;
	};
	CardElement.prototype.getDefaultSerializationContext = function () {
		return new SerializationContext();
	};
	CardElement.prototype.createPlaceholderElement = function () {
		var styleDefinition = this.getEffectiveStyleDefinition();
		var foregroundCssColor = Utils.stringToCssColor(styleDefinition.foregroundColors.default.subtle);
		var element = document.createElement("div");
		element.style.border = "1px dashed " + foregroundCssColor;
		element.style.padding = "4px";
		element.style.minHeight = "32px";
		element.style.fontSize = "10px";
		element.style.color = foregroundCssColor;
		element.innerText = "Empty " + this.getJsonTypeName();
		return element;
	};
	CardElement.prototype.adjustRenderedElementSize = function (renderedElement) {
		if (this.height === "auto") {
			renderedElement.style.flex = "0 0 auto";
		}
		else {
			renderedElement.style.flex = "1 1 auto";
		}
	};
	CardElement.prototype.isDisplayed = function () {
		return this._renderedElement !== undefined && this.isVisible && this._renderedElement.offsetHeight > 0;
	};
	CardElement.prototype.overrideInternalRender = function () {
		return this.internalRender();
	};
	CardElement.prototype.applyPadding = function () {
		if (this.separatorElement && this.separatorOrientation === Enums.Orientation.Horizontal) {
			if (shared_1.GlobalSettings.alwaysBleedSeparators && !this.isBleeding()) {
				var padding = new shared_1.PaddingDefinition();
				this.getImmediateSurroundingPadding(padding);
				var physicalPadding = this.hostConfig.paddingDefinitionToSpacingDefinition(padding);
				this.separatorElement.style.marginLeft = "-" + physicalPadding.left + "px";
				this.separatorElement.style.marginRight = "-" + physicalPadding.right + "px";
			}
			else {
				this.separatorElement.style.marginRight = "0";
				this.separatorElement.style.marginLeft = "0";
			}
		}
	};
	/*
	 * Called when this element overflows the bottom of the card.
	 * maxHeight will be the amount of space still available on the card (0 if
	 * the element is fully off the card).
	 */
	CardElement.prototype.truncateOverflow = function (maxHeight) {
		// Child implementations should return true if the element handled
		// the truncation request such that its content fits within maxHeight,
		// false if the element should fall back to being hidden
		return false;
	};
	/*
	 * This should reverse any changes performed in truncateOverflow().
	 */
	CardElement.prototype.undoOverflowTruncation = function () { };
	CardElement.prototype.getDefaultPadding = function () {
		return new shared_1.PaddingDefinition();
	};
	CardElement.prototype.getHasBackground = function () {
		return false;
	};
	CardElement.prototype.getPadding = function () {
		return this._padding;
	};
	CardElement.prototype.setPadding = function (value) {
		this._padding = value;
	};
	CardElement.prototype.shouldSerialize = function (context) {
		return context.elementRegistry.findByName(this.getJsonTypeName()) !== undefined;
	};
	Object.defineProperty(CardElement.prototype, "useDefaultSizing", {
		get: function () {
			return true;
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(CardElement.prototype, "allowCustomPadding", {
		get: function () {
			return true;
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(CardElement.prototype, "separatorOrientation", {
		get: function () {
			return Enums.Orientation.Horizontal;
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(CardElement.prototype, "defaultStyle", {
		get: function () {
			return Enums.ContainerStyle.Default;
		},
		enumerable: false,
		configurable: true
	});
	CardElement.prototype.parse = function (source, context) {
		_super.prototype.parse.call(this, source, context ? context : new SerializationContext());
	};
	CardElement.prototype.asString = function () {
		return "";
	};
	CardElement.prototype.isBleeding = function () {
		return false;
	};
	CardElement.prototype.getEffectiveStyle = function () {
		if (this.parent) {
			return this.parent.getEffectiveStyle();
		}
		return this.defaultStyle;
	};
	CardElement.prototype.getEffectiveStyleDefinition = function () {
		return this.hostConfig.containerStyles.getStyleByName(this.getEffectiveStyle());
	};
	CardElement.prototype.getForbiddenActionTypes = function () {
		return [];
	};
	CardElement.prototype.getImmediateSurroundingPadding = function (result, processTop, processRight, processBottom, processLeft) {
		if (processTop === void 0) { processTop = true; }
		if (processRight === void 0) { processRight = true; }
		if (processBottom === void 0) { processBottom = true; }
		if (processLeft === void 0) { processLeft = true; }
		if (this.parent) {
			var doProcessTop = processTop && this.parent.isTopElement(this);
			var doProcessRight = processRight && this.parent.isRightMostElement(this);
			var doProcessBottom = processBottom && this.parent.isBottomElement(this);
			var doProcessLeft = processLeft && this.parent.isLeftMostElement(this);
			var effectivePadding = this.parent.getEffectivePadding();
			if (effectivePadding) {
				if (doProcessTop && effectivePadding.top != Enums.Spacing.None) {
					result.top = effectivePadding.top;
					doProcessTop = false;
				}
				if (doProcessRight && effectivePadding.right != Enums.Spacing.None) {
					result.right = effectivePadding.right;
					doProcessRight = false;
				}
				if (doProcessBottom && effectivePadding.bottom != Enums.Spacing.None) {
					result.bottom = effectivePadding.bottom;
					doProcessBottom = false;
				}
				if (doProcessLeft && effectivePadding.left != Enums.Spacing.None) {
					result.left = effectivePadding.left;
					doProcessLeft = false;
				}
			}
			if (doProcessTop || doProcessRight || doProcessBottom || doProcessLeft) {
				this.parent.getImmediateSurroundingPadding(result, doProcessTop, doProcessRight, doProcessBottom, doProcessLeft);
			}
		}
	};
	CardElement.prototype.getActionCount = function () {
		return 0;
	};
	CardElement.prototype.getActionAt = function (index) {
		throw new Error(strings_1.Strings.errors.indexOutOfRange(index));
	};
	CardElement.prototype.remove = function () {
		if (this.parent && this.parent instanceof CardElementContainer) {
			return this.parent.removeItem(this);
		}
		return false;
	};
	CardElement.prototype.render = function () {
		this._renderedElement = this.overrideInternalRender();
		this._separatorElement = this.internalRenderSeparator();
		if (this._renderedElement) {
			if (this.id) {
				this._renderedElement.id = this.id;
			}
			if (this.customCssSelector) {
				this._renderedElement.classList.add(this.customCssSelector);
			}
			this._renderedElement.style.boxSizing = "border-box";
			this._defaultRenderedElementDisplayMode = this._renderedElement.style.display ? this._renderedElement.style.display : undefined;
			this.adjustRenderedElementSize(this._renderedElement);
			this.updateLayout(false);
		}
		else if (this.isDesignMode()) {
			this._renderedElement = this.createPlaceholderElement();
		}
		return this._renderedElement;
	};
	CardElement.prototype.updateLayout = function (processChildren) {
		if (processChildren === void 0) { processChildren = true; }
		this.updateRenderedElementVisibility();
		this.applyPadding();
	};
	CardElement.prototype.indexOf = function (cardElement) {
		return -1;
	};
	CardElement.prototype.isDesignMode = function () {
		var rootElement = this.getRootElement();
		return rootElement instanceof AdaptiveCard && rootElement.designMode;
	};
	CardElement.prototype.isFirstElement = function (element) {
		return true;
	};
	CardElement.prototype.isLastElement = function (element) {
		return true;
	};
	CardElement.prototype.isAtTheVeryLeft = function () {
		return this.parent ? this.parent.isLeftMostElement(this) && this.parent.isAtTheVeryLeft() : true;
	};
	CardElement.prototype.isAtTheVeryRight = function () {
		return this.parent ? this.parent.isRightMostElement(this) && this.parent.isAtTheVeryRight() : true;
	};
	CardElement.prototype.isAtTheVeryTop = function () {
		return this.parent ? this.parent.isFirstElement(this) && this.parent.isAtTheVeryTop() : true;
	};
	CardElement.prototype.isAtTheVeryBottom = function () {
		return this.parent ? this.parent.isLastElement(this) && this.parent.isAtTheVeryBottom() : true;
	};
	CardElement.prototype.isBleedingAtTop = function () {
		return false;
	};
	CardElement.prototype.isBleedingAtBottom = function () {
		return false;
	};
	CardElement.prototype.isLeftMostElement = function (element) {
		return true;
	};
	CardElement.prototype.isRightMostElement = function (element) {
		return true;
	};
	CardElement.prototype.isTopElement = function (element) {
		return this.isFirstElement(element);
	};
	CardElement.prototype.isBottomElement = function (element) {
		return this.isLastElement(element);
	};
	CardElement.prototype.isHiddenDueToOverflow = function () {
		return this._renderedElement !== undefined && this._renderedElement.style.visibility == 'hidden';
	};
	CardElement.prototype.getRootElement = function () {
		return this.getRootObject();
	};
	CardElement.prototype.getParentContainer = function () {
		var currentElement = this.parent;
		while (currentElement) {
			if (currentElement instanceof Container) {
				return currentElement;
			}
			currentElement = currentElement.parent;
		}
		return undefined;
	};
	CardElement.prototype.getAllInputs = function (processActions) {
		if (processActions === void 0) { processActions = true; }
		return [];
	};
	CardElement.prototype.getResourceInformation = function () {
		return [];
	};
	CardElement.prototype.getElementById = function (id) {
		return this.id === id ? this : undefined;
	};
	CardElement.prototype.getActionById = function (id) {
		return undefined;
	};
	CardElement.prototype.getEffectivePadding = function () {
		var padding = this.getPadding();
		return (padding && this.allowCustomPadding) ? padding : this.getDefaultPadding();
	};
	Object.defineProperty(CardElement.prototype, "hostConfig", {
		get: function () {
			if (this._hostConfig) {
				return this._hostConfig;
			}
			else {
				if (this.parent) {
					return this.parent.hostConfig;
				}
				else {
					return host_config_1.defaultHostConfig;
				}
			}
		},
		set: function (value) {
			this._hostConfig = value;
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(CardElement.prototype, "index", {
		get: function () {
			if (this.parent) {
				return this.parent.indexOf(this);
			}
			else {
				return 0;
			}
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(CardElement.prototype, "isInteractive", {
		get: function () {
			return false;
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(CardElement.prototype, "isStandalone", {
		get: function () {
			return true;
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(CardElement.prototype, "isInline", {
		get: function () {
			return false;
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(CardElement.prototype, "hasVisibleSeparator", {
		get: function () {
			if (this.parent && this.separatorElement) {
				return !this.parent.isFirstElement(this) && (this.isVisible || this.isDesignMode());
			}
			else {
				return false;
			}
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(CardElement.prototype, "separatorElement", {
		get: function () {
			return this._separatorElement;
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(CardElement.prototype, "parent", {
		get: function () {
			return this._parent;
		},
		enumerable: false,
		configurable: true
	});
	CardElement.langProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_1, "lang", true, /^[a-z]{2,3}$/ig);
	CardElement.isVisibleProperty = new serialization_1.BoolProperty(serialization_1.Versions.v1_2, "isVisible", true);
	CardElement.separatorProperty = new serialization_1.BoolProperty(serialization_1.Versions.v1_0, "separator", false);
	CardElement.heightProperty = new serialization_1.ValueSetProperty(serialization_1.Versions.v1_1, "height", [
		{ value: "auto" },
		{ value: "stretch" }
	], "auto");
	CardElement.horizontalAlignmentProperty = new serialization_1.EnumProperty(serialization_1.Versions.v1_0, "horizontalAlignment", Enums.HorizontalAlignment, Enums.HorizontalAlignment.Left);
	CardElement.spacingProperty = new serialization_1.EnumProperty(serialization_1.Versions.v1_0, "spacing", Enums.Spacing, Enums.Spacing.Default);
	__decorate([
		serialization_1.property(CardElement.horizontalAlignmentProperty)
	], CardElement.prototype, "horizontalAlignment", void 0);
	__decorate([
		serialization_1.property(CardElement.spacingProperty)
	], CardElement.prototype, "spacing", void 0);
	__decorate([
		serialization_1.property(CardElement.separatorProperty)
	], CardElement.prototype, "separator", void 0);
	__decorate([
		serialization_1.property(CardElement.heightProperty)
	], CardElement.prototype, "height", void 0);
	__decorate([
		serialization_1.property(CardElement.langProperty)
	], CardElement.prototype, "lang", null);
	__decorate([
		serialization_1.property(CardElement.isVisibleProperty)
	], CardElement.prototype, "isVisible", null);
	return CardElement;
}(card_object_1.CardObject));
exports.CardElement = CardElement;
var ActionProperty = /** @class */ (function (_super) {
	__extends(ActionProperty, _super);
	function ActionProperty(targetVersion, name, forbiddenActionTypes) {
		if (forbiddenActionTypes === void 0) { forbiddenActionTypes = []; }
		var _this = _super.call(this, targetVersion, name, undefined) || this;
		_this.targetVersion = targetVersion;
		_this.name = name;
		_this.forbiddenActionTypes = forbiddenActionTypes;
		return _this;
	}
	ActionProperty.prototype.parse = function (sender, source, context) {
		var parent = sender;
		return context.parseAction(parent, source[this.name], this.forbiddenActionTypes, parent.isDesignMode());
	};
	ActionProperty.prototype.toJSON = function (sender, target, value, context) {
		context.serializeValue(target, this.name, value ? value.toJSON(context) : undefined, undefined, true);
	};
	return ActionProperty;
}(serialization_1.PropertyDefinition));
exports.ActionProperty = ActionProperty;
var BaseTextBlock = /** @class */ (function (_super) {
	__extends(BaseTextBlock, _super);
	function BaseTextBlock(text) {
		var _this = _super.call(this) || this;
		_this.size = Enums.TextSize.Default;
		_this.weight = Enums.TextWeight.Default;
		_this.color = Enums.TextColor.Default;
		_this.isSubtle = false;
		_this.ariaHidden = false;
		if (text) {
			_this.text = text;
		}
		return _this;
	}
	BaseTextBlock.prototype.populateSchema = function (schema) {
		_super.prototype.populateSchema.call(this, schema);
		// selectAction is declared on BaseTextBlock but is only exposed on TextRun,
		// so the property is removed from the BaseTextBlock schema.
		schema.remove(BaseTextBlock.selectActionProperty);
	};
	Object.defineProperty(BaseTextBlock.prototype, "text", {
		get: function () {
			return this.getValue(BaseTextBlock.textProperty);
		},
		set: function (value) {
			this.setText(value);
		},
		enumerable: false,
		configurable: true
	});
	//#endregion
	BaseTextBlock.prototype.getFontSize = function (fontType) {
		switch (this.size) {
			case Enums.TextSize.Small:
				return fontType.fontSizes.small;
			case Enums.TextSize.Medium:
				return fontType.fontSizes.medium;
			case Enums.TextSize.Large:
				return fontType.fontSizes.large;
			case Enums.TextSize.ExtraLarge:
				return fontType.fontSizes.extraLarge;
			default:
				return fontType.fontSizes.default;
		}
	};
	BaseTextBlock.prototype.getColorDefinition = function (colorSet, color) {
		switch (color) {
			case Enums.TextColor.Accent:
				return colorSet.accent;
			case Enums.TextColor.Dark:
				return colorSet.dark;
			case Enums.TextColor.Light:
				return colorSet.light;
			case Enums.TextColor.Good:
				return colorSet.good;
			case Enums.TextColor.Warning:
				return colorSet.warning;
			case Enums.TextColor.Attention:
				return colorSet.attention;
			default:
				return colorSet.default;
		}
	};
	BaseTextBlock.prototype.setText = function (value) {
		this.setValue(BaseTextBlock.textProperty, value);
	};
	BaseTextBlock.prototype.init = function (textDefinition) {
		this.size = textDefinition.size;
		this.weight = textDefinition.weight;
		this.color = textDefinition.color;
		this.isSubtle = textDefinition.isSubtle;
	};
	BaseTextBlock.prototype.asString = function () {
		return this.text;
	};
	BaseTextBlock.prototype.applyStylesTo = function (targetElement) {
		var fontType = this.hostConfig.getFontTypeDefinition(this.fontType);
		if (fontType.fontFamily) {
			targetElement.style.fontFamily = fontType.fontFamily;
		}
		var fontSize;
		switch (this.size) {
			case Enums.TextSize.Small:
				fontSize = fontType.fontSizes.small;
				break;
			case Enums.TextSize.Medium:
				fontSize = fontType.fontSizes.medium;
				break;
			case Enums.TextSize.Large:
				fontSize = fontType.fontSizes.large;
				break;
			case Enums.TextSize.ExtraLarge:
				fontSize = fontType.fontSizes.extraLarge;
				break;
			default:
				fontSize = fontType.fontSizes.default;
				break;
		}
		targetElement.style.fontSize = fontSize + "px";
		var colorDefinition = this.getColorDefinition(this.getEffectiveStyleDefinition().foregroundColors, this.effectiveColor);
		targetElement.style.color = Utils.stringToCssColor(this.isSubtle ? colorDefinition.subtle : colorDefinition.default);
		var fontWeight;
		switch (this.weight) {
			case Enums.TextWeight.Lighter:
				fontWeight = fontType.fontWeights.lighter;
				break;
			case Enums.TextWeight.Bolder:
				fontWeight = fontType.fontWeights.bolder;
				break;
			default:
				fontWeight = fontType.fontWeights.default;
				break;
		}
		targetElement.style.fontWeight = fontWeight.toString();
		if (this.ariaHidden) {
			targetElement.setAttribute("aria-hidden", "true");
		}
	};
	Object.defineProperty(BaseTextBlock.prototype, "effectiveColor", {
		get: function () {
			return this.color ? this.color : Enums.TextColor.Default;
		},
		enumerable: false,
		configurable: true
	});
	//#region Schema
	BaseTextBlock.textProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_0, "text", true);
	BaseTextBlock.sizeProperty = new serialization_1.EnumProperty(serialization_1.Versions.v1_0, "size", Enums.TextSize, Enums.TextSize.Default);
	BaseTextBlock.weightProperty = new serialization_1.EnumProperty(serialization_1.Versions.v1_0, "weight", Enums.TextWeight, Enums.TextWeight.Default);
	BaseTextBlock.colorProperty = new serialization_1.EnumProperty(serialization_1.Versions.v1_0, "color", Enums.TextColor, Enums.TextColor.Default);
	BaseTextBlock.isSubtleProperty = new serialization_1.BoolProperty(serialization_1.Versions.v1_0, "isSubtle", false);
	BaseTextBlock.fontTypeProperty = new serialization_1.EnumProperty(serialization_1.Versions.v1_2, "fontType", Enums.FontType);
	BaseTextBlock.selectActionProperty = new ActionProperty(serialization_1.Versions.v1_1, "selectAction", ["Action.ShowCard"]);
	__decorate([
		serialization_1.property(BaseTextBlock.sizeProperty)
	], BaseTextBlock.prototype, "size", void 0);
	__decorate([
		serialization_1.property(BaseTextBlock.weightProperty)
	], BaseTextBlock.prototype, "weight", void 0);
	__decorate([
		serialization_1.property(BaseTextBlock.colorProperty)
	], BaseTextBlock.prototype, "color", void 0);
	__decorate([
		serialization_1.property(BaseTextBlock.fontTypeProperty)
	], BaseTextBlock.prototype, "fontType", void 0);
	__decorate([
		serialization_1.property(BaseTextBlock.isSubtleProperty)
	], BaseTextBlock.prototype, "isSubtle", void 0);
	__decorate([
		serialization_1.property(BaseTextBlock.textProperty)
	], BaseTextBlock.prototype, "text", null);
	__decorate([
		serialization_1.property(BaseTextBlock.selectActionProperty)
	], BaseTextBlock.prototype, "selectAction", void 0);
	return BaseTextBlock;
}(CardElement));
exports.BaseTextBlock = BaseTextBlock;
var TextBlock = /** @class */ (function (_super) {
	__extends(TextBlock, _super);
	function TextBlock() {
		//#region Schema
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this.wrap = false;
		_this._treatAsPlainText = true;
		_this.useMarkdown = true;
		return _this;
	}
	TextBlock.prototype.restoreOriginalContent = function () {
		if (this.renderedElement !== undefined) {
			if (this.maxLines && this.maxLines > 0) {
				this.renderedElement.style.maxHeight = this._computedLineHeight * this.maxLines + "px";
			}
			this.renderedElement.innerHTML = this._originalInnerHtml;
		}
	};
	TextBlock.prototype.truncateIfSupported = function (maxHeight) {
		if (this.renderedElement !== undefined) {
			// For now, only truncate TextBlocks that contain just a single
			// paragraph -- since the maxLines calculation doesn't take into
			// account Markdown lists
			var children = this.renderedElement.children;
			var isTextOnly = !children.length;
			var truncationSupported = isTextOnly || children.length == 1 && children[0].tagName.toLowerCase() == 'p';
			if (truncationSupported) {
				var element = isTextOnly ? this.renderedElement : children[0];
				Utils.truncate(element, maxHeight, this._computedLineHeight);
				return true;
			}
		}
		return false;
	};
	TextBlock.prototype.setText = function (value) {
		_super.prototype.setText.call(this, value);
		this._processedText = undefined;
	};
	TextBlock.prototype.internalRender = function () {
		var _this = this;
		this._processedText = undefined;
		if (this.text) {
			var preProcessedText = this.preProcessPropertyValue(BaseTextBlock.textProperty);
			var hostConfig = this.hostConfig;
			var element = void 0;
			if (this.forElementId) {
				var labelElement = document.createElement("label");
				labelElement.htmlFor = this.forElementId;
				element = labelElement;
			}
			else {
				element = document.createElement("div");
			}
			element.classList.add(hostConfig.makeCssClassName("ac-textBlock"));
			element.style.overflow = "hidden";
			this.applyStylesTo(element);
			if (this.selectAction) {
				element.onclick = function (e) {
					e.preventDefault();
					e.cancelBubble = true;
					if (_this.selectAction) {
						_this.selectAction.execute();
					}
				};
				if (hostConfig.supportsInteractivity) {
					element.tabIndex = 0;
					element.setAttribute("role", this.selectAction.getAriaRole());
					if (this.selectAction.title) {
						element.setAttribute("aria-label", this.selectAction.title);
						element.title = this.selectAction.title;
					}
					element.classList.add(hostConfig.makeCssClassName("ac-selectable"));
				}
			}
			if (!this._processedText) {
				this._treatAsPlainText = true;
				var formattedText = TextFormatters.formatText(this.lang, preProcessedText);
				if (this.useMarkdown && formattedText) {
					if (shared_1.GlobalSettings.allowMarkForTextHighlighting) {
						formattedText = formattedText.replace(/<mark>/g, "===").replace(/<\/mark>/g, "/==/");
					}
					var markdownProcessingResult = AdaptiveCard.applyMarkdown(formattedText);
					if (markdownProcessingResult.didProcess && markdownProcessingResult.outputHtml) {
						this._processedText = markdownProcessingResult.outputHtml;
						this._treatAsPlainText = false;
						// Only process <mark> tag if markdown processing was applied because
						// markdown processing is also responsible for sanitizing the input string
						if (shared_1.GlobalSettings.allowMarkForTextHighlighting && this._processedText) {
							var markStyle = "";
							var effectiveStyle = this.getEffectiveStyleDefinition();
							if (effectiveStyle.highlightBackgroundColor) {
								markStyle += "background-color: " + effectiveStyle.highlightBackgroundColor + ";";
							}
							if (effectiveStyle.highlightForegroundColor) {
								markStyle += "color: " + effectiveStyle.highlightForegroundColor + ";";
							}
							if (markStyle) {
								markStyle = 'style="' + markStyle + '"';
							}
							this._processedText = this._processedText.replace(/===/g, "<mark " + markStyle + ">").replace(/\/==\//g, "</mark>");
						}
					}
					else {
						this._processedText = formattedText;
						this._treatAsPlainText = true;
					}
				}
				else {
					this._processedText = formattedText;
					this._treatAsPlainText = true;
				}
			}
			if (!this._processedText) {
				this._processedText = "";
			}
			if (this._treatAsPlainText) {
				element.innerText = this._processedText;
			}
			else {
				element.innerHTML = this._processedText;
			}
			if (element.firstElementChild instanceof HTMLElement) {
				var firstElementChild = element.firstElementChild;
				firstElementChild.style.marginTop = "0px";
				firstElementChild.style.width = "100%";
				if (!this.wrap) {
					firstElementChild.style.overflow = "hidden";
					firstElementChild.style.textOverflow = "ellipsis";
				}
			}
			if (element.lastElementChild instanceof HTMLElement) {
				element.lastElementChild.style.marginBottom = "0px";
			}
			var anchors = element.getElementsByTagName("a");
			for (var i = 0; i < anchors.length; i++) {
				var anchor = anchors[i];
				anchor.classList.add(hostConfig.makeCssClassName("ac-anchor"));
				anchor.target = "_blank";
				anchor.onclick = function (e) {
					if (raiseAnchorClickedEvent(_this, e.target, e)) {
						e.preventDefault();
						e.cancelBubble = true;
					}
				};
				anchor.oncontextmenu = function (e) {
					if (raiseAnchorClickedEvent(_this, e.target, e)) {
						e.preventDefault();
						e.cancelBubble = true;
						return false;
					}
					return true;
				};
			}
			if (this.wrap) {
				element.style.wordWrap = "break-word";
				if (this.maxLines && this.maxLines > 0) {
					element.style.overflow = "hidden";
					if (Utils.isInternetExplorer() || !shared_1.GlobalSettings.useWebkitLineClamp) {
						element.style.maxHeight = (this._computedLineHeight * this.maxLines) + "px";
					}
					else {
						// While non standard, --webkit-line-clamp works in every browser (except IE)
						// and is a great solution to support the maxLines feature with ellipsis
						// truncation. With --webkit-line-clamp there is need to use explicit line heights
						element.style.removeProperty("line-height");
						element.style.display = "-webkit-box";
						element.style.webkitBoxOrient = "vertical";
						element.style.webkitLineClamp = this.maxLines.toString();
					}
				}
			}
			else {
				element.style.whiteSpace = "nowrap";
				element.style.textOverflow = "ellipsis";
			}
			if (shared_1.GlobalSettings.useAdvancedTextBlockTruncation || shared_1.GlobalSettings.useAdvancedCardBottomTruncation) {
				this._originalInnerHtml = element.innerHTML;
			}
			return element;
		}
		else {
			return undefined;
		}
	};
	TextBlock.prototype.truncateOverflow = function (maxHeight) {
		if (maxHeight >= this._computedLineHeight) {
			return this.truncateIfSupported(maxHeight);
		}
		return false;
	};
	TextBlock.prototype.undoOverflowTruncation = function () {
		this.restoreOriginalContent();
		if (shared_1.GlobalSettings.useAdvancedTextBlockTruncation && this.maxLines) {
			var maxHeight = this._computedLineHeight * this.maxLines;
			this.truncateIfSupported(maxHeight);
		}
	};
	TextBlock.prototype.applyStylesTo = function (targetElement) {
		_super.prototype.applyStylesTo.call(this, targetElement);
		var parentContainer = this.getParentContainer();
		var isRtl = parentContainer ? parentContainer.isRtl() : false;
		switch (this.horizontalAlignment) {
			case Enums.HorizontalAlignment.Center:
				targetElement.style.textAlign = "center";
				break;
			case Enums.HorizontalAlignment.Right:
				targetElement.style.textAlign = isRtl ? "left" : "right";
				break;
			default:
				targetElement.style.textAlign = isRtl ? "right" : "left";
				break;
		}
		var lineHeights = this.hostConfig.lineHeights;
		if (lineHeights) {
			switch (this.size) {
				case Enums.TextSize.Small:
					this._computedLineHeight = lineHeights.small;
					break;
				case Enums.TextSize.Medium:
					this._computedLineHeight = lineHeights.medium;
					break;
				case Enums.TextSize.Large:
					this._computedLineHeight = lineHeights.large;
					break;
				case Enums.TextSize.ExtraLarge:
					this._computedLineHeight = lineHeights.extraLarge;
					break;
				default:
					this._computedLineHeight = lineHeights.default;
					break;
			}
		}
		else {
			// Looks like 1.33 is the magic number to compute line-height
			// from font size.
			this._computedLineHeight = this.getFontSize(this.hostConfig.getFontTypeDefinition(this.fontType)) * 1.33;
		}
		targetElement.style.lineHeight = this._computedLineHeight + "px";
	};
	TextBlock.prototype.getJsonTypeName = function () {
		return "TextBlock";
	};
	TextBlock.prototype.updateLayout = function (processChildren) {
		if (processChildren === void 0) { processChildren = false; }
		_super.prototype.updateLayout.call(this, processChildren);
		if (shared_1.GlobalSettings.useAdvancedTextBlockTruncation && this.maxLines && this.isDisplayed()) {
			// Reset the element's innerHTML in case the available room for
			// content has increased
			this.restoreOriginalContent();
			this.truncateIfSupported(this._computedLineHeight * this.maxLines);
		}
	};
	TextBlock.wrapProperty = new serialization_1.BoolProperty(serialization_1.Versions.v1_0, "wrap", false);
	TextBlock.maxLinesProperty = new serialization_1.NumProperty(serialization_1.Versions.v1_0, "maxLines");
	__decorate([
		serialization_1.property(TextBlock.wrapProperty)
	], TextBlock.prototype, "wrap", void 0);
	__decorate([
		serialization_1.property(TextBlock.maxLinesProperty)
	], TextBlock.prototype, "maxLines", void 0);
	return TextBlock;
}(BaseTextBlock));
exports.TextBlock = TextBlock;
var TextRun = /** @class */ (function (_super) {
	__extends(TextRun, _super);
	function TextRun() {
		//#region Schema
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this.italic = false;
		_this.strikethrough = false;
		_this.highlight = false;
		_this.underline = false;
		return _this;
	}
	TextRun.prototype.populateSchema = function (schema) {
		_super.prototype.populateSchema.call(this, schema);
		schema.add(BaseTextBlock.selectActionProperty);
	};
	//#endregion
	TextRun.prototype.internalRender = function () {
		var _this = this;
		if (this.text) {
			var preProcessedText = this.preProcessPropertyValue(BaseTextBlock.textProperty);
			var hostConfig = this.hostConfig;
			var formattedText = TextFormatters.formatText(this.lang, preProcessedText);
			if (!formattedText) {
				formattedText = "";
			}
			var element = document.createElement("span");
			element.classList.add(hostConfig.makeCssClassName("ac-textRun"));
			this.applyStylesTo(element);
			if (this.selectAction && hostConfig.supportsInteractivity) {
				var anchor = document.createElement("a");
				anchor.classList.add(hostConfig.makeCssClassName("ac-anchor"));
				var href = this.selectAction.getHref();
				anchor.href = href ? href : "";
				anchor.target = "_blank";
				anchor.onclick = function (e) {
					e.preventDefault();
					e.cancelBubble = true;
					if (_this.selectAction) {
						_this.selectAction.execute();
					}
				};
				if (this.selectAction.title) {
					anchor.setAttribute("aria-label", this.selectAction.title);
					anchor.title = this.selectAction.title;
				}
				anchor.innerText = formattedText;
				element.appendChild(anchor);
			}
			else {
				element.innerText = formattedText;
			}
			return element;
		}
		else {
			return undefined;
		}
	};
	TextRun.prototype.applyStylesTo = function (targetElement) {
		_super.prototype.applyStylesTo.call(this, targetElement);
		if (this.italic) {
			targetElement.style.fontStyle = "italic";
		}
		if (this.strikethrough) {
			targetElement.style.textDecoration = "line-through";
		}
		if (this.highlight) {
			var colorDefinition = this.getColorDefinition(this.getEffectiveStyleDefinition().foregroundColors, this.effectiveColor);
			targetElement.style.backgroundColor = Utils.stringToCssColor(this.isSubtle ? colorDefinition.highlightColors.subtle : colorDefinition.highlightColors.default);
		}
		if (this.underline) {
			targetElement.style.textDecoration = "underline";
		}
	};
	TextRun.prototype.getJsonTypeName = function () {
		return "TextRun";
	};
	Object.defineProperty(TextRun.prototype, "isStandalone", {
		get: function () {
			return false;
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(TextRun.prototype, "isInline", {
		get: function () {
			return true;
		},
		enumerable: false,
		configurable: true
	});
	TextRun.italicProperty = new serialization_1.BoolProperty(serialization_1.Versions.v1_2, "italic", false);
	TextRun.strikethroughProperty = new serialization_1.BoolProperty(serialization_1.Versions.v1_2, "strikethrough", false);
	TextRun.highlightProperty = new serialization_1.BoolProperty(serialization_1.Versions.v1_2, "highlight", false);
	TextRun.underlineProperty = new serialization_1.BoolProperty(serialization_1.Versions.v1_3, "underline", false);
	__decorate([
		serialization_1.property(TextRun.italicProperty)
	], TextRun.prototype, "italic", void 0);
	__decorate([
		serialization_1.property(TextRun.strikethroughProperty)
	], TextRun.prototype, "strikethrough", void 0);
	__decorate([
		serialization_1.property(TextRun.highlightProperty)
	], TextRun.prototype, "highlight", void 0);
	__decorate([
		serialization_1.property(TextRun.underlineProperty)
	], TextRun.prototype, "underline", void 0);
	return TextRun;
}(BaseTextBlock));
exports.TextRun = TextRun;
var RichTextBlock = /** @class */ (function (_super) {
	__extends(RichTextBlock, _super);
	function RichTextBlock() {
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this._inlines = [];
		return _this;
	}
	RichTextBlock.prototype.internalAddInline = function (inline, forceAdd) {
		if (forceAdd === void 0) { forceAdd = false; }
		if (!inline.isInline) {
			throw new Error(strings_1.Strings.errors.elementCannotBeUsedAsInline());
		}
		var doAdd = inline.parent === undefined || forceAdd;
		if (!doAdd && inline.parent != this) {
			throw new Error(strings_1.Strings.errors.inlineAlreadyParented());
		}
		else {
			inline.setParent(this);
			this._inlines.push(inline);
		}
	};
	RichTextBlock.prototype.internalParse = function (source, context) {
		_super.prototype.internalParse.call(this, source, context);
		this._inlines = [];
		if (Array.isArray(source["inlines"])) {
			for (var _i = 0, _a = source["inlines"]; _i < _a.length; _i++) {
				var jsonInline = _a[_i];
				var inline = void 0;
				if (typeof jsonInline === "string") {
					var textRun = new TextRun();
					textRun.text = jsonInline;
					inline = textRun;
				}
				else {
					// No fallback for inlines in 1.2
					inline = context.parseElement(this, jsonInline, false);
				}
				if (inline) {
					this.internalAddInline(inline, true);
				}
			}
		}
	};
	RichTextBlock.prototype.internalToJSON = function (target, context) {
		_super.prototype.internalToJSON.call(this, target, context);
		if (this._inlines.length > 0) {
			var jsonInlines = [];
			for (var _i = 0, _a = this._inlines; _i < _a.length; _i++) {
				var inline = _a[_i];
				jsonInlines.push(inline.toJSON(context));
			}
			context.serializeValue(target, "inlines", jsonInlines);
		}
	};
	RichTextBlock.prototype.internalRender = function () {
		if (this._inlines.length > 0) {
			var element = void 0;
			if (this.forElementId) {
				var labelElement = document.createElement("label");
				labelElement.htmlFor = this.forElementId;
				element = labelElement;
			}
			else {
				element = document.createElement("div");
			}
			element.className = this.hostConfig.makeCssClassName("ac-richTextBlock");
			var parentContainer = this.getParentContainer();
			var isRtl = parentContainer ? parentContainer.isRtl() : false;
			switch (this.horizontalAlignment) {
				case Enums.HorizontalAlignment.Center:
					element.style.textAlign = "center";
					break;
				case Enums.HorizontalAlignment.Right:
					element.style.textAlign = isRtl ? "left" : "right";
					break;
				default:
					element.style.textAlign = isRtl ? "right" : "left";
					break;
			}
			var renderedInlines = 0;
			for (var _i = 0, _a = this._inlines; _i < _a.length; _i++) {
				var inline = _a[_i];
				var renderedInline = inline.render();
				if (renderedInline) {
					element.appendChild(renderedInline);
					renderedInlines++;
				}
			}
			if (renderedInlines > 0) {
				return element;
			}
		}
		return undefined;
	};
	RichTextBlock.prototype.asString = function () {
		var result = "";
		for (var _i = 0, _a = this._inlines; _i < _a.length; _i++) {
			var inline = _a[_i];
			result += inline.asString();
		}
		return result;
	};
	RichTextBlock.prototype.getJsonTypeName = function () {
		return "RichTextBlock";
	};
	RichTextBlock.prototype.getInlineCount = function () {
		return this._inlines.length;
	};
	RichTextBlock.prototype.getInlineAt = function (index) {
		if (index >= 0 && index < this._inlines.length) {
			return this._inlines[index];
		}
		else {
			throw new Error(strings_1.Strings.errors.indexOutOfRange(index));
		}
	};
	RichTextBlock.prototype.addInline = function (inline) {
		if (typeof inline === "string") {
			this.internalAddInline(new TextRun(inline));
		}
		else {
			this.internalAddInline(inline);
		}
	};
	RichTextBlock.prototype.removeInline = function (inline) {
		var index = this._inlines.indexOf(inline);
		if (index >= 0) {
			this._inlines[index].setParent(undefined);
			this._inlines.splice(index, 1);
			return true;
		}
		return false;
	};
	return RichTextBlock;
}(CardElement));
exports.RichTextBlock = RichTextBlock;
var Fact = /** @class */ (function (_super) {
	__extends(Fact, _super);
	function Fact(name, value) {
		var _this = _super.call(this) || this;
		_this.name = name;
		_this.value = value;
		return _this;
	}
	//#endregion
	Fact.prototype.getSchemaKey = function () {
		return "Fact";
	};
	//#region Schema
	Fact.titleProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_0, "title");
	Fact.valueProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_0, "value");
	__decorate([
		serialization_1.property(Fact.titleProperty)
	], Fact.prototype, "name", void 0);
	__decorate([
		serialization_1.property(Fact.valueProperty)
	], Fact.prototype, "value", void 0);
	return Fact;
}(serialization_1.SerializableObject));
exports.Fact = Fact;
var FactSet = /** @class */ (function (_super) {
	__extends(FactSet, _super);
	function FactSet() {
		return _super !== null && _super.apply(this, arguments) || this;
	}
	Object.defineProperty(FactSet.prototype, "useDefaultSizing", {
		//#endregion
		get: function () {
			return false;
		},
		enumerable: false,
		configurable: true
	});
	FactSet.prototype.internalRender = function () {
		var element = undefined;
		var hostConfig = this.hostConfig;
		if (this.facts.length > 0) {
			element = document.createElement("table");
			element.style.borderWidth = "0px";
			element.style.borderSpacing = "0px";
			element.style.borderStyle = "none";
			element.style.borderCollapse = "collapse";
			element.style.display = "block";
			element.style.overflow = "hidden";
			element.classList.add(hostConfig.makeCssClassName("ac-factset"));
			element.setAttribute("role", "presentation");
			for (var i = 0; i < this.facts.length; i++) {
				var trElement = document.createElement("tr");
				if (i > 0) {
					trElement.style.marginTop = hostConfig.factSet.spacing + "px";
				}
				// Title column
				var tdElement = document.createElement("td");
				tdElement.style.padding = "0";
				tdElement.classList.add(hostConfig.makeCssClassName("ac-fact-title"));
				if (hostConfig.factSet.title.maxWidth) {
					tdElement.style.maxWidth = hostConfig.factSet.title.maxWidth + "px";
				}
				tdElement.style.verticalAlign = "top";
				var textBlock = new TextBlock();
				textBlock.setParent(this);
				textBlock.text = (!this.facts[i].name && this.isDesignMode()) ? "Title" : this.facts[i].name;
				textBlock.size = hostConfig.factSet.title.size;
				textBlock.color = hostConfig.factSet.title.color;
				textBlock.isSubtle = hostConfig.factSet.title.isSubtle;
				textBlock.weight = hostConfig.factSet.title.weight;
				textBlock.wrap = hostConfig.factSet.title.wrap;
				textBlock.spacing = Enums.Spacing.None;
				Utils.appendChild(tdElement, textBlock.render());
				Utils.appendChild(trElement, tdElement);
				// Spacer column
				tdElement = document.createElement("td");
				tdElement.style.width = "10px";
				Utils.appendChild(trElement, tdElement);
				// Value column
				tdElement = document.createElement("td");
				tdElement.style.padding = "0";
				tdElement.style.verticalAlign = "top";
				tdElement.classList.add(hostConfig.makeCssClassName("ac-fact-value"));
				textBlock = new TextBlock();
				textBlock.setParent(this);
				textBlock.text = this.facts[i].value;
				textBlock.size = hostConfig.factSet.value.size;
				textBlock.color = hostConfig.factSet.value.color;
				textBlock.isSubtle = hostConfig.factSet.value.isSubtle;
				textBlock.weight = hostConfig.factSet.value.weight;
				textBlock.wrap = hostConfig.factSet.value.wrap;
				textBlock.spacing = Enums.Spacing.None;
				Utils.appendChild(tdElement, textBlock.render());
				Utils.appendChild(trElement, tdElement);
				Utils.appendChild(element, trElement);
			}
		}
		return element;
	};
	FactSet.prototype.getJsonTypeName = function () {
		return "FactSet";
	};
	//#region Schema
	FactSet.factsProperty = new serialization_1.SerializableObjectCollectionProperty(serialization_1.Versions.v1_0, "facts", Fact);
	__decorate([
		serialization_1.property(FactSet.factsProperty)
	], FactSet.prototype, "facts", void 0);
	return FactSet;
}(CardElement));
exports.FactSet = FactSet;
var ImageDimensionProperty = /** @class */ (function (_super) {
	__extends(ImageDimensionProperty, _super);
	function ImageDimensionProperty(targetVersion, name, internalName, fallbackProperty) {
		var _this = _super.call(this, targetVersion, name) || this;
		_this.targetVersion = targetVersion;
		_this.name = name;
		_this.internalName = internalName;
		_this.fallbackProperty = fallbackProperty;
		return _this;
	}
	ImageDimensionProperty.prototype.getInternalName = function () {
		return this.internalName;
	};
	ImageDimensionProperty.prototype.parse = function (sender, source, context) {
		var result = undefined;
		var sourceValue = source[this.name];
		if (sourceValue === undefined) {
			return this.defaultValue;
		}
		var isValid = false;
		if (typeof sourceValue === "string") {
			try {
				var size = shared_1.SizeAndUnit.parse(sourceValue, true);
				if (size.unit == Enums.SizeUnit.Pixel) {
					result = size.physicalSize;
					isValid = true;
				}
			}
			catch (_a) {
				// Swallow the exception
			}
			// If the source value isn't valid per this property definition,
			// check its validity per the fallback property, if specified
			if (!isValid && this.fallbackProperty) {
				isValid = this.fallbackProperty.isValidValue(sourceValue, context);
			}
		}
		if (!isValid) {
			context.logParseEvent(sender, Enums.ValidationEvent.InvalidPropertyValue, strings_1.Strings.errors.invalidPropertyValue(sourceValue, this.name));
		}
		return result;
	};
	ImageDimensionProperty.prototype.toJSON = function (sender, target, value, context) {
		context.serializeValue(target, this.name, typeof value === "number" && !isNaN(value) ? value + "px" : undefined);
	};
	return ImageDimensionProperty;
}(serialization_1.PropertyDefinition));
var Image = /** @class */ (function (_super) {
	__extends(Image, _super);
	function Image() {
		//#region Schema
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this.size = Enums.Size.Auto;
		_this.style = Enums.ImageStyle.Default;
		return _this;
	}
	Image.prototype.populateSchema = function (schema) {
		_super.prototype.populateSchema.call(this, schema);
		schema.remove(CardElement.heightProperty);
	};
	//#endregion
	Image.prototype.applySize = function (element) {
		if (this.pixelWidth || this.pixelHeight) {
			if (this.pixelWidth) {
				element.style.width = this.pixelWidth + "px";
			}
			if (this.pixelHeight) {
				element.style.height = this.pixelHeight + "px";
			}
		}
		else {
			if (this.maxHeight) {
				// If the image is constrained in height, we set its height property and
				// auto and stretch are ignored (default to medium). THis is necessary for
				// ImageSet which uses a maximum image height as opposed to the cards width
				// as a constraining dimension
				switch (this.size) {
					case Enums.Size.Small:
						element.style.height = this.hostConfig.imageSizes.small + "px";
						break;
					case Enums.Size.Large:
						element.style.height = this.hostConfig.imageSizes.large + "px";
						break;
					default:
						element.style.height = this.hostConfig.imageSizes.medium + "px";
						break;
				}
				element.style.maxHeight = this.maxHeight + "px";
			}
			else {
				switch (this.size) {
					case Enums.Size.Stretch:
						element.style.width = "100%";
						break;
					case Enums.Size.Auto:
						element.style.maxWidth = "100%";
						break;
					case Enums.Size.Small:
						element.style.width = this.hostConfig.imageSizes.small + "px";
						break;
					case Enums.Size.Large:
						element.style.width = this.hostConfig.imageSizes.large + "px";
						break;
					case Enums.Size.Medium:
						element.style.width = this.hostConfig.imageSizes.medium + "px";
						break;
				}
				element.style.maxHeight = "100%";
			}
		}
	};
	Object.defineProperty(Image.prototype, "useDefaultSizing", {
		get: function () {
			return false;
		},
		enumerable: false,
		configurable: true
	});
	Image.prototype.internalRender = function () {
		var _this = this;
		var element = undefined;
		if (this.url) {
			element = document.createElement("div");
			element.style.display = "flex";
			element.style.alignItems = "flex-start";
			element.onkeypress = function (e) {
				if (_this.selectAction && (e.keyCode == 13 || e.keyCode == 32)) { // enter or space pressed
					e.preventDefault();
					e.cancelBubble = true;
					_this.selectAction.execute();
				}
			};
			element.onclick = function (e) {
				if (_this.selectAction) {
					e.preventDefault();
					e.cancelBubble = true;
					_this.selectAction.execute();
				}
			};
			switch (this.horizontalAlignment) {
				case Enums.HorizontalAlignment.Center:
					element.style.justifyContent = "center";
					break;
				case Enums.HorizontalAlignment.Right:
					element.style.justifyContent = "flex-end";
					break;
				default:
					element.style.justifyContent = "flex-start";
					break;
			}
			// Cache hostConfig to avoid walking the parent hierarchy multiple times
			var hostConfig = this.hostConfig;
			var imageElement = document.createElement("img");
			imageElement.onload = function (e) {
				raiseImageLoadedEvent(_this);
			};
			imageElement.onerror = function (e) {
				if (_this.renderedElement) {
					var card = _this.getRootElement();
					_this.renderedElement.innerHTML = "";
					if (card && card.designMode) {
						var errorElement = document.createElement("div");
						errorElement.style.display = "flex";
						errorElement.style.alignItems = "center";
						errorElement.style.justifyContent = "center";
						errorElement.style.backgroundColor = "#EEEEEE";
						errorElement.style.color = "black";
						errorElement.innerText = ":-(";
						errorElement.style.padding = "10px";
						_this.applySize(errorElement);
						_this.renderedElement.appendChild(errorElement);
					}
				}
				raiseImageLoadedEvent(_this);
			};
			imageElement.style.minWidth = "0";
			imageElement.classList.add(hostConfig.makeCssClassName("ac-image"));
			if (this.selectAction !== undefined && hostConfig.supportsInteractivity) {
				imageElement.tabIndex = 0;
				imageElement.setAttribute("role", this.selectAction.getAriaRole());
				if (this.selectAction.title) {
					imageElement.setAttribute("aria-label", this.selectAction.title);
					imageElement.title = this.selectAction.title;
				}
				imageElement.classList.add(hostConfig.makeCssClassName("ac-selectable"));
			}
			this.applySize(imageElement);
			if (this.style === Enums.ImageStyle.Person) {
				imageElement.style.borderRadius = "50%";
				imageElement.style.backgroundPosition = "50% 50%";
				imageElement.style.backgroundRepeat = "no-repeat";
			}
			imageElement.style.backgroundColor = Utils.stringToCssColor(this.backgroundColor);
			imageElement.src = this.preProcessPropertyValue(Image.urlProperty);
			var altTextProperty = this.preProcessPropertyValue(Image.altTextProperty);
			if (altTextProperty) {
				imageElement.alt = altTextProperty;
			}
			element.appendChild(imageElement);
		}
		return element;
	};
	Image.prototype.getJsonTypeName = function () {
		return "Image";
	};
	Image.prototype.getActionById = function (id) {
		var result = _super.prototype.getActionById.call(this, id);
		if (!result && this.selectAction) {
			result = this.selectAction.getActionById(id);
		}
		return result;
	};
	Image.prototype.getResourceInformation = function () {
		return this.url ? [{ url: this.url, mimeType: "image" }] : [];
	};
	Image.urlProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_0, "url");
	Image.altTextProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_0, "altText");
	Image.backgroundColorProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_1, "backgroundColor");
	Image.styleProperty = new serialization_1.EnumProperty(serialization_1.Versions.v1_0, "style", Enums.ImageStyle, Enums.ImageStyle.Default);
	Image.sizeProperty = new serialization_1.EnumProperty(serialization_1.Versions.v1_0, "size", Enums.Size, Enums.Size.Auto);
	Image.pixelWidthProperty = new ImageDimensionProperty(serialization_1.Versions.v1_1, "width", "pixelWidth");
	Image.pixelHeightProperty = new ImageDimensionProperty(serialization_1.Versions.v1_1, "height", "pixelHeight", CardElement.heightProperty);
	Image.selectActionProperty = new ActionProperty(serialization_1.Versions.v1_1, "selectAction", ["Action.ShowCard"]);
	__decorate([
		serialization_1.property(Image.urlProperty)
	], Image.prototype, "url", void 0);
	__decorate([
		serialization_1.property(Image.altTextProperty)
	], Image.prototype, "altText", void 0);
	__decorate([
		serialization_1.property(Image.backgroundColorProperty)
	], Image.prototype, "backgroundColor", void 0);
	__decorate([
		serialization_1.property(Image.sizeProperty)
	], Image.prototype, "size", void 0);
	__decorate([
		serialization_1.property(Image.styleProperty)
	], Image.prototype, "style", void 0);
	__decorate([
		serialization_1.property(Image.pixelWidthProperty)
	], Image.prototype, "pixelWidth", void 0);
	__decorate([
		serialization_1.property(Image.pixelHeightProperty)
	], Image.prototype, "pixelHeight", void 0);
	__decorate([
		serialization_1.property(Image.selectActionProperty)
	], Image.prototype, "selectAction", void 0);
	return Image;
}(CardElement));
exports.Image = Image;
var CardElementContainer = /** @class */ (function (_super) {
	__extends(CardElementContainer, _super);
	function CardElementContainer() {
		//#region Schema
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this.allowVerticalOverflow = false;
		return _this;
	}
	CardElementContainer.prototype.populateSchema = function (schema) {
		_super.prototype.populateSchema.call(this, schema);
		if (!this.isSelectable) {
			schema.remove(CardElementContainer.selectActionProperty);
		}
	};
	//#endregion
	CardElementContainer.prototype.isElementAllowed = function (element) {
		return this.hostConfig.supportsInteractivity || !element.isInteractive;
	};
	CardElementContainer.prototype.applyPadding = function () {
		_super.prototype.applyPadding.call(this);
		if (!this.renderedElement) {
			return;
		}
		var physicalPadding = new shared_1.SpacingDefinition();
		if (this.getEffectivePadding()) {
			physicalPadding = this.hostConfig.paddingDefinitionToSpacingDefinition(this.getEffectivePadding());
		}
		this.renderedElement.style.paddingTop = physicalPadding.top + "px";
		this.renderedElement.style.paddingRight = physicalPadding.right + "px";
		this.renderedElement.style.paddingBottom = physicalPadding.bottom + "px";
		this.renderedElement.style.paddingLeft = physicalPadding.left + "px";
		this.renderedElement.style.marginRight = "0";
		this.renderedElement.style.marginLeft = "0";
	};
	Object.defineProperty(CardElementContainer.prototype, "isSelectable", {
		get: function () {
			return false;
		},
		enumerable: false,
		configurable: true
	});
	CardElementContainer.prototype.internalValidateProperties = function (context) {
		_super.prototype.internalValidateProperties.call(this, context);
		for (var i = 0; i < this.getItemCount(); i++) {
			var item = this.getItemAt(i);
			if (!this.hostConfig.supportsInteractivity && item.isInteractive) {
				context.addFailure(this, Enums.ValidationEvent.InteractivityNotAllowed, strings_1.Strings.errors.interactivityNotAllowed());
			}
			if (!this.isElementAllowed(item)) {
				context.addFailure(this, Enums.ValidationEvent.InteractivityNotAllowed, strings_1.Strings.errors.elementTypeNotAllowed(item.getJsonTypeName()));
			}
			item.internalValidateProperties(context);
		}
		if (this._selectAction) {
			this._selectAction.internalValidateProperties(context);
		}
	};
	CardElementContainer.prototype.render = function () {
		var _this = this;
		var element = _super.prototype.render.call(this);
		if (element) {
			var hostConfig = this.hostConfig;
			if (this.allowVerticalOverflow) {
				element.style.overflowX = "hidden";
				element.style.overflowY = "auto";
			}
			if (element && this.isSelectable && this._selectAction && hostConfig.supportsInteractivity) {
				element.classList.add(hostConfig.makeCssClassName("ac-selectable"));
				element.tabIndex = 0;
				element.setAttribute("role", this._selectAction.getAriaRole());
				if (this._selectAction.title) {
					element.setAttribute("aria-label", this._selectAction.title);
					element.title = this._selectAction.title;
				}
				element.onclick = function (e) {
					if (_this._selectAction !== undefined) {
						e.preventDefault();
						e.cancelBubble = true;
						_this._selectAction.execute();
					}
				};
				element.onkeypress = function (e) {
					if (_this._selectAction !== undefined && (e.keyCode == 13 || e.keyCode == 32)) {
						// Enter or space pressed
						e.preventDefault();
						e.cancelBubble = true;
						_this._selectAction.execute();
					}
				};
			}
		}
		return element;
	};
	CardElementContainer.prototype.updateLayout = function (processChildren) {
		if (processChildren === void 0) { processChildren = true; }
		_super.prototype.updateLayout.call(this, processChildren);
		if (processChildren) {
			for (var i = 0; i < this.getItemCount(); i++) {
				this.getItemAt(i).updateLayout();
			}
		}
	};
	CardElementContainer.prototype.getAllInputs = function (processActions) {
		if (processActions === void 0) { processActions = true; }
		var result = [];
		for (var i = 0; i < this.getItemCount(); i++) {
			result = result.concat(this.getItemAt(i).getAllInputs(processActions));
		}
		return result;
	};
	CardElementContainer.prototype.getResourceInformation = function () {
		var result = [];
		for (var i = 0; i < this.getItemCount(); i++) {
			result = result.concat(this.getItemAt(i).getResourceInformation());
		}
		return result;
	};
	CardElementContainer.prototype.getElementById = function (id) {
		var result = _super.prototype.getElementById.call(this, id);
		if (!result) {
			for (var i = 0; i < this.getItemCount(); i++) {
				result = this.getItemAt(i).getElementById(id);
				if (result) {
					break;
				}
			}
		}
		return result;
	};
	/**
	 * @inheritdoc
	 */
	CardElementContainer.prototype.findDOMNodeOwner = function (node) {
		var target = undefined;
		for (var i = 0; i < this.getItemCount(); i++) {
			// recur through child elements
			target = this.getItemAt(i).findDOMNodeOwner(node);
			if (target) {
				return target;
			}
		}
		// if not found in children, defer to parent implementation
		return _super.prototype.findDOMNodeOwner.call(this, node);
	};
	CardElementContainer.selectActionProperty = new ActionProperty(serialization_1.Versions.v1_1, "selectAction", ["Action.ShowCard"]);
	__decorate([
		serialization_1.property(CardElementContainer.selectActionProperty)
	], CardElementContainer.prototype, "_selectAction", void 0);
	return CardElementContainer;
}(CardElement));
exports.CardElementContainer = CardElementContainer;
var ImageSet = /** @class */ (function (_super) {
	__extends(ImageSet, _super);
	function ImageSet() {
		//#region Schema
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this._images = [];
		_this.imageSize = Enums.ImageSize.Medium;
		return _this;
	}
	//#endregion
	ImageSet.prototype.internalRender = function () {
		var element = undefined;
		if (this._images.length > 0) {
			element = document.createElement("div");
			element.style.display = "flex";
			element.style.flexWrap = "wrap";
			for (var _i = 0, _a = this._images; _i < _a.length; _i++) {
				var image = _a[_i];
				switch (this.imageSize) {
					case Enums.ImageSize.Small:
						image.size = Enums.Size.Small;
						break;
					case Enums.ImageSize.Large:
						image.size = Enums.Size.Large;
						break;
					default:
						image.size = Enums.Size.Medium;
						break;
				}
				image.maxHeight = this.hostConfig.imageSet.maxImageHeight;
				var renderedImage = image.render();
				if (renderedImage) {
					renderedImage.style.display = "inline-flex";
					renderedImage.style.margin = "0px";
					renderedImage.style.marginRight = "10px";
					Utils.appendChild(element, renderedImage);
				}
			}
		}
		return element;
	};
	ImageSet.prototype.getItemCount = function () {
		return this._images.length;
	};
	ImageSet.prototype.getItemAt = function (index) {
		return this._images[index];
	};
	ImageSet.prototype.getFirstVisibleRenderedItem = function () {
		return this._images && this._images.length > 0 ? this._images[0] : undefined;
	};
	ImageSet.prototype.getLastVisibleRenderedItem = function () {
		return this._images && this._images.length > 0 ? this._images[this._images.length - 1] : undefined;
	};
	ImageSet.prototype.removeItem = function (item) {
		if (item instanceof Image) {
			var itemIndex = this._images.indexOf(item);
			if (itemIndex >= 0) {
				this._images.splice(itemIndex, 1);
				item.setParent(undefined);
				this.updateLayout();
				return true;
			}
		}
		return false;
	};
	ImageSet.prototype.getJsonTypeName = function () {
		return "ImageSet";
	};
	ImageSet.prototype.addImage = function (image) {
		if (!image.parent) {
			this._images.push(image);
			image.setParent(this);
		}
		else {
			throw new Error("This image already belongs to another ImageSet");
		}
	};
	ImageSet.prototype.indexOf = function (cardElement) {
		return cardElement instanceof Image ? this._images.indexOf(cardElement) : -1;
	};
	ImageSet.imagesProperty = new serialization_1.SerializableObjectCollectionProperty(serialization_1.Versions.v1_0, "images", Image, function (sender, item) { item.setParent(sender); });
	ImageSet.imageSizeProperty = new serialization_1.EnumProperty(serialization_1.Versions.v1_0, "imageSize", Enums.ImageSize, Enums.ImageSize.Medium);
	__decorate([
		serialization_1.property(ImageSet.imagesProperty)
	], ImageSet.prototype, "_images", void 0);
	__decorate([
		serialization_1.property(ImageSet.imageSizeProperty)
	], ImageSet.prototype, "imageSize", void 0);
	return ImageSet;
}(CardElementContainer));
exports.ImageSet = ImageSet;
var MediaSource = /** @class */ (function (_super) {
	__extends(MediaSource, _super);
	function MediaSource(url, mimeType) {
		var _this = _super.call(this) || this;
		_this.url = url;
		_this.mimeType = mimeType;
		return _this;
	}
	//#endregion
	MediaSource.prototype.getSchemaKey = function () {
		return "MediaSource";
	};
	MediaSource.prototype.isValid = function () {
		return this.mimeType && this.url ? true : false;
	};
	MediaSource.prototype.render = function () {
		var result = undefined;
		if (this.isValid()) {
			result = document.createElement("source");
			result.src = this.url;
			result.type = this.mimeType;
		}
		return result;
	};
	//#region Schema
	MediaSource.mimeTypeProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_1, "mimeType");
	MediaSource.urlProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_1, "url");
	__decorate([
		serialization_1.property(MediaSource.mimeTypeProperty)
	], MediaSource.prototype, "mimeType", void 0);
	__decorate([
		serialization_1.property(MediaSource.urlProperty)
	], MediaSource.prototype, "url", void 0);
	return MediaSource;
}(serialization_1.SerializableObject));
exports.MediaSource = MediaSource;
var Media = /** @class */ (function (_super) {
	__extends(Media, _super);
	function Media() {
		//#region Schema
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this.sources = [];
		return _this;
	}
	Media.prototype.getPosterUrl = function () {
		return this.poster ? this.poster : this.hostConfig.media.defaultPoster;
	};
	Media.prototype.processSources = function () {
		this._selectedSources = [];
		this._selectedMediaType = undefined;
		for (var _i = 0, _a = this.sources; _i < _a.length; _i++) {
			var source = _a[_i];
			var mimeComponents = source.mimeType ? source.mimeType.split('/') : [];
			if (mimeComponents.length == 2) {
				if (!this._selectedMediaType) {
					var index = Media.supportedMediaTypes.indexOf(mimeComponents[0]);
					if (index >= 0) {
						this._selectedMediaType = Media.supportedMediaTypes[index];
					}
				}
				if (mimeComponents[0] == this._selectedMediaType) {
					this._selectedSources.push(source);
				}
			}
		}
	};
	Media.prototype.handlePlayButtonInvoke = function (event) {
		if (this.hostConfig.media.allowInlinePlayback) {
			event.preventDefault();
			event.cancelBubble = true;
			if (this.renderedElement) {
				var mediaPlayerElement = this.renderMediaPlayer();
				this.renderedElement.innerHTML = "";
				this.renderedElement.appendChild(mediaPlayerElement);
				mediaPlayerElement.play();
				mediaPlayerElement.focus();
			}
		}
		else {
			if (Media.onPlay) {
				event.preventDefault();
				event.cancelBubble = true;
				Media.onPlay(this);
			}
		}
	};
	Media.prototype.renderPoster = function () {
		var _this = this;
		var playButtonArrowWidth = 12;
		var playButtonArrowHeight = 15;
		var posterRootElement = document.createElement("div");
		posterRootElement.className = this.hostConfig.makeCssClassName("ac-media-poster");
		posterRootElement.setAttribute("role", "contentinfo");
		posterRootElement.setAttribute("aria-label", this.altText ? this.altText : strings_1.Strings.defaults.mediaPlayerAriaLabel());
		posterRootElement.style.position = "relative";
		posterRootElement.style.display = "flex";
		var posterUrl = this.getPosterUrl();
		if (posterUrl) {
			var posterImageElement_1 = document.createElement("img");
			posterImageElement_1.style.width = "100%";
			posterImageElement_1.style.height = "100%";
			posterImageElement_1.setAttribute("role", "presentation");
			posterImageElement_1.onerror = function (e) {
				if (posterImageElement_1.parentNode) {
					posterImageElement_1.parentNode.removeChild(posterImageElement_1);
				}
				posterRootElement.classList.add("empty");
				posterRootElement.style.minHeight = "150px";
			};
			posterImageElement_1.src = posterUrl;
			posterRootElement.appendChild(posterImageElement_1);
		}
		else {
			posterRootElement.classList.add("empty");
			posterRootElement.style.minHeight = "150px";
		}
		if (this.hostConfig.supportsInteractivity && this._selectedSources.length > 0) {
			var playButtonOuterElement = document.createElement("div");
			playButtonOuterElement.tabIndex = 0;
			playButtonOuterElement.setAttribute("role", "button");
			playButtonOuterElement.setAttribute("aria-label", strings_1.Strings.defaults.mediaPlayerPlayMedia());
			playButtonOuterElement.className = this.hostConfig.makeCssClassName("ac-media-playButton");
			playButtonOuterElement.style.display = "flex";
			playButtonOuterElement.style.alignItems = "center";
			playButtonOuterElement.style.justifyContent = "center";
			playButtonOuterElement.onclick = function (e) {
				_this.handlePlayButtonInvoke(e);
			};
			playButtonOuterElement.onkeypress = function (e) {
				if (e.keyCode == 13 || e.keyCode == 32) { // space or enter
					_this.handlePlayButtonInvoke(e);
				}
			};
			var playButtonInnerElement = document.createElement("div");
			playButtonInnerElement.className = this.hostConfig.makeCssClassName("ac-media-playButton-arrow");
			playButtonInnerElement.style.width = playButtonArrowWidth + "px";
			playButtonInnerElement.style.height = playButtonArrowHeight + "px";
			playButtonInnerElement.style.borderTopWidth = (playButtonArrowHeight / 2) + "px";
			playButtonInnerElement.style.borderBottomWidth = (playButtonArrowHeight / 2) + "px";
			playButtonInnerElement.style.borderLeftWidth = playButtonArrowWidth + "px";
			playButtonInnerElement.style.borderRightWidth = "0";
			playButtonInnerElement.style.borderStyle = "solid";
			playButtonInnerElement.style.borderTopColor = "transparent";
			playButtonInnerElement.style.borderRightColor = "transparent";
			playButtonInnerElement.style.borderBottomColor = "transparent";
			playButtonInnerElement.style.transform = "translate(" + (playButtonArrowWidth / 10) + "px,0px)";
			playButtonOuterElement.appendChild(playButtonInnerElement);
			var playButtonContainer = document.createElement("div");
			playButtonContainer.style.position = "absolute";
			playButtonContainer.style.left = "0";
			playButtonContainer.style.top = "0";
			playButtonContainer.style.width = "100%";
			playButtonContainer.style.height = "100%";
			playButtonContainer.style.display = "flex";
			playButtonContainer.style.justifyContent = "center";
			playButtonContainer.style.alignItems = "center";
			playButtonContainer.appendChild(playButtonOuterElement);
			posterRootElement.appendChild(playButtonContainer);
		}
		return posterRootElement;
	};
	Media.prototype.renderMediaPlayer = function () {
		var mediaElement;
		if (this._selectedMediaType == "video") {
			var videoPlayer = document.createElement("video");
			var posterUrl = this.getPosterUrl();
			if (posterUrl) {
				videoPlayer.poster = posterUrl;
			}
			mediaElement = videoPlayer;
		}
		else {
			mediaElement = document.createElement("audio");
		}
		mediaElement.setAttribute("aria-label", this.altText ? this.altText : strings_1.Strings.defaults.mediaPlayerAriaLabel());
		mediaElement.setAttribute("webkit-playsinline", "");
		mediaElement.setAttribute("playsinline", "");
		mediaElement.autoplay = true;
		mediaElement.controls = true;
		if (Utils.isMobileOS()) {
			mediaElement.muted = true;
		}
		mediaElement.preload = "none";
		mediaElement.style.width = "100%";
		for (var _i = 0, _a = this.sources; _i < _a.length; _i++) {
			var source = _a[_i];
			var renderedSource = source.render();
			Utils.appendChild(mediaElement, renderedSource);
		}
		return mediaElement;
	};
	Media.prototype.internalRender = function () {
		var element = document.createElement("div");
		element.className = this.hostConfig.makeCssClassName("ac-media");
		this.processSources();
		element.appendChild(this.renderPoster());
		return element;
	};
	Media.prototype.getJsonTypeName = function () {
		return "Media";
	};
	Media.prototype.getResourceInformation = function () {
		var result = [];
		var posterUrl = this.getPosterUrl();
		if (posterUrl) {
			result.push({ url: posterUrl, mimeType: "image" });
		}
		for (var _i = 0, _a = this.sources; _i < _a.length; _i++) {
			var mediaSource = _a[_i];
			if (mediaSource.isValid()) {
				result.push({
					url: mediaSource.url,
					mimeType: mediaSource.mimeType
				});
			}
		}
		return result;
	};
	Object.defineProperty(Media.prototype, "selectedMediaType", {
		get: function () {
			return this._selectedMediaType;
		},
		enumerable: false,
		configurable: true
	});
	Media.sourcesProperty = new serialization_1.SerializableObjectCollectionProperty(serialization_1.Versions.v1_1, "sources", MediaSource);
	Media.posterProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_1, "poster");
	Media.altTextProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_1, "altText");
	//#endregion
	Media.supportedMediaTypes = ["audio", "video"];
	__decorate([
		serialization_1.property(Media.sourcesProperty)
	], Media.prototype, "sources", void 0);
	__decorate([
		serialization_1.property(Media.posterProperty)
	], Media.prototype, "poster", void 0);
	__decorate([
		serialization_1.property(Media.altTextProperty)
	], Media.prototype, "altText", void 0);
	return Media;
}(CardElement));
exports.Media = Media;
var Input = /** @class */ (function (_super) {
	__extends(Input, _super);
	function Input() {
		return _super !== null && _super.apply(this, arguments) || this;
	}
	Input.prototype.getAllLabelIds = function () {
		var labelIds = [];
		if (this._renderedLabelElement) {
			labelIds.push(this._renderedLabelElement.id);
		}
		if (this._renderedErrorMessageElement) {
			labelIds.push(this._renderedErrorMessageElement.id);
		}
		return labelIds;
	};
	Input.prototype.updateInputControlAriaLabelledBy = function () {
		if (this._renderedInputControlElement) {
			var labelIds = this.getAllLabelIds();
			if (this.labelledBy) {
				labelIds.push(this.labelledBy);
			}
			if (this._renderedLabelElement) {
				labelIds.push(this._renderedLabelElement.id);
			}
			if (this._renderedErrorMessageElement) {
				labelIds.push(this._renderedErrorMessageElement.id);
			}
			if (labelIds.length > 0) {
				this._renderedInputControlElement.setAttribute("aria-labelledby", labelIds.join(" "));
			}
			else {
				this._renderedInputControlElement.removeAttribute("aria-labelledby");
			}
		}
	};
	Object.defineProperty(Input.prototype, "isNullable", {
		get: function () {
			return true;
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(Input.prototype, "renderedInputControlElement", {
		get: function () {
			return this._renderedInputControlElement;
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(Input.prototype, "inputControlContainerElement", {
		get: function () {
			return this._inputControlContainerElement;
		},
		enumerable: false,
		configurable: true
	});
	Input.prototype.overrideInternalRender = function () {
		var hostConfig = this.hostConfig;
		this._outerContainerElement = document.createElement("div");
		this._outerContainerElement.style.display = "flex";
		this._outerContainerElement.style.flexDirection = "column";
		var renderedInputControlId = Utils.generateUniqueId();
		if (this.label) {
			var labelRichTextBlock = new RichTextBlock();
			labelRichTextBlock.setParent(this);
			labelRichTextBlock.forElementId = renderedInputControlId;
			var labelInline = new TextRun(this.label);
			labelRichTextBlock.addInline(labelInline);
			if (this.isRequired) {
				labelInline.init(hostConfig.inputs.label.requiredInputs);
				var isRequiredCueInline = new TextRun(hostConfig.inputs.label.requiredInputs.suffix);
				isRequiredCueInline.color = hostConfig.inputs.label.requiredInputs.suffixColor;
				isRequiredCueInline.ariaHidden = true;
				labelRichTextBlock.addInline(isRequiredCueInline);
			}
			else {
				labelInline.init(hostConfig.inputs.label.optionalInputs);
			}
			this._renderedLabelElement = labelRichTextBlock.render();
			if (this._renderedLabelElement) {
				this._renderedLabelElement.id = Utils.generateUniqueId();
				this._renderedLabelElement.style.marginBottom = hostConfig.getEffectiveSpacing(hostConfig.inputs.label.inputSpacing) + "px";
				this._outerContainerElement.appendChild(this._renderedLabelElement);
			}
		}
		this._inputControlContainerElement = document.createElement("div");
		this._inputControlContainerElement.className = hostConfig.makeCssClassName("ac-input-container");
		this._inputControlContainerElement.style.display = "flex";
		if (this.height === "stretch") {
			this._inputControlContainerElement.style.alignItems = "stretch";
			this._inputControlContainerElement.style.flex = "1 1 auto";
		}
		this._renderedInputControlElement = this.internalRender();
		if (this._renderedInputControlElement) {
			this._renderedInputControlElement.id = renderedInputControlId;
			this._renderedInputControlElement.style.minWidth = "0px";
			if (this.isNullable && this.isRequired) {
				this._renderedInputControlElement.setAttribute("aria-required", "true");
				this._renderedInputControlElement.classList.add(hostConfig.makeCssClassName("ac-input-required"));
			}
			this._inputControlContainerElement.appendChild(this._renderedInputControlElement);
			this._outerContainerElement.appendChild(this._inputControlContainerElement);
			this.updateInputControlAriaLabelledBy();
			return this._outerContainerElement;
		}
		return undefined;
	};
	Input.prototype.valueChanged = function () {
		if (this.isValid()) {
			this.resetValidationFailureCue();
		}
		if (this.onValueChanged) {
			this.onValueChanged(this);
		}
		raiseInputValueChangedEvent(this);
	};
	Input.prototype.resetValidationFailureCue = function () {
		if (this.renderedInputControlElement) {
			this.renderedInputControlElement.classList.remove(this.hostConfig.makeCssClassName("ac-input-validation-failed"));
			this.updateInputControlAriaLabelledBy();
			if (this._renderedErrorMessageElement) {
				this._outerContainerElement.removeChild(this._renderedErrorMessageElement);
				this._renderedErrorMessageElement = undefined;
			}
		}
	};
	Input.prototype.showValidationErrorMessage = function () {
		if (this.renderedElement && this.errorMessage && shared_1.GlobalSettings.displayInputValidationErrors) {
			var errorMessageTextBlock = new TextBlock();
			errorMessageTextBlock.setParent(this);
			errorMessageTextBlock.text = this.errorMessage;
			errorMessageTextBlock.wrap = true;
			errorMessageTextBlock.init(this.hostConfig.inputs.errorMessage);
			this._renderedErrorMessageElement = errorMessageTextBlock.render();
			if (this._renderedErrorMessageElement) {
				this._renderedErrorMessageElement.id = Utils.generateUniqueId();
				this._outerContainerElement.appendChild(this._renderedErrorMessageElement);
				this.updateInputControlAriaLabelledBy();
			}
		}
	};
	Input.prototype.focus = function () {
		if (this._renderedInputControlElement) {
			this._renderedInputControlElement.focus();
		}
	};
	Input.prototype.isValid = function () {
		return true;
	};
	Input.prototype.internalValidateProperties = function (context) {
		_super.prototype.internalValidateProperties.call(this, context);
		if (!this.id) {
			context.addFailure(this, Enums.ValidationEvent.PropertyCantBeNull, strings_1.Strings.errors.inputsMustHaveUniqueId());
		}
		if (this.isRequired) {
			if (!this.label) {
				context.addFailure(this, Enums.ValidationEvent.RequiredInputsShouldHaveLabel, "Required inputs should have a label");
			}
			if (!this.errorMessage) {
				context.addFailure(this, Enums.ValidationEvent.RequiredInputsShouldHaveErrorMessage, "Required inputs should have an error message");
			}
		}
	};
	Input.prototype.validateValue = function () {
		this.resetValidationFailureCue();
		var result = this.isRequired ? this.isSet() && this.isValid() : this.isValid();
		if (!result && this.renderedInputControlElement) {
			this.renderedInputControlElement.classList.add(this.hostConfig.makeCssClassName("ac-input-validation-failed"));
			this.showValidationErrorMessage();
		}
		return result;
	};
	Input.prototype.getAllInputs = function (processActions) {
		if (processActions === void 0) { processActions = true; }
		return [this];
	};
	Object.defineProperty(Input.prototype, "isInteractive", {
		get: function () {
			return true;
		},
		enumerable: false,
		configurable: true
	});
	//#region Schema
	Input.labelProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_3, "label", true);
	Input.isRequiredProperty = new serialization_1.BoolProperty(serialization_1.Versions.v1_3, "isRequired", false);
	Input.errorMessageProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_3, "errorMessage", true);
	__decorate([
		serialization_1.property(Input.labelProperty)
	], Input.prototype, "label", void 0);
	__decorate([
		serialization_1.property(Input.isRequiredProperty)
	], Input.prototype, "isRequired", void 0);
	__decorate([
		serialization_1.property(Input.errorMessageProperty)
	], Input.prototype, "errorMessage", void 0);
	return Input;
}(CardElement));
exports.Input = Input;
var TextInput = /** @class */ (function (_super) {
	__extends(TextInput, _super);
	function TextInput() {
		//#region Schema
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this.isMultiline = false;
		_this.style = Enums.InputTextStyle.Text;
		return _this;
	}
	//#endregion
	TextInput.prototype.setupInput = function (input) {
		var _this = this;
		input.style.flex = "1 1 auto";
		input.tabIndex = 0;
		if (this.placeholder) {
			input.placeholder = this.placeholder;
			input.setAttribute("aria-label", this.placeholder);
		}
		if (this.defaultValue) {
			input.value = this.defaultValue;
		}
		if (this.maxLength && this.maxLength > 0) {
			input.maxLength = this.maxLength;
		}
		input.oninput = function () { _this.valueChanged(); };
		input.onkeypress = function (e) {
			// Ctrl+Enter pressed
			if (e.ctrlKey && e.code === "Enter" && _this.inlineAction) {
				_this.inlineAction.execute();
			}
		};
	};
	TextInput.prototype.internalRender = function () {
		var result;
		if (this.isMultiline) {
			result = document.createElement("textarea");
			result.className = this.hostConfig.makeCssClassName("ac-input", "ac-textInput", "ac-multiline");
			if (this.height === "stretch") {
				result.style.height = "initial";
			}
		}
		else {
			result = document.createElement("input");
			result.className = this.hostConfig.makeCssClassName("ac-input", "ac-textInput");
			result.type = Enums.InputTextStyle[this.style].toLowerCase();
		}
		this.setupInput(result);
		return result;
	};
	TextInput.prototype.overrideInternalRender = function () {
		var _this = this;
		var renderedInputControl = _super.prototype.overrideInternalRender.call(this);
		if (this.inlineAction) {
			var button_1 = document.createElement("button");
			button_1.className = this.hostConfig.makeCssClassName("ac-inlineActionButton");
			button_1.onclick = function (e) {
				e.preventDefault();
				e.cancelBubble = true;
				if (_this.inlineAction) {
					_this.inlineAction.execute();
				}
			};
			if (this.inlineAction.iconUrl) {
				button_1.classList.add("iconOnly");
				var icon_1 = document.createElement("img");
				icon_1.style.height = "100%";
				icon_1.setAttribute("role", "presentation");
				// The below trick is necessary as a workaround in Chrome where the icon is initially displayed
				// at its native size then resized to 100% of the button's height. This cfreates an unpleasant
				// flicker. On top of that, Chrome's flex implementation fails to prperly re-layout the button
				// after the image has loaded and been gicven its final size. The below trick also fixes that.
				icon_1.style.display = "none";
				icon_1.onload = function () {
					icon_1.style.removeProperty("display");
				};
				icon_1.onerror = function () {
					button_1.removeChild(icon_1);
					button_1.classList.remove("iconOnly");
					button_1.classList.add("textOnly");
					button_1.textContent = _this.inlineAction && _this.inlineAction.title ? _this.inlineAction.title : strings_1.Strings.defaults.inlineActionTitle();
				};
				icon_1.src = this.inlineAction.iconUrl;
				button_1.appendChild(icon_1);
				button_1.title = this.inlineAction.title ? this.inlineAction.title : strings_1.Strings.defaults.inlineActionTitle();
			}
			else {
				button_1.classList.add("textOnly");
				button_1.textContent = this.inlineAction.title ? this.inlineAction.title : strings_1.Strings.defaults.inlineActionTitle();
			}
			button_1.style.marginLeft = "8px";
			this.inputControlContainerElement.appendChild(button_1);
		}
		return renderedInputControl;
	};
	TextInput.prototype.getJsonTypeName = function () {
		return "Input.Text";
	};
	TextInput.prototype.getActionById = function (id) {
		var result = _super.prototype.getActionById.call(this, id);
		if (!result && this.inlineAction) {
			result = this.inlineAction.getActionById(id);
		}
		return result;
	};
	TextInput.prototype.isSet = function () {
		return this.value ? true : false;
	};
	TextInput.prototype.isValid = function () {
		if (!this.value) {
			return true;
		}
		if (this.regex) {
			return new RegExp(this.regex, "g").test(this.value);
		}
		return true;
	};
	Object.defineProperty(TextInput.prototype, "value", {
		get: function () {
			if (this.renderedInputControlElement) {
				if (this.isMultiline) {
					return this.renderedInputControlElement.value;
				}
				else {
					return this.renderedInputControlElement.value;
				}
			}
			else {
				return undefined;
			}
		},
		enumerable: false,
		configurable: true
	});
	TextInput.valueProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_0, "value");
	TextInput.maxLengthProperty = new serialization_1.NumProperty(serialization_1.Versions.v1_0, "maxLength");
	TextInput.isMultilineProperty = new serialization_1.BoolProperty(serialization_1.Versions.v1_0, "isMultiline", false);
	TextInput.placeholderProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_0, "placeholder");
	TextInput.styleProperty = new serialization_1.EnumProperty(serialization_1.Versions.v1_0, "style", Enums.InputTextStyle, Enums.InputTextStyle.Text);
	TextInput.inlineActionProperty = new ActionProperty(serialization_1.Versions.v1_0, "inlineAction", ["Action.ShowCard"]);
	TextInput.regexProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_3, "regex", true);
	__decorate([
		serialization_1.property(TextInput.valueProperty)
	], TextInput.prototype, "defaultValue", void 0);
	__decorate([
		serialization_1.property(TextInput.maxLengthProperty)
	], TextInput.prototype, "maxLength", void 0);
	__decorate([
		serialization_1.property(TextInput.isMultilineProperty)
	], TextInput.prototype, "isMultiline", void 0);
	__decorate([
		serialization_1.property(TextInput.placeholderProperty)
	], TextInput.prototype, "placeholder", void 0);
	__decorate([
		serialization_1.property(TextInput.styleProperty)
	], TextInput.prototype, "style", void 0);
	__decorate([
		serialization_1.property(TextInput.inlineActionProperty)
	], TextInput.prototype, "inlineAction", void 0);
	__decorate([
		serialization_1.property(TextInput.regexProperty)
	], TextInput.prototype, "regex", void 0);
	return TextInput;
}(Input));
exports.TextInput = TextInput;
var ToggleInput = /** @class */ (function (_super) {
	__extends(ToggleInput, _super);
	function ToggleInput() {
		//#region Schema
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this.valueOn = "true";
		_this.valueOff = "false";
		_this.wrap = false;
		return _this;
	}
	ToggleInput.prototype.updateInputControlAriaLabelledBy = function () {
		if (this._checkboxInputElement) {
			var joinedLabelIds = this.getAllLabelIds().join(" ");
			if (this._checkboxInputLabelElement && this._checkboxInputLabelElement.id) {
				joinedLabelIds += " " + this._checkboxInputLabelElement.id;
			}
			if (joinedLabelIds) {
				this._checkboxInputElement.setAttribute("aria-labelledby", joinedLabelIds);
			}
			else {
				this._checkboxInputElement.removeAttribute("aria-labelledby");
			}
		}
	};
	ToggleInput.prototype.internalRender = function () {
		var _this = this;
		var element = document.createElement("div");
		element.className = this.hostConfig.makeCssClassName("ac-input", "ac-toggleInput");
		element.style.width = "100%";
		element.style.display = "flex";
		element.style.alignItems = "center";
		this._checkboxInputElement = document.createElement("input");
		this._checkboxInputElement.id = Utils.generateUniqueId();
		this._checkboxInputElement.type = "checkbox";
		this._checkboxInputElement.style.display = "inline-block";
		this._checkboxInputElement.style.verticalAlign = "middle";
		this._checkboxInputElement.style.margin = "0";
		this._checkboxInputElement.style.flex = "0 0 auto";
		if (this.title) {
			this._checkboxInputElement.setAttribute("aria-label", this.title);
		}
		if (this.isRequired) {
			this._checkboxInputElement.setAttribute("aria-required", "true");
		}
		this._checkboxInputElement.tabIndex = 0;
		if (this.defaultValue == this.valueOn) {
			this._checkboxInputElement.checked = true;
		}
		this._checkboxInputElement.onchange = function () { _this.valueChanged(); };
		Utils.appendChild(element, this._checkboxInputElement);
		if (this.title || this.isDesignMode()) {
			var label = new TextBlock();
			label.setParent(this);
			label.forElementId = this._checkboxInputElement.id;
			label.hostConfig = this.hostConfig;
			label.text = !this.title ? this.getJsonTypeName() : this.title;
			label.useMarkdown = shared_1.GlobalSettings.useMarkdownInRadioButtonAndCheckbox;
			label.wrap = this.wrap;
			this._checkboxInputLabelElement = label.render();
			if (this._checkboxInputLabelElement) {
				this._checkboxInputLabelElement.id = Utils.generateUniqueId();
				this._checkboxInputLabelElement.style.display = "inline-block";
				this._checkboxInputLabelElement.style.flex = "1 1 auto";
				this._checkboxInputLabelElement.style.marginLeft = "6px";
				this._checkboxInputLabelElement.style.verticalAlign = "middle";
				var spacerElement = document.createElement("div");
				spacerElement.style.width = "6px";
				Utils.appendChild(element, spacerElement);
				Utils.appendChild(element, this._checkboxInputLabelElement);
			}
		}
		return element;
	};
	Object.defineProperty(ToggleInput.prototype, "isNullable", {
		get: function () {
			return false;
		},
		enumerable: false,
		configurable: true
	});
	ToggleInput.prototype.getJsonTypeName = function () {
		return "Input.Toggle";
	};
	ToggleInput.prototype.focus = function () {
		if (this._checkboxInputElement) {
			this._checkboxInputElement.focus();
		}
	};
	ToggleInput.prototype.isSet = function () {
		if (this.isRequired) {
			return this.value === this.valueOn;
		}
		return this.value ? true : false;
	};
	Object.defineProperty(ToggleInput.prototype, "value", {
		get: function () {
			if (this._checkboxInputElement) {
				return this._checkboxInputElement.checked ? this.valueOn : this.valueOff;
			}
			else {
				return undefined;
			}
		},
		enumerable: false,
		configurable: true
	});
	ToggleInput.valueProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_0, "value");
	ToggleInput.titleProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_0, "title");
	ToggleInput.valueOnProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_0, "valueOn", true, undefined, "true", function (sender) { return "true"; });
	ToggleInput.valueOffProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_0, "valueOff", true, undefined, "false", function (sender) { return "false"; });
	ToggleInput.wrapProperty = new serialization_1.BoolProperty(serialization_1.Versions.v1_2, "wrap", false);
	__decorate([
		serialization_1.property(ToggleInput.valueProperty)
	], ToggleInput.prototype, "defaultValue", void 0);
	__decorate([
		serialization_1.property(ToggleInput.titleProperty)
	], ToggleInput.prototype, "title", void 0);
	__decorate([
		serialization_1.property(ToggleInput.valueOnProperty)
	], ToggleInput.prototype, "valueOn", void 0);
	__decorate([
		serialization_1.property(ToggleInput.valueOffProperty)
	], ToggleInput.prototype, "valueOff", void 0);
	__decorate([
		serialization_1.property(ToggleInput.wrapProperty)
	], ToggleInput.prototype, "wrap", void 0);
	return ToggleInput;
}(Input));
exports.ToggleInput = ToggleInput;
var Choice = /** @class */ (function (_super) {
	__extends(Choice, _super);
	function Choice(title, value) {
		var _this = _super.call(this) || this;
		_this.title = title;
		_this.value = value;
		return _this;
	}
	//#endregion
	Choice.prototype.getSchemaKey = function () {
		return "Choice";
	};
	//#region Schema
	Choice.titleProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_0, "title");
	Choice.valueProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_0, "value");
	__decorate([
		serialization_1.property(Choice.titleProperty)
	], Choice.prototype, "title", void 0);
	__decorate([
		serialization_1.property(Choice.valueProperty)
	], Choice.prototype, "value", void 0);
	return Choice;
}(serialization_1.SerializableObject));
exports.Choice = Choice;
var ChoiceSetInput = /** @class */ (function (_super) {
	__extends(ChoiceSetInput, _super);
	function ChoiceSetInput() {
		//#region Schema
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this.isMultiSelect = false;
		_this.wrap = false;
		_this.choices = [];
		return _this;
	}
	Object.defineProperty(ChoiceSetInput.prototype, "isCompact", {
		get: function () {
			return this.style !== "expanded";
		},
		set: function (value) {
			this.style = value ? undefined : "expanded";
		},
		enumerable: false,
		configurable: true
	});
	ChoiceSetInput.getUniqueCategoryName = function () {
		var uniqueCategoryName = "__ac-category" + ChoiceSetInput.uniqueCategoryCounter;
		ChoiceSetInput.uniqueCategoryCounter++;
		return uniqueCategoryName;
	};
	// Make sure `aria-current` is applied to the currently-selected item
	ChoiceSetInput.prototype.internalApplyAriaCurrent = function () {
		var options = this._selectElement.options;
		if (options) {
			for (var i = 0; i < options.length; i++) {
				if (options[i].selected) {
					options[i].setAttribute("aria-current", "true");
				}
				else {
					options[i].removeAttribute("aria-current");
				}
			}
		}
	};
	ChoiceSetInput.prototype.renderCompoundInput = function (cssClassName, type, defaultValues) {
		var _this = this;
		var element = document.createElement("div");
		element.className = this.hostConfig.makeCssClassName("ac-input", cssClassName);
		element.style.width = "100%";
		this._toggleInputs = [];
		this._labels = [];
		for (var _i = 0, _a = this.choices; _i < _a.length; _i++) {
			var choice = _a[_i];
			var input = document.createElement("input");
			input.id = Utils.generateUniqueId();
			input.type = type;
			input.style.margin = "0";
			input.style.display = "inline-block";
			input.style.verticalAlign = "middle";
			input.style.flex = "0 0 auto";
			input.name = this.id ? this.id : this._uniqueCategoryName;
			if (this.isRequired) {
				input.setAttribute("aria-required", "true");
			}
			if (choice.value) {
				input.value = choice.value;
			}
			if (choice.title) {
				input.setAttribute("aria-label", choice.title);
			}
			if (defaultValues && choice.value) {
				if (defaultValues.indexOf(choice.value) >= 0) {
					input.checked = true;
				}
			}
			input.onchange = function () { _this.valueChanged(); };
			this._toggleInputs.push(input);
			var compoundInput = document.createElement("div");
			compoundInput.style.display = "flex";
			compoundInput.style.alignItems = "center";
			Utils.appendChild(compoundInput, input);
			var label = new TextBlock();
			label.setParent(this);
			label.forElementId = input.id;
			label.hostConfig = this.hostConfig;
			label.text = choice.title ? choice.title : "Choice " + this._toggleInputs.length;
			label.useMarkdown = shared_1.GlobalSettings.useMarkdownInRadioButtonAndCheckbox;
			label.wrap = this.wrap;
			var labelElement = label.render();
			this._labels.push(labelElement);
			if (labelElement) {
				labelElement.id = Utils.generateUniqueId();
				labelElement.style.display = "inline-block";
				labelElement.style.flex = "1 1 auto";
				labelElement.style.marginLeft = "6px";
				labelElement.style.verticalAlign = "middle";
				var spacerElement = document.createElement("div");
				spacerElement.style.width = "6px";
				Utils.appendChild(compoundInput, spacerElement);
				Utils.appendChild(compoundInput, labelElement);
			}
			Utils.appendChild(element, compoundInput);
		}
		return element;
	};
	ChoiceSetInput.prototype.updateInputControlAriaLabelledBy = function () {
		if ((this.isMultiSelect || this.style === "expanded") && this._toggleInputs && this._labels) {
			var labelIds = this.getAllLabelIds();
			for (var i = 0; i < this._toggleInputs.length; i++) {
				var joinedLabelIds = labelIds.join(" ");
				var label = this._labels[i];
				if (label && label.id) {
					joinedLabelIds += " " + label.id;
				}
				if (joinedLabelIds) {
					this._toggleInputs[i].setAttribute("aria-labelledby", joinedLabelIds);
				}
				else {
					this._toggleInputs[i].removeAttribute("aria-labelledby");
				}
			}
		}
		else {
			_super.prototype.updateInputControlAriaLabelledBy.call(this);
		}
	};
	ChoiceSetInput.prototype.internalRender = function () {
		var _this = this;
		this._uniqueCategoryName = ChoiceSetInput.getUniqueCategoryName();
		if (this.isMultiSelect) {
			// Render as a list of toggle inputs
			return this.renderCompoundInput("ac-choiceSetInput-multiSelect", "checkbox", this.defaultValue ? this.defaultValue.split(this.hostConfig.choiceSetInputValueSeparator) : undefined);
		}
		else {
			if (this.style === "expanded") {
				// Render as a series of radio buttons
				return this.renderCompoundInput("ac-choiceSetInput-expanded", "radio", this.defaultValue ? [this.defaultValue] : undefined);
			}
			else {
				// Render as a combo box
				this._selectElement = document.createElement("select");
				this._selectElement.className = this.hostConfig.makeCssClassName("ac-input", "ac-multichoiceInput", "ac-choiceSetInput-compact");
				this._selectElement.style.width = "100%";
				var option = document.createElement("option");
				option.selected = true;
				option.disabled = true;
				option.hidden = true;
				option.value = "";
				if (this.placeholder) {
					option.text = this.placeholder;
				}
				Utils.appendChild(this._selectElement, option);
				for (var _i = 0, _a = this.choices; _i < _a.length; _i++) {
					var choice = _a[_i];
					var option_1 = document.createElement("option");
					option_1.value = choice.value;
					option_1.text = choice.title;
					option_1.setAttribute("aria-label", choice.title);
					if (choice.value == this.defaultValue) {
						option_1.selected = true;
					}
					Utils.appendChild(this._selectElement, option_1);
				}
				this._selectElement.onchange = function () {
					_this.internalApplyAriaCurrent();
					_this.valueChanged();
				};
				this.internalApplyAriaCurrent();
				return this._selectElement;
			}
		}
	};
	ChoiceSetInput.prototype.getJsonTypeName = function () {
		return "Input.ChoiceSet";
	};
	ChoiceSetInput.prototype.focus = function () {
		if (this._toggleInputs && (this.isMultiSelect || this.style === "expanded")) {
			if (this._toggleInputs.length > 0) {
				this._toggleInputs[0].focus();
			}
		}
		else {
			_super.prototype.focus.call(this);
		}
	};
	ChoiceSetInput.prototype.internalValidateProperties = function (context) {
		_super.prototype.internalValidateProperties.call(this, context);
		if (this.choices.length == 0) {
			context.addFailure(this, Enums.ValidationEvent.CollectionCantBeEmpty, strings_1.Strings.errors.choiceSetMustHaveAtLeastOneChoice());
		}
		for (var _i = 0, _a = this.choices; _i < _a.length; _i++) {
			var choice = _a[_i];
			if (!choice.title || !choice.value) {
				context.addFailure(this, Enums.ValidationEvent.PropertyCantBeNull, strings_1.Strings.errors.choiceSetChoicesMustHaveTitleAndValue());
			}
		}
	};
	ChoiceSetInput.prototype.isSet = function () {
		return this.value ? true : false;
	};
	Object.defineProperty(ChoiceSetInput.prototype, "value", {
		get: function () {
			if (!this.isMultiSelect) {
				if (this.isCompact) {
					if (this._selectElement) {
						return this._selectElement.selectedIndex > 0 ? this._selectElement.value : undefined;
					}
					return undefined;
				}
				else {
					if (!this._toggleInputs || this._toggleInputs.length == 0) {
						return undefined;
					}
					for (var _i = 0, _a = this._toggleInputs; _i < _a.length; _i++) {
						var toggleInput = _a[_i];
						if (toggleInput.checked) {
							return toggleInput.value;
						}
					}
					return undefined;
				}
			}
			else {
				if (!this._toggleInputs || this._toggleInputs.length == 0) {
					return undefined;
				}
				var result = "";
				for (var _b = 0, _c = this._toggleInputs; _b < _c.length; _b++) {
					var toggleInput = _c[_b];
					if (toggleInput.checked) {
						if (result != "") {
							result += this.hostConfig.choiceSetInputValueSeparator;
						}
						result += toggleInput.value;
					}
				}
				return result ? result : undefined;
			}
		},
		enumerable: false,
		configurable: true
	});
	ChoiceSetInput.valueProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_0, "value");
	ChoiceSetInput.choicesProperty = new serialization_1.SerializableObjectCollectionProperty(serialization_1.Versions.v1_0, "choices", Choice);
	ChoiceSetInput.styleProperty = new serialization_1.ValueSetProperty(serialization_1.Versions.v1_0, "style", [
		{ value: "compact" },
		{ value: "expanded" }
	], "compact");
	ChoiceSetInput.isMultiSelectProperty = new serialization_1.BoolProperty(serialization_1.Versions.v1_0, "isMultiSelect", false);
	ChoiceSetInput.placeholderProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_0, "placeholder");
	ChoiceSetInput.wrapProperty = new serialization_1.BoolProperty(serialization_1.Versions.v1_2, "wrap", false);
	//#endregion
	ChoiceSetInput.uniqueCategoryCounter = 0;
	__decorate([
		serialization_1.property(ChoiceSetInput.valueProperty)
	], ChoiceSetInput.prototype, "defaultValue", void 0);
	__decorate([
		serialization_1.property(ChoiceSetInput.styleProperty)
	], ChoiceSetInput.prototype, "style", void 0);
	__decorate([
		serialization_1.property(ChoiceSetInput.isMultiSelectProperty)
	], ChoiceSetInput.prototype, "isMultiSelect", void 0);
	__decorate([
		serialization_1.property(ChoiceSetInput.placeholderProperty)
	], ChoiceSetInput.prototype, "placeholder", void 0);
	__decorate([
		serialization_1.property(ChoiceSetInput.wrapProperty)
	], ChoiceSetInput.prototype, "wrap", void 0);
	__decorate([
		serialization_1.property(ChoiceSetInput.choicesProperty)
	], ChoiceSetInput.prototype, "choices", void 0);
	return ChoiceSetInput;
}(Input));
exports.ChoiceSetInput = ChoiceSetInput;
var NumberInput = /** @class */ (function (_super) {
	__extends(NumberInput, _super);
	function NumberInput() {
		return _super !== null && _super.apply(this, arguments) || this;
	}
	NumberInput.prototype.internalRender = function () {
		var _this = this;
		this._numberInputElement = document.createElement("input");
		this._numberInputElement.setAttribute("type", "number");
		if (this.min !== undefined) {
			this._numberInputElement.setAttribute("min", this.min.toString());
		}
		if (this.max !== undefined) {
			this._numberInputElement.setAttribute("max", this.max.toString());
		}
		this._numberInputElement.className = this.hostConfig.makeCssClassName("ac-input", "ac-numberInput");
		this._numberInputElement.style.width = "100%";
		this._numberInputElement.tabIndex = 0;
		if (this.defaultValue !== undefined) {
			this._numberInputElement.valueAsNumber = this.defaultValue;
		}
		if (this.placeholder) {
			this._numberInputElement.placeholder = this.placeholder;
			this._numberInputElement.setAttribute("aria-label", this.placeholder);
		}
		this._numberInputElement.oninput = function () { _this.valueChanged(); };
		return this._numberInputElement;
	};
	NumberInput.prototype.getJsonTypeName = function () {
		return "Input.Number";
	};
	NumberInput.prototype.isSet = function () {
		return this.value !== undefined && !isNaN(this.value);
	};
	NumberInput.prototype.isValid = function () {
		if (this.value === undefined) {
			return !this.isRequired;
		}
		var result = true;
		if (this.min !== undefined) {
			result = result && (this.value >= this.min);
		}
		if (this.max !== undefined) {
			result = result && (this.value <= this.max);
		}
		return result;
	};
	Object.defineProperty(NumberInput.prototype, "value", {
		get: function () {
			return this._numberInputElement ? this._numberInputElement.valueAsNumber : undefined;
		},
		enumerable: false,
		configurable: true
	});
	//#region Schema
	NumberInput.valueProperty = new serialization_1.NumProperty(serialization_1.Versions.v1_0, "value");
	NumberInput.placeholderProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_0, "placeholder");
	NumberInput.minProperty = new serialization_1.NumProperty(serialization_1.Versions.v1_0, "min");
	NumberInput.maxProperty = new serialization_1.NumProperty(serialization_1.Versions.v1_0, "max");
	__decorate([
		serialization_1.property(NumberInput.valueProperty)
	], NumberInput.prototype, "defaultValue", void 0);
	__decorate([
		serialization_1.property(NumberInput.minProperty)
	], NumberInput.prototype, "min", void 0);
	__decorate([
		serialization_1.property(NumberInput.maxProperty)
	], NumberInput.prototype, "max", void 0);
	__decorate([
		serialization_1.property(NumberInput.placeholderProperty)
	], NumberInput.prototype, "placeholder", void 0);
	return NumberInput;
}(Input));
exports.NumberInput = NumberInput;
var DateInput = /** @class */ (function (_super) {
	__extends(DateInput, _super);
	function DateInput() {
		return _super !== null && _super.apply(this, arguments) || this;
	}
	DateInput.prototype.internalRender = function () {
		var _this = this;
		this._dateInputElement = document.createElement("input");
		this._dateInputElement.setAttribute("type", "date");
		if (this.min) {
			this._dateInputElement.setAttribute("min", this.min);
		}
		if (this.max) {
			this._dateInputElement.setAttribute("max", this.max);
		}
		if (this.placeholder) {
			this._dateInputElement.placeholder = this.placeholder;
			this._dateInputElement.setAttribute("aria-label", this.placeholder);
		}
		this._dateInputElement.className = this.hostConfig.makeCssClassName("ac-input", "ac-dateInput");
		this._dateInputElement.style.width = "100%";
		this._dateInputElement.oninput = function () { _this.valueChanged(); };
		if (this.defaultValue) {
			this._dateInputElement.value = this.defaultValue;
		}
		return this._dateInputElement;
	};
	DateInput.prototype.getJsonTypeName = function () {
		return "Input.Date";
	};
	DateInput.prototype.isSet = function () {
		return this.value ? true : false;
	};
	DateInput.prototype.isValid = function () {
		if (!this.value) {
			return !this.isRequired;
		}
		var valueAsDate = new Date(this.value);
		var result = true;
		if (this.min) {
			var minDate = new Date(this.min);
			result = result && (valueAsDate >= minDate);
		}
		if (this.max) {
			var maxDate = new Date(this.max);
			result = result && (valueAsDate <= maxDate);
		}
		return result;
	};
	Object.defineProperty(DateInput.prototype, "value", {
		get: function () {
			return this._dateInputElement ? this._dateInputElement.value : undefined;
		},
		enumerable: false,
		configurable: true
	});
	//#region Schema
	DateInput.valueProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_0, "value");
	DateInput.placeholderProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_0, "placeholder");
	DateInput.minProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_0, "min");
	DateInput.maxProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_0, "max");
	__decorate([
		serialization_1.property(DateInput.valueProperty)
	], DateInput.prototype, "defaultValue", void 0);
	__decorate([
		serialization_1.property(DateInput.minProperty)
	], DateInput.prototype, "min", void 0);
	__decorate([
		serialization_1.property(DateInput.maxProperty)
	], DateInput.prototype, "max", void 0);
	__decorate([
		serialization_1.property(DateInput.placeholderProperty)
	], DateInput.prototype, "placeholder", void 0);
	return DateInput;
}(Input));
exports.DateInput = DateInput;
var TimeProperty = /** @class */ (function (_super) {
	__extends(TimeProperty, _super);
	function TimeProperty(targetVersion, name) {
		var _this = _super.call(this, targetVersion, name, function (sender, property, source, context) {
			var value = source[property.name];
			if (typeof value === "string" && value && /^[0-9]{2}:[0-9]{2}$/.test(value)) {
				return value;
			}
			return undefined;
		}, function (sender, property, target, value, context) {
			context.serializeValue(target, property.name, value);
		}) || this;
		_this.targetVersion = targetVersion;
		_this.name = name;
		return _this;
	}
	return TimeProperty;
}(serialization_1.CustomProperty));
exports.TimeProperty = TimeProperty;
var TimeInput = /** @class */ (function (_super) {
	__extends(TimeInput, _super);
	function TimeInput() {
		return _super !== null && _super.apply(this, arguments) || this;
	}
	TimeInput.convertTimeStringToDate = function (timeString) {
		return new Date("1973-09-04T" + timeString + ":00Z");
	};
	TimeInput.prototype.internalRender = function () {
		var _this = this;
		this._timeInputElement = document.createElement("input");
		this._timeInputElement.setAttribute("type", "time");
		this._timeInputElement.setAttribute("min", this.min);
		this._timeInputElement.setAttribute("max", this.max);
		this._timeInputElement.className = this.hostConfig.makeCssClassName("ac-input", "ac-timeInput");
		this._timeInputElement.style.width = "100%";
		this._timeInputElement.oninput = function () { _this.valueChanged(); };
		if (this.placeholder) {
			this._timeInputElement.placeholder = this.placeholder;
			this._timeInputElement.setAttribute("aria-label", this.placeholder);
		}
		if (this.defaultValue) {
			this._timeInputElement.value = this.defaultValue;
		}
		return this._timeInputElement;
	};
	TimeInput.prototype.getJsonTypeName = function () {
		return "Input.Time";
	};
	TimeInput.prototype.isSet = function () {
		return this.value ? true : false;
	};
	TimeInput.prototype.isValid = function () {
		if (!this.value) {
			return !this.isRequired;
		}
		var valueAsDate = TimeInput.convertTimeStringToDate(this.value);
		var result = true;
		if (this.min) {
			var minDate = TimeInput.convertTimeStringToDate(this.min);
			result = result && (valueAsDate >= minDate);
		}
		if (this.max) {
			var maxDate = TimeInput.convertTimeStringToDate(this.max);
			result = result && (valueAsDate <= maxDate);
		}
		return result;
	};
	Object.defineProperty(TimeInput.prototype, "value", {
		get: function () {
			return this._timeInputElement ? this._timeInputElement.value : undefined;
		},
		enumerable: false,
		configurable: true
	});
	//#region Schema
	TimeInput.valueProperty = new TimeProperty(serialization_1.Versions.v1_0, "value");
	TimeInput.placeholderProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_0, "placeholder");
	TimeInput.minProperty = new TimeProperty(serialization_1.Versions.v1_0, "min");
	TimeInput.maxProperty = new TimeProperty(serialization_1.Versions.v1_0, "max");
	__decorate([
		serialization_1.property(TimeInput.valueProperty)
	], TimeInput.prototype, "defaultValue", void 0);
	__decorate([
		serialization_1.property(TimeInput.minProperty)
	], TimeInput.prototype, "min", void 0);
	__decorate([
		serialization_1.property(TimeInput.maxProperty)
	], TimeInput.prototype, "max", void 0);
	__decorate([
		serialization_1.property(TimeInput.placeholderProperty)
	], TimeInput.prototype, "placeholder", void 0);
	return TimeInput;
}(Input));
exports.TimeInput = TimeInput;
var ActionButton = /** @class */ (function () {
	function ActionButton(action, parentContainerStyle) {
		this._state = 0 /* Normal */;
		this.action = action;
		this._parentContainerStyle = parentContainerStyle;
	}
	ActionButton.prototype.updateCssStyle = function () {
		var _a, _b;
		if (this.action.parent && this.action.renderedElement) {
			var hostConfig = this.action.parent.hostConfig;
			this.action.renderedElement.className = hostConfig.makeCssClassName("ac-pushButton");
			if (this._parentContainerStyle) {
				this.action.renderedElement.classList.add("style-" + this._parentContainerStyle);
			}
			this.action.updateActionButtonCssStyle(this.action.renderedElement, this._state);
			this.action.renderedElement.classList.remove(hostConfig.makeCssClassName("expanded"));
			this.action.renderedElement.classList.remove(hostConfig.makeCssClassName("subdued"));
			switch (this._state) {
				case 1 /* Expanded */:
					this.action.renderedElement.classList.add(hostConfig.makeCssClassName("expanded"));
					break;
				case 2 /* Subdued */:
					this.action.renderedElement.classList.add(hostConfig.makeCssClassName("subdued"));
					break;
			}
			if (this.action.style) {
				if (this.action.style === Enums.ActionStyle.Positive) {
					(_a = this.action.renderedElement.classList).add.apply(_a, hostConfig.makeCssClassNames("primary", "style-positive"));
				}
				else {
					(_b = this.action.renderedElement.classList).add.apply(_b, hostConfig.makeCssClassNames("style-" + this.action.style.toLowerCase()));
				}
			}
		}
	};
	ActionButton.prototype.render = function () {
		var _this = this;
		this.action.render();
		if (this.action.renderedElement) {
			this.action.renderedElement.onclick = function (e) {
				e.preventDefault();
				e.cancelBubble = true;
				_this.click();
			};
			this.updateCssStyle();
		}
	};
	ActionButton.prototype.click = function () {
		if (this.onClick !== undefined) {
			this.onClick(this);
		}
	};
	Object.defineProperty(ActionButton.prototype, "state", {
		get: function () {
			return this._state;
		},
		set: function (value) {
			this._state = value;
			this.updateCssStyle();
		},
		enumerable: false,
		configurable: true
	});
	return ActionButton;
}());
var Action = /** @class */ (function (_super) {
	__extends(Action, _super);
	function Action() {
		//#region Schema
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this.style = Enums.ActionStyle.Default;
		return _this;
	}
	Action.prototype.getDefaultSerializationContext = function () {
		return new SerializationContext();
	};
	Action.prototype.addCssClasses = function (element) {
		// Do nothing in base implementation
	};
	Action.prototype.internalGetReferencedInputs = function () {
		return {};
	};
	Action.prototype.internalPrepareForExecution = function (inputs) {
		// Do nothing in base implementation
	};
	Action.prototype.internalValidateInputs = function (referencedInputs) {
		var result = [];
		if (referencedInputs) {
			for (var _i = 0, _a = Object.keys(referencedInputs); _i < _a.length; _i++) {
				var key = _a[_i];
				var input = referencedInputs[key];
				if (!input.validateValue()) {
					result.push(input);
				}
			}
		}
		return result;
	};
	Action.prototype.shouldSerialize = function (context) {
		return context.actionRegistry.findByName(this.getJsonTypeName()) !== undefined;
	};
	Action.prototype.raiseExecuteActionEvent = function () {
		if (this.onExecute) {
			this.onExecute(this);
		}
		raiseExecuteActionEvent(this);
	};
	Action.prototype.getHref = function () {
		return "";
	};
	Action.prototype.getAriaRole = function () {
		return "button";
	};
	Action.prototype.updateActionButtonCssStyle = function (actionButtonElement, buttonState) {
		if (buttonState === void 0) { buttonState = 0 /* Normal */; }
		// Do nothing in base implementation
	};
	Action.prototype.parse = function (source, context) {
		return _super.prototype.parse.call(this, source, context ? context : new SerializationContext());
	};
	Action.prototype.render = function (baseCssClass) {
		if (baseCssClass === void 0) { baseCssClass = "ac-pushButton"; }
		// Cache hostConfig for perf
		var hostConfig = this.hostConfig;
		var buttonElement = document.createElement("button");
		this.addCssClasses(buttonElement);
		if (this.accessibleTitle) {
			buttonElement.setAttribute("aria-label", this.accessibleTitle);
		}
		else if (this.title) {
			buttonElement.setAttribute("aria-label", this.title);
		}
		if (this.expanded != undefined) {
			buttonElement.setAttribute("aria-expanded", this.expanded.toString());
		}
		buttonElement.type = "button";
		buttonElement.style.display = "flex";
		buttonElement.style.alignItems = "center";
		buttonElement.style.justifyContent = "center";
		buttonElement.setAttribute("role", this.getAriaRole());
		var titleElement = document.createElement("div");
		titleElement.style.overflow = "hidden";
		titleElement.style.textOverflow = "ellipsis";
		if (!(hostConfig.actions.iconPlacement == Enums.ActionIconPlacement.AboveTitle || hostConfig.actions.allowTitleToWrap)) {
			titleElement.style.whiteSpace = "nowrap";
		}
		if (this.title) {
			titleElement.innerText = this.title;
		}
		if (!this.iconUrl) {
			buttonElement.classList.add("noIcon");
			buttonElement.appendChild(titleElement);
		}
		else {
			var iconElement = document.createElement("img");
			iconElement.src = this.iconUrl;
			iconElement.style.width = hostConfig.actions.iconSize + "px";
			iconElement.style.height = hostConfig.actions.iconSize + "px";
			iconElement.style.flex = "0 0 auto";
			if (hostConfig.actions.iconPlacement == Enums.ActionIconPlacement.AboveTitle) {
				buttonElement.classList.add("iconAbove");
				buttonElement.style.flexDirection = "column";
				if (this.title) {
					iconElement.style.marginBottom = "6px";
				}
			}
			else {
				buttonElement.classList.add("iconLeft");
				iconElement.style.maxHeight = "100%";
				if (this.title) {
					iconElement.style.marginRight = "6px";
				}
			}
			buttonElement.appendChild(iconElement);
			buttonElement.appendChild(titleElement);
		}
		this._renderedElement = buttonElement;
	};
	Action.prototype.execute = function () {
		if (this._actionCollection) {
			this._actionCollection.actionExecuted(this);
		}
		this.raiseExecuteActionEvent();
	};
	Action.prototype.prepareForExecution = function () {
		var referencedInputs = this.getReferencedInputs();
		var invalidInputs = this.internalValidateInputs(referencedInputs);
		if (invalidInputs.length > 0) {
			invalidInputs[0].focus();
			return false;
		}
		this.internalPrepareForExecution(referencedInputs);
		return true;
	};
	;
	Action.prototype.remove = function () {
		if (this._actionCollection) {
			return this._actionCollection.removeAction(this);
		}
		return false;
	};
	Action.prototype.getAllInputs = function (processActions) {
		if (processActions === void 0) { processActions = true; }
		return [];
	};
	Action.prototype.getResourceInformation = function () {
		return this.iconUrl ? [{ url: this.iconUrl, mimeType: "image" }] : [];
	};
	Action.prototype.getActionById = function (id) {
		return this.id === id ? this : undefined;
	};
	Action.prototype.getReferencedInputs = function () {
		return this.internalGetReferencedInputs();
	};
	/**
	 * Validates the inputs associated with this action.
	 *
	 * @returns A list of inputs that failed validation, or an empty array if no input failed validation.
	 */
	Action.prototype.validateInputs = function () {
		return this.internalValidateInputs(this.getReferencedInputs());
	};
	Object.defineProperty(Action.prototype, "isPrimary", {
		get: function () {
			return this.style == Enums.ActionStyle.Positive;
		},
		set: function (value) {
			if (value) {
				this.style = Enums.ActionStyle.Positive;
			}
			else {
				if (this.style == Enums.ActionStyle.Positive) {
					this.style = Enums.ActionStyle.Default;
				}
			}
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(Action.prototype, "hostConfig", {
		get: function () {
			return this.parent ? this.parent.hostConfig : host_config_1.defaultHostConfig;
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(Action.prototype, "parent", {
		get: function () {
			return this._parent;
		},
		enumerable: false,
		configurable: true
	});
	Action.titleProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_0, "title");
	Action.iconUrlProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_1, "iconUrl");
	Action.styleProperty = new serialization_1.ValueSetProperty(serialization_1.Versions.v1_2, "style", [
		{ value: Enums.ActionStyle.Default },
		{ value: Enums.ActionStyle.Positive },
		{ value: Enums.ActionStyle.Destructive }
	], Enums.ActionStyle.Default);
	__decorate([
		serialization_1.property(Action.titleProperty)
	], Action.prototype, "title", void 0);
	__decorate([
		serialization_1.property(Action.iconUrlProperty)
	], Action.prototype, "iconUrl", void 0);
	__decorate([
		serialization_1.property(Action.styleProperty)
	], Action.prototype, "style", void 0);
	return Action;
}(card_object_1.CardObject));
exports.Action = Action;
var SubmitActionBase = /** @class */ (function (_super) {
	__extends(SubmitActionBase, _super);
	function SubmitActionBase() {
		//#region Schema
		var _this = _super !== null && _super.apply(this, arguments) || this;
		//#endregion
		_this._isPrepared = false;
		return _this;
	}
	SubmitActionBase.prototype.internalGetReferencedInputs = function () {
		var result = {};
		if (this.associatedInputs !== "none") {
			var current = this.parent;
			var inputs = [];
			while (current) {
				inputs = inputs.concat(current.getAllInputs(false));
				current = current.parent;
			}
			for (var _i = 0, inputs_1 = inputs; _i < inputs_1.length; _i++) {
				var input = inputs_1[_i];
				if (input.id) {
					result[input.id] = input;
				}
			}
		}
		return result;
	};
	SubmitActionBase.prototype.internalPrepareForExecution = function (inputs) {
		if (this._originalData) {
			this._processedData = JSON.parse(JSON.stringify(this._originalData));
		}
		else {
			this._processedData = {};
		}
		if (this._processedData && inputs) {
			for (var _i = 0, _a = Object.keys(inputs); _i < _a.length; _i++) {
				var key = _a[_i];
				var input = inputs[key];
				if (input.id && input.isSet()) {
					this._processedData[input.id] = typeof input.value === "string" ? input.value : input.value.toString();
				}
			}
		}
		this._isPrepared = true;
	};
	Object.defineProperty(SubmitActionBase.prototype, "data", {
		get: function () {
			return this._isPrepared ? this._processedData : this._originalData;
		},
		set: function (value) {
			this._originalData = value;
			this._isPrepared = false;
		},
		enumerable: false,
		configurable: true
	});
	SubmitActionBase.dataProperty = new serialization_1.PropertyDefinition(serialization_1.Versions.v1_0, "data");
	SubmitActionBase.associatedInputsProperty = new serialization_1.CustomProperty(serialization_1.Versions.v1_3, "associatedInputs", function (sender, property, source, context) {
		var value = source[property.name];
		if (value !== undefined && typeof value === "string") {
			return value.toLowerCase() === "none" ? "none" : "auto";
		}
		return undefined;
	}, function (sender, property, target, value, context) {
		context.serializeValue(target, property.name, value);
	});
	__decorate([
		serialization_1.property(SubmitActionBase.dataProperty)
	], SubmitActionBase.prototype, "_originalData", void 0);
	__decorate([
		serialization_1.property(SubmitActionBase.associatedInputsProperty)
	], SubmitActionBase.prototype, "associatedInputs", void 0);
	return SubmitActionBase;
}(Action));
exports.SubmitActionBase = SubmitActionBase;
var SubmitAction = /** @class */ (function (_super) {
	__extends(SubmitAction, _super);
	function SubmitAction() {
		return _super !== null && _super.apply(this, arguments) || this;
	}
	SubmitAction.prototype.getJsonTypeName = function () {
		return SubmitAction.JsonTypeName;
	};
	// Note the "weird" way this field is declared is to work around a breaking
	// change introduced in TS 3.1 wrt d.ts generation. DO NOT CHANGE
	SubmitAction.JsonTypeName = "Action.Submit";
	return SubmitAction;
}(SubmitActionBase));
exports.SubmitAction = SubmitAction;
var ExecuteAction = /** @class */ (function (_super) {
	__extends(ExecuteAction, _super);
	function ExecuteAction() {
		return _super !== null && _super.apply(this, arguments) || this;
	}
	//#endregion
	ExecuteAction.prototype.getJsonTypeName = function () {
		return ExecuteAction.JsonTypeName;
	};
	// Note the "weird" way this field is declared is to work around a breaking
	// change introduced in TS 3.1 wrt d.ts generation. DO NOT CHANGE
	ExecuteAction.JsonTypeName = "Action.Execute";
	//#region Schema
	ExecuteAction.verbProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_4, "verb");
	__decorate([
		serialization_1.property(ExecuteAction.verbProperty)
	], ExecuteAction.prototype, "verb", void 0);
	return ExecuteAction;
}(SubmitActionBase));
exports.ExecuteAction = ExecuteAction;
var OpenUrlAction = /** @class */ (function (_super) {
	__extends(OpenUrlAction, _super);
	function OpenUrlAction() {
		return _super !== null && _super.apply(this, arguments) || this;
	}
	OpenUrlAction.prototype.getJsonTypeName = function () {
		return OpenUrlAction.JsonTypeName;
	};
	OpenUrlAction.prototype.getAriaRole = function () {
		return "link";
	};
	OpenUrlAction.prototype.internalValidateProperties = function (context) {
		_super.prototype.internalValidateProperties.call(this, context);
		if (!this.url) {
			context.addFailure(this, Enums.ValidationEvent.PropertyCantBeNull, strings_1.Strings.errors.propertyMustBeSet("url"));
		}
	};
	OpenUrlAction.prototype.getHref = function () {
		return this.url;
	};
	//#region Schema
	OpenUrlAction.urlProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_0, "url");
	//#endregion
	// Note the "weird" way this field is declared is to work around a breaking
	// change introduced in TS 3.1 wrt d.ts generation. DO NOT CHANGE
	OpenUrlAction.JsonTypeName = "Action.OpenUrl";
	__decorate([
		serialization_1.property(OpenUrlAction.urlProperty)
	], OpenUrlAction.prototype, "url", void 0);
	return OpenUrlAction;
}(Action));
exports.OpenUrlAction = OpenUrlAction;
var ToggleVisibilityAction = /** @class */ (function (_super) {
	__extends(ToggleVisibilityAction, _super);
	function ToggleVisibilityAction() {
		//#region Schema
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this.targetElements = {};
		return _this;
	}
	ToggleVisibilityAction.prototype.updateAriaControlsAttribute = function () {
		// apply aria labels to make it clear which elements this action will toggle
		if (this.targetElements) {
			var elementIds = Object.keys(this.targetElements);
			if (this._renderedElement) {
				if (elementIds.length > 0) {
					this._renderedElement.setAttribute("aria-controls", elementIds.join(" "));
				}
				else {
					this._renderedElement.removeAttribute("aria-controls");
				}
			}
		}
	};
	ToggleVisibilityAction.prototype.internalValidateProperties = function (context) {
		_super.prototype.internalValidateProperties.call(this, context);
		if (!this.targetElements) {
			context.addFailure(this, Enums.ValidationEvent.PropertyCantBeNull, strings_1.Strings.errors.propertyMustBeSet("targetElements"));
		}
	};
	ToggleVisibilityAction.prototype.getJsonTypeName = function () {
		return ToggleVisibilityAction.JsonTypeName;
	};
	ToggleVisibilityAction.prototype.render = function (baseCssClass) {
		if (baseCssClass === void 0) { baseCssClass = "ac-pushButton"; }
		_super.prototype.render.call(this, baseCssClass);
		this.updateAriaControlsAttribute();
	};
	ToggleVisibilityAction.prototype.execute = function () {
		if (this.parent) {
			for (var _i = 0, _a = Object.keys(this.targetElements); _i < _a.length; _i++) {
				var elementId = _a[_i];
				var targetElement = this.parent.getRootElement().getElementById(elementId);
				if (targetElement) {
					if (typeof this.targetElements[elementId] === "boolean") {
						targetElement.isVisible = this.targetElements[elementId];
					}
					else {
						targetElement.isVisible = !targetElement.isVisible;
					}
				}
			}
		}
	};
	ToggleVisibilityAction.prototype.addTargetElement = function (elementId, isVisible) {
		if (isVisible === void 0) { isVisible = undefined; }
		this.targetElements[elementId] = isVisible;
		this.updateAriaControlsAttribute();
	};
	ToggleVisibilityAction.prototype.removeTargetElement = function (elementId) {
		delete this.targetElements[elementId];
		this.updateAriaControlsAttribute();
	};
	ToggleVisibilityAction.targetElementsProperty = new serialization_1.CustomProperty(serialization_1.Versions.v1_2, "targetElements", function (sender, property, source, context) {
		var result = {};
		if (Array.isArray(source[property.name])) {
			for (var _i = 0, _a = source[property.name]; _i < _a.length; _i++) {
				var item = _a[_i];
				if (typeof item === "string") {
					result[item] = undefined;
				}
				else if (typeof item === "object") {
					var elementId = item["elementId"];
					if (typeof elementId === "string") {
						result[elementId] = Utils.parseBool(item["isVisible"]);
					}
				}
			}
		}
		return result;
	}, function (sender, property, target, value, context) {
		var targetElements = [];
		for (var _i = 0, _a = Object.keys(value); _i < _a.length; _i++) {
			var id = _a[_i];
			if (typeof value[id] === "boolean") {
				targetElements.push({
					elementId: id,
					isVisible: value[id]
				});
			}
			else {
				targetElements.push(id);
			}
		}
		context.serializeArray(target, property.name, targetElements);
	}, {}, function (sender) { return {}; });
	//#endregion
	// Note the "weird" way this field is declared is to work around a breaking
	// change introduced in TS 3.1 wrt d.ts generation. DO NOT CHANGE
	ToggleVisibilityAction.JsonTypeName = "Action.ToggleVisibility";
	__decorate([
		serialization_1.property(ToggleVisibilityAction.targetElementsProperty)
	], ToggleVisibilityAction.prototype, "targetElements", void 0);
	return ToggleVisibilityAction;
}(Action));
exports.ToggleVisibilityAction = ToggleVisibilityAction;
var StringWithSubstitutionProperty = /** @class */ (function (_super) {
	__extends(StringWithSubstitutionProperty, _super);
	function StringWithSubstitutionProperty(targetVersion, name) {
		var _this = _super.call(this, targetVersion, name, undefined, function () { return new shared_1.StringWithSubstitutions(); }) || this;
		_this.targetVersion = targetVersion;
		_this.name = name;
		return _this;
	}
	StringWithSubstitutionProperty.prototype.parse = function (sender, source, context) {
		var result = new shared_1.StringWithSubstitutions();
		result.set(Utils.parseString(source[this.name]));
		return result;
	};
	StringWithSubstitutionProperty.prototype.toJSON = function (sender, target, value, context) {
		context.serializeValue(target, this.name, value.getOriginal());
	};
	return StringWithSubstitutionProperty;
}(serialization_1.PropertyDefinition));
var HttpHeader = /** @class */ (function (_super) {
	__extends(HttpHeader, _super);
	//#endregion
	function HttpHeader(name, value) {
		if (name === void 0) { name = ""; }
		if (value === void 0) { value = ""; }
		var _this = _super.call(this) || this;
		_this.name = name;
		_this.value = value;
		return _this;
	}
	HttpHeader.prototype.getSchemaKey = function () {
		return "HttpHeader";
	};
	HttpHeader.prototype.getReferencedInputs = function (inputs, referencedInputs) {
		this._value.getReferencedInputs(inputs, referencedInputs);
	};
	HttpHeader.prototype.prepareForExecution = function (inputs) {
		this._value.substituteInputValues(inputs, shared_1.ContentTypes.applicationXWwwFormUrlencoded);
	};
	Object.defineProperty(HttpHeader.prototype, "value", {
		get: function () {
			return this._value.get();
		},
		set: function (newValue) {
			this._value.set(newValue);
		},
		enumerable: false,
		configurable: true
	});
	//#region Schema
	HttpHeader.nameProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_0, "name");
	HttpHeader.valueProperty = new StringWithSubstitutionProperty(serialization_1.Versions.v1_0, "value");
	__decorate([
		serialization_1.property(HttpHeader.nameProperty)
	], HttpHeader.prototype, "name", void 0);
	__decorate([
		serialization_1.property(HttpHeader.valueProperty)
	], HttpHeader.prototype, "_value", void 0);
	return HttpHeader;
}(serialization_1.SerializableObject));
exports.HttpHeader = HttpHeader;
var HttpAction = /** @class */ (function (_super) {
	__extends(HttpAction, _super);
	function HttpAction() {
		//#region Schema
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this._ignoreInputValidation = false;
		return _this;
	}
	HttpAction.prototype.internalGetReferencedInputs = function () {
		var allInputs = this.parent ? this.parent.getRootElement().getAllInputs() : [];
		var result = {};
		this._url.getReferencedInputs(allInputs, result);
		for (var _i = 0, _a = this.headers; _i < _a.length; _i++) {
			var header = _a[_i];
			header.getReferencedInputs(allInputs, result);
		}
		this._body.getReferencedInputs(allInputs, result);
		return result;
	};
	HttpAction.prototype.internalPrepareForExecution = function (inputs) {
		if (inputs) {
			this._url.substituteInputValues(inputs, shared_1.ContentTypes.applicationXWwwFormUrlencoded);
			var contentType = shared_1.ContentTypes.applicationJson;
			for (var _i = 0, _a = this.headers; _i < _a.length; _i++) {
				var header = _a[_i];
				header.prepareForExecution(inputs);
				if (header.name && header.name.toLowerCase() == "content-type") {
					contentType = header.value;
				}
			}
			this._body.substituteInputValues(inputs, contentType);
		}
	};
	;
	HttpAction.prototype.getJsonTypeName = function () {
		return HttpAction.JsonTypeName;
	};
	HttpAction.prototype.internalValidateProperties = function (context) {
		_super.prototype.internalValidateProperties.call(this, context);
		if (!this.url) {
			context.addFailure(this, Enums.ValidationEvent.PropertyCantBeNull, strings_1.Strings.errors.propertyMustBeSet("url"));
		}
		if (this.headers.length > 0) {
			for (var _i = 0, _a = this.headers; _i < _a.length; _i++) {
				var header = _a[_i];
				if (!header.name) {
					context.addFailure(this, Enums.ValidationEvent.PropertyCantBeNull, strings_1.Strings.errors.actionHttpHeadersMustHaveNameAndValue());
				}
			}
		}
	};
	Object.defineProperty(HttpAction.prototype, "ignoreInputValidation", {
		get: function () {
			return this._ignoreInputValidation;
		},
		set: function (value) {
			this._ignoreInputValidation = value;
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(HttpAction.prototype, "url", {
		get: function () {
			return this._url.get();
		},
		set: function (value) {
			this._url.set(value);
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(HttpAction.prototype, "body", {
		get: function () {
			return this._body.get();
		},
		set: function (value) {
			this._body.set(value);
		},
		enumerable: false,
		configurable: true
	});
	HttpAction.urlProperty = new StringWithSubstitutionProperty(serialization_1.Versions.v1_0, "url");
	HttpAction.bodyProperty = new StringWithSubstitutionProperty(serialization_1.Versions.v1_0, "body");
	HttpAction.methodProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_0, "method");
	HttpAction.headersProperty = new serialization_1.SerializableObjectCollectionProperty(serialization_1.Versions.v1_0, "headers", HttpHeader);
	HttpAction.ignoreInputValidationProperty = new serialization_1.BoolProperty(serialization_1.Versions.v1_3, "ignoreInputValidation", false);
	//#endregion
	// Note the "weird" way this field is declared is to work around a breaking
	// change introduced in TS 3.1 wrt d.ts generation. DO NOT CHANGE
	HttpAction.JsonTypeName = "Action.Http";
	__decorate([
		serialization_1.property(HttpAction.urlProperty)
	], HttpAction.prototype, "_url", void 0);
	__decorate([
		serialization_1.property(HttpAction.bodyProperty)
	], HttpAction.prototype, "_body", void 0);
	__decorate([
		serialization_1.property(HttpAction.methodProperty)
	], HttpAction.prototype, "method", void 0);
	__decorate([
		serialization_1.property(HttpAction.headersProperty)
	], HttpAction.prototype, "headers", void 0);
	__decorate([
		serialization_1.property(HttpAction.ignoreInputValidationProperty)
	], HttpAction.prototype, "_ignoreInputValidation", void 0);
	return HttpAction;
}(Action));
exports.HttpAction = HttpAction;
var ShowCardAction = /** @class */ (function (_super) {
	__extends(ShowCardAction, _super);
	function ShowCardAction() {
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this.card = new InlineAdaptiveCard();
		return _this;
	}
	ShowCardAction.prototype.internalParse = function (source, context) {
		_super.prototype.internalParse.call(this, source, context);
		var jsonCard = source["card"];
		if (jsonCard) {
			this.card.parse(jsonCard, context);
		}
		else {
			context.logParseEvent(this, Enums.ValidationEvent.PropertyCantBeNull, strings_1.Strings.errors.showCardMustHaveCard());
		}
	};
	ShowCardAction.prototype.internalToJSON = function (target, context) {
		_super.prototype.internalToJSON.call(this, target, context);
		if (this.card) {
			context.serializeValue(target, "card", this.card.toJSON(context));
		}
	};
	ShowCardAction.prototype.addCssClasses = function (element) {
		_super.prototype.addCssClasses.call(this, element);
		if (this.parent) {
			element.classList.add(this.parent.hostConfig.makeCssClassName("expandable"));
		}
	};
	ShowCardAction.prototype.raiseExecuteActionEvent = function () {
		if (this.hostConfig.actions.showCard.actionMode === Enums.ShowCardActionMode.Popup) {
			// Only raise the event in Popup mode.
			_super.prototype.raiseExecuteActionEvent.call(this);
		}
	};
	ShowCardAction.prototype.getJsonTypeName = function () {
		return ShowCardAction.JsonTypeName;
	};
	ShowCardAction.prototype.internalValidateProperties = function (context) {
		_super.prototype.internalValidateProperties.call(this, context);
		this.card.internalValidateProperties(context);
	};
	ShowCardAction.prototype.updateActionButtonCssStyle = function (actionButtonElement, buttonState) {
		if (buttonState === void 0) { buttonState = 0 /* Normal */; }
		_super.prototype.updateActionButtonCssStyle.call(this, actionButtonElement);
		if (this.parent) {
			actionButtonElement.classList.add(this.parent.hostConfig.makeCssClassName("expandable"));
			actionButtonElement.setAttribute("aria-expanded", (buttonState === 1 /* Expanded */).toString());
		}
	};
	ShowCardAction.prototype.setParent = function (value) {
		_super.prototype.setParent.call(this, value);
		this.card.setParent(value);
	};
	ShowCardAction.prototype.getAllInputs = function (processActions) {
		if (processActions === void 0) { processActions = true; }
		return this.card.getAllInputs(processActions);
	};
	ShowCardAction.prototype.getResourceInformation = function () {
		return _super.prototype.getResourceInformation.call(this).concat(this.card.getResourceInformation());
	};
	ShowCardAction.prototype.getActionById = function (id) {
		var result = _super.prototype.getActionById.call(this, id);
		if (!result) {
			result = this.card.getActionById(id);
		}
		return result;
	};
	// Note the "weird" way this field is declared is to work around a breaking
	// change introduced in TS 3.1 wrt d.ts generation. DO NOT CHANGE
	ShowCardAction.JsonTypeName = "Action.ShowCard";
	return ShowCardAction;
}(Action));
exports.ShowCardAction = ShowCardAction;
var ActionCollection = /** @class */ (function () {
	function ActionCollection(owner) {
		this._renderedActionCount = 0;
		this.items = [];
		this.buttons = [];
		this._owner = owner;
	}
	ActionCollection.prototype.isActionAllowed = function (action) {
		var forbiddenTypes = this._owner.getForbiddenActionTypes();
		if (forbiddenTypes) {
			for (var _i = 0, forbiddenTypes_1 = forbiddenTypes; _i < forbiddenTypes_1.length; _i++) {
				var forbiddenType = forbiddenTypes_1[_i];
				if (action.constructor === forbiddenType) {
					return false;
				}
			}
		}
		return true;
	};
	ActionCollection.prototype.refreshContainer = function () {
		this._actionCardContainer.innerHTML = "";
		if (!this._actionCard) {
			this._actionCardContainer.style.marginTop = "0px";
			return;
		}
		this._actionCardContainer.style.marginTop = this._renderedActionCount > 0 ? this._owner.hostConfig.actions.showCard.inlineTopMargin + "px" : "0px";
		var padding = this._owner.getEffectivePadding();
		this._owner.getImmediateSurroundingPadding(padding);
		var physicalPadding = this._owner.hostConfig.paddingDefinitionToSpacingDefinition(padding);
		if (this._actionCard) {
			this._actionCard.style.paddingLeft = physicalPadding.left + "px";
			this._actionCard.style.paddingRight = physicalPadding.right + "px";
			this._actionCard.style.marginLeft = "-" + physicalPadding.left + "px";
			this._actionCard.style.marginRight = "-" + physicalPadding.right + "px";
			if (physicalPadding.bottom != 0 && !this._owner.isDesignMode()) {
				this._actionCard.style.paddingBottom = physicalPadding.bottom + "px";
				this._actionCard.style.marginBottom = "-" + physicalPadding.bottom + "px";
			}
			Utils.appendChild(this._actionCardContainer, this._actionCard);
		}
	};
	ActionCollection.prototype.layoutChanged = function () {
		this._owner.getRootElement().updateLayout();
	};
	ActionCollection.prototype.showActionCard = function (action, suppressStyle, raiseEvent) {
		if (suppressStyle === void 0) { suppressStyle = false; }
		if (raiseEvent === void 0) { raiseEvent = true; }
		action.card.suppressStyle = suppressStyle;
		// Always re-render a ShowCard action in design mode; reuse already rendered ShowCard (if available) otherwise
		var renderedCard = action.card.renderedElement && !this._owner.isDesignMode() ? action.card.renderedElement : action.card.render();
		this._actionCard = renderedCard;
		this._expandedAction = action;
		this.refreshContainer();
		if (raiseEvent) {
			this.layoutChanged();
			raiseInlineCardExpandedEvent(action, true);
		}
	};
	ActionCollection.prototype.collapseExpandedAction = function () {
		for (var _i = 0, _a = this.buttons; _i < _a.length; _i++) {
			var button = _a[_i];
			button.state = 0 /* Normal */;
		}
		var previouslyExpandedAction = this._expandedAction;
		this._expandedAction = undefined;
		this._actionCard = undefined;
		this.refreshContainer();
		if (previouslyExpandedAction) {
			this.layoutChanged();
			raiseInlineCardExpandedEvent(previouslyExpandedAction, false);
		}
	};
	ActionCollection.prototype.expandShowCardAction = function (action, raiseEvent) {
		for (var _i = 0, _a = this.buttons; _i < _a.length; _i++) {
			var button = _a[_i];
			if (button.action !== action) {
				button.state = 2 /* Subdued */;
			}
			else {
				button.state = 1 /* Expanded */;
			}
		}
		this.showActionCard(action, !(this._owner.isAtTheVeryLeft() && this._owner.isAtTheVeryRight()), raiseEvent);
	};
	ActionCollection.prototype.getParentContainer = function () {
		if (this._owner instanceof Container) {
			return this._owner;
		}
		else {
			return this._owner.getParentContainer();
		}
	};
	ActionCollection.prototype.findActionButton = function (action) {
		for (var _i = 0, _a = this.buttons; _i < _a.length; _i++) {
			var actionButton = _a[_i];
			if (actionButton.action == action) {
				return actionButton;
			}
		}
		return undefined;
	};
	ActionCollection.prototype.actionExecuted = function (action) {
		if (!(action instanceof ShowCardAction)) {
			this.collapseExpandedAction();
		}
		else {
			if (action === this._expandedAction) {
				this.collapseExpandedAction();
			}
			else {
				this.expandShowCardAction(action, true);
			}
		}
	};
	ActionCollection.prototype.parse = function (source, context) {
		this.clear();
		if (Array.isArray(source)) {
			for (var _i = 0, source_1 = source; _i < source_1.length; _i++) {
				var jsonAction = source_1[_i];
				var action = context.parseAction(this._owner, jsonAction, [], !this._owner.isDesignMode());
				if (action) {
					this.addAction(action);
				}
			}
		}
	};
	ActionCollection.prototype.toJSON = function (target, propertyName, context) {
		context.serializeArray(target, propertyName, this.items);
	};
	ActionCollection.prototype.getActionById = function (id) {
		var result = undefined;
		for (var _i = 0, _a = this.items; _i < _a.length; _i++) {
			var item = _a[_i];
			result = item.getActionById(id);
			if (result) {
				break;
			}
		}
		return result;
	};
	ActionCollection.prototype.validateProperties = function (context) {
		if (this._owner.hostConfig.actions.maxActions && this.items.length > this._owner.hostConfig.actions.maxActions) {
			context.addFailure(this._owner, Enums.ValidationEvent.TooManyActions, strings_1.Strings.errors.tooManyActions(this._owner.hostConfig.actions.maxActions));
		}
		if (this.items.length > 0 && !this._owner.hostConfig.supportsInteractivity) {
			context.addFailure(this._owner, Enums.ValidationEvent.InteractivityNotAllowed, strings_1.Strings.errors.interactivityNotAllowed());
		}
		for (var _i = 0, _a = this.items; _i < _a.length; _i++) {
			var item = _a[_i];
			if (!this.isActionAllowed(item)) {
				context.addFailure(this._owner, Enums.ValidationEvent.ActionTypeNotAllowed, strings_1.Strings.errors.actionTypeNotAllowed(item.getJsonTypeName()));
			}
			item.internalValidateProperties(context);
		}
	};
	ActionCollection.prototype.render = function (orientation, isDesignMode) {
		// Cache hostConfig for better perf
		var hostConfig = this._owner.hostConfig;
		if (!hostConfig.supportsInteractivity) {
			return undefined;
		}
		var element = document.createElement("div");
		var maxActions = hostConfig.actions.maxActions ? Math.min(hostConfig.actions.maxActions, this.items.length) : this.items.length;
		this._actionCardContainer = document.createElement("div");
		this._renderedActionCount = 0;
		if (hostConfig.actions.preExpandSingleShowCardAction && maxActions == 1 && this.items[0] instanceof ShowCardAction && this.isActionAllowed(this.items[0])) {
			this.showActionCard(this.items[0], true);
			this._renderedActionCount = 1;
		}
		else {
			var buttonStrip = document.createElement("div");
			buttonStrip.className = hostConfig.makeCssClassName("ac-actionSet");
			buttonStrip.style.display = "flex";
			buttonStrip.setAttribute("role", "menubar");
			if (orientation == Enums.Orientation.Horizontal) {
				buttonStrip.style.flexDirection = "row";
				if (this._owner.horizontalAlignment && hostConfig.actions.actionAlignment != Enums.ActionAlignment.Stretch) {
					switch (this._owner.horizontalAlignment) {
						case Enums.HorizontalAlignment.Center:
							buttonStrip.style.justifyContent = "center";
							break;
						case Enums.HorizontalAlignment.Right:
							buttonStrip.style.justifyContent = "flex-end";
							break;
						default:
							buttonStrip.style.justifyContent = "flex-start";
							break;
					}
				}
				else {
					switch (hostConfig.actions.actionAlignment) {
						case Enums.ActionAlignment.Center:
							buttonStrip.style.justifyContent = "center";
							break;
						case Enums.ActionAlignment.Right:
							buttonStrip.style.justifyContent = "flex-end";
							break;
						default:
							buttonStrip.style.justifyContent = "flex-start";
							break;
					}
				}
			}
			else {
				buttonStrip.style.flexDirection = "column";
				if (this._owner.horizontalAlignment && hostConfig.actions.actionAlignment != Enums.ActionAlignment.Stretch) {
					switch (this._owner.horizontalAlignment) {
						case Enums.HorizontalAlignment.Center:
							buttonStrip.style.alignItems = "center";
							break;
						case Enums.HorizontalAlignment.Right:
							buttonStrip.style.alignItems = "flex-end";
							break;
						default:
							buttonStrip.style.alignItems = "flex-start";
							break;
					}
				}
				else {
					switch (hostConfig.actions.actionAlignment) {
						case Enums.ActionAlignment.Center:
							buttonStrip.style.alignItems = "center";
							break;
						case Enums.ActionAlignment.Right:
							buttonStrip.style.alignItems = "flex-end";
							break;
						case Enums.ActionAlignment.Stretch:
							buttonStrip.style.alignItems = "stretch";
							break;
						default:
							buttonStrip.style.alignItems = "flex-start";
							break;
					}
				}
			}
			var parentContainer = this.getParentContainer();
			if (parentContainer) {
				var parentContainerStyle = parentContainer.getEffectiveStyle();
				var allowedActions = this.items.filter(this.isActionAllowed.bind(this));
				for (var i = 0; i < allowedActions.length; i++) {
					var actionButton = this.findActionButton(allowedActions[i]);
					if (!actionButton) {
						actionButton = new ActionButton(allowedActions[i], parentContainerStyle);
						actionButton.onClick = function (ab) { ab.action.execute(); };
						this.buttons.push(actionButton);
					}
					actionButton.render();
					if (actionButton.action.renderedElement) {
						if (allowedActions.length > 1) {
							actionButton.action.renderedElement.setAttribute("aria-posinset", (i + 1).toString());
							actionButton.action.renderedElement.setAttribute("aria-setsize", allowedActions.length.toString());
							actionButton.action.renderedElement.setAttribute("role", "menuitem");
						}
						if (hostConfig.actions.actionsOrientation == Enums.Orientation.Horizontal && hostConfig.actions.actionAlignment == Enums.ActionAlignment.Stretch) {
							actionButton.action.renderedElement.style.flex = "0 1 100%";
						}
						else {
							actionButton.action.renderedElement.style.flex = "0 1 auto";
						}
						buttonStrip.appendChild(actionButton.action.renderedElement);
						this._renderedActionCount++;
						if (this._renderedActionCount >= hostConfig.actions.maxActions || i == this.items.length - 1) {
							break;
						}
						else if (hostConfig.actions.buttonSpacing > 0) {
							var spacer = document.createElement("div");
							if (orientation === Enums.Orientation.Horizontal) {
								spacer.style.flex = "0 0 auto";
								spacer.style.width = hostConfig.actions.buttonSpacing + "px";
							}
							else {
								spacer.style.height = hostConfig.actions.buttonSpacing + "px";
							}
							Utils.appendChild(buttonStrip, spacer);
						}
					}
				}
			}
			var buttonStripContainer = document.createElement("div");
			buttonStripContainer.style.overflow = "hidden";
			buttonStripContainer.appendChild(buttonStrip);
			Utils.appendChild(element, buttonStripContainer);
		}
		Utils.appendChild(element, this._actionCardContainer);
		for (var _i = 0, _a = this.buttons; _i < _a.length; _i++) {
			var button = _a[_i];
			if (button.state == 1 /* Expanded */) {
				this.expandShowCardAction(button.action, false);
				break;
			}
		}
		return this._renderedActionCount > 0 ? element : undefined;
	};
	ActionCollection.prototype.addAction = function (action) {
		if (!action) {
			throw new Error("The action parameter cannot be null.");
		}
		if ((!action.parent || action.parent === this._owner) && this.items.indexOf(action) < 0) {
			this.items.push(action);
			if (!action.parent) {
				action.setParent(this._owner);
			}
			action["_actionCollection"] = this;
		}
		else {
			throw new Error(strings_1.Strings.errors.actionAlreadyParented());
		}
	};
	ActionCollection.prototype.removeAction = function (action) {
		if (this.expandedAction && this._expandedAction == action) {
			this.collapseExpandedAction();
		}
		var actionIndex = this.items.indexOf(action);
		if (actionIndex >= 0) {
			this.items.splice(actionIndex, 1);
			action.setParent(undefined);
			action["_actionCollection"] = undefined;
			for (var i = 0; i < this.buttons.length; i++) {
				if (this.buttons[i].action == action) {
					this.buttons.splice(i, 1);
					break;
				}
			}
			return true;
		}
		return false;
	};
	ActionCollection.prototype.clear = function () {
		this.items = [];
		this.buttons = [];
		this._expandedAction = undefined;
		this._renderedActionCount = 0;
	};
	ActionCollection.prototype.getAllInputs = function (processActions) {
		if (processActions === void 0) { processActions = true; }
		var result = [];
		if (processActions) {
			for (var _i = 0, _a = this.items; _i < _a.length; _i++) {
				var action = _a[_i];
				result = result.concat(action.getAllInputs());
			}
		}
		return result;
	};
	ActionCollection.prototype.getResourceInformation = function () {
		var result = [];
		for (var _i = 0, _a = this.items; _i < _a.length; _i++) {
			var action = _a[_i];
			result = result.concat(action.getResourceInformation());
		}
		return result;
	};
	Object.defineProperty(ActionCollection.prototype, "renderedActionCount", {
		get: function () {
			return this._renderedActionCount;
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(ActionCollection.prototype, "expandedAction", {
		get: function () {
			return this._expandedAction;
		},
		enumerable: false,
		configurable: true
	});
	return ActionCollection;
}());
var ActionSet = /** @class */ (function (_super) {
	__extends(ActionSet, _super);
	function ActionSet() {
		var _this = _super.call(this) || this;
		_this._actionCollection = new ActionCollection(_this);
		return _this;
	}
	ActionSet.prototype.internalParse = function (source, context) {
		_super.prototype.internalParse.call(this, source, context);
		this._actionCollection.parse(source["actions"], context);
	};
	ActionSet.prototype.internalToJSON = function (target, context) {
		_super.prototype.internalToJSON.call(this, target, context);
		this._actionCollection.toJSON(target, "actions", context);
	};
	ActionSet.prototype.internalRender = function () {
		return this._actionCollection.render(this.orientation !== undefined ? this.orientation : this.hostConfig.actions.actionsOrientation, this.isDesignMode());
	};
	ActionSet.prototype.isBleedingAtBottom = function () {
		if (this._actionCollection.renderedActionCount == 0) {
			return _super.prototype.isBleedingAtBottom.call(this);
		}
		else {
			if (this._actionCollection.items.length == 1) {
				return this._actionCollection.expandedAction !== undefined && !this.hostConfig.actions.preExpandSingleShowCardAction;
			}
			else {
				return this._actionCollection.expandedAction !== undefined;
			}
		}
	};
	ActionSet.prototype.getJsonTypeName = function () {
		return "ActionSet";
	};
	ActionSet.prototype.getActionCount = function () {
		return this._actionCollection.items.length;
	};
	ActionSet.prototype.getActionAt = function (index) {
		if (index >= 0 && index < this.getActionCount()) {
			return this._actionCollection.items[index];
		}
		else {
			return _super.prototype.getActionAt.call(this, index);
		}
	};
	ActionSet.prototype.getActionById = function (id) {
		var result = this._actionCollection.getActionById(id);
		return result ? result : _super.prototype.getActionById.call(this, id);
	};
	ActionSet.prototype.internalValidateProperties = function (context) {
		_super.prototype.internalValidateProperties.call(this, context);
		this._actionCollection.validateProperties(context);
	};
	ActionSet.prototype.addAction = function (action) {
		this._actionCollection.addAction(action);
	};
	ActionSet.prototype.getAllInputs = function (processActions) {
		if (processActions === void 0) { processActions = true; }
		return processActions ? this._actionCollection.getAllInputs() : [];
	};
	ActionSet.prototype.getResourceInformation = function () {
		return this._actionCollection.getResourceInformation();
	};
	/**
	 * @inheritdoc
	 */
	ActionSet.prototype.findDOMNodeOwner = function (node) {
		var target = undefined;
		for (var _i = 0, _a = this._actionCollection.items; _i < _a.length; _i++) {
			var action = _a[_i];
			// recur through each Action
			target = action.findDOMNodeOwner(node);
			if (target) {
				return target;
			}
		}
		// if not found in any Action, defer to parent implementation
		return _super.prototype.findDOMNodeOwner.call(this, node);
	};
	Object.defineProperty(ActionSet.prototype, "isInteractive", {
		get: function () {
			return true;
		},
		enumerable: false,
		configurable: true
	});
	//#region Schema
	ActionSet.orientationProperty = new serialization_1.EnumProperty(serialization_1.Versions.v1_1, "orientation", Enums.Orientation);
	__decorate([
		serialization_1.property(ActionSet.orientationProperty)
	], ActionSet.prototype, "orientation", void 0);
	return ActionSet;
}(CardElement));
exports.ActionSet = ActionSet;
var StylableCardElementContainer = /** @class */ (function (_super) {
	__extends(StylableCardElementContainer, _super);
	function StylableCardElementContainer() {
		//#region Schema
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this._bleed = false;
		return _this;
	}
	Object.defineProperty(StylableCardElementContainer.prototype, "style", {
		get: function () {
			if (this.allowCustomStyle) {
				var style = this.getValue(StylableCardElementContainer.styleProperty);
				if (style && this.hostConfig.containerStyles.getStyleByName(style)) {
					return style;
				}
			}
			return undefined;
		},
		set: function (value) {
			this.setValue(StylableCardElementContainer.styleProperty, value);
		},
		enumerable: false,
		configurable: true
	});
	//#endregion
	StylableCardElementContainer.prototype.adjustRenderedElementSize = function (renderedElement) {
		_super.prototype.adjustRenderedElementSize.call(this, renderedElement);
		if (this.minPixelHeight) {
			renderedElement.style.minHeight = this.minPixelHeight + "px";
		}
	};
	StylableCardElementContainer.prototype.applyBackground = function () {
		if (this.renderedElement) {
			var styleDefinition = this.hostConfig.containerStyles.getStyleByName(this.style, this.hostConfig.containerStyles.getStyleByName(this.defaultStyle));
			if (styleDefinition.backgroundColor) {
				var bgColor = Utils.stringToCssColor(styleDefinition.backgroundColor);
				this.renderedElement.style.backgroundColor = bgColor;
				this.renderedElement.style.border = "1px solid " + bgColor;
			}
		}
	};
	StylableCardElementContainer.prototype.applyPadding = function () {
		_super.prototype.applyPadding.call(this);
		if (!this.renderedElement) {
			return;
		}
		var physicalPadding = new shared_1.SpacingDefinition();
		if (this.getEffectivePadding()) {
			physicalPadding = this.hostConfig.paddingDefinitionToSpacingDefinition(this.getEffectivePadding());
		}
		this.renderedElement.style.paddingTop = physicalPadding.top + "px";
		this.renderedElement.style.paddingRight = physicalPadding.right + "px";
		this.renderedElement.style.paddingBottom = physicalPadding.bottom + "px";
		this.renderedElement.style.paddingLeft = physicalPadding.left + "px";
		if (this.isBleeding()) {
			// Bleed into the first parent that does have padding
			var padding = new shared_1.PaddingDefinition();
			this.getImmediateSurroundingPadding(padding);
			var surroundingPadding = this.hostConfig.paddingDefinitionToSpacingDefinition(padding);
			this.renderedElement.style.marginRight = "-" + surroundingPadding.right + "px";
			this.renderedElement.style.marginLeft = "-" + surroundingPadding.left + "px";
			if (!this.isDesignMode()) {
				this.renderedElement.style.marginTop = "-" + surroundingPadding.top + "px";
				this.renderedElement.style.marginBottom = "-" + surroundingPadding.bottom + "px";
			}
			if (this.separatorElement && this.separatorOrientation == Enums.Orientation.Horizontal) {
				this.separatorElement.style.marginLeft = "-" + surroundingPadding.left + "px";
				this.separatorElement.style.marginRight = "-" + surroundingPadding.right + "px";
			}
		}
		else {
			this.renderedElement.style.marginRight = "0";
			this.renderedElement.style.marginLeft = "0";
			this.renderedElement.style.marginTop = "0";
			this.renderedElement.style.marginBottom = "0";
			if (this.separatorElement && this.separatorOrientation === Enums.Orientation.Horizontal) {
				this.separatorElement.style.marginRight = "0";
				this.separatorElement.style.marginLeft = "0";
			}
		}
	};
	StylableCardElementContainer.prototype.getHasBackground = function () {
		var currentElement = this.parent;
		while (currentElement) {
			var currentElementHasBackgroundImage = currentElement instanceof Container ? currentElement.backgroundImage.isValid() : false;
			if (currentElement instanceof StylableCardElementContainer) {
				if (this.hasExplicitStyle && (currentElement.getEffectiveStyle() != this.getEffectiveStyle() || currentElementHasBackgroundImage)) {
					return true;
				}
			}
			currentElement = currentElement.parent;
		}
		return false;
	};
	StylableCardElementContainer.prototype.getDefaultPadding = function () {
		return this.getHasBackground() ?
			new shared_1.PaddingDefinition(Enums.Spacing.Padding, Enums.Spacing.Padding, Enums.Spacing.Padding, Enums.Spacing.Padding) : _super.prototype.getDefaultPadding.call(this);
	};
	StylableCardElementContainer.prototype.getHasExpandedAction = function () {
		return false;
	};
	StylableCardElementContainer.prototype.getBleed = function () {
		return this._bleed;
	};
	StylableCardElementContainer.prototype.setBleed = function (value) {
		this._bleed = value;
	};
	Object.defineProperty(StylableCardElementContainer.prototype, "renderedActionCount", {
		get: function () {
			return 0;
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(StylableCardElementContainer.prototype, "hasExplicitStyle", {
		get: function () {
			return this.getValue(StylableCardElementContainer.styleProperty) !== undefined;
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(StylableCardElementContainer.prototype, "allowCustomStyle", {
		get: function () {
			return true;
		},
		enumerable: false,
		configurable: true
	});
	StylableCardElementContainer.prototype.isBleeding = function () {
		return (this.getHasBackground() || this.hostConfig.alwaysAllowBleed) && this.getBleed();
	};
	StylableCardElementContainer.prototype.internalValidateProperties = function (context) {
		_super.prototype.internalValidateProperties.call(this, context);
		var explicitStyle = this.getValue(StylableCardElementContainer.styleProperty);
		if (explicitStyle !== undefined) {
			var styleDefinition = this.hostConfig.containerStyles.getStyleByName(explicitStyle);
			if (!styleDefinition) {
				context.addFailure(this, Enums.ValidationEvent.InvalidPropertyValue, strings_1.Strings.errors.invalidPropertyValue(explicitStyle, "style"));
			}
		}
	};
	StylableCardElementContainer.prototype.render = function () {
		var renderedElement = _super.prototype.render.call(this);
		if (renderedElement && this.getHasBackground()) {
			this.applyBackground();
		}
		return renderedElement;
	};
	StylableCardElementContainer.prototype.getEffectiveStyle = function () {
		var effectiveStyle = this.style;
		return effectiveStyle ? effectiveStyle : _super.prototype.getEffectiveStyle.call(this);
	};
	StylableCardElementContainer.styleProperty = new serialization_1.ValueSetProperty(serialization_1.Versions.v1_0, "style", [
		{ value: Enums.ContainerStyle.Default },
		{ value: Enums.ContainerStyle.Emphasis },
		{ targetVersion: serialization_1.Versions.v1_2, value: Enums.ContainerStyle.Accent },
		{ targetVersion: serialization_1.Versions.v1_2, value: Enums.ContainerStyle.Good },
		{ targetVersion: serialization_1.Versions.v1_2, value: Enums.ContainerStyle.Attention },
		{ targetVersion: serialization_1.Versions.v1_2, value: Enums.ContainerStyle.Warning }
	]);
	StylableCardElementContainer.bleedProperty = new serialization_1.BoolProperty(serialization_1.Versions.v1_2, "bleed", false);
	StylableCardElementContainer.minHeightProperty = new serialization_1.PixelSizeProperty(serialization_1.Versions.v1_2, "minHeight");
	__decorate([
		serialization_1.property(StylableCardElementContainer.styleProperty)
	], StylableCardElementContainer.prototype, "style", null);
	__decorate([
		serialization_1.property(StylableCardElementContainer.bleedProperty)
	], StylableCardElementContainer.prototype, "_bleed", void 0);
	__decorate([
		serialization_1.property(StylableCardElementContainer.minHeightProperty)
	], StylableCardElementContainer.prototype, "minPixelHeight", void 0);
	return StylableCardElementContainer;
}(CardElementContainer));
exports.StylableCardElementContainer = StylableCardElementContainer;
var BackgroundImage = /** @class */ (function (_super) {
	__extends(BackgroundImage, _super);
	function BackgroundImage() {
		return _super !== null && _super.apply(this, arguments) || this;
	}
	//#endregion
	BackgroundImage.prototype.getSchemaKey = function () {
		return "BackgroundImage";
	};
	BackgroundImage.prototype.internalParse = function (source, context) {
		if (typeof source === "string") {
			this.resetDefaultValues();
			this.url = source;
		}
		else {
			return _super.prototype.internalParse.call(this, source, context);
		}
	};
	BackgroundImage.prototype.apply = function (element) {
		if (this.url && element.renderedElement) {
			element.renderedElement.style.backgroundImage = "url('" + element.preProcessPropertyValue(BackgroundImage.urlProperty, this.url) + "')";
			switch (this.fillMode) {
				case Enums.FillMode.Repeat:
					element.renderedElement.style.backgroundRepeat = "repeat";
					break;
				case Enums.FillMode.RepeatHorizontally:
					element.renderedElement.style.backgroundRepeat = "repeat-x";
					break;
				case Enums.FillMode.RepeatVertically:
					element.renderedElement.style.backgroundRepeat = "repeat-y";
					break;
				case Enums.FillMode.Cover:
				default:
					element.renderedElement.style.backgroundRepeat = "no-repeat";
					element.renderedElement.style.backgroundSize = "cover";
					break;
			}
			switch (this.horizontalAlignment) {
				case Enums.HorizontalAlignment.Center:
					element.renderedElement.style.backgroundPositionX = "center";
					break;
				case Enums.HorizontalAlignment.Right:
					element.renderedElement.style.backgroundPositionX = "right";
					break;
			}
			switch (this.verticalAlignment) {
				case Enums.VerticalAlignment.Center:
					element.renderedElement.style.backgroundPositionY = "center";
					break;
				case Enums.VerticalAlignment.Bottom:
					element.renderedElement.style.backgroundPositionY = "bottom";
					break;
			}
		}
	};
	BackgroundImage.prototype.isValid = function () {
		return this.url ? true : false;
	};
	//#region Schema
	BackgroundImage.urlProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_0, "url");
	BackgroundImage.fillModeProperty = new serialization_1.EnumProperty(serialization_1.Versions.v1_2, "fillMode", Enums.FillMode, Enums.FillMode.Cover);
	BackgroundImage.horizontalAlignmentProperty = new serialization_1.EnumProperty(serialization_1.Versions.v1_2, "horizontalAlignment", Enums.HorizontalAlignment, Enums.HorizontalAlignment.Left);
	BackgroundImage.verticalAlignmentProperty = new serialization_1.EnumProperty(serialization_1.Versions.v1_2, "verticalAlignment", Enums.VerticalAlignment, Enums.VerticalAlignment.Top);
	__decorate([
		serialization_1.property(BackgroundImage.urlProperty)
	], BackgroundImage.prototype, "url", void 0);
	__decorate([
		serialization_1.property(BackgroundImage.fillModeProperty)
	], BackgroundImage.prototype, "fillMode", void 0);
	__decorate([
		serialization_1.property(BackgroundImage.horizontalAlignmentProperty)
	], BackgroundImage.prototype, "horizontalAlignment", void 0);
	__decorate([
		serialization_1.property(BackgroundImage.verticalAlignmentProperty)
	], BackgroundImage.prototype, "verticalAlignment", void 0);
	return BackgroundImage;
}(serialization_1.SerializableObject));
exports.BackgroundImage = BackgroundImage;
var Container = /** @class */ (function (_super) {
	__extends(Container, _super);
	function Container() {
		//#region Schema
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this.verticalContentAlignment = Enums.VerticalAlignment.Top;
		//#endregion
		_this._items = [];
		_this._renderedItems = [];
		return _this;
	}
	Object.defineProperty(Container.prototype, "backgroundImage", {
		get: function () {
			return this.getValue(Container.backgroundImageProperty);
		},
		enumerable: false,
		configurable: true
	});
	Container.prototype.insertItemAt = function (item, index, forceInsert) {
		if (!item.parent || forceInsert) {
			if (item.isStandalone) {
				if (index < 0 || index >= this._items.length) {
					this._items.push(item);
				}
				else {
					this._items.splice(index, 0, item);
				}
				item.setParent(this);
			}
			else {
				throw new Error(strings_1.Strings.errors.elementTypeNotStandalone(item.getJsonTypeName()));
			}
		}
		else {
			throw new Error(strings_1.Strings.errors.elementAlreadyParented());
		}
	};
	Container.prototype.supportsExcplitiHeight = function () {
		return true;
	};
	Container.prototype.getItemsCollectionPropertyName = function () {
		return "items";
	};
	Container.prototype.applyBackground = function () {
		if (this.backgroundImage.isValid() && this.renderedElement) {
			this.backgroundImage.apply(this);
		}
		_super.prototype.applyBackground.call(this);
	};
	Container.prototype.internalRender = function () {
		this._renderedItems = [];
		// Cache hostConfig to avoid walking the parent hierarchy several times
		var hostConfig = this.hostConfig;
		var element = document.createElement("div");
		if (this.rtl !== undefined && this.rtl) {
			element.dir = "rtl";
		}
		element.classList.add(hostConfig.makeCssClassName("ac-container"));
		element.style.display = "flex";
		element.style.flexDirection = "column";
		if (shared_1.GlobalSettings.useAdvancedCardBottomTruncation) {
			// Forces the container to be at least as tall as its content.
			//
			// Fixes a quirk in Chrome where, for nested flex elements, the
			// inner element's height would never exceed the outer element's
			// height. This caused overflow truncation to break -- containers
			// would always be measured as not overflowing, since their heights
			// were constrained by their parents as opposed to truly reflecting
			// the height of their content.
			//
			// See the "Browser Rendering Notes" section of this answer:
			// https://stackoverflow.com/questions/36247140/why-doesnt-flex-item-shrink-past-content-size
			element.style.minHeight = '-webkit-min-content';
		}
		switch (this.verticalContentAlignment) {
			case Enums.VerticalAlignment.Center:
				element.style.justifyContent = "center";
				break;
			case Enums.VerticalAlignment.Bottom:
				element.style.justifyContent = "flex-end";
				break;
			default:
				element.style.justifyContent = "flex-start";
				break;
		}
		if (this._items.length > 0) {
			for (var _i = 0, _a = this._items; _i < _a.length; _i++) {
				var item = _a[_i];
				var renderedItem = this.isElementAllowed(item) ? item.render() : undefined;
				if (renderedItem) {
					if (this._renderedItems.length > 0 && item.separatorElement) {
						item.separatorElement.style.flex = "0 0 auto";
						Utils.appendChild(element, item.separatorElement);
					}
					Utils.appendChild(element, renderedItem);
					this._renderedItems.push(item);
				}
			}
		}
		else {
			if (this.isDesignMode()) {
				var placeholderElement = this.createPlaceholderElement();
				placeholderElement.style.width = "100%";
				placeholderElement.style.height = "100%";
				element.appendChild(placeholderElement);
			}
		}
		return element;
	};
	Container.prototype.truncateOverflow = function (maxHeight) {
		if (this.renderedElement) {
			// Add 1 to account for rounding differences between browsers
			var boundary_1 = this.renderedElement.offsetTop + maxHeight + 1;
			var handleElement_1 = function (cardElement) {
				var elt = cardElement.renderedElement;
				if (elt) {
					switch (Utils.getFitStatus(elt, boundary_1)) {
						case Enums.ContainerFitStatus.FullyInContainer:
							var sizeChanged = cardElement['resetOverflow']();
							// If the element's size changed after resetting content,
							// we have to check if it still fits fully in the card
							if (sizeChanged) {
								handleElement_1(cardElement);
							}
							break;
						case Enums.ContainerFitStatus.Overflowing:
							var maxHeight_1 = boundary_1 - elt.offsetTop;
							cardElement['handleOverflow'](maxHeight_1);
							break;
						case Enums.ContainerFitStatus.FullyOutOfContainer:
							cardElement['handleOverflow'](0);
							break;
					}
				}
			};
			for (var _i = 0, _a = this._items; _i < _a.length; _i++) {
				var item = _a[_i];
				handleElement_1(item);
			}
			return true;
		}
		return false;
	};
	Container.prototype.undoOverflowTruncation = function () {
		for (var _i = 0, _a = this._items; _i < _a.length; _i++) {
			var item = _a[_i];
			item['resetOverflow']();
		}
	};
	Container.prototype.getHasBackground = function () {
		return this.backgroundImage.isValid() || _super.prototype.getHasBackground.call(this);
	};
	Container.prototype.internalParse = function (source, context) {
		_super.prototype.internalParse.call(this, source, context);
		this.clear();
		this.setShouldFallback(false);
		var jsonItems = source[this.getItemsCollectionPropertyName()];
		if (Array.isArray(jsonItems)) {
			for (var _i = 0, jsonItems_1 = jsonItems; _i < jsonItems_1.length; _i++) {
				var item = jsonItems_1[_i];
				var element = context.parseElement(this, item, !this.isDesignMode());
				if (element) {
					this.insertItemAt(element, -1, true);
				}
			}
		}
	};
	Container.prototype.internalToJSON = function (target, context) {
		_super.prototype.internalToJSON.call(this, target, context);
		context.serializeArray(target, this.getItemsCollectionPropertyName(), this._items);
	};
	Object.defineProperty(Container.prototype, "isSelectable", {
		get: function () {
			return true;
		},
		enumerable: false,
		configurable: true
	});
	Container.prototype.getItemCount = function () {
		return this._items.length;
	};
	Container.prototype.getItemAt = function (index) {
		return this._items[index];
	};
	Container.prototype.getFirstVisibleRenderedItem = function () {
		if (this.renderedElement && this._renderedItems && this._renderedItems.length > 0) {
			for (var _i = 0, _a = this._renderedItems; _i < _a.length; _i++) {
				var item = _a[_i];
				if (item.isVisible) {
					return item;
				}
			}
			;
		}
		return undefined;
	};
	Container.prototype.getLastVisibleRenderedItem = function () {
		if (this.renderedElement && this._renderedItems && this._renderedItems.length > 0) {
			for (var i = this._renderedItems.length - 1; i >= 0; i--) {
				if (this._renderedItems[i].isVisible) {
					return this._renderedItems[i];
				}
			}
		}
		return undefined;
	};
	Container.prototype.getJsonTypeName = function () {
		return "Container";
	};
	Container.prototype.isFirstElement = function (element) {
		var designMode = this.isDesignMode();
		for (var _i = 0, _a = this._items; _i < _a.length; _i++) {
			var item = _a[_i];
			if (item.isVisible || designMode) {
				return item == element;
			}
		}
		return false;
	};
	Container.prototype.isLastElement = function (element) {
		var designMode = this.isDesignMode();
		for (var i = this._items.length - 1; i >= 0; i--) {
			if (this._items[i].isVisible || designMode) {
				return this._items[i] == element;
			}
		}
		return false;
	};
	Container.prototype.isRtl = function () {
		if (this.rtl !== undefined) {
			return this.rtl;
		}
		else {
			var parentContainer = this.getParentContainer();
			return parentContainer ? parentContainer.isRtl() : false;
		}
	};
	Container.prototype.isBleedingAtTop = function () {
		var firstRenderedItem = this.getFirstVisibleRenderedItem();
		return this.isBleeding() || (firstRenderedItem ? firstRenderedItem.isBleedingAtTop() : false);
	};
	Container.prototype.isBleedingAtBottom = function () {
		var lastRenderedItem = this.getLastVisibleRenderedItem();
		return this.isBleeding() || (lastRenderedItem ? lastRenderedItem.isBleedingAtBottom() && lastRenderedItem.getEffectiveStyle() == this.getEffectiveStyle() : false);
	};
	Container.prototype.indexOf = function (cardElement) {
		return this._items.indexOf(cardElement);
	};
	Container.prototype.addItem = function (item) {
		this.insertItemAt(item, -1, false);
	};
	Container.prototype.insertItemBefore = function (item, insertBefore) {
		this.insertItemAt(item, this._items.indexOf(insertBefore), false);
	};
	Container.prototype.insertItemAfter = function (item, insertAfter) {
		this.insertItemAt(item, this._items.indexOf(insertAfter) + 1, false);
	};
	Container.prototype.removeItem = function (item) {
		var itemIndex = this._items.indexOf(item);
		if (itemIndex >= 0) {
			this._items.splice(itemIndex, 1);
			item.setParent(undefined);
			this.updateLayout();
			return true;
		}
		return false;
	};
	Container.prototype.clear = function () {
		this._items = [];
		this._renderedItems = [];
	};
	Container.prototype.getResourceInformation = function () {
		var result = _super.prototype.getResourceInformation.call(this);
		if (this.backgroundImage.isValid()) {
			result.push({
				url: this.backgroundImage.url,
				mimeType: "image"
			});
		}
		return result;
	};
	Container.prototype.getActionById = function (id) {
		var result = _super.prototype.getActionById.call(this, id);
		if (!result) {
			if (this.selectAction) {
				result = this.selectAction.getActionById(id);
			}
			if (!result) {
				for (var _i = 0, _a = this._items; _i < _a.length; _i++) {
					var item = _a[_i];
					result = item.getActionById(id);
					if (result) {
						break;
					}
				}
			}
		}
		return result;
	};
	Object.defineProperty(Container.prototype, "padding", {
		get: function () {
			return this.getPadding();
		},
		set: function (value) {
			this.setPadding(value);
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(Container.prototype, "selectAction", {
		get: function () {
			return this._selectAction;
		},
		set: function (value) {
			this._selectAction = value;
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(Container.prototype, "bleed", {
		get: function () {
			return this.getBleed();
		},
		set: function (value) {
			this.setBleed(value);
		},
		enumerable: false,
		configurable: true
	});
	Container.backgroundImageProperty = new serialization_1.SerializableObjectProperty(serialization_1.Versions.v1_0, "backgroundImage", BackgroundImage);
	Container.verticalContentAlignmentProperty = new serialization_1.EnumProperty(serialization_1.Versions.v1_1, "verticalContentAlignment", Enums.VerticalAlignment, Enums.VerticalAlignment.Top);
	Container.rtlProperty = new serialization_1.BoolProperty(serialization_1.Versions.v1_0, "rtl");
	__decorate([
		serialization_1.property(Container.backgroundImageProperty)
	], Container.prototype, "backgroundImage", null);
	__decorate([
		serialization_1.property(Container.verticalContentAlignmentProperty)
	], Container.prototype, "verticalContentAlignment", void 0);
	__decorate([
		serialization_1.property(Container.rtlProperty)
	], Container.prototype, "rtl", void 0);
	return Container;
}(StylableCardElementContainer));
exports.Container = Container;
var Column = /** @class */ (function (_super) {
	__extends(Column, _super);
	function Column(width) {
		if (width === void 0) { width = "stretch"; }
		var _this = _super.call(this) || this;
		_this.width = "stretch";
		//#endregion
		_this._computedWeight = 0;
		_this.width = width;
		return _this;
	}
	Column.prototype.adjustRenderedElementSize = function (renderedElement) {
		var minDesignTimeColumnHeight = 20;
		if (this.isDesignMode()) {
			renderedElement.style.minWidth = "20px";
			renderedElement.style.minHeight = (!this.minPixelHeight ? minDesignTimeColumnHeight : Math.max(this.minPixelHeight, minDesignTimeColumnHeight)) + "px";
		}
		else {
			renderedElement.style.minWidth = "0";
			if (this.minPixelHeight) {
				renderedElement.style.minHeight = this.minPixelHeight + "px";
			}
		}
		if (this.width === "auto") {
			renderedElement.style.flex = "0 1 auto";
		}
		else if (this.width === "stretch") {
			renderedElement.style.flex = "1 1 50px";
		}
		else if (this.width instanceof shared_1.SizeAndUnit) {
			if (this.width.unit == Enums.SizeUnit.Pixel) {
				renderedElement.style.flex = "0 0 auto";
				renderedElement.style.width = this.width.physicalSize + "px";
			}
			else {
				renderedElement.style.flex = "1 1 " + (this._computedWeight > 0 ? this._computedWeight : this.width.physicalSize) + "%";
			}
		}
	};
	Column.prototype.shouldSerialize = function (context) {
		return true;
	};
	Object.defineProperty(Column.prototype, "separatorOrientation", {
		get: function () {
			return Enums.Orientation.Vertical;
		},
		enumerable: false,
		configurable: true
	});
	Column.prototype.getJsonTypeName = function () {
		return "Column";
	};
	Object.defineProperty(Column.prototype, "hasVisibleSeparator", {
		get: function () {
			if (this.parent && this.parent instanceof ColumnSet) {
				return this.separatorElement !== undefined && !this.parent.isLeftMostElement(this);
			}
			else {
				return false;
			}
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(Column.prototype, "isStandalone", {
		get: function () {
			return false;
		},
		enumerable: false,
		configurable: true
	});
	//#region Schema
	Column.widthProperty = new serialization_1.CustomProperty(serialization_1.Versions.v1_0, "width", function (sender, property, source, context) {
		var result = property.defaultValue;
		var value = source[property.name];
		var invalidWidth = false;
		if (typeof value === "number" && !isNaN(value)) {
			result = new shared_1.SizeAndUnit(value, Enums.SizeUnit.Weight);
		}
		else if (value === "auto" || value === "stretch") {
			result = value;
		}
		else if (typeof value === "string") {
			try {
				result = shared_1.SizeAndUnit.parse(value);
				if (result.unit === Enums.SizeUnit.Pixel && property.targetVersion.compareTo(context.targetVersion) > 0) {
					invalidWidth = true;
				}
			}
			catch (e) {
				invalidWidth = true;
			}
		}
		else {
			invalidWidth = true;
		}
		if (invalidWidth) {
			context.logParseEvent(sender, Enums.ValidationEvent.InvalidPropertyValue, strings_1.Strings.errors.invalidColumnWidth(value));
			result = "auto";
		}
		return result;
	}, function (sender, property, target, value, context) {
		if (value instanceof shared_1.SizeAndUnit) {
			if (value.unit === Enums.SizeUnit.Pixel) {
				context.serializeValue(target, "width", value.physicalSize + "px");
			}
			else {
				context.serializeNumber(target, "width", value.physicalSize);
			}
		}
		else {
			context.serializeValue(target, "width", value);
		}
	}, "stretch");
	__decorate([
		serialization_1.property(Column.widthProperty)
	], Column.prototype, "width", void 0);
	return Column;
}(Container));
exports.Column = Column;
var ColumnSet = /** @class */ (function (_super) {
	__extends(ColumnSet, _super);
	function ColumnSet() {
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this._columns = [];
		return _this;
	}
	ColumnSet.prototype.createColumnInstance = function (source, context) {
		return context.parseCardObject(this, source, [], // Forbidden types not supported for elements for now
		!this.isDesignMode(), function (typeName) {
			return !typeName || typeName === "Column" ? new Column() : undefined;
		}, function (typeName, errorType) {
			context.logParseEvent(undefined, Enums.ValidationEvent.ElementTypeNotAllowed, strings_1.Strings.errors.elementTypeNotAllowed(typeName));
		});
	};
	ColumnSet.prototype.internalRender = function () {
		this._renderedColumns = [];
		if (this._columns.length > 0) {
			// Cache hostConfig to avoid walking the parent hierarchy several times
			var hostConfig = this.hostConfig;
			var element = document.createElement("div");
			element.className = hostConfig.makeCssClassName("ac-columnSet");
			element.style.display = "flex";
			if (shared_1.GlobalSettings.useAdvancedCardBottomTruncation) {
				// See comment in Container.internalRender()
				element.style.minHeight = '-webkit-min-content';
			}
			switch (this.horizontalAlignment) {
				case Enums.HorizontalAlignment.Center:
					element.style.justifyContent = "center";
					break;
				case Enums.HorizontalAlignment.Right:
					element.style.justifyContent = "flex-end";
					break;
				default:
					element.style.justifyContent = "flex-start";
					break;
			}
			var totalWeight = 0;
			for (var _i = 0, _a = this._columns; _i < _a.length; _i++) {
				var column = _a[_i];
				if (column.width instanceof shared_1.SizeAndUnit && (column.width.unit == Enums.SizeUnit.Weight)) {
					totalWeight += column.width.physicalSize;
				}
			}
			for (var _b = 0, _c = this._columns; _b < _c.length; _b++) {
				var column = _c[_b];
				if (column.width instanceof shared_1.SizeAndUnit && column.width.unit == Enums.SizeUnit.Weight && totalWeight > 0) {
					var computedWeight = 100 / totalWeight * column.width.physicalSize;
					// Best way to emulate "internal" access I know of
					column["_computedWeight"] = computedWeight;
				}
				var renderedColumn = column.render();
				if (renderedColumn) {
					if (this._renderedColumns.length > 0 && column.separatorElement) {
						column.separatorElement.style.flex = "0 0 auto";
						Utils.appendChild(element, column.separatorElement);
					}
					Utils.appendChild(element, renderedColumn);
					this._renderedColumns.push(column);
				}
			}
			return this._renderedColumns.length > 0 ? element : undefined;
		}
		else {
			return undefined;
		}
	};
	ColumnSet.prototype.truncateOverflow = function (maxHeight) {
		for (var _i = 0, _a = this._columns; _i < _a.length; _i++) {
			var column = _a[_i];
			column['handleOverflow'](maxHeight);
		}
		return true;
	};
	ColumnSet.prototype.undoOverflowTruncation = function () {
		for (var _i = 0, _a = this._columns; _i < _a.length; _i++) {
			var column = _a[_i];
			column['resetOverflow']();
		}
	};
	Object.defineProperty(ColumnSet.prototype, "isSelectable", {
		get: function () {
			return true;
		},
		enumerable: false,
		configurable: true
	});
	ColumnSet.prototype.internalParse = function (source, context) {
		_super.prototype.internalParse.call(this, source, context);
		this._columns = [];
		this._renderedColumns = [];
		var jsonColumns = source["columns"];
		if (Array.isArray(jsonColumns)) {
			for (var _i = 0, jsonColumns_1 = jsonColumns; _i < jsonColumns_1.length; _i++) {
				var item = jsonColumns_1[_i];
				var column = this.createColumnInstance(item, context);
				if (column) {
					this._columns.push(column);
				}
			}
		}
	};
	ColumnSet.prototype.internalToJSON = function (target, context) {
		_super.prototype.internalToJSON.call(this, target, context);
		context.serializeArray(target, "columns", this._columns);
	};
	ColumnSet.prototype.isFirstElement = function (element) {
		for (var _i = 0, _a = this._columns; _i < _a.length; _i++) {
			var column = _a[_i];
			if (column.isVisible) {
				return column == element;
			}
		}
		return false;
	};
	ColumnSet.prototype.isBleedingAtTop = function () {
		if (this.isBleeding()) {
			return true;
		}
		if (this._renderedColumns && this._renderedColumns.length > 0) {
			for (var _i = 0, _a = this._columns; _i < _a.length; _i++) {
				var column = _a[_i];
				if (column.isBleedingAtTop()) {
					return true;
				}
			}
		}
		return false;
	};
	ColumnSet.prototype.isBleedingAtBottom = function () {
		if (this.isBleeding()) {
			return true;
		}
		if (this._renderedColumns && this._renderedColumns.length > 0) {
			for (var _i = 0, _a = this._columns; _i < _a.length; _i++) {
				var column = _a[_i];
				if (column.isBleedingAtBottom()) {
					return true;
				}
			}
		}
		return false;
	};
	ColumnSet.prototype.getItemCount = function () {
		return this._columns.length;
	};
	ColumnSet.prototype.getFirstVisibleRenderedItem = function () {
		if (this.renderedElement && this._renderedColumns && this._renderedColumns.length > 0) {
			return this._renderedColumns[0];
		}
		else {
			return undefined;
		}
	};
	ColumnSet.prototype.getLastVisibleRenderedItem = function () {
		if (this.renderedElement && this._renderedColumns && this._renderedColumns.length > 0) {
			return this._renderedColumns[this._renderedColumns.length - 1];
		}
		else {
			return undefined;
		}
	};
	ColumnSet.prototype.getColumnAt = function (index) {
		return this._columns[index];
	};
	ColumnSet.prototype.getItemAt = function (index) {
		return this.getColumnAt(index);
	};
	ColumnSet.prototype.getJsonTypeName = function () {
		return "ColumnSet";
	};
	ColumnSet.prototype.internalValidateProperties = function (context) {
		_super.prototype.internalValidateProperties.call(this, context);
		var weightedColumns = 0;
		var stretchedColumns = 0;
		for (var _i = 0, _a = this._columns; _i < _a.length; _i++) {
			var column = _a[_i];
			if (typeof column.width === "number") {
				weightedColumns++;
			}
			else if (column.width === "stretch") {
				stretchedColumns++;
			}
		}
		if (weightedColumns > 0 && stretchedColumns > 0) {
			context.addFailure(this, Enums.ValidationEvent.Hint, strings_1.Strings.hints.dontUseWeightedAndStrecthedColumnsInSameSet());
		}
	};
	ColumnSet.prototype.addColumn = function (column) {
		if (!column.parent) {
			this._columns.push(column);
			column.setParent(this);
		}
		else {
			throw new Error(strings_1.Strings.errors.columnAlreadyBelongsToAnotherSet());
		}
	};
	ColumnSet.prototype.removeItem = function (item) {
		if (item instanceof Column) {
			var itemIndex = this._columns.indexOf(item);
			if (itemIndex >= 0) {
				this._columns.splice(itemIndex, 1);
				item.setParent(undefined);
				this.updateLayout();
				return true;
			}
		}
		return false;
	};
	ColumnSet.prototype.indexOf = function (cardElement) {
		return cardElement instanceof Column ? this._columns.indexOf(cardElement) : -1;
	};
	ColumnSet.prototype.isLeftMostElement = function (element) {
		return this._columns.indexOf(element) == 0;
	};
	ColumnSet.prototype.isRightMostElement = function (element) {
		return this._columns.indexOf(element) == this._columns.length - 1;
	};
	ColumnSet.prototype.isTopElement = function (element) {
		return this._columns.indexOf(element) >= 0;
	};
	ColumnSet.prototype.isBottomElement = function (element) {
		return this._columns.indexOf(element) >= 0;
	};
	ColumnSet.prototype.getActionById = function (id) {
		var result = undefined;
		for (var _i = 0, _a = this._columns; _i < _a.length; _i++) {
			var column = _a[_i];
			result = column.getActionById(id);
			if (result) {
				break;
			}
		}
		return result;
	};
	Object.defineProperty(ColumnSet.prototype, "bleed", {
		get: function () {
			return this.getBleed();
		},
		set: function (value) {
			this.setBleed(value);
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(ColumnSet.prototype, "padding", {
		get: function () {
			return this.getPadding();
		},
		set: function (value) {
			this.setPadding(value);
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(ColumnSet.prototype, "selectAction", {
		get: function () {
			return this._selectAction;
		},
		set: function (value) {
			this._selectAction = value;
		},
		enumerable: false,
		configurable: true
	});
	return ColumnSet;
}(StylableCardElementContainer));
exports.ColumnSet = ColumnSet;
function raiseImageLoadedEvent(image) {
	var card = image.getRootElement();
	var onImageLoadedHandler = (card && card.onImageLoaded) ? card.onImageLoaded : AdaptiveCard.onImageLoaded;
	if (onImageLoadedHandler) {
		onImageLoadedHandler(image);
	}
}
function raiseAnchorClickedEvent(element, anchor, ev) {
	var card = element.getRootElement();
	var onAnchorClickedHandler = (card && card.onAnchorClicked) ? card.onAnchorClicked : AdaptiveCard.onAnchorClicked;
	return onAnchorClickedHandler !== undefined ? onAnchorClickedHandler(element, anchor, ev) : false;
}
function raiseExecuteActionEvent(action) {
	var card = action.parent ? action.parent.getRootElement() : undefined;
	var onExecuteActionHandler = (card && card.onExecuteAction) ? card.onExecuteAction : AdaptiveCard.onExecuteAction;
	if (action.prepareForExecution() && onExecuteActionHandler) {
		onExecuteActionHandler(action);
	}
}
function raiseInlineCardExpandedEvent(action, isExpanded) {
	var card = action.parent ? action.parent.getRootElement() : undefined;
	var onInlineCardExpandedHandler = (card && card.onInlineCardExpanded) ? card.onInlineCardExpanded : AdaptiveCard.onInlineCardExpanded;
	if (onInlineCardExpandedHandler) {
		onInlineCardExpandedHandler(action, isExpanded);
	}
}
function raiseInputValueChangedEvent(input) {
	var card = input.getRootElement();
	var onInputValueChangedHandler = (card && card.onInputValueChanged) ? card.onInputValueChanged : AdaptiveCard.onInputValueChanged;
	if (onInputValueChangedHandler) {
		onInputValueChangedHandler(input);
	}
}
function raiseElementVisibilityChangedEvent(element, shouldUpdateLayout) {
	if (shouldUpdateLayout === void 0) { shouldUpdateLayout = true; }
	var rootElement = element.getRootElement();
	if (shouldUpdateLayout) {
		rootElement.updateLayout();
	}
	var card = rootElement;
	var onElementVisibilityChangedHandler = (card && card.onElementVisibilityChanged) ? card.onElementVisibilityChanged : AdaptiveCard.onElementVisibilityChanged;
	if (onElementVisibilityChangedHandler !== undefined) {
		onElementVisibilityChangedHandler(element);
	}
}
var ContainerWithActions = /** @class */ (function (_super) {
	__extends(ContainerWithActions, _super);
	function ContainerWithActions() {
		var _this = _super.call(this) || this;
		_this._actionCollection = new ActionCollection(_this);
		return _this;
	}
	ContainerWithActions.prototype.internalParse = function (source, context) {
		_super.prototype.internalParse.call(this, source, context);
		this._actionCollection.parse(source["actions"], context);
	};
	ContainerWithActions.prototype.internalToJSON = function (target, context) {
		_super.prototype.internalToJSON.call(this, target, context);
		this._actionCollection.toJSON(target, "actions", context);
	};
	ContainerWithActions.prototype.internalRender = function () {
		var element = _super.prototype.internalRender.call(this);
		if (element) {
			var renderedActions = this._actionCollection.render(this.hostConfig.actions.actionsOrientation, false);
			if (renderedActions) {
				Utils.appendChild(element, Utils.renderSeparation(this.hostConfig, {
					spacing: this.hostConfig.getEffectiveSpacing(this.hostConfig.actions.spacing)
				}, Enums.Orientation.Horizontal));
				Utils.appendChild(element, renderedActions);
			}
			if (this.renderIfEmpty) {
				return element;
			}
			else {
				return element.children.length > 0 ? element : undefined;
			}
		}
		else {
			return undefined;
		}
	};
	ContainerWithActions.prototype.getHasExpandedAction = function () {
		if (this.renderedActionCount == 0) {
			return false;
		}
		else if (this.renderedActionCount == 1) {
			return this._actionCollection.expandedAction !== undefined && !this.hostConfig.actions.preExpandSingleShowCardAction;
		}
		else {
			return this._actionCollection.expandedAction !== undefined;
		}
	};
	Object.defineProperty(ContainerWithActions.prototype, "renderedActionCount", {
		get: function () {
			return this._actionCollection.renderedActionCount;
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(ContainerWithActions.prototype, "renderIfEmpty", {
		get: function () {
			return false;
		},
		enumerable: false,
		configurable: true
	});
	ContainerWithActions.prototype.getActionCount = function () {
		return this._actionCollection.items.length;
	};
	ContainerWithActions.prototype.getActionAt = function (index) {
		if (index >= 0 && index < this.getActionCount()) {
			return this._actionCollection.items[index];
		}
		else {
			return _super.prototype.getActionAt.call(this, index);
		}
	};
	ContainerWithActions.prototype.getActionById = function (id) {
		var result = this._actionCollection.getActionById(id);
		return result ? result : _super.prototype.getActionById.call(this, id);
	};
	ContainerWithActions.prototype.internalValidateProperties = function (context) {
		_super.prototype.internalValidateProperties.call(this, context);
		if (this._actionCollection) {
			this._actionCollection.validateProperties(context);
		}
	};
	ContainerWithActions.prototype.isLastElement = function (element) {
		return _super.prototype.isLastElement.call(this, element) && this._actionCollection.items.length == 0;
	};
	ContainerWithActions.prototype.addAction = function (action) {
		this._actionCollection.addAction(action);
	};
	ContainerWithActions.prototype.clear = function () {
		_super.prototype.clear.call(this);
		this._actionCollection.clear();
	};
	ContainerWithActions.prototype.getAllInputs = function (processActions) {
		if (processActions === void 0) { processActions = true; }
		var result = _super.prototype.getAllInputs.call(this, processActions);
		if (processActions) {
			result = result.concat(this._actionCollection.getAllInputs(processActions));
		}
		return result;
	};
	ContainerWithActions.prototype.getResourceInformation = function () {
		return _super.prototype.getResourceInformation.call(this).concat(this._actionCollection.getResourceInformation());
	};
	ContainerWithActions.prototype.isBleedingAtBottom = function () {
		if (this._actionCollection.renderedActionCount == 0) {
			return _super.prototype.isBleedingAtBottom.call(this);
		}
		else {
			if (this._actionCollection.items.length == 1) {
				return this._actionCollection.expandedAction !== undefined && !this.hostConfig.actions.preExpandSingleShowCardAction;
			}
			else {
				return this._actionCollection.expandedAction !== undefined;
			}
		}
	};
	Object.defineProperty(ContainerWithActions.prototype, "isStandalone", {
		get: function () {
			return false;
		},
		enumerable: false,
		configurable: true
	});
	return ContainerWithActions;
}(Container));
exports.ContainerWithActions = ContainerWithActions;
var RefreshActionProperty = /** @class */ (function (_super) {
	__extends(RefreshActionProperty, _super);
	function RefreshActionProperty(targetVersion, name) {
		var _this = _super.call(this, targetVersion, name, undefined) || this;
		_this.targetVersion = targetVersion;
		_this.name = name;
		return _this;
	}
	RefreshActionProperty.prototype.parse = function (sender, source, context) {
		var action = context.parseAction(sender.parent, source[this.name], [], false);
		if (action !== undefined) {
			if (action instanceof ExecuteAction) {
				return action;
			}
			context.logParseEvent(sender, Enums.ValidationEvent.ActionTypeNotAllowed, strings_1.Strings.errors.actionTypeNotAllowed(action.getJsonTypeName()));
		}
		context.logParseEvent(sender, Enums.ValidationEvent.PropertyCantBeNull, strings_1.Strings.errors.propertyMustBeSet("action"));
		return undefined;
	};
	RefreshActionProperty.prototype.toJSON = function (sender, target, value, context) {
		context.serializeValue(target, this.name, value ? value.toJSON(context) : undefined, undefined, true);
	};
	return RefreshActionProperty;
}(serialization_1.PropertyDefinition));
exports.RefreshActionProperty = RefreshActionProperty;
var RefreshDefinition = /** @class */ (function (_super) {
	__extends(RefreshDefinition, _super);
	function RefreshDefinition() {
		return _super !== null && _super.apply(this, arguments) || this;
	}
	Object.defineProperty(RefreshDefinition.prototype, "action", {
		get: function () {
			return this.getValue(RefreshDefinition.actionProperty);
		},
		set: function (value) {
			this.setValue(RefreshDefinition.actionProperty, value);
			if (value) {
				value.setParent(this.parent);
			}
		},
		enumerable: false,
		configurable: true
	});
	RefreshDefinition.prototype.getSchemaKey = function () {
		return "RefreshDefinition";
	};
	//#region Schema
	RefreshDefinition.actionProperty = new RefreshActionProperty(serialization_1.Versions.v1_4, "action");
	RefreshDefinition.userIdsProperty = new serialization_1.StringArrayProperty(serialization_1.Versions.v1_4, "userIds");
	__decorate([
		serialization_1.property(RefreshDefinition.actionProperty)
	], RefreshDefinition.prototype, "action", null);
	__decorate([
		serialization_1.property(RefreshDefinition.userIdsProperty)
	], RefreshDefinition.prototype, "userIds", void 0);
	return RefreshDefinition;
}(serialization_1.SerializableObject));
exports.RefreshDefinition = RefreshDefinition;
var AuthCardButton = /** @class */ (function (_super) {
	__extends(AuthCardButton, _super);
	function AuthCardButton() {
		return _super !== null && _super.apply(this, arguments) || this;
	}
	AuthCardButton.prototype.getSchemaKey = function () {
		return "AuthCardButton";
	};
	//#region Schema
	AuthCardButton.typeProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_4, "type");
	AuthCardButton.titleProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_4, "title");
	AuthCardButton.imageProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_4, "image");
	AuthCardButton.valueProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_4, "value");
	__decorate([
		serialization_1.property(AuthCardButton.typeProperty)
	], AuthCardButton.prototype, "type", void 0);
	__decorate([
		serialization_1.property(AuthCardButton.titleProperty)
	], AuthCardButton.prototype, "title", void 0);
	__decorate([
		serialization_1.property(AuthCardButton.imageProperty)
	], AuthCardButton.prototype, "image", void 0);
	__decorate([
		serialization_1.property(AuthCardButton.valueProperty)
	], AuthCardButton.prototype, "value", void 0);
	return AuthCardButton;
}(serialization_1.SerializableObject));
exports.AuthCardButton = AuthCardButton;
var TokenExchangeResource = /** @class */ (function (_super) {
	__extends(TokenExchangeResource, _super);
	function TokenExchangeResource() {
		return _super !== null && _super.apply(this, arguments) || this;
	}
	TokenExchangeResource.prototype.getSchemaKey = function () {
		return "TokenExchangeResource";
	};
	//#region Schema
	TokenExchangeResource.idProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_4, "id");
	TokenExchangeResource.uriProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_4, "uri");
	TokenExchangeResource.providerIdProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_4, "providerId");
	__decorate([
		serialization_1.property(TokenExchangeResource.idProperty)
	], TokenExchangeResource.prototype, "id", void 0);
	__decorate([
		serialization_1.property(TokenExchangeResource.uriProperty)
	], TokenExchangeResource.prototype, "uri", void 0);
	__decorate([
		serialization_1.property(TokenExchangeResource.providerIdProperty)
	], TokenExchangeResource.prototype, "providerId", void 0);
	return TokenExchangeResource;
}(serialization_1.SerializableObject));
exports.TokenExchangeResource = TokenExchangeResource;
var Authentication = /** @class */ (function (_super) {
	__extends(Authentication, _super);
	function Authentication() {
		return _super !== null && _super.apply(this, arguments) || this;
	}
	Authentication.prototype.getSchemaKey = function () {
		return "Authentication";
	};
	//#region Schema
	Authentication.textProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_4, "text");
	Authentication.connectionNameProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_4, "connectionName");
	Authentication.buttonsProperty = new serialization_1.SerializableObjectCollectionProperty(serialization_1.Versions.v1_4, "buttons", AuthCardButton);
	Authentication.tokenExchangeResourceProperty = new serialization_1.SerializableObjectProperty(serialization_1.Versions.v1_4, "tokenExchangeResource", TokenExchangeResource, true);
	__decorate([
		serialization_1.property(Authentication.textProperty)
	], Authentication.prototype, "text", void 0);
	__decorate([
		serialization_1.property(Authentication.connectionNameProperty)
	], Authentication.prototype, "connectionName", void 0);
	__decorate([
		serialization_1.property(Authentication.buttonsProperty)
	], Authentication.prototype, "buttons", void 0);
	__decorate([
		serialization_1.property(Authentication.tokenExchangeResourceProperty)
	], Authentication.prototype, "tokenExchangeResource", void 0);
	return Authentication;
}(serialization_1.SerializableObject));
exports.Authentication = Authentication;
// @dynamic
var AdaptiveCard = /** @class */ (function (_super) {
	__extends(AdaptiveCard, _super);
	function AdaptiveCard() {
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this.designMode = false;
		return _this;
	}
	Object.defineProperty(AdaptiveCard.prototype, "refresh", {
		get: function () {
			return this.getValue(AdaptiveCard.refreshProperty);
		},
		set: function (value) {
			this.setValue(AdaptiveCard.refreshProperty, value);
			if (value) {
				value.parent = this;
			}
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(AdaptiveCard, "processMarkdown", {
		get: function () {
			throw new Error(strings_1.Strings.errors.processMarkdownEventRemoved());
		},
		set: function (value) {
			throw new Error(strings_1.Strings.errors.processMarkdownEventRemoved());
		},
		enumerable: false,
		configurable: true
	});
	AdaptiveCard.applyMarkdown = function (text) {
		var result = {
			didProcess: false
		};
		if (AdaptiveCard.onProcessMarkdown) {
			AdaptiveCard.onProcessMarkdown(text, result);
		}
		else if (window.markdownit) {
			// Check for markdownit
			var markdownIt = window.markdownit;
			result.outputHtml = markdownIt().render(text);
			result.didProcess = true;
		}
		else {
			console.warn(strings_1.Strings.errors.markdownProcessingNotEnabled);
		}
		return result;
	};
	AdaptiveCard.prototype.isVersionSupported = function () {
		if (this.bypassVersionCheck) {
			return true;
		}
		else {
			var unsupportedVersion = !this.version ||
				!this.version.isValid ||
				(this.maxVersion.major < this.version.major) ||
				(this.maxVersion.major == this.version.major && this.maxVersion.minor < this.version.minor);
			return !unsupportedVersion;
		}
	};
	AdaptiveCard.prototype.getDefaultSerializationContext = function () {
		return new SerializationContext(this.version);
	};
	AdaptiveCard.prototype.getItemsCollectionPropertyName = function () {
		return "body";
	};
	AdaptiveCard.prototype.internalParse = function (source, context) {
		this._fallbackCard = undefined;
		var fallbackElement = context.parseElement(undefined, source["fallback"], !this.isDesignMode());
		if (fallbackElement) {
			this._fallbackCard = new AdaptiveCard();
			this._fallbackCard.addItem(fallbackElement);
		}
		_super.prototype.internalParse.call(this, source, context);
	};
	AdaptiveCard.prototype.internalToJSON = function (target, context) {
		this.setValue(AdaptiveCard.versionProperty, context.targetVersion);
		_super.prototype.internalToJSON.call(this, target, context);
	};
	AdaptiveCard.prototype.internalRender = function () {
		var renderedElement = _super.prototype.internalRender.call(this);
		if (shared_1.GlobalSettings.useAdvancedCardBottomTruncation && renderedElement) {
			// Unlike containers, the root card element should be allowed to
			// be shorter than its content (otherwise the overflow truncation
			// logic would never get triggered)
			renderedElement.style.removeProperty("minHeight");
		}
		return renderedElement;
	};
	AdaptiveCard.prototype.getHasBackground = function () {
		return true;
	};
	AdaptiveCard.prototype.getDefaultPadding = function () {
		return new shared_1.PaddingDefinition(Enums.Spacing.Padding, Enums.Spacing.Padding, Enums.Spacing.Padding, Enums.Spacing.Padding);
	};
	AdaptiveCard.prototype.shouldSerialize = function (context) {
		return true;
	};
	Object.defineProperty(AdaptiveCard.prototype, "renderIfEmpty", {
		get: function () {
			return true;
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(AdaptiveCard.prototype, "bypassVersionCheck", {
		get: function () {
			return false;
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(AdaptiveCard.prototype, "allowCustomStyle", {
		get: function () {
			return this.hostConfig.adaptiveCard && this.hostConfig.adaptiveCard.allowCustomStyle;
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(AdaptiveCard.prototype, "hasBackground", {
		get: function () {
			return true;
		},
		enumerable: false,
		configurable: true
	});
	AdaptiveCard.prototype.getJsonTypeName = function () {
		return "AdaptiveCard";
	};
	AdaptiveCard.prototype.internalValidateProperties = function (context) {
		_super.prototype.internalValidateProperties.call(this, context);
		if (this.getValue(CardElement.typeNameProperty) !== "AdaptiveCard") {
			context.addFailure(this, Enums.ValidationEvent.MissingCardType, strings_1.Strings.errors.invalidCardType());
		}
		if (!this.bypassVersionCheck && !this.version) {
			context.addFailure(this, Enums.ValidationEvent.PropertyCantBeNull, strings_1.Strings.errors.propertyMustBeSet("version"));
		}
		else if (!this.isVersionSupported()) {
			context.addFailure(this, Enums.ValidationEvent.UnsupportedCardVersion, strings_1.Strings.errors.unsupportedCardVersion(this.version.toString(), this.maxVersion.toString()));
		}
	};
	AdaptiveCard.prototype.render = function (target) {
		var renderedCard;
		if (this.shouldFallback() && this._fallbackCard) {
			this._fallbackCard.hostConfig = this.hostConfig;
			renderedCard = this._fallbackCard.render();
		}
		else {
			renderedCard = _super.prototype.render.call(this);
			if (renderedCard) {
				renderedCard.classList.add(this.hostConfig.makeCssClassName("ac-adaptiveCard"));
				// Having a tabIndex on the root container for a card can mess up accessibility in some scenarios.
				// However, we've shipped this behavior before, and so can't just turn it off in a point release. For
				// now, to unblock accessibility scenarios for our customers, we've got an option to turn it off. In a
				// future release, we should strongly consider flipping the default such that we *don't* emit a tabIndex
				// by default.
				if (shared_1.GlobalSettings.setTabIndexAtCardRoot) {
					renderedCard.tabIndex = 0;
				}
				if (this.speak) {
					renderedCard.setAttribute("aria-label", this.speak);
				}
			}
		}
		if (target) {
			Utils.appendChild(target, renderedCard);
			this.updateLayout();
		}
		return renderedCard;
	};
	AdaptiveCard.prototype.updateLayout = function (processChildren) {
		if (processChildren === void 0) { processChildren = true; }
		_super.prototype.updateLayout.call(this, processChildren);
		if (shared_1.GlobalSettings.useAdvancedCardBottomTruncation && this.isDisplayed()) {
			var padding = this.hostConfig.getEffectiveSpacing(Enums.Spacing.Default);
			this['handleOverflow'](this.renderedElement.offsetHeight - padding);
		}
	};
	AdaptiveCard.prototype.shouldFallback = function () {
		return _super.prototype.shouldFallback.call(this) || !this.isVersionSupported();
	};
	Object.defineProperty(AdaptiveCard.prototype, "hasVisibleSeparator", {
		get: function () {
			return false;
		},
		enumerable: false,
		configurable: true
	});
	AdaptiveCard.schemaUrl = "http://adaptivecards.io/schemas/adaptive-card.json";
	//#region Schema
	AdaptiveCard.$schemaProperty = new serialization_1.CustomProperty(serialization_1.Versions.v1_0, "$schema", function (sender, property, source, context) {
		return AdaptiveCard.schemaUrl;
	}, function (sender, property, target, value, context) {
		context.serializeValue(target, property.name, AdaptiveCard.schemaUrl);
	});
	AdaptiveCard.versionProperty = new serialization_1.CustomProperty(serialization_1.Versions.v1_0, "version", function (sender, property, source, context) {
		var version = serialization_1.Version.parse(source[property.name], context);
		if (version === undefined) {
			version = serialization_1.Versions.latest;
			context.logParseEvent(sender, Enums.ValidationEvent.InvalidPropertyValue, strings_1.Strings.errors.invalidCardVersion(version.toString()));
		}
		return version;
	}, function (sender, property, target, value, context) {
		if (value !== undefined) {
			context.serializeValue(target, property.name, value.toString());
		}
	}, serialization_1.Versions.v1_0);
	AdaptiveCard.fallbackTextProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_0, "fallbackText");
	AdaptiveCard.speakProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_0, "speak");
	AdaptiveCard.refreshProperty = new serialization_1.SerializableObjectProperty(serialization_1.Versions.v1_4, "refresh", RefreshDefinition, true);
	AdaptiveCard.authenticationProperty = new serialization_1.SerializableObjectProperty(serialization_1.Versions.v1_4, "authentication", Authentication, true);
	__decorate([
		serialization_1.property(AdaptiveCard.versionProperty)
	], AdaptiveCard.prototype, "version", void 0);
	__decorate([
		serialization_1.property(AdaptiveCard.fallbackTextProperty)
	], AdaptiveCard.prototype, "fallbackText", void 0);
	__decorate([
		serialization_1.property(AdaptiveCard.speakProperty)
	], AdaptiveCard.prototype, "speak", void 0);
	__decorate([
		serialization_1.property(AdaptiveCard.refreshProperty)
	], AdaptiveCard.prototype, "refresh", null);
	__decorate([
		serialization_1.property(AdaptiveCard.authenticationProperty)
	], AdaptiveCard.prototype, "authentication", void 0);
	return AdaptiveCard;
}(ContainerWithActions));
exports.AdaptiveCard = AdaptiveCard;
var InlineAdaptiveCard = /** @class */ (function (_super) {
	__extends(InlineAdaptiveCard, _super);
	function InlineAdaptiveCard() {
		//#region Schema
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this.suppressStyle = false;
		return _this;
	}
	InlineAdaptiveCard.prototype.getSchemaKey = function () {
		return "InlineAdaptiveCard";
	};
	InlineAdaptiveCard.prototype.populateSchema = function (schema) {
		_super.prototype.populateSchema.call(this, schema);
		schema.remove(AdaptiveCard.$schemaProperty, AdaptiveCard.versionProperty);
	};
	//#endregion
	InlineAdaptiveCard.prototype.getDefaultPadding = function () {
		return new shared_1.PaddingDefinition(this.suppressStyle ? Enums.Spacing.None : Enums.Spacing.Padding, Enums.Spacing.Padding, this.suppressStyle ? Enums.Spacing.None : Enums.Spacing.Padding, Enums.Spacing.Padding);
	};
	Object.defineProperty(InlineAdaptiveCard.prototype, "bypassVersionCheck", {
		get: function () {
			return true;
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(InlineAdaptiveCard.prototype, "defaultStyle", {
		get: function () {
			if (this.suppressStyle) {
				return Enums.ContainerStyle.Default;
			}
			else {
				return this.hostConfig.actions.showCard.style ? this.hostConfig.actions.showCard.style : Enums.ContainerStyle.Emphasis;
			}
		},
		enumerable: false,
		configurable: true
	});
	InlineAdaptiveCard.prototype.render = function (target) {
		var renderedCard = _super.prototype.render.call(this, target);
		if (renderedCard) {
			renderedCard.setAttribute("aria-live", "polite");
			renderedCard.removeAttribute("tabindex");
		}
		return renderedCard;
	};
	return InlineAdaptiveCard;
}(AdaptiveCard));
var GlobalRegistry = /** @class */ (function () {
	function GlobalRegistry() {
	}
	GlobalRegistry.populateWithDefaultElements = function (registry) {
		registry.clear();
		registry.register("Container", Container);
		registry.register("TextBlock", TextBlock);
		registry.register("RichTextBlock", RichTextBlock, serialization_1.Versions.v1_2);
		registry.register("TextRun", TextRun, serialization_1.Versions.v1_2);
		registry.register("Image", Image);
		registry.register("ImageSet", ImageSet);
		registry.register("Media", Media, serialization_1.Versions.v1_1);
		registry.register("FactSet", FactSet);
		registry.register("ColumnSet", ColumnSet);
		registry.register("ActionSet", ActionSet, serialization_1.Versions.v1_2);
		registry.register("Input.Text", TextInput);
		registry.register("Input.Date", DateInput);
		registry.register("Input.Time", TimeInput);
		registry.register("Input.Number", NumberInput);
		registry.register("Input.ChoiceSet", ChoiceSetInput);
		registry.register("Input.Toggle", ToggleInput);
	};
	GlobalRegistry.populateWithDefaultActions = function (registry) {
		registry.clear();
		registry.register(OpenUrlAction.JsonTypeName, OpenUrlAction);
		registry.register(SubmitAction.JsonTypeName, SubmitAction);
		registry.register(ShowCardAction.JsonTypeName, ShowCardAction);
		registry.register(ToggleVisibilityAction.JsonTypeName, ToggleVisibilityAction, serialization_1.Versions.v1_2);
		registry.register(ExecuteAction.JsonTypeName, ExecuteAction, serialization_1.Versions.v1_4);
	};
	GlobalRegistry.reset = function () {
		GlobalRegistry.populateWithDefaultElements(GlobalRegistry.elements);
		GlobalRegistry.populateWithDefaultActions(GlobalRegistry.actions);
	};
	GlobalRegistry.elements = new registry_1.CardObjectRegistry();
	GlobalRegistry.actions = new registry_1.CardObjectRegistry();
	return GlobalRegistry;
}());
exports.GlobalRegistry = GlobalRegistry;
GlobalRegistry.reset();
var SerializationContext = /** @class */ (function (_super) {
	__extends(SerializationContext, _super);
	function SerializationContext() {
		return _super !== null && _super.apply(this, arguments) || this;
	}
	SerializationContext.prototype.internalParseCardObject = function (parent, source, forbiddenTypeNames, allowFallback, createInstanceCallback, logParseEvent) {
		var result = undefined;
		if (source && typeof source === "object") {
			var typeName = Utils.parseString(source["type"]);
			if (typeName) {
				if (forbiddenTypeNames.indexOf(typeName) >= 0) {
					logParseEvent(typeName, 1 /* ForbiddenType */);
				}
				else {
					var tryToFallback = false;
					result = createInstanceCallback(typeName);
					if (!result) {
						tryToFallback = shared_1.GlobalSettings.enableFallback && allowFallback;
						logParseEvent(typeName, 0 /* UnknownType */);
					}
					else {
						result.setParent(parent);
						result.parse(source, this);
						tryToFallback = shared_1.GlobalSettings.enableFallback && allowFallback && result.shouldFallback();
					}
					if (tryToFallback) {
						var fallback = source["fallback"];
						if (!fallback && parent) {
							parent.setShouldFallback(true);
						}
						if (typeof fallback === "string" && fallback.toLowerCase() === "drop") {
							result = undefined;
						}
						else if (typeof fallback === "object") {
							result = this.internalParseCardObject(parent, fallback, forbiddenTypeNames, true, createInstanceCallback, logParseEvent);
						}
					}
				}
			}
		}
		return result;
	};
	SerializationContext.prototype.cardObjectParsed = function (o, source) {
		if (o instanceof Action && this.onParseAction) {
			this.onParseAction(o, source, this);
		}
		else if (o instanceof CardElement && this.onParseElement) {
			this.onParseElement(o, source, this);
		}
	};
	SerializationContext.prototype.shouldSerialize = function (o) {
		if (o instanceof Action) {
			return this.actionRegistry.findByName(o.getJsonTypeName()) !== undefined;
		}
		else if (o instanceof CardElement) {
			return this.elementRegistry.findByName(o.getJsonTypeName()) !== undefined;
		}
		else {
			return true;
		}
	};
	SerializationContext.prototype.parseCardObject = function (parent, source, forbiddenTypeNames, allowFallback, createInstanceCallback, logParseEvent) {
		var result = this.internalParseCardObject(parent, source, forbiddenTypeNames, allowFallback, createInstanceCallback, logParseEvent);
		if (result !== undefined) {
			this.cardObjectParsed(result, source);
		}
		return result;
	};
	SerializationContext.prototype.parseElement = function (parent, source, allowFallback) {
		var _this = this;
		return this.parseCardObject(parent, source, [], // Forbidden types not supported for elements for now
		allowFallback, function (typeName) {
			return _this.elementRegistry.createInstance(typeName, _this.targetVersion);
		}, function (typeName, errorType) {
			if (errorType === 0 /* UnknownType */) {
				_this.logParseEvent(undefined, Enums.ValidationEvent.UnknownElementType, strings_1.Strings.errors.unknownElementType(typeName));
			}
			else {
				_this.logParseEvent(undefined, Enums.ValidationEvent.ElementTypeNotAllowed, strings_1.Strings.errors.elementTypeNotAllowed(typeName));
			}
		});
	};
	SerializationContext.prototype.parseAction = function (parent, source, forbiddenActionTypes, allowFallback) {
		var _this = this;
		return this.parseCardObject(parent, source, forbiddenActionTypes, allowFallback, function (typeName) {
			return _this.actionRegistry.createInstance(typeName, _this.targetVersion);
		}, function (typeName, errorType) {
			if (errorType == 0 /* UnknownType */) {
				_this.logParseEvent(undefined, Enums.ValidationEvent.UnknownActionType, strings_1.Strings.errors.unknownActionType(typeName));
			}
			else {
				_this.logParseEvent(undefined, Enums.ValidationEvent.ActionTypeNotAllowed, strings_1.Strings.errors.actionTypeNotAllowed(typeName));
			}
		});
	};
	Object.defineProperty(SerializationContext.prototype, "elementRegistry", {
		get: function () {
			return this._elementRegistry ? this._elementRegistry : GlobalRegistry.elements;
		},
		enumerable: false,
		configurable: true
	});
	// Not using a property setter here because the setter should accept "undefined"
	// whereas the getter should never return undefined.
	SerializationContext.prototype.setElementRegistry = function (value) {
		this._elementRegistry = value;
	};
	Object.defineProperty(SerializationContext.prototype, "actionRegistry", {
		get: function () {
			return this._actionRegistry ? this._actionRegistry : GlobalRegistry.actions;
		},
		enumerable: false,
		configurable: true
	});
	// Not using a property setter here because the setter should accept "undefined"
	// whereas the getter should never return undefined.
	SerializationContext.prototype.setActionRegistry = function (value) {
		this._actionRegistry = value;
	};
	return SerializationContext;
}(serialization_1.BaseSerializationContext));
exports.SerializationContext = SerializationContext;


/***/ }),

/***/ "./src/card-object.ts":
/*!****************************!*\
  !*** ./src/card-object.ts ***!
  \****************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
	var extendStatics = function (d, b) {
		extendStatics = Object.setPrototypeOf ||
			({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
			function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
		return extendStatics(d, b);
	};
	return function (d, b) {
		extendStatics(d, b);
		function __() { this.constructor = d; }
		d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
	var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
	if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
	else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
	return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CardObject = exports.ValidationResults = void 0;
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
var Enums = __webpack_require__(/*! ./enums */ "./src/enums.ts");
var strings_1 = __webpack_require__(/*! ./strings */ "./src/strings.ts");
var shared_1 = __webpack_require__(/*! ./shared */ "./src/shared.ts");
var host_capabilities_1 = __webpack_require__(/*! ./host-capabilities */ "./src/host-capabilities.ts");
var serialization_1 = __webpack_require__(/*! ./serialization */ "./src/serialization.ts");
var ValidationResults = /** @class */ (function () {
	function ValidationResults() {
		this.allIds = {};
		this.validationEvents = [];
	}
	ValidationResults.prototype.addFailure = function (cardObject, event, message) {
		this.validationEvents.push({
			phase: Enums.ValidationPhase.Validation,
			source: cardObject,
			event: event,
			message: message
		});
	};
	return ValidationResults;
}());
exports.ValidationResults = ValidationResults;
var CardObject = /** @class */ (function (_super) {
	__extends(CardObject, _super);
	function CardObject() {
		//#region Schema
		var _this = _super !== null && _super.apply(this, arguments) || this;
		//#endregion
		_this._shouldFallback = false;
		return _this;
	}
	CardObject.prototype.getSchemaKey = function () {
		return this.getJsonTypeName();
	};
	Object.defineProperty(CardObject.prototype, "requires", {
		get: function () {
			return this.getValue(CardObject.requiresProperty);
		},
		enumerable: false,
		configurable: true
	});
	/**
	 * Checks if this CardObject contains the given DOM Node.
	 * @param node The DOM Node to look for.
	 * @returns `true` if the DOM Node was found, `false` otherwise.
	 */
	CardObject.prototype.contains = function (node) {
		if (this._renderedElement) {
			return this._renderedElement.contains(node);
		}
		return false;
	};
	CardObject.prototype.preProcessPropertyValue = function (property, propertyValue) {
		var value = propertyValue === undefined ? this.getValue(property) : propertyValue;
		if (shared_1.GlobalSettings.allowPreProcessingPropertyValues) {
			var currentObject = this;
			while (currentObject && !currentObject.onPreProcessPropertyValue) {
				currentObject = currentObject.parent;
			}
			if (currentObject && currentObject.onPreProcessPropertyValue) {
				return currentObject.onPreProcessPropertyValue(this, property, value);
			}
		}
		return value;
	};
	CardObject.prototype.setParent = function (value) {
		this._parent = value;
	};
	CardObject.prototype.setShouldFallback = function (value) {
		this._shouldFallback = value;
	};
	CardObject.prototype.shouldFallback = function () {
		return this._shouldFallback || !this.requires.areAllMet(this.hostConfig.hostCapabilities);
	};
	CardObject.prototype.getRootObject = function () {
		var rootObject = this;
		while (rootObject.parent) {
			rootObject = rootObject.parent;
		}
		return rootObject;
	};
	CardObject.prototype.internalValidateProperties = function (context) {
		if (this.id) {
			if (context.allIds.hasOwnProperty(this.id)) {
				if (context.allIds[this.id] == 1) {
					context.addFailure(this, Enums.ValidationEvent.DuplicateId, strings_1.Strings.errors.duplicateId(this.id));
				}
				context.allIds[this.id] += 1;
			}
			else {
				context.allIds[this.id] = 1;
			}
		}
	};
	CardObject.prototype.validateProperties = function () {
		var result = new ValidationResults();
		this.internalValidateProperties(result);
		return result;
	};
	/**
	 * Recursively searches this CardObject and any children to find the
	 * innermost CardObject that owns the given DOM Node.
	 *
	 * @param node The DOM Node to look for.
	 *
	 * @returns The owner of the given DOM Node, or `undefined` if no owner was found.
	 */
	CardObject.prototype.findDOMNodeOwner = function (node) {
		// default implementation for CardObjects with no associated children
		return this.contains(node) ? this : undefined;
	};
	Object.defineProperty(CardObject.prototype, "parent", {
		get: function () {
			return this._parent;
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(CardObject.prototype, "renderedElement", {
		get: function () {
			return this._renderedElement;
		},
		enumerable: false,
		configurable: true
	});
	CardObject.typeNameProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_0, "type", undefined, undefined, undefined, function (sender) {
		return sender.getJsonTypeName();
	});
	CardObject.idProperty = new serialization_1.StringProperty(serialization_1.Versions.v1_0, "id");
	CardObject.requiresProperty = new serialization_1.SerializableObjectProperty(serialization_1.Versions.v1_2, "requires", host_capabilities_1.HostCapabilities, false, new host_capabilities_1.HostCapabilities());
	__decorate([
		serialization_1.property(CardObject.idProperty)
	], CardObject.prototype, "id", void 0);
	__decorate([
		serialization_1.property(CardObject.requiresProperty)
	], CardObject.prototype, "requires", null);
	return CardObject;
}(serialization_1.SerializableObject));
exports.CardObject = CardObject;


/***/ }),

/***/ "./src/channel-adapter.ts":
/*!********************************!*\
  !*** ./src/channel-adapter.ts ***!
  \********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.ChannelAdapter = void 0;
var ChannelAdapter = /** @class */ (function () {
	function ChannelAdapter() {
	}
	return ChannelAdapter;
}());
exports.ChannelAdapter = ChannelAdapter;


/***/ }),

/***/ "./src/enums.ts":
/*!**********************!*\
  !*** ./src/enums.ts ***!
  \**********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogLevel = exports.RefreshMode = exports.ContainerFitStatus = exports.ValidationEvent = exports.ValidationPhase = exports.ContainerStyle = exports.InputTextStyle = exports.ActionIconPlacement = exports.FillMode = exports.Orientation = exports.ShowCardActionMode = exports.ImageStyle = exports.ActionAlignment = exports.VerticalAlignment = exports.HorizontalAlignment = exports.TextColor = exports.Spacing = exports.FontType = exports.TextWeight = exports.TextSize = exports.SizeUnit = exports.ImageSize = exports.Size = exports.ActionStyle = void 0;
// Note the "weird" way these readonly fields are declared is to work around
// a breaking change introduced in TS 3.1 wrt d.ts generation. DO NOT CHANGE
// and adopt this syntax for all other static readonly fields.
var ActionStyle = /** @class */ (function () {
	function ActionStyle() {
	}
	ActionStyle.Default = "default";
	ActionStyle.Positive = "positive";
	ActionStyle.Destructive = "destructive";
	return ActionStyle;
}());
exports.ActionStyle = ActionStyle;
var Size;
(function (Size) {
	Size[Size["Auto"] = 0] = "Auto";
	Size[Size["Stretch"] = 1] = "Stretch";
	Size[Size["Small"] = 2] = "Small";
	Size[Size["Medium"] = 3] = "Medium";
	Size[Size["Large"] = 4] = "Large";
})(Size = exports.Size || (exports.Size = {}));
var ImageSize;
(function (ImageSize) {
	ImageSize[ImageSize["Small"] = 0] = "Small";
	ImageSize[ImageSize["Medium"] = 1] = "Medium";
	ImageSize[ImageSize["Large"] = 2] = "Large";
})(ImageSize = exports.ImageSize || (exports.ImageSize = {}));
var SizeUnit;
(function (SizeUnit) {
	SizeUnit[SizeUnit["Weight"] = 0] = "Weight";
	SizeUnit[SizeUnit["Pixel"] = 1] = "Pixel";
})(SizeUnit = exports.SizeUnit || (exports.SizeUnit = {}));
var TextSize;
(function (TextSize) {
	TextSize[TextSize["Small"] = 0] = "Small";
	TextSize[TextSize["Default"] = 1] = "Default";
	TextSize[TextSize["Medium"] = 2] = "Medium";
	TextSize[TextSize["Large"] = 3] = "Large";
	TextSize[TextSize["ExtraLarge"] = 4] = "ExtraLarge";
})(TextSize = exports.TextSize || (exports.TextSize = {}));
var TextWeight;
(function (TextWeight) {
	TextWeight[TextWeight["Lighter"] = 0] = "Lighter";
	TextWeight[TextWeight["Default"] = 1] = "Default";
	TextWeight[TextWeight["Bolder"] = 2] = "Bolder";
})(TextWeight = exports.TextWeight || (exports.TextWeight = {}));
var FontType;
(function (FontType) {
	FontType[FontType["Default"] = 0] = "Default";
	FontType[FontType["Monospace"] = 1] = "Monospace";
})(FontType = exports.FontType || (exports.FontType = {}));
var Spacing;
(function (Spacing) {
	Spacing[Spacing["None"] = 0] = "None";
	Spacing[Spacing["Small"] = 1] = "Small";
	Spacing[Spacing["Default"] = 2] = "Default";
	Spacing[Spacing["Medium"] = 3] = "Medium";
	Spacing[Spacing["Large"] = 4] = "Large";
	Spacing[Spacing["ExtraLarge"] = 5] = "ExtraLarge";
	Spacing[Spacing["Padding"] = 6] = "Padding";
})(Spacing = exports.Spacing || (exports.Spacing = {}));
var TextColor;
(function (TextColor) {
	TextColor[TextColor["Default"] = 0] = "Default";
	TextColor[TextColor["Dark"] = 1] = "Dark";
	TextColor[TextColor["Light"] = 2] = "Light";
	TextColor[TextColor["Accent"] = 3] = "Accent";
	TextColor[TextColor["Good"] = 4] = "Good";
	TextColor[TextColor["Warning"] = 5] = "Warning";
	TextColor[TextColor["Attention"] = 6] = "Attention";
})(TextColor = exports.TextColor || (exports.TextColor = {}));
var HorizontalAlignment;
(function (HorizontalAlignment) {
	HorizontalAlignment[HorizontalAlignment["Left"] = 0] = "Left";
	HorizontalAlignment[HorizontalAlignment["Center"] = 1] = "Center";
	HorizontalAlignment[HorizontalAlignment["Right"] = 2] = "Right";
})(HorizontalAlignment = exports.HorizontalAlignment || (exports.HorizontalAlignment = {}));
var VerticalAlignment;
(function (VerticalAlignment) {
	VerticalAlignment[VerticalAlignment["Top"] = 0] = "Top";
	VerticalAlignment[VerticalAlignment["Center"] = 1] = "Center";
	VerticalAlignment[VerticalAlignment["Bottom"] = 2] = "Bottom";
})(VerticalAlignment = exports.VerticalAlignment || (exports.VerticalAlignment = {}));
var ActionAlignment;
(function (ActionAlignment) {
	ActionAlignment[ActionAlignment["Left"] = 0] = "Left";
	ActionAlignment[ActionAlignment["Center"] = 1] = "Center";
	ActionAlignment[ActionAlignment["Right"] = 2] = "Right";
	ActionAlignment[ActionAlignment["Stretch"] = 3] = "Stretch";
})(ActionAlignment = exports.ActionAlignment || (exports.ActionAlignment = {}));
var ImageStyle;
(function (ImageStyle) {
	ImageStyle[ImageStyle["Default"] = 0] = "Default";
	ImageStyle[ImageStyle["Person"] = 1] = "Person";
})(ImageStyle = exports.ImageStyle || (exports.ImageStyle = {}));
var ShowCardActionMode;
(function (ShowCardActionMode) {
	ShowCardActionMode[ShowCardActionMode["Inline"] = 0] = "Inline";
	ShowCardActionMode[ShowCardActionMode["Popup"] = 1] = "Popup";
})(ShowCardActionMode = exports.ShowCardActionMode || (exports.ShowCardActionMode = {}));
var Orientation;
(function (Orientation) {
	Orientation[Orientation["Horizontal"] = 0] = "Horizontal";
	Orientation[Orientation["Vertical"] = 1] = "Vertical";
})(Orientation = exports.Orientation || (exports.Orientation = {}));
var FillMode;
(function (FillMode) {
	FillMode[FillMode["Cover"] = 0] = "Cover";
	FillMode[FillMode["RepeatHorizontally"] = 1] = "RepeatHorizontally";
	FillMode[FillMode["RepeatVertically"] = 2] = "RepeatVertically";
	FillMode[FillMode["Repeat"] = 3] = "Repeat";
})(FillMode = exports.FillMode || (exports.FillMode = {}));
var ActionIconPlacement;
(function (ActionIconPlacement) {
	ActionIconPlacement[ActionIconPlacement["LeftOfTitle"] = 0] = "LeftOfTitle";
	ActionIconPlacement[ActionIconPlacement["AboveTitle"] = 1] = "AboveTitle";
})(ActionIconPlacement = exports.ActionIconPlacement || (exports.ActionIconPlacement = {}));
var InputTextStyle;
(function (InputTextStyle) {
	InputTextStyle[InputTextStyle["Text"] = 0] = "Text";
	InputTextStyle[InputTextStyle["Tel"] = 1] = "Tel";
	InputTextStyle[InputTextStyle["Url"] = 2] = "Url";
	InputTextStyle[InputTextStyle["Email"] = 3] = "Email";
})(InputTextStyle = exports.InputTextStyle || (exports.InputTextStyle = {}));
/*
	This should really be a string enum, e.g.

		export enum ContainerStyle {
			Default = "default",
			Emphasis = "emphasis"
		}

	However, some hosts do not use a version of TypeScript
	recent enough to understand string enums. This is
	a compatible construct that does not require using
	a more recent version of TypeScript.

	Also note the "weird" way these readonly fields are declared is to work around
	a breaking change introduced in TS 3.1 wrt d.ts generation. DO NOT CHANGE
	and adopt this syntax for all other static readonly fields.
*/
var ContainerStyle = /** @class */ (function () {
	function ContainerStyle() {
	}
	ContainerStyle.Default = "default";
	ContainerStyle.Emphasis = "emphasis";
	ContainerStyle.Accent = "accent";
	ContainerStyle.Good = "good";
	ContainerStyle.Attention = "attention";
	ContainerStyle.Warning = "warning";
	return ContainerStyle;
}());
exports.ContainerStyle = ContainerStyle;
var ValidationPhase;
(function (ValidationPhase) {
	ValidationPhase[ValidationPhase["Parse"] = 0] = "Parse";
	ValidationPhase[ValidationPhase["ToJSON"] = 1] = "ToJSON";
	ValidationPhase[ValidationPhase["Validation"] = 2] = "Validation";
})(ValidationPhase = exports.ValidationPhase || (exports.ValidationPhase = {}));
var ValidationEvent;
(function (ValidationEvent) {
	ValidationEvent[ValidationEvent["Hint"] = 0] = "Hint";
	ValidationEvent[ValidationEvent["ActionTypeNotAllowed"] = 1] = "ActionTypeNotAllowed";
	ValidationEvent[ValidationEvent["CollectionCantBeEmpty"] = 2] = "CollectionCantBeEmpty";
	ValidationEvent[ValidationEvent["Deprecated"] = 3] = "Deprecated";
	ValidationEvent[ValidationEvent["ElementTypeNotAllowed"] = 4] = "ElementTypeNotAllowed";
	ValidationEvent[ValidationEvent["InteractivityNotAllowed"] = 5] = "InteractivityNotAllowed";
	ValidationEvent[ValidationEvent["InvalidPropertyValue"] = 6] = "InvalidPropertyValue";
	ValidationEvent[ValidationEvent["MissingCardType"] = 7] = "MissingCardType";
	ValidationEvent[ValidationEvent["PropertyCantBeNull"] = 8] = "PropertyCantBeNull";
	ValidationEvent[ValidationEvent["TooManyActions"] = 9] = "TooManyActions";
	ValidationEvent[ValidationEvent["UnknownActionType"] = 10] = "UnknownActionType";
	ValidationEvent[ValidationEvent["UnknownElementType"] = 11] = "UnknownElementType";
	ValidationEvent[ValidationEvent["UnsupportedCardVersion"] = 12] = "UnsupportedCardVersion";
	ValidationEvent[ValidationEvent["DuplicateId"] = 13] = "DuplicateId";
	ValidationEvent[ValidationEvent["UnsupportedProperty"] = 14] = "UnsupportedProperty";
	ValidationEvent[ValidationEvent["RequiredInputsShouldHaveLabel"] = 15] = "RequiredInputsShouldHaveLabel";
	ValidationEvent[ValidationEvent["RequiredInputsShouldHaveErrorMessage"] = 16] = "RequiredInputsShouldHaveErrorMessage";
	ValidationEvent[ValidationEvent["Other"] = 17] = "Other";
})(ValidationEvent = exports.ValidationEvent || (exports.ValidationEvent = {}));
var ContainerFitStatus;
(function (ContainerFitStatus) {
	ContainerFitStatus[ContainerFitStatus["FullyInContainer"] = 0] = "FullyInContainer";
	ContainerFitStatus[ContainerFitStatus["Overflowing"] = 1] = "Overflowing";
	ContainerFitStatus[ContainerFitStatus["FullyOutOfContainer"] = 2] = "FullyOutOfContainer";
})(ContainerFitStatus = exports.ContainerFitStatus || (exports.ContainerFitStatus = {}));
var RefreshMode;
(function (RefreshMode) {
	RefreshMode[RefreshMode["Disabled"] = 0] = "Disabled";
	RefreshMode[RefreshMode["Manual"] = 1] = "Manual";
	RefreshMode[RefreshMode["Automatic"] = 2] = "Automatic";
})(RefreshMode = exports.RefreshMode || (exports.RefreshMode = {}));
var LogLevel;
(function (LogLevel) {
	LogLevel[LogLevel["Info"] = 0] = "Info";
	LogLevel[LogLevel["Warning"] = 1] = "Warning";
	LogLevel[LogLevel["Error"] = 2] = "Error";
})(LogLevel = exports.LogLevel || (exports.LogLevel = {}));


/***/ }),

/***/ "./src/host-capabilities.ts":
/*!**********************************!*\
  !*** ./src/host-capabilities.ts ***!
  \**********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
	var extendStatics = function (d, b) {
		extendStatics = Object.setPrototypeOf ||
			({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
			function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
		return extendStatics(d, b);
	};
	return function (d, b) {
		extendStatics(d, b);
		function __() { this.constructor = d; }
		d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.HostCapabilities = void 0;
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
var serialization_1 = __webpack_require__(/*! ./serialization */ "./src/serialization.ts");
var HostCapabilities = /** @class */ (function (_super) {
	__extends(HostCapabilities, _super);
	function HostCapabilities() {
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this._capabilities = {};
		return _this;
	}
	HostCapabilities.prototype.getSchemaKey = function () {
		return "HostCapabilities";
	};
	HostCapabilities.prototype.internalParse = function (source, context) {
		_super.prototype.internalParse.call(this, source, context);
		if (source) {
			for (var name_1 in source) {
				var jsonVersion = source[name_1];
				if (typeof jsonVersion === "string") {
					if (jsonVersion == "*") {
						this.addCapability(name_1, "*");
					}
					else {
						var version = serialization_1.Version.parse(jsonVersion, context);
						if (version && version.isValid) {
							this.addCapability(name_1, version);
						}
					}
				}
			}
		}
	};
	HostCapabilities.prototype.internalToJSON = function (target, context) {
		_super.prototype.internalToJSON.call(this, target, context);
		for (var key in this._capabilities) {
			target[key] = this._capabilities[key];
		}
	};
	HostCapabilities.prototype.addCapability = function (name, version) {
		this._capabilities[name] = version;
	};
	HostCapabilities.prototype.removeCapability = function (name) {
		delete this._capabilities[name];
	};
	HostCapabilities.prototype.clear = function () {
		this._capabilities = {};
	};
	HostCapabilities.prototype.hasCapability = function (name, version) {
		if (this._capabilities.hasOwnProperty(name)) {
			if (version == "*" || this._capabilities[name] == "*") {
				return true;
			}
			return version.compareTo(this._capabilities[name]) <= 0;
		}
		return false;
	};
	HostCapabilities.prototype.areAllMet = function (hostCapabilities) {
		for (var capabilityName in this._capabilities) {
			if (!hostCapabilities.hasCapability(capabilityName, this._capabilities[capabilityName])) {
				return false;
			}
		}
		return true;
	};
	return HostCapabilities;
}(serialization_1.SerializableObject));
exports.HostCapabilities = HostCapabilities;


/***/ }),

/***/ "./src/host-config.ts":
/*!****************************!*\
  !*** ./src/host-config.ts ***!
  \****************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
	var extendStatics = function (d, b) {
		extendStatics = Object.setPrototypeOf ||
			({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
			function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
		return extendStatics(d, b);
	};
	return function (d, b) {
		extendStatics(d, b);
		function __() { this.constructor = d; }
		d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultHostConfig = exports.HostConfig = exports.FontTypeSet = exports.FontTypeDefinition = exports.ContainerStyleSet = exports.ContainerStyleDefinition = exports.ColorSetDefinition = exports.ActionsConfig = exports.ShowCardActionConfig = exports.FactSetConfig = exports.FactTitleDefinition = exports.FactTextDefinition = exports.InputConfig = exports.InputLabelConfig = exports.RequiredInputLabelTextDefinition = exports.BaseTextDefinition = exports.MediaConfig = exports.ImageSetConfig = exports.AdaptiveCardConfig = exports.TextColorDefinition = exports.ColorDefinition = void 0;
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
var Enums = __webpack_require__(/*! ./enums */ "./src/enums.ts");
var Utils = __webpack_require__(/*! ./utils */ "./src/utils.ts");
var Shared = __webpack_require__(/*! ./shared */ "./src/shared.ts");
var host_capabilities_1 = __webpack_require__(/*! ./host-capabilities */ "./src/host-capabilities.ts");
function parseHostConfigEnum(targetEnum, value, defaultValue) {
	if (typeof value === "string") {
		var parsedValue = Utils.parseEnum(targetEnum, value, defaultValue);
		return parsedValue !== undefined ? parsedValue : defaultValue;
	}
	else if (typeof value === "number") {
		return value;
	}
	else {
		return defaultValue;
	}
}
var ColorDefinition = /** @class */ (function () {
	function ColorDefinition(defaultColor, subtleColor) {
		this.default = "#000000";
		this.subtle = "#666666";
		if (defaultColor) {
			this.default = defaultColor;
		}
		if (subtleColor) {
			this.subtle = subtleColor;
		}
	}
	ColorDefinition.prototype.parse = function (obj) {
		if (obj) {
			this.default = obj["default"] || this.default;
			this.subtle = obj["subtle"] || this.subtle;
		}
	};
	return ColorDefinition;
}());
exports.ColorDefinition = ColorDefinition;
var TextColorDefinition = /** @class */ (function (_super) {
	__extends(TextColorDefinition, _super);
	function TextColorDefinition() {
		var _this = _super !== null && _super.apply(this, arguments) || this;
		_this.highlightColors = new ColorDefinition("#22000000", "#11000000");
		return _this;
	}
	TextColorDefinition.prototype.parse = function (obj) {
		_super.prototype.parse.call(this, obj);
		if (obj) {
			this.highlightColors.parse(obj["highlightColors"]);
		}
	};
	return TextColorDefinition;
}(ColorDefinition));
exports.TextColorDefinition = TextColorDefinition;
var AdaptiveCardConfig = /** @class */ (function () {
	function AdaptiveCardConfig(obj) {
		this.allowCustomStyle = false;
		if (obj) {
			this.allowCustomStyle = obj["allowCustomStyle"] || this.allowCustomStyle;
		}
	}
	return AdaptiveCardConfig;
}());
exports.AdaptiveCardConfig = AdaptiveCardConfig;
var ImageSetConfig = /** @class */ (function () {
	function ImageSetConfig(obj) {
		this.imageSize = Enums.Size.Medium;
		this.maxImageHeight = 100;
		if (obj) {
			this.imageSize = obj["imageSize"] != null ? obj["imageSize"] : this.imageSize;
			this.maxImageHeight = Utils.parseNumber(obj["maxImageHeight"], 100);
		}
	}
	ImageSetConfig.prototype.toJSON = function () {
		return {
			imageSize: Enums.Size[this.imageSize],
			maxImageHeight: this.maxImageHeight
		};
	};
	return ImageSetConfig;
}());
exports.ImageSetConfig = ImageSetConfig;
var MediaConfig = /** @class */ (function () {
	function MediaConfig(obj) {
		this.allowInlinePlayback = true;
		if (obj) {
			this.defaultPoster = obj["defaultPoster"];
			this.allowInlinePlayback = obj["allowInlinePlayback"] || this.allowInlinePlayback;
		}
	}
	MediaConfig.prototype.toJSON = function () {
		return {
			defaultPoster: this.defaultPoster,
			allowInlinePlayback: this.allowInlinePlayback
		};
	};
	return MediaConfig;
}());
exports.MediaConfig = MediaConfig;
var BaseTextDefinition = /** @class */ (function () {
	function BaseTextDefinition(obj) {
		this.size = Enums.TextSize.Default;
		this.color = Enums.TextColor.Default;
		this.isSubtle = false;
		this.weight = Enums.TextWeight.Default;
		if (obj) {
			this.size = parseHostConfigEnum(Enums.TextSize, obj["size"], this.size);
			this.color = parseHostConfigEnum(Enums.TextColor, obj["color"], this.color);
			this.isSubtle = obj["isSubtle"] || this.isSubtle;
			this.weight = parseHostConfigEnum(Enums.TextWeight, obj["weight"], this.getDefaultWeight());
		}
	}
	;
	BaseTextDefinition.prototype.getDefaultWeight = function () {
		return Enums.TextWeight.Default;
	};
	BaseTextDefinition.prototype.toJSON = function () {
		return {
			size: Enums.TextSize[this.size],
			color: Enums.TextColor[this.color],
			isSubtle: this.isSubtle,
			weight: Enums.TextWeight[this.weight]
		};
	};
	return BaseTextDefinition;
}());
exports.BaseTextDefinition = BaseTextDefinition;
var RequiredInputLabelTextDefinition = /** @class */ (function (_super) {
	__extends(RequiredInputLabelTextDefinition, _super);
	function RequiredInputLabelTextDefinition(obj) {
		var _this = _super.call(this, obj) || this;
		_this.suffix = " *";
		_this.suffixColor = Enums.TextColor.Attention;
		if (obj) {
			_this.suffix = obj["suffix"] || _this.suffix;
			_this.suffixColor = parseHostConfigEnum(Enums.TextColor, obj["suffixColor"], _this.suffixColor);
		}
		return _this;
	}
	RequiredInputLabelTextDefinition.prototype.toJSON = function () {
		var result = _super.prototype.toJSON.call(this);
		result["suffix"] = this.suffix;
		result["suffixColor"] = Enums.TextColor[this.suffixColor];
		return result;
	};
	return RequiredInputLabelTextDefinition;
}(BaseTextDefinition));
exports.RequiredInputLabelTextDefinition = RequiredInputLabelTextDefinition;
var InputLabelConfig = /** @class */ (function () {
	function InputLabelConfig(obj) {
		this.inputSpacing = Enums.Spacing.Small;
		this.requiredInputs = new RequiredInputLabelTextDefinition();
		this.optionalInputs = new BaseTextDefinition();
		if (obj) {
			this.inputSpacing = parseHostConfigEnum(Enums.Spacing, obj["inputSpacing"], this.inputSpacing);
			this.requiredInputs = new RequiredInputLabelTextDefinition(obj["requiredInputs"]);
			this.optionalInputs = new BaseTextDefinition(obj["optionalInputs"]);
		}
	}
	return InputLabelConfig;
}());
exports.InputLabelConfig = InputLabelConfig;
var InputConfig = /** @class */ (function () {
	function InputConfig(obj) {
		this.label = new InputLabelConfig();
		this.errorMessage = new BaseTextDefinition({ color: Enums.TextColor.Attention });
		if (obj) {
			this.label = new InputLabelConfig(obj["label"]);
			this.errorMessage = new BaseTextDefinition(obj["errorMessage"]);
		}
	}
	return InputConfig;
}());
exports.InputConfig = InputConfig;
var FactTextDefinition = /** @class */ (function (_super) {
	__extends(FactTextDefinition, _super);
	function FactTextDefinition(obj) {
		var _this = _super.call(this, obj) || this;
		_this.wrap = true;
		if (obj) {
			_this.wrap = obj["wrap"] != null ? obj["wrap"] : _this.wrap;
		}
		return _this;
	}
	FactTextDefinition.prototype.toJSON = function () {
		var result = _super.prototype.toJSON.call(this);
		result["wrap"] = this.wrap;
		return result;
	};
	return FactTextDefinition;
}(BaseTextDefinition));
exports.FactTextDefinition = FactTextDefinition;
var FactTitleDefinition = /** @class */ (function (_super) {
	__extends(FactTitleDefinition, _super);
	function FactTitleDefinition(obj) {
		var _this = _super.call(this, obj) || this;
		_this.maxWidth = 150;
		_this.weight = Enums.TextWeight.Bolder;
		if (obj) {
			_this.maxWidth = obj["maxWidth"] != null ? obj["maxWidth"] : _this.maxWidth;
			_this.weight = parseHostConfigEnum(Enums.TextWeight, obj["weight"], Enums.TextWeight.Bolder);
		}
		return _this;
	}
	FactTitleDefinition.prototype.getDefaultWeight = function () {
		return Enums.TextWeight.Bolder;
	};
	return FactTitleDefinition;
}(FactTextDefinition));
exports.FactTitleDefinition = FactTitleDefinition;
var FactSetConfig = /** @class */ (function () {
	function FactSetConfig(obj) {
		this.title = new FactTitleDefinition();
		this.value = new FactTextDefinition();
		this.spacing = 10;
		if (obj) {
			this.title = new FactTitleDefinition(obj["title"]);
			this.value = new FactTextDefinition(obj["value"]);
			this.spacing = obj.spacing && obj.spacing != null ? obj.spacing && obj.spacing : this.spacing;
		}
	}
	return FactSetConfig;
}());
exports.FactSetConfig = FactSetConfig;
var ShowCardActionConfig = /** @class */ (function () {
	function ShowCardActionConfig(obj) {
		this.actionMode = Enums.ShowCardActionMode.Inline;
		this.inlineTopMargin = 16;
		this.style = Enums.ContainerStyle.Emphasis;
		if (obj) {
			this.actionMode = parseHostConfigEnum(Enums.ShowCardActionMode, obj["actionMode"], Enums.ShowCardActionMode.Inline);
			this.inlineTopMargin = obj["inlineTopMargin"] != null ? obj["inlineTopMargin"] : this.inlineTopMargin;
			this.style = obj["style"] && typeof obj["style"] === "string" ? obj["style"] : Enums.ContainerStyle.Emphasis;
		}
	}
	ShowCardActionConfig.prototype.toJSON = function () {
		return {
			actionMode: Enums.ShowCardActionMode[this.actionMode],
			inlineTopMargin: this.inlineTopMargin,
			style: this.style
		};
	};
	return ShowCardActionConfig;
}());
exports.ShowCardActionConfig = ShowCardActionConfig;
var ActionsConfig = /** @class */ (function () {
	function ActionsConfig(obj) {
		this.maxActions = 5;
		this.spacing = Enums.Spacing.Default;
		this.buttonSpacing = 20;
		this.showCard = new ShowCardActionConfig();
		this.preExpandSingleShowCardAction = false;
		this.actionsOrientation = Enums.Orientation.Horizontal;
		this.actionAlignment = Enums.ActionAlignment.Left;
		this.iconPlacement = Enums.ActionIconPlacement.LeftOfTitle;
		this.allowTitleToWrap = false;
		this.iconSize = 16;
		if (obj) {
			this.maxActions = obj["maxActions"] != null ? obj["maxActions"] : this.maxActions;
			this.spacing = parseHostConfigEnum(Enums.Spacing, obj.spacing && obj.spacing, Enums.Spacing.Default);
			this.buttonSpacing = obj["buttonSpacing"] != null ? obj["buttonSpacing"] : this.buttonSpacing;
			this.showCard = new ShowCardActionConfig(obj["showCard"]);
			this.preExpandSingleShowCardAction = Utils.parseBool(obj["preExpandSingleShowCardAction"], false);
			this.actionsOrientation = parseHostConfigEnum(Enums.Orientation, obj["actionsOrientation"], Enums.Orientation.Horizontal);
			this.actionAlignment = parseHostConfigEnum(Enums.ActionAlignment, obj["actionAlignment"], Enums.ActionAlignment.Left);
			this.iconPlacement = parseHostConfigEnum(Enums.ActionIconPlacement, obj["iconPlacement"], Enums.ActionIconPlacement.LeftOfTitle);
			this.allowTitleToWrap = obj["allowTitleToWrap"] != null ? obj["allowTitleToWrap"] : this.allowTitleToWrap;
			try {
				var sizeAndUnit = Shared.SizeAndUnit.parse(obj["iconSize"]);
				if (sizeAndUnit.unit == Enums.SizeUnit.Pixel) {
					this.iconSize = sizeAndUnit.physicalSize;
				}
			}
			catch (e) {
				// Swallow this, keep default icon size
			}
		}
	}
	ActionsConfig.prototype.toJSON = function () {
		return {
			maxActions: this.maxActions,
			spacing: Enums.Spacing[this.spacing],
			buttonSpacing: this.buttonSpacing,
			showCard: this.showCard,
			preExpandSingleShowCardAction: this.preExpandSingleShowCardAction,
			actionsOrientation: Enums.Orientation[this.actionsOrientation],
			actionAlignment: Enums.ActionAlignment[this.actionAlignment]
		};
	};
	return ActionsConfig;
}());
exports.ActionsConfig = ActionsConfig;
var ColorSetDefinition = /** @class */ (function () {
	function ColorSetDefinition(obj) {
		this.default = new TextColorDefinition();
		this.dark = new TextColorDefinition();
		this.light = new TextColorDefinition();
		this.accent = new TextColorDefinition();
		this.good = new TextColorDefinition();
		this.warning = new TextColorDefinition();
		this.attention = new TextColorDefinition();
		this.parse(obj);
	}
	ColorSetDefinition.prototype.parseSingleColor = function (obj, propertyName) {
		if (obj) {
			this[propertyName].parse(obj[propertyName]);
		}
	};
	ColorSetDefinition.prototype.parse = function (obj) {
		if (obj) {
			this.parseSingleColor(obj, "default");
			this.parseSingleColor(obj, "dark");
			this.parseSingleColor(obj, "light");
			this.parseSingleColor(obj, "accent");
			this.parseSingleColor(obj, "good");
			this.parseSingleColor(obj, "warning");
			this.parseSingleColor(obj, "attention");
		}
	};
	return ColorSetDefinition;
}());
exports.ColorSetDefinition = ColorSetDefinition;
var ContainerStyleDefinition = /** @class */ (function () {
	function ContainerStyleDefinition(obj) {
		this.foregroundColors = new ColorSetDefinition({
			"default": { default: "#333333", subtle: "#EE333333" },
			"dark": { default: "#000000", subtle: "#66000000" },
			"light": { default: "#FFFFFF", subtle: "#33000000" },
			"accent": { default: "#2E89FC", subtle: "#882E89FC" },
			"good": { default: "#028A02", subtle: "#DD027502" },
			"warning": { default: "#E69500", subtle: "#DDE69500" },
			"attention": { default: "#CC3300", subtle: "#DDCC3300" }
		});
		this.parse(obj);
	}
	ContainerStyleDefinition.prototype.parse = function (obj) {
		if (obj) {
			this.backgroundColor = obj["backgroundColor"];
			this.foregroundColors.parse(obj["foregroundColors"]);
			this.highlightBackgroundColor = obj["highlightBackgroundColor"];
			this.highlightForegroundColor = obj["highlightForegroundColor"];
		}
	};
	Object.defineProperty(ContainerStyleDefinition.prototype, "isBuiltIn", {
		get: function () {
			return false;
		},
		enumerable: false,
		configurable: true
	});
	return ContainerStyleDefinition;
}());
exports.ContainerStyleDefinition = ContainerStyleDefinition;
var BuiltInContainerStyleDefinition = /** @class */ (function (_super) {
	__extends(BuiltInContainerStyleDefinition, _super);
	function BuiltInContainerStyleDefinition() {
		return _super !== null && _super.apply(this, arguments) || this;
	}
	Object.defineProperty(BuiltInContainerStyleDefinition.prototype, "isBuiltIn", {
		get: function () {
			return true;
		},
		enumerable: false,
		configurable: true
	});
	return BuiltInContainerStyleDefinition;
}(ContainerStyleDefinition));
var ContainerStyleSet = /** @class */ (function () {
	function ContainerStyleSet(obj) {
		this._allStyles = {};
		this._allStyles[Enums.ContainerStyle.Default] = new BuiltInContainerStyleDefinition();
		this._allStyles[Enums.ContainerStyle.Emphasis] = new BuiltInContainerStyleDefinition();
		this._allStyles[Enums.ContainerStyle.Accent] = new BuiltInContainerStyleDefinition();
		this._allStyles[Enums.ContainerStyle.Good] = new BuiltInContainerStyleDefinition();
		this._allStyles[Enums.ContainerStyle.Attention] = new BuiltInContainerStyleDefinition();
		this._allStyles[Enums.ContainerStyle.Warning] = new BuiltInContainerStyleDefinition();
		if (obj) {
			this._allStyles[Enums.ContainerStyle.Default].parse(obj[Enums.ContainerStyle.Default]);
			this._allStyles[Enums.ContainerStyle.Emphasis].parse(obj[Enums.ContainerStyle.Emphasis]);
			this._allStyles[Enums.ContainerStyle.Accent].parse(obj[Enums.ContainerStyle.Accent]);
			this._allStyles[Enums.ContainerStyle.Good].parse(obj[Enums.ContainerStyle.Good]);
			this._allStyles[Enums.ContainerStyle.Attention].parse(obj[Enums.ContainerStyle.Attention]);
			this._allStyles[Enums.ContainerStyle.Warning].parse(obj[Enums.ContainerStyle.Warning]);
			var customStyleArray = obj["customStyles"];
			if (customStyleArray && Array.isArray(customStyleArray)) {
				for (var _i = 0, customStyleArray_1 = customStyleArray; _i < customStyleArray_1.length; _i++) {
					var customStyle = customStyleArray_1[_i];
					if (customStyle) {
						var styleName = customStyle["name"];
						if (styleName && typeof styleName === "string") {
							if (this._allStyles.hasOwnProperty(styleName)) {
								this._allStyles[styleName].parse(customStyle["style"]);
							}
							else {
								this._allStyles[styleName] = new ContainerStyleDefinition(customStyle["style"]);
							}
						}
					}
				}
			}
		}
	}
	ContainerStyleSet.prototype.toJSON = function () {
		var _this = this;
		var customStyleArray = [];
		Object.keys(this._allStyles).forEach(function (key) {
			if (!_this._allStyles[key].isBuiltIn) {
				customStyleArray.push({
					name: key,
					style: _this._allStyles[key]
				});
			}
		});
		var result = {
			default: this.default,
			emphasis: this.emphasis
		};
		if (customStyleArray.length > 0) {
			result.customStyles = customStyleArray;
		}
		return result;
	};
	ContainerStyleSet.prototype.getStyleByName = function (name, defaultValue) {
		if (name && this._allStyles.hasOwnProperty(name)) {
			return this._allStyles[name];
		}
		else {
			return defaultValue ? defaultValue : this._allStyles[Enums.ContainerStyle.Default];
		}
	};
	Object.defineProperty(ContainerStyleSet.prototype, "default", {
		get: function () {
			return this._allStyles[Enums.ContainerStyle.Default];
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(ContainerStyleSet.prototype, "emphasis", {
		get: function () {
			return this._allStyles[Enums.ContainerStyle.Emphasis];
		},
		enumerable: false,
		configurable: true
	});
	return ContainerStyleSet;
}());
exports.ContainerStyleSet = ContainerStyleSet;
var FontTypeDefinition = /** @class */ (function () {
	function FontTypeDefinition(fontFamily) {
		this.fontFamily = "Segoe UI,Segoe,Segoe WP,Helvetica Neue,Helvetica,sans-serif";
		this.fontSizes = {
			small: 12,
			default: 14,
			medium: 17,
			large: 21,
			extraLarge: 26
		};
		this.fontWeights = {
			lighter: 200,
			default: 400,
			bolder: 600
		};
		if (fontFamily) {
			this.fontFamily = fontFamily;
		}
	}
	FontTypeDefinition.prototype.parse = function (obj) {
		this.fontFamily = obj["fontFamily"] || this.fontFamily;
		this.fontSizes = {
			small: obj.fontSizes && obj.fontSizes["small"] || this.fontSizes.small,
			default: obj.fontSizes && obj.fontSizes["default"] || this.fontSizes.default,
			medium: obj.fontSizes && obj.fontSizes["medium"] || this.fontSizes.medium,
			large: obj.fontSizes && obj.fontSizes["large"] || this.fontSizes.large,
			extraLarge: obj.fontSizes && obj.fontSizes["extraLarge"] || this.fontSizes.extraLarge
		};
		this.fontWeights = {
			lighter: obj.fontWeights && obj.fontWeights["lighter"] || this.fontWeights.lighter,
			default: obj.fontWeights && obj.fontWeights["default"] || this.fontWeights.default,
			bolder: obj.fontWeights && obj.fontWeights["bolder"] || this.fontWeights.bolder
		};
	};
	FontTypeDefinition.monospace = new FontTypeDefinition("'Courier New', Courier, monospace");
	return FontTypeDefinition;
}());
exports.FontTypeDefinition = FontTypeDefinition;
var FontTypeSet = /** @class */ (function () {
	function FontTypeSet(obj) {
		this.default = new FontTypeDefinition();
		this.monospace = new FontTypeDefinition("'Courier New', Courier, monospace");
		if (obj) {
			this.default.parse(obj["default"]);
			this.monospace.parse(obj["monospace"]);
		}
	}
	FontTypeSet.prototype.getStyleDefinition = function (style) {
		switch (style) {
			case Enums.FontType.Monospace:
				return this.monospace;
			case Enums.FontType.Default:
			default:
				return this.default;
		}
	};
	return FontTypeSet;
}());
exports.FontTypeSet = FontTypeSet;
var HostConfig = /** @class */ (function () {
	function HostConfig(obj) {
		this.hostCapabilities = new host_capabilities_1.HostCapabilities();
		this.choiceSetInputValueSeparator = ",";
		this.supportsInteractivity = true;
		this.spacing = {
			small: 3,
			default: 8,
			medium: 20,
			large: 30,
			extraLarge: 40,
			padding: 15
		};
		this.separator = {
			lineThickness: 1,
			lineColor: "#EEEEEE"
		};
		this.imageSizes = {
			small: 40,
			medium: 80,
			large: 160
		};
		this.containerStyles = new ContainerStyleSet();
		this.inputs = new InputConfig();
		this.actions = new ActionsConfig();
		this.adaptiveCard = new AdaptiveCardConfig();
		this.imageSet = new ImageSetConfig();
		this.media = new MediaConfig();
		this.factSet = new FactSetConfig();
		this.alwaysAllowBleed = false;
		if (obj) {
			if (typeof obj === "string" || obj instanceof String) {
				obj = JSON.parse(obj);
			}
			this.choiceSetInputValueSeparator = (obj && typeof obj["choiceSetInputValueSeparator"] === "string") ? obj["choiceSetInputValueSeparator"] : this.choiceSetInputValueSeparator;
			this.supportsInteractivity = (obj && typeof obj["supportsInteractivity"] === "boolean") ? obj["supportsInteractivity"] : this.supportsInteractivity;
			this._legacyFontType = new FontTypeDefinition();
			this._legacyFontType.parse(obj);
			if (obj.fontTypes) {
				this.fontTypes = new FontTypeSet(obj.fontTypes);
			}
			if (obj.lineHeights) {
				this.lineHeights = {
					small: obj.lineHeights["small"],
					default: obj.lineHeights["default"],
					medium: obj.lineHeights["medium"],
					large: obj.lineHeights["large"],
					extraLarge: obj.lineHeights["extraLarge"]
				};
			}
			;
			this.imageSizes = {
				small: obj.imageSizes && obj.imageSizes["small"] || this.imageSizes.small,
				medium: obj.imageSizes && obj.imageSizes["medium"] || this.imageSizes.medium,
				large: obj.imageSizes && obj.imageSizes["large"] || this.imageSizes.large,
			};
			this.containerStyles = new ContainerStyleSet(obj["containerStyles"]);
			this.spacing = {
				small: obj.spacing && obj.spacing["small"] || this.spacing.small,
				default: obj.spacing && obj.spacing["default"] || this.spacing.default,
				medium: obj.spacing && obj.spacing["medium"] || this.spacing.medium,
				large: obj.spacing && obj.spacing["large"] || this.spacing.large,
				extraLarge: obj.spacing && obj.spacing["extraLarge"] || this.spacing.extraLarge,
				padding: obj.spacing && obj.spacing["padding"] || this.spacing.padding
			};
			this.separator = {
				lineThickness: obj.separator && obj.separator["lineThickness"] || this.separator.lineThickness,
				lineColor: obj.separator && obj.separator["lineColor"] || this.separator.lineColor
			};
			this.inputs = new InputConfig(obj.inputs || this.inputs);
			this.actions = new ActionsConfig(obj.actions || this.actions);
			this.adaptiveCard = new AdaptiveCardConfig(obj.adaptiveCard || this.adaptiveCard);
			this.imageSet = new ImageSetConfig(obj["imageSet"]);
			this.factSet = new FactSetConfig(obj["factSet"]);
		}
	}
	HostConfig.prototype.getFontTypeDefinition = function (style) {
		if (this.fontTypes) {
			return this.fontTypes.getStyleDefinition(style);
		}
		else {
			return style == Enums.FontType.Monospace ? FontTypeDefinition.monospace : this._legacyFontType;
		}
	};
	HostConfig.prototype.getEffectiveSpacing = function (spacing) {
		switch (spacing) {
			case Enums.Spacing.Small:
				return this.spacing.small;
			case Enums.Spacing.Default:
				return this.spacing.default;
			case Enums.Spacing.Medium:
				return this.spacing.medium;
			case Enums.Spacing.Large:
				return this.spacing.large;
			case Enums.Spacing.ExtraLarge:
				return this.spacing.extraLarge;
			case Enums.Spacing.Padding:
				return this.spacing.padding;
			default:
				return 0;
		}
	};
	HostConfig.prototype.paddingDefinitionToSpacingDefinition = function (paddingDefinition) {
		return new Shared.SpacingDefinition(this.getEffectiveSpacing(paddingDefinition.top), this.getEffectiveSpacing(paddingDefinition.right), this.getEffectiveSpacing(paddingDefinition.bottom), this.getEffectiveSpacing(paddingDefinition.left));
	};
	HostConfig.prototype.makeCssClassNames = function () {
		var classNames = [];
		for (var _i = 0; _i < arguments.length; _i++) {
			classNames[_i] = arguments[_i];
		}
		var result = [];
		for (var _a = 0, classNames_1 = classNames; _a < classNames_1.length; _a++) {
			var className = classNames_1[_a];
			result.push((this.cssClassNamePrefix ? this.cssClassNamePrefix + "-" : "") + className);
		}
		return result;
	};
	HostConfig.prototype.makeCssClassName = function () {
		var classNames = [];
		for (var _i = 0; _i < arguments.length; _i++) {
			classNames[_i] = arguments[_i];
		}
		var result = this.makeCssClassNames.apply(this, classNames).join(" ");
		return result ? result : "";
	};
	Object.defineProperty(HostConfig.prototype, "fontFamily", {
		get: function () {
			return this._legacyFontType.fontFamily;
		},
		set: function (value) {
			this._legacyFontType.fontFamily = value;
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(HostConfig.prototype, "fontSizes", {
		get: function () {
			return this._legacyFontType.fontSizes;
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(HostConfig.prototype, "fontWeights", {
		get: function () {
			return this._legacyFontType.fontWeights;
		},
		enumerable: false,
		configurable: true
	});
	return HostConfig;
}());
exports.HostConfig = HostConfig;
exports.defaultHostConfig = new HostConfig({
	supportsInteractivity: true,
	spacing: {
		small: 10,
		default: 20,
		medium: 30,
		large: 40,
		extraLarge: 50,
		padding: 20
	},
	separator: {
		lineThickness: 1,
		lineColor: "#EEEEEE"
	},
	fontTypes: {
		default: {
			fontFamily: "'Segoe UI', Tahoma, Geneva, Verdana, sans-serif",
			fontSizes: {
				small: 12,
				default: 14,
				medium: 17,
				large: 21,
				extraLarge: 26
			},
			fontWeights: {
				lighter: 200,
				default: 400,
				bolder: 600
			}
		},
		monospace: {
			fontFamily: "'Courier New', Courier, monospace",
			fontSizes: {
				small: 12,
				default: 14,
				medium: 17,
				large: 21,
				extraLarge: 26
			},
			fontWeights: {
				lighter: 200,
				default: 400,
				bolder: 600
			}
		}
	},
	imageSizes: {
		small: 40,
		medium: 80,
		large: 160
	},
	containerStyles: {
		default: {
			backgroundColor: "#FFFFFF",
			foregroundColors: {
				default: {
					default: "#333333",
					subtle: "#EE333333"
				},
				dark: {
					default: "#000000",
					subtle: "#66000000"
				},
				light: {
					default: "#FFFFFF",
					subtle: "#33000000"
				},
				accent: {
					default: "#2E89FC",
					subtle: "#882E89FC"
				},
				attention: {
					default: "#cc3300",
					subtle: "#DDcc3300"
				},
				good: {
					default: "#028A02",
					subtle: "#DD027502"
				},
				warning: {
					default: "#e69500",
					subtle: "#DDe69500"
				}
			}
		},
		emphasis: {
			backgroundColor: "#08000000",
			foregroundColors: {
				default: {
					default: "#333333",
					subtle: "#EE333333"
				},
				dark: {
					default: "#000000",
					subtle: "#66000000"
				},
				light: {
					default: "#FFFFFF",
					subtle: "#33000000"
				},
				accent: {
					default: "#2E89FC",
					subtle: "#882E89FC"
				},
				attention: {
					default: "#cc3300",
					subtle: "#DDcc3300"
				},
				good: {
					default: "#028A02",
					subtle: "#DD027502"
				},
				warning: {
					default: "#e69500",
					subtle: "#DDe69500"
				}
			}
		},
		accent: {
			backgroundColor: "#C7DEF9",
			foregroundColors: {
				default: {
					default: "#333333",
					subtle: "#EE333333"
				},
				dark: {
					default: "#000000",
					subtle: "#66000000"
				},
				light: {
					default: "#FFFFFF",
					subtle: "#33000000"
				},
				accent: {
					default: "#2E89FC",
					subtle: "#882E89FC"
				},
				attention: {
					default: "#cc3300",
					subtle: "#DDcc3300"
				},
				good: {
					default: "#028A02",
					subtle: "#DD027502"
				},
				warning: {
					default: "#e69500",
					subtle: "#DDe69500"
				}
			}
		},
		good: {
			backgroundColor: "#CCFFCC",
			foregroundColors: {
				default: {
					default: "#333333",
					subtle: "#EE333333"
				},
				dark: {
					default: "#000000",
					subtle: "#66000000"
				},
				light: {
					default: "#FFFFFF",
					subtle: "#33000000"
				},
				accent: {
					default: "#2E89FC",
					subtle: "#882E89FC"
				},
				attention: {
					default: "#cc3300",
					subtle: "#DDcc3300"
				},
				good: {
					default: "#028A02",
					subtle: "#DD027502"
				},
				warning: {
					default: "#e69500",
					subtle: "#DDe69500"
				}
			}
		},
		attention: {
			backgroundColor: "#FFC5B2",
			foregroundColors: {
				default: {
					default: "#333333",
					subtle: "#EE333333"
				},
				dark: {
					default: "#000000",
					subtle: "#66000000"
				},
				light: {
					default: "#FFFFFF",
					subtle: "#33000000"
				},
				accent: {
					default: "#2E89FC",
					subtle: "#882E89FC"
				},
				attention: {
					default: "#cc3300",
					subtle: "#DDcc3300"
				},
				good: {
					default: "#028A02",
					subtle: "#DD027502"
				},
				warning: {
					default: "#e69500",
					subtle: "#DDe69500"
				}
			}
		},
		warning: {
			backgroundColor: "#FFE2B2",
			foregroundColors: {
				default: {
					default: "#333333",
					subtle: "#EE333333"
				},
				dark: {
					default: "#000000",
					subtle: "#66000000"
				},
				light: {
					default: "#FFFFFF",
					subtle: "#33000000"
				},
				accent: {
					default: "#2E89FC",
					subtle: "#882E89FC"
				},
				attention: {
					default: "#cc3300",
					subtle: "#DDcc3300"
				},
				good: {
					default: "#028A02",
					subtle: "#DD027502"
				},
				warning: {
					default: "#e69500",
					subtle: "#DDe69500"
				}
			}
		}
	},
	inputs: {
		label: {
			requiredInputs: {
				color: Enums.TextColor.Accent,
				size: Enums.TextSize.ExtraLarge,
				weight: Enums.TextWeight.Bolder,
				isSubtle: true,
				suffix: " (required)",
				suffixColor: Enums.TextColor.Good
			},
			optionalInputs: {
				color: Enums.TextColor.Warning,
				size: Enums.TextSize.Medium,
				weight: Enums.TextWeight.Lighter,
				isSubtle: false
			}
		},
		errorMessage: {
			color: Enums.TextColor.Accent,
			size: Enums.TextSize.Small,
			weight: Enums.TextWeight.Bolder
		}
	},
	actions: {
		maxActions: 5,
		spacing: Enums.Spacing.Default,
		buttonSpacing: 10,
		showCard: {
			actionMode: Enums.ShowCardActionMode.Inline,
			inlineTopMargin: 16
		},
		actionsOrientation: Enums.Orientation.Horizontal,
		actionAlignment: Enums.ActionAlignment.Left
	},
	adaptiveCard: {
		allowCustomStyle: false
	},
	imageSet: {
		imageSize: Enums.Size.Medium,
		maxImageHeight: 100
	},
	factSet: {
		title: {
			color: Enums.TextColor.Default,
			size: Enums.TextSize.Default,
			isSubtle: false,
			weight: Enums.TextWeight.Bolder,
			wrap: true,
			maxWidth: 150,
		},
		value: {
			color: Enums.TextColor.Default,
			size: Enums.TextSize.Default,
			isSubtle: false,
			weight: Enums.TextWeight.Default,
			wrap: true,
		},
		spacing: 10
	}
});


/***/ }),

/***/ "./src/registry.ts":
/*!*************************!*\
  !*** ./src/registry.ts ***!
  \*************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.CardObjectRegistry = void 0;
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
var serialization_1 = __webpack_require__(/*! ./serialization */ "./src/serialization.ts");
var CardObjectRegistry = /** @class */ (function () {
	function CardObjectRegistry() {
		this._items = {};
	}
	CardObjectRegistry.prototype.findByName = function (typeName) {
		return this._items.hasOwnProperty(typeName) ? this._items[typeName] : undefined;
	};
	CardObjectRegistry.prototype.clear = function () {
		this._items = {};
	};
	CardObjectRegistry.prototype.register = function (typeName, objectType, schemaVersion) {
		if (schemaVersion === void 0) { schemaVersion = serialization_1.Versions.v1_0; }
		var registrationInfo = this.findByName(typeName);
		if (registrationInfo !== undefined) {
			registrationInfo.objectType = objectType;
		}
		else {
			registrationInfo = {
				typeName: typeName,
				objectType: objectType,
				schemaVersion: schemaVersion
			};
		}
		this._items[typeName] = registrationInfo;
	};
	CardObjectRegistry.prototype.unregister = function (typeName) {
		delete this._items[typeName];
	};
	CardObjectRegistry.prototype.createInstance = function (typeName, targetVersion) {
		var registrationInfo = this.findByName(typeName);
		return (registrationInfo && registrationInfo.schemaVersion.compareTo(targetVersion) <= 0) ? new registrationInfo.objectType() : undefined;
	};
	CardObjectRegistry.prototype.getItemCount = function () {
		return Object.keys(this._items).length;
	};
	CardObjectRegistry.prototype.getItemAt = function (index) {
		var _this = this;
		return Object.keys(this._items).map(function (e) { return _this._items[e]; })[index];
	};
	return CardObjectRegistry;
}());
exports.CardObjectRegistry = CardObjectRegistry;


/***/ }),

/***/ "./src/serialization.ts":
/*!******************************!*\
  !*** ./src/serialization.ts ***!
  \******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
	var extendStatics = function (d, b) {
		extendStatics = Object.setPrototypeOf ||
			({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
			function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
		return extendStatics(d, b);
	};
	return function (d, b) {
		extendStatics(d, b);
		function __() { this.constructor = d; }
		d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.SerializableObject = exports.property = exports.SerializableObjectSchema = exports.CustomProperty = exports.SerializableObjectCollectionProperty = exports.SerializableObjectProperty = exports.EnumProperty = exports.ValueSetProperty = exports.StringArrayProperty = exports.PixelSizeProperty = exports.NumProperty = exports.BoolProperty = exports.StringProperty = exports.PropertyDefinition = exports.BaseSerializationContext = exports.isVersionLessOrEqual = exports.Versions = exports.Version = void 0;
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
var shared_1 = __webpack_require__(/*! ./shared */ "./src/shared.ts");
var Utils = __webpack_require__(/*! ./utils */ "./src/utils.ts");
var Enums = __webpack_require__(/*! ./enums */ "./src/enums.ts");
var strings_1 = __webpack_require__(/*! ./strings */ "./src/strings.ts");
var Version = /** @class */ (function () {
	function Version(major, minor, label) {
		if (major === void 0) { major = 1; }
		if (minor === void 0) { minor = 1; }
		this._isValid = true;
		this._major = major;
		this._minor = minor;
		this._label = label;
	}
	Version.parse = function (versionString, context) {
		if (!versionString) {
			return undefined;
		}
		var result = new Version();
		result._versionString = versionString;
		var regEx = /(\d+).(\d+)/gi;
		var matches = regEx.exec(versionString);
		if (matches != null && matches.length == 3) {
			result._major = parseInt(matches[1]);
			result._minor = parseInt(matches[2]);
		}
		else {
			result._isValid = false;
		}
		if (!result._isValid) {
			context.logParseEvent(undefined, Enums.ValidationEvent.InvalidPropertyValue, strings_1.Strings.errors.invalidVersionString(result._versionString));
		}
		return result;
	};
	Version.prototype.toString = function () {
		return !this._isValid ? this._versionString : this._major + "." + this._minor;
	};
	Version.prototype.toJSON = function () {
		return this.toString();
	};
	Version.prototype.compareTo = function (otherVersion) {
		if (!this.isValid || !otherVersion.isValid) {
			throw new Error("Cannot compare invalid version.");
		}
		if (this.major > otherVersion.major) {
			return 1;
		}
		else if (this.major < otherVersion.major) {
			return -1;
		}
		else if (this.minor > otherVersion.minor) {
			return 1;
		}
		else if (this.minor < otherVersion.minor) {
			return -1;
		}
		return 0;
	};
	Object.defineProperty(Version.prototype, "label", {
		get: function () {
			return this._label ? this._label : this.toString();
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(Version.prototype, "major", {
		get: function () {
			return this._major;
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(Version.prototype, "minor", {
		get: function () {
			return this._minor;
		},
		enumerable: false,
		configurable: true
	});
	Object.defineProperty(Version.prototype, "isValid", {
		get: function () {
			return this._isValid;
		},
		enumerable: false,
		configurable: true
	});
	return Version;
}());
exports.Version = Version;
var Versions = /** @class */ (function () {
	function Versions() {
	}
	Versions.v1_0 = new Version(1, 0);
	Versions.v1_1 = new Version(1, 1);
	Versions.v1_2 = new Version(1, 2);
	Versions.v1_3 = new Version(1, 3);
	Versions.v1_4 = new Version(1, 4);
	Versions.latest = Versions.v1_4;
	return Versions;
}());
exports.Versions = Versions;
function isVersionLessOrEqual(version, targetVersion) {
	if (version instanceof Version) {
		if (targetVersion instanceof Version) {
			return targetVersion.compareTo(version) >= 0;
		}
		else {
			// Target version is *
			return true;
		}
	}
	else {
		// Version is *
		return true;
	}
}
exports.isVersionLessOrEqual = isVersionLessOrEqual;
var BaseSerializationContext = /** @class */ (function () {
	function BaseSerializationContext(targetVersion) {
		if (targetVersion === void 0) { targetVersion = Versions.latest; }
		this.targetVersion = targetVersion;
		this._validationEvents = [];
	}
	BaseSerializationContext.prototype.serializeValue = function (target, propertyName, propertyValue, defaultValue, forceDeleteIfNullOrDefault) {
		if (defaultValue === void 0) { defaultValue = undefined; }
		if (forceDeleteIfNullOrDefault === void 0) { forceDeleteIfNullOrDefault = false; }
		if (propertyValue === null || propertyValue === undefined || propertyValue === defaultValue) {
			if (!shared_1.GlobalSettings.enableFullJsonRoundTrip || forceDeleteIfNullOrDefault) {
				delete target[propertyName];
			}
		}
		else {
			target[propertyName] = propertyValue;
		}
	};
	BaseSerializationContext.prototype.serializeString = function (target, propertyName, propertyValue, defaultValue) {
		if (propertyValue === null || propertyValue === undefined || propertyValue === defaultValue) {
			delete target[propertyName];
		}
		else {
			target[propertyName] = propertyValue;
		}
	};
	BaseSerializationContext.prototype.serializeBool = function (target, propertyName, propertyValue, defaultValue) {
		if (propertyValue === null || propertyValue === undefined || propertyValue === defaultValue) {
			delete target[propertyName];
		}
		else {
			target[propertyName] = propertyValue;
		}
	};
	BaseSerializationContext.prototype.serializeNumber = function (target, propertyName, propertyValue, defaultValue) {
		if (propertyValue === null || propertyValue === undefined || propertyValue === defaultValue || isNaN(propertyValue)) {
			delete target[propertyName];
		}
		else {
			target[propertyName] = propertyValue;
		}
	};
	BaseSerializationContext.prototype.serializeEnum = function (enumType, target, propertyName, propertyValue, defaultValue) {
		if (defaultValue === void 0) { defaultValue = undefined; }
		var targetValue = target[propertyName];
		var canDeleteTarget = targetValue == undefined ? true : enumType[targetValue] !== undefined;
		if (propertyValue == defaultValue) {
			if (canDeleteTarget) {
				delete target[propertyName];
			}
		}
		else {
			if (propertyValue == undefined) {
				if (canDeleteTarget) {
					delete target[propertyName];
				}
			}
			else {
				target[propertyName] = enumType[propertyValue];
			}
		}
	};
	BaseSerializationContext.prototype.serializeArray = function (target, propertyName, propertyValue) {
		var items = [];
		if (propertyValue) {
			for (var _i = 0, propertyValue_1 = propertyValue; _i < propertyValue_1.length; _i++) {
				var item = propertyValue_1[_i];
				var serializedItem = undefined;
				if (item instanceof SerializableObject) {
					serializedItem = item.toJSON(this);
				}
				else if (item.toJSON) {
					serializedItem = item.toJSON();
				}
				else {
					serializedItem = item;
				}
				if (serializedItem !== undefined) {
					items.push(serializedItem);
				}
			}
		}
		if (items.length == 0) {
			if (target.hasOwnProperty(propertyName) && Array.isArray(target[propertyName])) {
				delete target[propertyName];
			}
		}
		else {
			this.serializeValue(target, propertyName, items);
		}
	};
	BaseSerializationContext.prototype.clearEvents = function () {
		this._validationEvents = [];
	};
	BaseSerializationContext.prototype.logEvent = function (source, phase, event, message) {
		this._validationEvents.push({
			source: source,
			phase: phase,
			event: event,
			message: message
		});
	};
	BaseSerializationContext.prototype.logParseEvent = function (source, event, message) {
		this.logEvent(source, Enums.ValidationPhase.Parse, event, message);
	};
	BaseSerializationContext.prototype.getEventAt = function (index) {
		return this._validationEvents[index];
	};
	Object.defineProperty(BaseSerializationContext.prototype, "eventCount", {
		get: function () {
			return this._validationEvents.length;
		},
		enumerable: false,
		configurable: true
	});
	return BaseSerializationContext;
}());
exports.BaseSerializationContext = BaseSerializationContext;
var SimpleSerializationContext = /** @class */ (function (_super) {
	__extends(SimpleSerializationContext, _super);
	function SimpleSerializationContext() {
		return _super !== null && _super.apply(this, arguments) || this;
	}
	return SimpleSerializationContext;
}(BaseSerializationContext));
var PropertyDefinition = /** @class */ (function () {
	function PropertyDefinition(targetVersion, name, defaultValue, onGetInitialValue) {
		this.targetVersion = targetVersion;
		this.name = name;
		this.defaultValue = defaultValue;
		this.onGetInitialValue = onGetInitialValue;
		this.isSerializationEnabled = true;
		this.sequentialNumber = PropertyDefinition._sequentialNumber;
		PropertyDefinition._sequentialNumber++;
	}
	PropertyDefinition.prototype.getInternalName = function () {
		return this.name;
	};
	PropertyDefinition.prototype.parse = function (sender, source, context) {
		return source[this.name];
	};
	PropertyDefinition.prototype.toJSON = function (sender, target, value, context) {
		context.serializeValue(target, this.name, value, this.defaultValue);
	};
	PropertyDefinition._sequentialNumber = 0;
	return PropertyDefinition;
}());
exports.PropertyDefinition = PropertyDefinition;
var StringProperty = /** @class */ (function (_super) {
	__extends(StringProperty, _super);
	function StringProperty(targetVersion, name, treatEmptyAsUndefined, regEx, defaultValue, onGetInitialValue) {
		if (treatEmptyAsUndefined === void 0) { treatEmptyAsUndefined = true; }
		var _this = _super.call(this, targetVersion, name, defaultValue, onGetInitialValue) || this;
		_this.targetVersion = targetVersion;
		_this.name = name;
		_this.treatEmptyAsUndefined = treatEmptyAsUndefined;
		_this.regEx = regEx;
		_this.defaultValue = defaultValue;
		_this.onGetInitialValue = onGetInitialValue;
		return _this;
	}
	StringProperty.prototype.parse = function (sender, source, context) {
		var parsedValue = Utils.parseString(source[this.name], this.defaultValue);
		var isUndefined = parsedValue === undefined || (parsedValue === "" && this.treatEmptyAsUndefined);
		if (!isUndefined && this.regEx !== undefined) {
			var matches = this.regEx.exec(parsedValue);
			if (!matches) {
				context.logParseEvent(sender, Enums.ValidationEvent.InvalidPropertyValue, strings_1.Strings.errors.invalidPropertyValue(parsedValue, this.name));
				return undefined;
			}
		}
		return parsedValue;
	};
	StringProperty.prototype.toJSON = function (sender, target, value, context) {
		context.serializeString(target, this.name, value === "" && this.treatEmptyAsUndefined ? undefined : value, this.defaultValue);
	};
	return StringProperty;
}(PropertyDefinition));
exports.StringProperty = StringProperty;
var BoolProperty = /** @class */ (function (_super) {
	__extends(BoolProperty, _super);
	function BoolProperty() {
		return _super !== null && _super.apply(this, arguments) || this;
	}
	BoolProperty.prototype.parse = function (sender, source, context) {
		return Utils.parseBool(source[this.name], this.defaultValue);
	};
	BoolProperty.prototype.toJSON = function (sender, target, value, context) {
		context.serializeBool(target, this.name, value, this.defaultValue);
	};
	return BoolProperty;
}(PropertyDefinition));
exports.BoolProperty = BoolProperty;
var NumProperty = /** @class */ (function (_super) {
	__extends(NumProperty, _super);
	function NumProperty() {
		return _super !== null && _super.apply(this, arguments) || this;
	}
	NumProperty.prototype.parse = function (sender, source, context) {
		return Utils.parseNumber(source[this.name], this.defaultValue);
	};
	NumProperty.prototype.toJSON = function (sender, target, value, context) {
		context.serializeNumber(target, this.name, value, this.defaultValue);
	};
	return NumProperty;
}(PropertyDefinition));
exports.NumProperty = NumProperty;
var PixelSizeProperty = /** @class */ (function (_super) {
	__extends(PixelSizeProperty, _super);
	function PixelSizeProperty() {
		return _super !== null && _super.apply(this, arguments) || this;
	}
	PixelSizeProperty.prototype.parse = function (sender, source, context) {
		var result = undefined;
		var value = source[this.name];
		if (typeof value === "string") {
			var isValid = false;
			try {
				var size = shared_1.SizeAndUnit.parse(value, true);
				if (size.unit == Enums.SizeUnit.Pixel) {
					result = size.physicalSize;
					isValid = true;
				}
			}
			catch (_a) {
				// Do nothing. A parse error is emitted below
			}
			if (!isValid) {
				context.logParseEvent(sender, Enums.ValidationEvent.InvalidPropertyValue, strings_1.Strings.errors.invalidPropertyValue(source[this.name], "minHeight"));
			}
		}
		return result;
	};
	PixelSizeProperty.prototype.toJSON = function (sender, target, value, context) {
		context.serializeValue(target, this.name, typeof value === "number" && !isNaN(value) ? value + "px" : undefined);
	};
	return PixelSizeProperty;
}(PropertyDefinition));
exports.PixelSizeProperty = PixelSizeProperty;
var StringArrayProperty = /** @class */ (function (_super) {
	__extends(StringArrayProperty, _super);
	function StringArrayProperty(targetVersion, name, defaultValue, onGetInitialValue) {
		var _this = _super.call(this, targetVersion, name, defaultValue, onGetInitialValue) || this;
		_this.targetVersion = targetVersion;
		_this.name = name;
		_this.defaultValue = defaultValue;
		_this.onGetInitialValue = onGetInitialValue;
		return _this;
	}
	StringArrayProperty.prototype.parse = function (sender, source, context) {
		var sourceValue = source[this.name];
		if (sourceValue === undefined || !Array.isArray(sourceValue)) {
			return this.defaultValue;
		}
		var result = [];
		for (var _i = 0, sourceValue_1 = sourceValue; _i < sourceValue_1.length; _i++) {
			var value = sourceValue_1[_i];
			if (typeof value === "string") {
				result.push(value);
			}
			else {
				context.logParseEvent(sender, Enums.ValidationEvent.InvalidPropertyValue, "Invalid array value \"" + value + "\" of type \"" + typeof value + "\" ignored for \"" + this.name + "\".");
			}
		}
		return result;
	};
	StringArrayProperty.prototype.toJSON = function (sender, target, value, context) {
		context.serializeArray(target, this.name, value);
	};
	return StringArrayProperty;
}(PropertyDefinition));
exports.StringArrayProperty = StringArrayProperty;
var ValueSetProperty = /** @class */ (function (_super) {
	__extends(ValueSetProperty, _super);
	function ValueSetProperty(targetVersion, name, values, defaultValue, onGetInitialValue) {
		var _this = _super.call(this, targetVersion, name, defaultValue, onGetInitialValue) || this;
		_this.targetVersion = targetVersion;
		_this.name = name;
		_this.values = values;
		_this.defaultValue = defaultValue;
		_this.onGetInitialValue = onGetInitialValue;
		return _this;
	}
	ValueSetProperty.prototype.isValidValue = function (value, context) {
		for (var _i = 0, _a = this.values; _i < _a.length; _i++) {
			var versionedValue = _a[_i];
			if (value.toLowerCase() === versionedValue.value.toLowerCase()) {
				var targetVersion = versionedValue.targetVersion ? versionedValue.targetVersion : this.targetVersion;
				return targetVersion.compareTo(context.targetVersion) <= 0;
			}
		}
		return false;
	};
	ValueSetProperty.prototype.parse = function (sender, source, context) {
		var sourceValue = source[this.name];
		if (sourceValue === undefined) {
			return this.defaultValue;
		}
		if (typeof sourceValue === "string") {
			for (var _i = 0, _a = this.values; _i < _a.length; _i++) {
				var versionedValue = _a[_i];
				if (sourceValue.toLowerCase() === versionedValue.value.toLowerCase()) {
					var targetVersion = versionedValue.targetVersion ? versionedValue.targetVersion : this.targetVersion;
					if (targetVersion.compareTo(context.targetVersion) <= 0) {
						return versionedValue.value;
					}
					else {
						context.logParseEvent(sender, Enums.ValidationEvent.InvalidPropertyValue, strings_1.Strings.errors.propertyValueNotSupported(sourceValue, this.name, targetVersion.toString(), context.targetVersion.toString()));
						return this.defaultValue;
					}
				}
			}
		}
		context.logParseEvent(sender, Enums.ValidationEvent.InvalidPropertyValue, strings_1.Strings.errors.invalidPropertyValue(sourceValue, this.name));
		return this.defaultValue;
	};
	ValueSetProperty.prototype.toJSON = function (sender, target, value, context) {
		var valueFound = false;
		for (var _i = 0, _a = this.values; _i < _a.length; _i++) {
			var versionedValue = _a[_i];
			if (versionedValue.value === value) {
				var targetVersion = versionedValue.targetVersion ? versionedValue.targetVersion : this.targetVersion;
				if (targetVersion.compareTo(context.targetVersion) <= 0) {
					valueFound = true;
					break;
				}
				else {
					context.logEvent(sender, Enums.ValidationPhase.ToJSON, Enums.ValidationEvent.InvalidPropertyValue, strings_1.Strings.errors.propertyValueNotSupported(value, this.name, targetVersion.toString(), context.targetVersion.toString()));
				}
			}
		}
		if (valueFound) {
			context.serializeValue(target, this.name, value, this.defaultValue);
		}
	};
	return ValueSetProperty;
}(PropertyDefinition));
exports.ValueSetProperty = ValueSetProperty;
var EnumProperty = /** @class */ (function (_super) {
	__extends(EnumProperty, _super);
	function EnumProperty(targetVersion, name, enumType, defaultValue, values, onGetInitialValue) {
		var _this = _super.call(this, targetVersion, name, defaultValue, onGetInitialValue) || this;
		_this.targetVersion = targetVersion;
		_this.name = name;
		_this.enumType = enumType;
		_this.defaultValue = defaultValue;
		_this.onGetInitialValue = onGetInitialValue;
		_this._values = [];
		if (!values) {
			for (var key in enumType) {
				var keyAsNumber = parseInt(key, 10);
				if (keyAsNumber >= 0) {
					_this._values.push({ value: keyAsNumber });
				}
			}
		}
		else {
			_this._values = values;
		}
		return _this;
	}
	EnumProperty.prototype.parse = function (sender, source, context) {
		var sourceValue = source[this.name];
		if (typeof sourceValue !== "string") {
			return this.defaultValue;
		}
		var enumValue = Utils.getEnumValueByName(this.enumType, sourceValue);
		if (enumValue !== undefined) {
			for (var _i = 0, _a = this.values; _i < _a.length; _i++) {
				var versionedValue = _a[_i];
				if (versionedValue.value === enumValue) {
					var targetVersion = versionedValue.targetVersion ? versionedValue.targetVersion : this.targetVersion;
					if (targetVersion.compareTo(context.targetVersion) <= 0) {
						return enumValue;
					}
					else {
						context.logParseEvent(sender, Enums.ValidationEvent.InvalidPropertyValue, strings_1.Strings.errors.propertyValueNotSupported(sourceValue, this.name, targetVersion.toString(), context.targetVersion.toString()));
						return this.defaultValue;
					}
				}
			}
		}
		context.logParseEvent(sender, Enums.ValidationEvent.InvalidPropertyValue, strings_1.Strings.errors.invalidPropertyValue(sourceValue, this.name));
		return this.defaultValue;
	};
	EnumProperty.prototype.toJSON = function (sender, target, value, context) {
		if (value !== undefined) {
			var valueFound = false;
			for (var _i = 0, _a = this.values; _i < _a.length; _i++) {
				var versionedValue = _a[_i];
				if (versionedValue.value === value) {
					var targetVersion = versionedValue.targetVersion ? versionedValue.targetVersion : this.targetVersion;
					if (targetVersion.compareTo(context.targetVersion) <= 0) {
						valueFound = true;
						break;
					}
					else {
						context.logEvent(sender, Enums.ValidationPhase.ToJSON, Enums.ValidationEvent.InvalidPropertyValue, strings_1.Strings.errors.invalidPropertyValue(value, this.name));
					}
				}
			}
			if (valueFound) {
				context.serializeEnum(this.enumType, target, this.name, value, this.defaultValue);
			}
		}
	};
	Object.defineProperty(EnumProperty.prototype, "values", {
		get: function () {
			return this._values;
		},
		enumerable: false,
		configurable: true
	});
	return EnumProperty;
}(PropertyDefinition));
exports.EnumProperty = EnumProperty;
var SerializableObjectProperty = /** @class */ (function (_super) {
	__extends(SerializableObjectProperty, _super);
	function SerializableObjectProperty(targetVersion, name, objectType, nullable, defaultValue) {
		if (nullable === void 0) { nullable = false; }
		var _this = _super.call(this, targetVersion, name, defaultValue, function (sender) { return _this.nullable ? undefined : new _this.objectType(); }) || this;
		_this.targetVersion = targetVersion;
		_this.name = name;
		_this.objectType = objectType;
		_this.nullable = nullable;
		return _this;
	}
	SerializableObjectProperty.prototype.parse = function (sender, source, context) {
		var sourceValue = source[this.name];
		if (sourceValue === undefined) {
			return this.onGetInitialValue ? this.onGetInitialValue(sender) : this.defaultValue;
		}
		var result = new this.objectType();
		result.parse(sourceValue, context);
		return result;
	};
	SerializableObjectProperty.prototype.toJSON = function (sender, target, value, context) {
		var serializedValue = undefined;
		if (value !== undefined && !value.hasAllDefaultValues()) {
			serializedValue = value.toJSON(context);
		}
		if (typeof serializedValue === "object" && Object.keys(serializedValue).length === 0) {
			serializedValue = undefined;
		}
		context.serializeValue(target, this.name, serializedValue, this.defaultValue, true);
	};
	return SerializableObjectProperty;
}(PropertyDefinition));
exports.SerializableObjectProperty = SerializableObjectProperty;
var SerializableObjectCollectionProperty = /** @class */ (function (_super) {
	__extends(SerializableObjectCollectionProperty, _super);
	function SerializableObjectCollectionProperty(targetVersion, name, objectType, onItemAdded) {
		var _this = _super.call(this, targetVersion, name, undefined, function (sender) { return []; }) || this;
		_this.targetVersion = targetVersion;
		_this.name = name;
		_this.objectType = objectType;
		_this.onItemAdded = onItemAdded;
		return _this;
	}
	SerializableObjectCollectionProperty.prototype.parse = function (sender, source, context) {
		var result = [];
		var sourceCollection = source[this.name];
		if (Array.isArray(sourceCollection)) {
			for (var _i = 0, sourceCollection_1 = sourceCollection; _i < sourceCollection_1.length; _i++) {
				var sourceItem = sourceCollection_1[_i];
				var item = new this.objectType();
				item.parse(sourceItem, context);
				result.push(item);
				if (this.onItemAdded) {
					this.onItemAdded(sender, item);
				}
			}
		}
		return result.length > 0 ? result : (this.onGetInitialValue ? this.onGetInitialValue(sender) : undefined);
	};
	SerializableObjectCollectionProperty.prototype.toJSON = function (sender, target, value, context) {
		context.serializeArray(target, this.name, value);
	};
	return SerializableObjectCollectionProperty;
}(PropertyDefinition));
exports.SerializableObjectCollectionProperty = SerializableObjectCollectionProperty;
var CustomProperty = /** @class */ (function (_super) {
	__extends(CustomProperty, _super);
	function CustomProperty(targetVersion, name, onParse, onToJSON, defaultValue, onGetInitialValue) {
		var _this = _super.call(this, targetVersion, name, defaultValue, onGetInitialValue) || this;
		_this.targetVersion = targetVersion;
		_this.name = name;
		_this.onParse = onParse;
		_this.onToJSON = onToJSON;
		_this.defaultValue = defaultValue;
		_this.onGetInitialValue = onGetInitialValue;
		if (!_this.onParse) {
			throw new Error("CustomPropertyDefinition instances must have an onParse handler.");
		}
		if (!_this.onToJSON) {
			throw new Error("CustomPropertyDefinition instances must have an onToJSON handler.");
		}
		return _this;
	}
	CustomProperty.prototype.parse = function (sender, source, context) {
		return this.onParse(sender, this, source, context);
	};
	CustomProperty.prototype.toJSON = function (sender, target, value, context) {
		this.onToJSON(sender, this, target, value, context);
	};
	return CustomProperty;
}(PropertyDefinition));
exports.CustomProperty = CustomProperty;
var SerializableObjectSchema = /** @class */ (function () {
	function SerializableObjectSchema() {
		this._properties = [];
	}
	SerializableObjectSchema.prototype.indexOf = function (property) {
		for (var i = 0; i < this._properties.length; i++) {
			if (this._properties[i] === property) {
				return i;
			}
		}
		return -1;
	};
	SerializableObjectSchema.prototype.add = function () {
		var properties = [];
		for (var _i = 0; _i < arguments.length; _i++) {
			properties[_i] = arguments[_i];
		}
		for (var i = 0; i < properties.length; i++) {
			if (this.indexOf(properties[i]) === -1) {
				this._properties.push(properties[i]);
			}
		}
	};
	SerializableObjectSchema.prototype.remove = function () {
		var properties = [];
		for (var _i = 0; _i < arguments.length; _i++) {
			properties[_i] = arguments[_i];
		}
		for (var _a = 0, properties_1 = properties; _a < properties_1.length; _a++) {
			var property_1 = properties_1[_a];
			while (true) {
				var index = this.indexOf(property_1);
				if (index >= 0) {
					this._properties.splice(index, 1);
				}
				else {
					break;
				}
			}
		}
	};
	SerializableObjectSchema.prototype.getItemAt = function (index) {
		return this._properties[index];
	};
	SerializableObjectSchema.prototype.getCount = function () {
		return this._properties.length;
	};
	return SerializableObjectSchema;
}());
exports.SerializableObjectSchema = SerializableObjectSchema;
// This is a decorator function, used to map SerializableObject descendant class members to
// schema properties
function property(property) {
	return function (target, propertyKey) {
		var descriptor = Object.getOwnPropertyDescriptor(target, propertyKey) || {};
		if (!descriptor.get && !descriptor.set) {
			descriptor.get = function () { return this.getValue(property); };
			descriptor.set = function (value) { this.setValue(property, value); };
			Object.defineProperty(target, propertyKey, descriptor);
		}
	};
}
exports.property = property;
var SerializableObject = /** @class */ (function () {
	function SerializableObject() {
		this._propertyBag = {};
		this._rawProperties = {};
		this.maxVersion = SerializableObject.defaultMaxVersion;
		var s = this.getSchema();
		for (var i = 0; i < s.getCount(); i++) {
			var property_2 = s.getItemAt(i);
			if (property_2.onGetInitialValue) {
				this.setValue(property_2, property_2.onGetInitialValue(this));
			}
		}
	}
	SerializableObject.prototype.getDefaultSerializationContext = function () {
		return new SimpleSerializationContext();
	};
	SerializableObject.prototype.populateSchema = function (schema) {
		var ctor = this.constructor;
		var properties = [];
		for (var propertyName in ctor) {
			try {
				var propertyValue = ctor[propertyName];
				if (propertyValue instanceof PropertyDefinition) {
					properties.push(propertyValue);
				}
			}
			catch (_a) {
				// If a property happens to have a getter function and
				// it throws an exception, we need to catch it here
			}
		}
		if (properties.length > 0) {
			var sortedProperties = properties.sort(function (p1, p2) {
				if (p1.sequentialNumber > p2.sequentialNumber) {
					return 1;
				}
				else if (p1.sequentialNumber < p2.sequentialNumber) {
					return -1;
				}
				return 0;
			});
			schema.add.apply(schema, sortedProperties);
		}
		if (SerializableObject.onRegisterCustomProperties) {
			SerializableObject.onRegisterCustomProperties(this, schema);
		}
	};
	SerializableObject.prototype.getValue = function (property) {
		return this._propertyBag.hasOwnProperty(property.getInternalName()) ? this._propertyBag[property.getInternalName()] : property.defaultValue;
	};
	SerializableObject.prototype.setValue = function (property, value) {
		if (value === undefined || value === null) {
			delete this._propertyBag[property.getInternalName()];
		}
		else {
			this._propertyBag[property.getInternalName()] = value;
		}
	};
	SerializableObject.prototype.internalParse = function (source, context) {
		this._propertyBag = {};
		this._rawProperties = shared_1.GlobalSettings.enableFullJsonRoundTrip ? (source ? source : {}) : {};
		if (source) {
			var s = this.getSchema();
			for (var i = 0; i < s.getCount(); i++) {
				var property_3 = s.getItemAt(i);
				if (property_3.isSerializationEnabled) {
					var propertyValue = property_3.onGetInitialValue ? property_3.onGetInitialValue(this) : undefined;
					if (source.hasOwnProperty(property_3.name)) {
						if (property_3.targetVersion.compareTo(context.targetVersion) <= 0) {
							propertyValue = property_3.parse(this, source, context);
						}
						else {
							context.logParseEvent(this, Enums.ValidationEvent.UnsupportedProperty, strings_1.Strings.errors.propertyNotSupported(property_3.name, property_3.targetVersion.toString(), context.targetVersion.toString()));
						}
					}
					this.setValue(property_3, propertyValue);
				}
			}
		}
		else {
			this.resetDefaultValues();
		}
	};
	SerializableObject.prototype.internalToJSON = function (target, context) {
		var s = this.getSchema();
		var serializedProperties = [];
		for (var i = 0; i < s.getCount(); i++) {
			var property_4 = s.getItemAt(i);
			// Avoid serializing the same property multiple times. This is necessary
			// because some property definitions map to the same underlying schema
			// property
			if (property_4.isSerializationEnabled && property_4.targetVersion.compareTo(context.targetVersion) <= 0 && serializedProperties.indexOf(property_4.name) === -1) {
				property_4.toJSON(this, target, this.getValue(property_4), context);
				serializedProperties.push(property_4.name);
			}
		}
	};
	SerializableObject.prototype.shouldSerialize = function (context) {
		return true;
	};
	SerializableObject.prototype.parse = function (source, context) {
		this.internalParse(source, context ? context : new SimpleSerializationContext());
	};
	SerializableObject.prototype.toJSON = function (context) {
		var effectiveContext;
		if (context && context instanceof BaseSerializationContext) {
			effectiveContext = context;
		}
		else {
			effectiveContext = this.getDefaultSerializationContext();
			effectiveContext.toJSONOriginalParam = context;
		}
		if (this.shouldSerialize(effectiveContext)) {
			var result = void 0;
			if (shared_1.GlobalSettings.enableFullJsonRoundTrip && this._rawProperties && typeof this._rawProperties === "object") {
				result = this._rawProperties;
			}
			else {
				result = {};
			}
			this.internalToJSON(result, effectiveContext);
			return result;
		}
		else {
			return undefined;
		}
	};
	SerializableObject.prototype.hasDefaultValue = function (property) {
		return this.getValue(property) === property.defaultValue;
	};
	SerializableObject.prototype.hasAllDefaultValues = function () {
		var s = this.getSchema();
		for (var i = 0; i < s.getCount(); i++) {
			var property_5 = s.getItemAt(i);
			if (!this.hasDefaultValue(property_5)) {
				return false;
			}
		}
		return true;
	};
	SerializableObject.prototype.resetDefaultValues = function () {
		var s = this.getSchema();
		for (var i = 0; i < s.getCount(); i++) {
			var property_6 = s.getItemAt(i);
			this.setValue(property_6, property_6.defaultValue);
		}
	};
	SerializableObject.prototype.setCustomProperty = function (name, value) {
		var shouldDeleteProperty = (typeof value === "string" && !value) || value === undefined || value === null;
		if (shouldDeleteProperty) {
			delete this._rawProperties[name];
		}
		else {
			this._rawProperties[name] = value;
		}
	};
	SerializableObject.prototype.getCustomProperty = function (name) {
		return this._rawProperties[name];
	};
	SerializableObject.prototype.getSchema = function () {
		var schema = SerializableObject._schemaCache[this.getSchemaKey()];
		if (!schema) {
			schema = new SerializableObjectSchema();
			this.populateSchema(schema);
			SerializableObject._schemaCache[this.getSchemaKey()] = schema;
		}
		return schema;
	};
	SerializableObject.defaultMaxVersion = Versions.v1_3;
	SerializableObject._schemaCache = {};
	return SerializableObject;
}());
exports.SerializableObject = SerializableObject;


/***/ }),

/***/ "./src/shared.ts":
/*!***********************!*\
  !*** ./src/shared.ts ***!
  \***********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.UUID = exports.SizeAndUnit = exports.PaddingDefinition = exports.SpacingDefinition = exports.StringWithSubstitutions = exports.ContentTypes = exports.GlobalSettings = void 0;
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
var Enums = __webpack_require__(/*! ./enums */ "./src/enums.ts");
var GlobalSettings = /** @class */ (function () {
	function GlobalSettings() {
	}
	GlobalSettings.useAdvancedTextBlockTruncation = true;
	GlobalSettings.useAdvancedCardBottomTruncation = false;
	GlobalSettings.useMarkdownInRadioButtonAndCheckbox = true;
	GlobalSettings.allowMarkForTextHighlighting = false;
	GlobalSettings.alwaysBleedSeparators = false;
	GlobalSettings.enableFullJsonRoundTrip = false;
	GlobalSettings.displayInputValidationErrors = true;
	GlobalSettings.allowPreProcessingPropertyValues = false;
	GlobalSettings.setTabIndexAtCardRoot = true;
	GlobalSettings.enableFallback = true;
	GlobalSettings.useWebkitLineClamp = true;
	GlobalSettings.applets = {
		logEnabled: true,
		logLevel: Enums.LogLevel.Error,
		maximumRetryAttempts: 3,
		defaultTimeBetweenRetryAttempts: 3000,
		authPromptWidth: 400,
		authPromptHeight: 600,
		refresh: {
			mode: Enums.RefreshMode.Manual,
			timeBetweenAutomaticRefreshes: 3000,
			maximumConsecutiveAutomaticRefreshes: 3,
			allowManualRefreshesAfterAutomaticRefreshes: true
		}
	};
	return GlobalSettings;
}());
exports.GlobalSettings = GlobalSettings;
exports.ContentTypes = {
	applicationJson: "application/json",
	applicationXWwwFormUrlencoded: "application/x-www-form-urlencoded"
};
var StringWithSubstitutions = /** @class */ (function () {
	function StringWithSubstitutions() {
		this._isProcessed = false;
	}
	StringWithSubstitutions.prototype.getReferencedInputs = function (inputs, referencedInputs) {
		if (!referencedInputs) {
			throw new Error("The referencedInputs parameter cannot be null.");
		}
		for (var _i = 0, inputs_1 = inputs; _i < inputs_1.length; _i++) {
			var input = inputs_1[_i];
			var matches = new RegExp("\\{{2}(" + input.id + ").value\\}{2}", "gi").exec(this._original);
			if (matches != null && input.id) {
				referencedInputs[input.id] = input;
			}
		}
	};
	StringWithSubstitutions.prototype.substituteInputValues = function (inputs, contentType) {
		this._processed = this._original;
		if (this._original) {
			var regEx = /\{{2}([a-z0-9_$@]+).value\}{2}/gi;
			var matches = void 0;
			while ((matches = regEx.exec(this._original)) !== null) {
				for (var _i = 0, _a = Object.keys(inputs); _i < _a.length; _i++) {
					var key = _a[_i];
					if (key.toLowerCase() == matches[1].toLowerCase()) {
						var matchedInput = inputs[key];
						var valueForReplace = "";
						if (matchedInput.value) {
							valueForReplace = matchedInput.value;
						}
						if (contentType === exports.ContentTypes.applicationJson) {
							valueForReplace = JSON.stringify(valueForReplace);
							valueForReplace = valueForReplace.slice(1, -1);
						}
						else if (contentType === exports.ContentTypes.applicationXWwwFormUrlencoded) {
							valueForReplace = encodeURIComponent(valueForReplace);
						}
						this._processed = this._processed.replace(matches[0], valueForReplace);
						break;
					}
				}
			}
		}
		this._isProcessed = true;
	};
	StringWithSubstitutions.prototype.getOriginal = function () {
		return this._original;
	};
	StringWithSubstitutions.prototype.get = function () {
		if (!this._isProcessed) {
			return this._original;
		}
		else {
			return this._processed;
		}
	};
	StringWithSubstitutions.prototype.set = function (value) {
		this._original = value;
		this._isProcessed = false;
	};
	return StringWithSubstitutions;
}());
exports.StringWithSubstitutions = StringWithSubstitutions;
var SpacingDefinition = /** @class */ (function () {
	function SpacingDefinition(top, right, bottom, left) {
		if (top === void 0) { top = 0; }
		if (right === void 0) { right = 0; }
		if (bottom === void 0) { bottom = 0; }
		if (left === void 0) { left = 0; }
		this.left = 0;
		this.top = 0;
		this.right = 0;
		this.bottom = 0;
		this.top = top;
		this.right = right;
		this.bottom = bottom;
		this.left = left;
	}
	return SpacingDefinition;
}());
exports.SpacingDefinition = SpacingDefinition;
var PaddingDefinition = /** @class */ (function () {
	function PaddingDefinition(top, right, bottom, left) {
		if (top === void 0) { top = Enums.Spacing.None; }
		if (right === void 0) { right = Enums.Spacing.None; }
		if (bottom === void 0) { bottom = Enums.Spacing.None; }
		if (left === void 0) { left = Enums.Spacing.None; }
		this.top = Enums.Spacing.None;
		this.right = Enums.Spacing.None;
		this.bottom = Enums.Spacing.None;
		this.left = Enums.Spacing.None;
		this.top = top;
		this.right = right;
		this.bottom = bottom;
		this.left = left;
	}
	return PaddingDefinition;
}());
exports.PaddingDefinition = PaddingDefinition;
var SizeAndUnit = /** @class */ (function () {
	function SizeAndUnit(physicalSize, unit) {
		this.physicalSize = physicalSize;
		this.unit = unit;
	}
	SizeAndUnit.parse = function (input, requireUnitSpecifier) {
		if (requireUnitSpecifier === void 0) { requireUnitSpecifier = false; }
		var result = new SizeAndUnit(0, Enums.SizeUnit.Weight);
		if (typeof input === "number") {
			result.physicalSize = input;
			return result;
		}
		else if (typeof input === "string") {
			var regExp = /^([0-9]+)(px|\*)?$/g;
			var matches = regExp.exec(input);
			var expectedMatchCount = requireUnitSpecifier ? 3 : 2;
			if (matches && matches.length >= expectedMatchCount) {
				result.physicalSize = parseInt(matches[1]);
				if (matches.length == 3) {
					if (matches[2] == "px") {
						result.unit = Enums.SizeUnit.Pixel;
					}
				}
				return result;
			}
		}
		throw new Error("Invalid size: " + input);
	};
	return SizeAndUnit;
}());
exports.SizeAndUnit = SizeAndUnit;
/**
 * Fast UUID generator, RFC4122 version 4 compliant.
 * @author Jeff Ward (jcward.com).
 * @license MIT license
 * @link http://stackoverflow.com/questions/105034/how-to-create-a-guid-uuid-in-javascript/21963136#21963136
 **/
var UUID = /** @class */ (function () {
	function UUID() {
	}
	UUID.generate = function () {
		var d0 = Math.random() * 0xffffffff | 0;
		var d1 = Math.random() * 0xffffffff | 0;
		var d2 = Math.random() * 0xffffffff | 0;
		var d3 = Math.random() * 0xffffffff | 0;
		return UUID.lut[d0 & 0xff] + UUID.lut[d0 >> 8 & 0xff] + UUID.lut[d0 >> 16 & 0xff] + UUID.lut[d0 >> 24 & 0xff] + '-' +
			UUID.lut[d1 & 0xff] + UUID.lut[d1 >> 8 & 0xff] + '-' + UUID.lut[d1 >> 16 & 0x0f | 0x40] + UUID.lut[d1 >> 24 & 0xff] + '-' +
			UUID.lut[d2 & 0x3f | 0x80] + UUID.lut[d2 >> 8 & 0xff] + '-' + UUID.lut[d2 >> 16 & 0xff] + UUID.lut[d2 >> 24 & 0xff] +
			UUID.lut[d3 & 0xff] + UUID.lut[d3 >> 8 & 0xff] + UUID.lut[d3 >> 16 & 0xff] + UUID.lut[d3 >> 24 & 0xff];
	};
	UUID.initialize = function () {
		for (var i = 0; i < 256; i++) {
			UUID.lut[i] = (i < 16 ? '0' : '') + i.toString(16);
		}
	};
	UUID.lut = [];
	return UUID;
}());
exports.UUID = UUID;
UUID.initialize();


/***/ }),

/***/ "./src/strings.ts":
/*!************************!*\
  !*** ./src/strings.ts ***!
  \************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Strings = void 0;
var Strings = /** @class */ (function () {
	function Strings() {
	}
	Strings.errors = {
		unknownElementType: function (typeName) { return "Unknown element type \"" + typeName + "\". Fallback will be used if present."; },
		unknownActionType: function (typeName) { return "Unknown action type \"" + typeName + "\". Fallback will be used if present."; },
		elementTypeNotAllowed: function (typeName) { return "Element type \"" + typeName + "\" is not allowed in this context."; },
		actionTypeNotAllowed: function (typeName) { return "Action type \"" + typeName + "\" is not allowed in this context."; },
		invalidPropertyValue: function (value, propertyName) { return "Invalid value \"" + value + "\" for property \"" + propertyName + "\"."; },
		showCardMustHaveCard: function () { return "\"An Action.ShowCard must have its \"card\" property set to a valid AdaptiveCard object."; },
		invalidColumnWidth: function (invalidWidth) { return "Invalid column width \"" + invalidWidth + "\" - defaulting to \"auto\"."; },
		invalidCardVersion: function (defaultingToVersion) { return "Invalid card version. Defaulting to \"" + defaultingToVersion + "\"."; },
		invalidVersionString: function (versionString) { return "Invalid version string \"" + versionString + "\"."; },
		propertyValueNotSupported: function (value, propertyName, supportedInVersion, versionUsed) { return "Value \"" + value + "\" for property \"" + propertyName + "\" is supported in version " + supportedInVersion + ", but you are using version " + versionUsed + "."; },
		propertyNotSupported: function (propertyName, supportedInVersion, versionUsed) { return "Property \"" + propertyName + "\" is supported in version " + supportedInVersion + ", but you are using version " + versionUsed + "."; },
		indexOutOfRange: function (index) { return "Index out of range (" + index + ")."; },
		elementCannotBeUsedAsInline: function () { return "RichTextBlock.addInline: the specified card element cannot be used as a RichTextBlock inline."; },
		inlineAlreadyParented: function () { return "RichTextBlock.addInline: the specified inline already belongs to another RichTextBlock."; },
		interactivityNotAllowed: function () { return "Interactivity is not allowed."; },
		inputsMustHaveUniqueId: function () { return "All inputs must have a unique Id."; },
		choiceSetMustHaveAtLeastOneChoice: function () { return "An Input.ChoiceSet must have at least one choice defined."; },
		choiceSetChoicesMustHaveTitleAndValue: function () { return "All choices in an Input.ChoiceSet must have their title and value properties set."; },
		propertyMustBeSet: function (propertyName) { return "Property \"" + propertyName + "\" must be set."; },
		actionHttpHeadersMustHaveNameAndValue: function () { return "All headers of an Action.Http must have their name and value properties set."; },
		tooManyActions: function (maximumActions) { return "Maximum number of actions exceeded (" + maximumActions + ")."; },
		columnAlreadyBelongsToAnotherSet: function () { return "This column already belongs to another ColumnSet."; },
		invalidCardType: function () { return "Invalid or missing card type. Make sure the card's type property is set to \"AdaptiveCard\"."; },
		unsupportedCardVersion: function (version, maxSupportedVersion) { return "The specified card version (" + version + ") is not supported. The maximum supported card version is " + maxSupportedVersion + "."; },
		duplicateId: function (id) { return "Duplicate Id \"" + id + "\"."; },
		markdownProcessingNotEnabled: function () { return "Markdown processing isn't enabled. Please see https://www.npmjs.com/package/adaptivecards#supporting-markdown"; },
		processMarkdownEventRemoved: function () { return "The processMarkdown event has been removed. Please update your code and set onProcessMarkdown instead."; },
		elementAlreadyParented: function () { return "The element already belongs to another container."; },
		actionAlreadyParented: function () { return "The action already belongs to another element."; },
		elementTypeNotStandalone: function (typeName) { return "Elements of type " + typeName + " cannot be used as standalone elements."; }
	};
	Strings.magicCodeInputCard = {
		tryAgain: function () { return "That didn't work... let's try again."; },
		pleaseLogin: function () { return "Please login in the popup. You will obtain a magic code. Paste that code below and select \"Submit\""; },
		enterMagicCode: function () { return "Enter magic code"; },
		pleaseEnterMagicCodeYouReceived: function () { return "Please enter the magic code you received."; },
		submit: function () { return "Submit"; },
		cancel: function () { return "Cancel"; },
		somethingWentWrong: function () { return "Something went wrong. This action can't be handled."; },
		authenticationFailed: function () { return "Authentication failed."; }
	};
	Strings.runtime = {
		automaticRefreshPaused: function () { return "Automatic refresh paused."; },
		clckToRestartAutomaticRefresh: function () { return "Click to restart."; },
		refreshThisCard: function () { return "Refresh this card"; }
	};
	Strings.hints = {
		dontUseWeightedAndStrecthedColumnsInSameSet: function () { return "It is not recommended to use weighted and stretched columns in the same ColumnSet, because in such a situation stretched columns will always get the minimum amount of space."; }
	};
	Strings.defaults = {
		inlineActionTitle: function () { return "Inline Action"; },
		mediaPlayerAriaLabel: function () { return "Media content"; },
		mediaPlayerPlayMedia: function () { return "Play media"; }
	};
	return Strings;
}());
exports.Strings = Strings;


/***/ }),

/***/ "./src/text-formatters.ts":
/*!********************************!*\
  !*** ./src/text-formatters.ts ***!
  \********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
	var extendStatics = function (d, b) {
		extendStatics = Object.setPrototypeOf ||
			({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
			function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
		return extendStatics(d, b);
	};
	return function (d, b) {
		extendStatics(d, b);
		function __() { this.constructor = d; }
		d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.formatText = void 0;
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
var AbstractTextFormatter = /** @class */ (function () {
	function AbstractTextFormatter(regularExpression) {
		this._regularExpression = regularExpression;
	}
	AbstractTextFormatter.prototype.format = function (lang, input) {
		var matches;
		if (input) {
			var result = input;
			while ((matches = this._regularExpression.exec(input)) != null) {
				result = result.replace(matches[0], this.internalFormat(lang, matches));
			}
			;
			return result;
		}
		else {
			return input;
		}
	};
	return AbstractTextFormatter;
}());
var DateFormatter = /** @class */ (function (_super) {
	__extends(DateFormatter, _super);
	function DateFormatter() {
		return _super !== null && _super.apply(this, arguments) || this;
	}
	DateFormatter.prototype.internalFormat = function (lang, matches) {
		var date = new Date(Date.parse(matches[1]));
		var format = matches[2] != undefined ? matches[2].toLowerCase() : "compact";
		if (format != "compact") {
			return date.toLocaleDateString(lang, { day: "numeric", weekday: format, month: format, year: "numeric" });
		}
		else {
			return date.toLocaleDateString();
		}
	};
	return DateFormatter;
}(AbstractTextFormatter));
var TimeFormatter = /** @class */ (function (_super) {
	__extends(TimeFormatter, _super);
	function TimeFormatter() {
		return _super !== null && _super.apply(this, arguments) || this;
	}
	TimeFormatter.prototype.internalFormat = function (lang, matches) {
		var date = new Date(Date.parse(matches[1]));
		return date.toLocaleTimeString(lang, { hour: 'numeric', minute: '2-digit' });
	};
	return TimeFormatter;
}(AbstractTextFormatter));
function formatText(lang, text) {
	var formatters = [
		new DateFormatter(/\{{2}DATE\((\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(?:Z|(?:(?:-|\+)\d{2}:\d{2})))(?:, ?(COMPACT|LONG|SHORT))?\)\}{2}/g),
		new TimeFormatter(/\{{2}TIME\((\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(?:Z|(?:(?:-|\+)\d{2}:\d{2})))\)\}{2}/g)
	];
	var result = text;
	for (var _i = 0, formatters_1 = formatters; _i < formatters_1.length; _i++) {
		var formatter = formatters_1[_i];
		result = formatter.format(lang, result);
	}
	return result;
}
exports.formatText = formatText;


/***/ }),

/***/ "./src/utils.ts":
/*!**********************!*\
  !*** ./src/utils.ts ***!
  \**********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.clearElementChildren = exports.getFitStatus = exports.truncate = exports.stringToCssColor = exports.renderSeparation = exports.parseEnum = exports.getEnumValueByName = exports.parseBool = exports.parseNumber = exports.parseString = exports.appendChild = exports.generateUniqueId = exports.isMobileOS = exports.isInternetExplorer = void 0;
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
var Enums = __webpack_require__(/*! ./enums */ "./src/enums.ts");
var Shared = __webpack_require__(/*! ./shared */ "./src/shared.ts");
function isInternetExplorer() {
	// The documentMode property only exists in IE
	return window.document.documentMode !== undefined;
}
exports.isInternetExplorer = isInternetExplorer;
function isMobileOS() {
	var userAgent = window.navigator.userAgent;
	return !!userAgent.match(/Android/i) || !!userAgent.match(/iPad/i) || !!userAgent.match(/iPhone/i);
}
exports.isMobileOS = isMobileOS;
/**
 * Generate a UUID prepended with "__ac-"
 */
function generateUniqueId() {
	return "__ac-" + Shared.UUID.generate();
}
exports.generateUniqueId = generateUniqueId;
function appendChild(node, child) {
	if (child) {
		node.appendChild(child);
	}
}
exports.appendChild = appendChild;
function parseString(obj, defaultValue) {
	return typeof obj === "string" ? obj : defaultValue;
}
exports.parseString = parseString;
function parseNumber(obj, defaultValue) {
	return typeof obj === "number" ? obj : defaultValue;
}
exports.parseNumber = parseNumber;
function parseBool(value, defaultValue) {
	if (typeof value === "boolean") {
		return value;
	}
	else if (typeof value === "string") {
		switch (value.toLowerCase()) {
			case "true":
				return true;
			case "false":
				return false;
			default:
				return defaultValue;
		}
	}
	return defaultValue;
}
exports.parseBool = parseBool;
function getEnumValueByName(enumType, name) {
	for (var key in enumType) {
		var keyAsNumber = parseInt(key, 10);
		if (keyAsNumber >= 0) {
			var value = enumType[key];
			if (value && typeof value === "string" && value.toLowerCase() === name.toLowerCase()) {
				return keyAsNumber;
			}
		}
	}
	return undefined;
}
exports.getEnumValueByName = getEnumValueByName;
function parseEnum(enumType, name, defaultValue) {
	if (!name) {
		return defaultValue;
	}
	var enumValue = getEnumValueByName(enumType, name);
	return enumValue !== undefined ? enumValue : defaultValue;
}
exports.parseEnum = parseEnum;
function renderSeparation(hostConfig, separationDefinition, orientation) {
	if (separationDefinition.spacing > 0 || (separationDefinition.lineThickness && separationDefinition.lineThickness > 0)) {
		var separator = document.createElement("div");
		separator.className = hostConfig.makeCssClassName("ac-" + (orientation == Enums.Orientation.Horizontal ? "horizontal" : "vertical") + "-separator");
		separator.setAttribute("aria-hidden", "true");
		var color = separationDefinition.lineColor ? stringToCssColor(separationDefinition.lineColor) : "";
		if (orientation == Enums.Orientation.Horizontal) {
			if (separationDefinition.lineThickness) {
				separator.style.paddingTop = (separationDefinition.spacing / 2) + "px";
				separator.style.marginBottom = (separationDefinition.spacing / 2) + "px";
				separator.style.borderBottom = separationDefinition.lineThickness + "px solid " + color;
			}
			else {
				separator.style.height = separationDefinition.spacing + "px";
			}
		}
		else {
			if (separationDefinition.lineThickness) {
				separator.style.paddingLeft = (separationDefinition.spacing / 2) + "px";
				separator.style.marginRight = (separationDefinition.spacing / 2) + "px";
				separator.style.borderRight = separationDefinition.lineThickness + "px solid " + color;
			}
			else {
				separator.style.width = separationDefinition.spacing + "px";
			}
		}
		separator.style.overflow = "hidden";
		separator.style.flex = "0 0 auto";
		return separator;
	}
	else {
		return undefined;
	}
}
exports.renderSeparation = renderSeparation;
function stringToCssColor(color) {
	if (color) {
		var regEx = /#([0-9A-F]{2})([0-9A-F]{2})([0-9A-F]{2})([0-9A-F]{2})?/gi;
		var matches = regEx.exec(color);
		if (matches && matches[4]) {
			var a = parseInt(matches[1], 16) / 255;
			var r = parseInt(matches[2], 16);
			var g = parseInt(matches[3], 16);
			var b = parseInt(matches[4], 16);
			return "rgba(" + r + "," + g + "," + b + "," + a + ")";
		}
	}
	return color;
}
exports.stringToCssColor = stringToCssColor;
function truncate(element, maxHeight, lineHeight) {
	var fits = function () {
		// Allow a one pixel overflow to account for rounding differences
		// between browsers
		return maxHeight - element.scrollHeight >= -1.0;
	};
	if (fits())
		return;
	var fullText = element.innerHTML;
	var truncateAt = function (idx) {
		element.innerHTML = fullText.substring(0, idx) + '...';
	};
	var breakableIndices = findBreakableIndices(fullText);
	var lo = 0;
	var hi = breakableIndices.length;
	var bestBreakIdx = 0;
	// Do a binary search for the longest string that fits
	while (lo < hi) {
		var mid = Math.floor((lo + hi) / 2);
		truncateAt(breakableIndices[mid]);
		if (fits()) {
			bestBreakIdx = breakableIndices[mid];
			lo = mid + 1;
		}
		else {
			hi = mid;
		}
	}
	truncateAt(bestBreakIdx);
	// If we have extra room, try to expand the string letter by letter
	// (covers the case where we have to break in the middle of a long word)
	if (lineHeight && maxHeight - element.scrollHeight >= lineHeight - 1.0) {
		var idx = findNextCharacter(fullText, bestBreakIdx);
		while (idx < fullText.length) {
			truncateAt(idx);
			if (fits()) {
				bestBreakIdx = idx;
				idx = findNextCharacter(fullText, idx);
			}
			else {
				break;
			}
		}
		truncateAt(bestBreakIdx);
	}
}
exports.truncate = truncate;
function findBreakableIndices(html) {
	var results = [];
	var idx = findNextCharacter(html, -1);
	while (idx < html.length) {
		if (html[idx] == ' ') {
			results.push(idx);
		}
		idx = findNextCharacter(html, idx);
	}
	return results;
}
function findNextCharacter(html, currIdx) {
	currIdx += 1;
	// If we found the start of an HTML tag, keep advancing until we get
	// past it, so we don't end up truncating in the middle of the tag
	while (currIdx < html.length && html[currIdx] == '<') {
		while (currIdx < html.length && html[currIdx++] != '>')
			;
	}
	return currIdx;
}
function getFitStatus(element, containerEnd) {
	var start = element.offsetTop;
	var end = start + element.clientHeight;
	if (end <= containerEnd) {
		return Enums.ContainerFitStatus.FullyInContainer;
	}
	else if (start < containerEnd) {
		return Enums.ContainerFitStatus.Overflowing;
	}
	else {
		return Enums.ContainerFitStatus.FullyOutOfContainer;
	}
}
exports.getFitStatus = getFitStatus;
function clearElementChildren(element) {
	while (element.firstChild) {
		element.removeChild(element.firstChild);
	}
}
exports.clearElementChildren = clearElementChildren;


/***/ })

/******/ });
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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