/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.util.EnumSet;
import java.util.Set;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value=Scopes.BuildSession.class)
public class FeaturePreviews {
    private final EnumSet<Feature> enabledFeatures = EnumSet.noneOf(Feature.class);

    public void enableFeature(Feature feature) {
        if (feature.isActive()) {
            this.enabledFeatures.add(feature);
        }
    }

    public boolean isFeatureEnabled(Feature feature) {
        return this.enabledFeatures.contains((Object)feature);
    }

    public Set<Feature> getActiveFeatures() {
        return Feature.activeFeatures();
    }

    public static enum Feature {
        GROOVY_COMPILATION_AVOIDANCE(true),
        ONE_LOCKFILE_PER_PROJECT(false),
        VERSION_ORDERING_V2(false),
        VERSION_CATALOGS(false),
        TYPESAFE_PROJECT_ACCESSORS(true),
        STABLE_CONFIGURATION_CACHE(true);

        private final boolean active;

        public static Feature withName(String name) {
            try {
                return Feature.valueOf(name);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("There is no feature named " + name);
            }
        }

        private static EnumSet<Feature> activeFeatures() {
            EnumSet<Feature> activeFeatures = EnumSet.noneOf(Feature.class);
            for (Feature feature : Feature.values()) {
                if (!feature.isActive()) continue;
                activeFeatures.add(feature);
            }
            return activeFeatures;
        }

        private Feature(boolean active) {
            this.active = active;
        }

        public boolean isActive() {
            return this.active;
        }
    }
}

