/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.BuilderInferenceSession;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.types.EnumCompatibilityCheckerKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.expressions.SenselessComparisonChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u000b\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\f\u001a\u00020\r2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J\u001a\u0010\u000f\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u000eJ\u001c\u0010\u0010\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J\u001c\u0010\u0011\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/EqualityCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkEquality", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "checkIdentityEquality", "checkIdentityOnPrimitiveOrInlineClassTypes", "ensureNonemptyIntersectionOfOperandTypes", "isIdentityComparedWithImplicitBoxing", "", "leftType", "Lorg/jetbrains/kotlin/types/KotlinType;", "rightType", "frontend"})
public final class EqualityCallChecker
implements CallChecker {
    @NotNull
    public static final EqualityCallChecker INSTANCE = new EqualityCallChecker();

    private EqualityCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        KtBinaryExpression ktBinaryExpression = ktElement instanceof KtBinaryExpression ? (KtBinaryExpression)ktElement : null;
        if (ktBinaryExpression == null) {
            return;
        }
        KtBinaryExpression callExpression = ktBinaryExpression;
        IElementType operationType = callExpression.getOperationReference().getReferencedNameElementType();
        ImmutableSet<KtSingleValueToken> immutableSet = OperatorConventions.EQUALS_OPERATIONS;
        Intrinsics.checkNotNullExpressionValue(immutableSet, (String)"EQUALS_OPERATIONS");
        if (CollectionsKt.contains((Iterable)immutableSet, (Object)operationType)) {
            this.checkEquality(resolvedCall2, callExpression, context.getResolutionContext());
        }
    }

    private final void checkEquality(ResolvedCall<?> resolvedCall2, KtBinaryExpression expression2, ResolutionContext<?> context) {
        KotlinType kotlinType = resolvedCall2.getResultingDescriptor().getReturnType();
        if (kotlinType == null) {
            return;
        }
        KotlinType returnType2 = kotlinType;
        KotlinBuiltIns builtIns = TypeUtilsKt.getBuiltIns(returnType2);
        if (!builtIns.isBooleanOrSubtype(returnType2)) {
            context.trace.report(Errors.RESULT_TYPE_MISMATCH.on((KtExpression)((PsiElement)expression2.getOperationReference()), "" + '\'' + OperatorNameConventions.EQUALS + '\'', builtIns.getBooleanType(), returnType2));
            return;
        }
        this.ensureNonemptyIntersectionOfOperandTypes(expression2, context);
    }

    public final void checkIdentityEquality(@NotNull KtBinaryExpression expression2, @NotNull ResolutionContext<?> context) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        this.ensureNonemptyIntersectionOfOperandTypes(expression2, context);
        this.checkIdentityOnPrimitiveOrInlineClassTypes(expression2, context);
    }

    private final void checkIdentityOnPrimitiveOrInlineClassTypes(KtBinaryExpression expression2, ResolutionContext<?> context) {
        KtExpression ktExpression = expression2.getLeft();
        if (ktExpression == null) {
            return;
        }
        KtExpression left = ktExpression;
        KtExpression ktExpression2 = expression2.getRight();
        if (ktExpression2 == null) {
            return;
        }
        KtExpression right = ktExpression2;
        KotlinType kotlinType = context.trace.getType(left);
        if (kotlinType == null) {
            return;
        }
        KotlinType leftType = kotlinType;
        KotlinType kotlinType2 = context.trace.getType(right);
        if (kotlinType2 == null) {
            return;
        }
        KotlinType rightType = kotlinType2;
        if (KotlinTypeChecker.DEFAULT.equalTypes(leftType, rightType)) {
            if (KotlinBuiltIns.isPrimitiveType(leftType)) {
                context.trace.report(Errors.DEPRECATED_IDENTITY_EQUALS.on((KtBinaryExpression)((PsiElement)expression2), leftType, rightType));
            }
        } else if (this.isIdentityComparedWithImplicitBoxing(leftType, rightType) || this.isIdentityComparedWithImplicitBoxing(rightType, leftType)) {
            context.trace.report(Errors.IMPLICIT_BOXING_IN_IDENTITY_EQUALS.on((KtBinaryExpression)((PsiElement)expression2), leftType, rightType));
        }
        if (InlineClassesUtilsKt.isInlineClassType(leftType) || InlineClassesUtilsKt.isInlineClassType(rightType)) {
            context.trace.report(Errors.FORBIDDEN_IDENTITY_EQUALS.on((KtBinaryExpression)((PsiElement)expression2), leftType, rightType));
        }
    }

    private final boolean isIdentityComparedWithImplicitBoxing(KotlinType leftType, KotlinType rightType) {
        return KotlinBuiltIns.isPrimitiveType(leftType) && !KotlinBuiltIns.isPrimitiveType(rightType) && KotlinTypeChecker.DEFAULT.isSubtypeOf(leftType, rightType);
    }

    private final void ensureNonemptyIntersectionOfOperandTypes(KtBinaryExpression expression2, ResolutionContext<?> context) {
        KtExpression ktExpression = expression2.getLeft();
        if (ktExpression == null) {
            return;
        }
        KtExpression left = ktExpression;
        KtExpression ktExpression2 = expression2.getRight();
        if (ktExpression2 == null) {
            return;
        }
        KtExpression right = ktExpression2;
        KotlinType kotlinType = context.trace.getType(left);
        if (kotlinType == null) {
            return;
        }
        KotlinType leftType = kotlinType;
        KotlinType kotlinType2 = context.trace.getType(right);
        if (kotlinType2 == null) {
            return;
        }
        KotlinType rightType = kotlinType2;
        if (TypeIntersector.isIntersectionEmpty(leftType, rightType)) {
            boolean isProperEqualityChecksEnabled = context.languageVersionSettings.supportsFeature(LanguageFeature.ProperEqualityChecksInBuilderInferenceCalls);
            boolean shouldReportWarnings = !isProperEqualityChecksEnabled && context.inferenceSession instanceof BuilderInferenceSession && context.trace.get(BindingContext.MARKED_EQUALIY_CALL_PROPER_IN_BUILDER_INFERENCE, expression2) != null;
            DiagnosticFactory3<KtBinaryExpression, KtSimpleNameExpression, KotlinType, KotlinType> diagnostic = shouldReportWarnings ? Errors.EQUALITY_NOT_APPLICABLE_WARNING : Errors.EQUALITY_NOT_APPLICABLE;
            context.trace.report(diagnostic.on((KtBinaryExpression)((PsiElement)expression2), expression2.getOperationReference(), leftType, rightType));
        } else {
            EnumCompatibilityCheckerKt.checkEnumsForCompatibility(context, expression2, leftType, rightType);
        }
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"context.trace");
        Function1 function1 = (Function1)new Function1<KtExpression, KotlinType>((Object)bindingTrace){

            @Nullable
            public final KotlinType invoke(@NotNull KtExpression p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((BindingTrace)this.receiver).getType(p0);
            }

            @NotNull
            public final String getSignature() {
                return "getType(Lorg/jetbrains/kotlin/psi/KtExpression;)Lorg/jetbrains/kotlin/types/KotlinType;";
            }

            @NotNull
            public final String getName() {
                return "getType";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(BindingTrace.class);
            }
        };
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"context.dataFlowInfo");
        SenselessComparisonChecker.checkSenselessComparisonWithNull(expression2, left, right, context, (Function1<? super KtExpression, ? extends KotlinType>)function1, (Function1<? super DataFlowValue, ? extends Nullability>)((Function1)new Function1<DataFlowValue, Nullability>((Object)dataFlowInfo){

            @NotNull
            public final Nullability invoke(@NotNull DataFlowValue p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((DataFlowInfo)this.receiver).getStableNullability(p0);
            }

            @NotNull
            public final String getSignature() {
                return "getStableNullability(Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;)Lorg/jetbrains/kotlin/resolve/calls/smartcasts/Nullability;";
            }

            @NotNull
            public final String getName() {
                return "getStableNullability";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(DataFlowInfo.class);
            }
        }));
    }
}

