/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.get;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.opensearch.action.admin.indices.get.GetIndexRequest;
import org.opensearch.action.admin.indices.get.GetIndexResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.clustermanager.info.TransportClusterInfoAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.cluster.metadata.Context;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.indices.IndicesService;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportGetIndexAction
extends TransportClusterInfoAction<GetIndexRequest, GetIndexResponse> {
    private final IndicesService indicesService;
    private final IndexScopedSettings indexScopedSettings;
    private final SettingsFilter settingsFilter;

    @Inject
    public TransportGetIndexAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, SettingsFilter settingsFilter, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService, IndexScopedSettings indexScopedSettings) {
        super("indices:admin/get", transportService, clusterService, threadPool, actionFilters, GetIndexRequest::new, indexNameExpressionResolver);
        this.indicesService = indicesService;
        this.settingsFilter = settingsFilter;
        this.indexScopedSettings = indexScopedSettings;
    }

    @Override
    protected GetIndexResponse read(StreamInput in) throws IOException {
        return new GetIndexResponse(in);
    }

    @Override
    protected void doClusterManagerOperation(GetIndexRequest request, String[] concreteIndices, ClusterState state, ActionListener<GetIndexResponse> listener) {
        Map<String, MappingMetadata> mappingsResult = Map.of();
        Map<String, List<AliasMetadata>> aliasesResult = Map.of();
        Map<String, Settings> settings = Map.of();
        Map<String, Settings> defaultSettings = Map.of();
        Map<String, Context> contexts = Map.of();
        HashMap<String, String> dataStreams = new HashMap<String, String>(StreamSupport.stream(Spliterators.spliterator(state.metadata().findDataStreams(concreteIndices).entrySet(), 0), false).collect(Collectors.toMap(k -> (String)k.getKey(), v -> ((IndexAbstraction.DataStream)v.getValue()).getName())));
        GetIndexRequest.Feature[] features = request.features();
        boolean doneAliases = false;
        boolean doneMappings = false;
        boolean doneSettings = false;
        boolean doneContext = false;
        block8: for (GetIndexRequest.Feature feature : features) {
            switch (feature) {
                case MAPPINGS: {
                    if (doneMappings) continue block8;
                    try {
                        mappingsResult = state.metadata().findMappings(concreteIndices, this.indicesService.getFieldFilter());
                        doneMappings = true;
                        continue block8;
                    }
                    catch (IOException e) {
                        listener.onFailure((Exception)e);
                        return;
                    }
                }
                case ALIASES: {
                    if (doneAliases) continue block8;
                    aliasesResult = state.metadata().findAllAliases(concreteIndices);
                    doneAliases = true;
                    continue block8;
                }
                case SETTINGS: {
                    if (doneSettings) continue block8;
                    HashMap<String, Settings> settingsMapBuilder = new HashMap<String, Settings>();
                    HashMap<String, Settings> defaultSettingsMapBuilder = new HashMap<String, Settings>();
                    String[] stringArray = concreteIndices;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String index = stringArray[i];
                        Settings indexSettings = state.metadata().index(index).getSettings();
                        if (request.humanReadable()) {
                            indexSettings = IndexMetadata.addHumanReadableSettings(indexSettings);
                        }
                        settingsMapBuilder.put(index, indexSettings);
                        if (!request.includeDefaults()) continue;
                        Settings defaultIndexSettings = this.settingsFilter.filter(this.indexScopedSettings.diff(indexSettings, Settings.EMPTY));
                        defaultSettingsMapBuilder.put(index, defaultIndexSettings);
                    }
                    settings = settingsMapBuilder;
                    defaultSettings = defaultSettingsMapBuilder;
                    doneSettings = true;
                    continue block8;
                }
                case CONTEXT: {
                    if (doneContext) continue block8;
                    HashMap<String, Context> contextBuilder = new HashMap<String, Context>();
                    for (String index : concreteIndices) {
                        Context indexContext = state.metadata().index(index).context();
                        if (indexContext == null) continue;
                        contextBuilder.put(index, indexContext);
                    }
                    contexts = contextBuilder;
                    doneContext = true;
                    continue block8;
                }
                default: {
                    throw new IllegalStateException("feature [" + feature + "] is not valid");
                }
            }
        }
        listener.onResponse((Object)new GetIndexResponse(concreteIndices, mappingsResult, aliasesResult, settings, defaultSettings, dataStreams, contexts));
    }
}

