/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.xcontent;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.AbstractXContentParser;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentLocation;
import org.opensearch.core.xcontent.XContentParser;

public class JsonToStringXContentParser
extends AbstractXContentParser {
    private final String fieldTypeName;
    private final XContentParser parser;
    private final ArrayList<String> valueList = new ArrayList();
    private final ArrayList<String> valueAndPathList = new ArrayList();
    private final ArrayList<String> keyList = new ArrayList();
    private final XContentBuilder builder = XContentBuilder.builder((XContent)JsonXContent.jsonXContent);
    private final NamedXContentRegistry xContentRegistry;
    private final DeprecationHandler deprecationHandler;
    private static final String VALUE_AND_PATH_SUFFIX = "._valueAndPath";
    private static final String VALUE_SUFFIX = "._value";
    private static final String EQUAL_SYMBOL = "=";

    public JsonToStringXContentParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, XContentParser parser, String fieldTypeName) throws IOException {
        super(xContentRegistry, deprecationHandler);
        this.deprecationHandler = deprecationHandler;
        this.xContentRegistry = xContentRegistry;
        this.parser = parser;
        this.fieldTypeName = fieldTypeName;
    }

    public XContentParser parseObject() throws IOException {
        assert (this.currentToken() == XContentParser.Token.START_OBJECT);
        this.parser.nextToken();
        this.builder.startObject();
        LinkedList<String> path = new LinkedList<String>(Collections.singleton(this.fieldTypeName));
        while (this.currentToken() != XContentParser.Token.END_OBJECT) {
            this.parseToken(path, null);
        }
        this.builder.field(this.fieldTypeName, new HashSet<String>(this.keyList));
        this.builder.field(this.fieldTypeName + VALUE_SUFFIX, new HashSet<String>(this.valueList));
        this.builder.field(this.fieldTypeName + VALUE_AND_PATH_SUFFIX, new HashSet<String>(this.valueAndPathList));
        this.builder.endObject();
        String jString = XContentHelper.convertToJson(BytesReference.bytes((XContentBuilder)this.builder), false, MediaTypeRegistry.JSON);
        return JsonXContent.jsonXContent.createParser(this.xContentRegistry, this.deprecationHandler, String.valueOf(jString));
    }

    private boolean parseToken(Deque<String> path, String currentFieldName) throws IOException {
        if (path.size() == 1 && this.processNoNestedValue()) {
            return true;
        }
        boolean isChildrenValueValid = false;
        boolean visitFieldName = false;
        if (this.parser.currentToken() == XContentParser.Token.FIELD_NAME) {
            currentFieldName = this.parser.currentName();
            path.addLast(currentFieldName);
            visitFieldName = true;
            String parts = currentFieldName;
            while (parts.contains(".")) {
                int dotPos = parts.indexOf(46);
                String part = parts.substring(0, dotPos);
                this.keyList.add(part);
                parts = parts.substring(dotPos + 1);
            }
            this.keyList.add(parts);
            this.parser.nextToken();
            isChildrenValueValid = this.parseToken(path, currentFieldName);
            path.removeLast();
        } else if (this.parser.currentToken() == XContentParser.Token.START_ARRAY) {
            this.parser.nextToken();
            while (this.parser.currentToken() != XContentParser.Token.END_ARRAY) {
                isChildrenValueValid |= this.parseToken(path, currentFieldName);
            }
            this.parser.nextToken();
        } else if (this.parser.currentToken() != XContentParser.Token.END_ARRAY) {
            if (this.parser.currentToken() == XContentParser.Token.START_OBJECT) {
                this.parser.nextToken();
                while (this.parser.currentToken() != XContentParser.Token.END_OBJECT) {
                    isChildrenValueValid |= this.parseToken(path, currentFieldName);
                }
                this.parser.nextToken();
            } else {
                String parsedValue = this.parseValue();
                if (parsedValue != null) {
                    this.valueList.add(parsedValue);
                    this.valueAndPathList.add(Strings.collectionToDelimitedString(path, (String)".") + EQUAL_SYMBOL + parsedValue);
                    isChildrenValueValid = true;
                }
                this.parser.nextToken();
            }
        }
        if (visitFieldName && !isChildrenValueValid) {
            this.removeKeyOfNullValue();
        }
        return isChildrenValueValid;
    }

    public void removeKeyOfNullValue() {
        assert (this.keyList.size() > 0);
        this.keyList.remove(this.keyList.size() - 1);
    }

    private boolean processNoNestedValue() throws IOException {
        if (this.parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            return true;
        }
        if (this.parser.currentToken() == XContentParser.Token.VALUE_STRING || this.parser.currentToken() == XContentParser.Token.VALUE_NUMBER || this.parser.currentToken() == XContentParser.Token.VALUE_BOOLEAN) {
            String value = this.parser.textOrNull();
            if (value != null) {
                this.valueList.add(value);
            }
            return true;
        }
        return false;
    }

    private String parseValue() throws IOException {
        switch (this.parser.currentToken()) {
            case VALUE_BOOLEAN: 
            case VALUE_NUMBER: 
            case VALUE_STRING: 
            case VALUE_NULL: {
                return this.parser.textOrNull();
            }
        }
        throw new IOException("Unsupported value token type [" + this.parser.currentToken() + "]");
    }

    public MediaType contentType() {
        return MediaTypeRegistry.JSON;
    }

    public XContentParser.Token nextToken() throws IOException {
        return this.parser.nextToken();
    }

    public void skipChildren() throws IOException {
        this.parser.skipChildren();
    }

    public XContentParser.Token currentToken() {
        return this.parser.currentToken();
    }

    public String currentName() throws IOException {
        return this.parser.currentName();
    }

    public String text() throws IOException {
        return this.parser.text();
    }

    public CharBuffer charBuffer() throws IOException {
        return this.parser.charBuffer();
    }

    public Object objectText() throws IOException {
        return this.parser.objectText();
    }

    public Object objectBytes() throws IOException {
        return this.parser.objectBytes();
    }

    public boolean hasTextCharacters() {
        return this.parser.hasTextCharacters();
    }

    public char[] textCharacters() throws IOException {
        return this.parser.textCharacters();
    }

    public int textLength() throws IOException {
        return this.parser.textLength();
    }

    public int textOffset() throws IOException {
        return this.parser.textOffset();
    }

    public Number numberValue() throws IOException {
        return this.parser.numberValue();
    }

    public XContentParser.NumberType numberType() throws IOException {
        return this.parser.numberType();
    }

    public byte[] binaryValue() throws IOException {
        return this.parser.binaryValue();
    }

    public XContentLocation getTokenLocation() {
        return this.parser.getTokenLocation();
    }

    protected boolean doBooleanValue() throws IOException {
        return this.parser.booleanValue();
    }

    protected short doShortValue() throws IOException {
        return this.parser.shortValue();
    }

    protected int doIntValue() throws IOException {
        return this.parser.intValue();
    }

    protected long doLongValue() throws IOException {
        return this.parser.longValue();
    }

    protected float doFloatValue() throws IOException {
        return this.parser.floatValue();
    }

    protected double doDoubleValue() throws IOException {
        return this.parser.doubleValue();
    }

    protected BigInteger doBigIntegerValue() throws IOException {
        return this.parser.bigIntegerValue();
    }

    public boolean isClosed() {
        return this.parser.isClosed();
    }

    public void close() throws IOException {
        this.parser.close();
    }
}

