/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.compositeindex.datacube;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.opensearch.common.Rounding;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.compositeindex.datacube.Dimension;

@ExperimentalApi
public class DateDimension
implements Dimension {
    private final List<Rounding.DateTimeUnit> calendarIntervals;
    public static final String CALENDAR_INTERVALS = "calendar_intervals";
    public static final String DATE = "date";
    private final String field;

    public DateDimension(String field, List<Rounding.DateTimeUnit> calendarIntervals) {
        this.field = field;
        this.calendarIntervals = calendarIntervals;
    }

    public List<Rounding.DateTimeUnit> getIntervals() {
        return this.calendarIntervals;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("name", this.getField());
        builder.field("type", DATE);
        builder.startArray(CALENDAR_INTERVALS);
        for (Rounding.DateTimeUnit interval : this.calendarIntervals) {
            builder.value(interval.shortName());
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateDimension that = (DateDimension)o;
        return Objects.equals(this.field, that.getField()) && Objects.equals(this.calendarIntervals, that.calendarIntervals);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.calendarIntervals);
    }

    @Override
    public String getField() {
        return this.field;
    }
}

