/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

@PublicApi(since="1.0.0")
public final class Scroll
implements Writeable {
    private final TimeValue keepAlive;

    public Scroll(StreamInput in) throws IOException {
        this.keepAlive = in.readTimeValue();
    }

    public Scroll(TimeValue keepAlive) {
        this.keepAlive = Objects.requireNonNull(keepAlive, "keepAlive must not be null");
    }

    public TimeValue keepAlive() {
        return this.keepAlive;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeTimeValue(this.keepAlive);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scroll scroll = (Scroll)o;
        return Objects.equals(this.keepAlive, scroll.keepAlive);
    }

    public int hashCode() {
        return Objects.hash(this.keepAlive);
    }

    public String toString() {
        return "Scroll{keepAlive=" + this.keepAlive + "}";
    }
}

