/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.deciders;

import java.util.Collection;
import org.opensearch.common.annotation.ExperimentalApi;

@ExperimentalApi
public class ConcurrentSearchDecision {
    private final DecisionStatus decisionStatus;
    private final String decisionReason;

    public ConcurrentSearchDecision(DecisionStatus decisionStatus, String decisionReason) {
        this.decisionStatus = decisionStatus;
        this.decisionReason = decisionReason;
    }

    public DecisionStatus getDecisionStatus() {
        return this.decisionStatus;
    }

    public String getDecisionReason() {
        return this.decisionReason;
    }

    public String toString() {
        return "ConcurrentSearchDecision{decisionStatus=" + this.decisionStatus + ", decisionReason='" + this.decisionReason + "'}";
    }

    public static ConcurrentSearchDecision getCompositeDecision(Collection<ConcurrentSearchDecision> allDecisions) {
        DecisionStatus finalDecisionStatus = DecisionStatus.NO_OP;
        for (ConcurrentSearchDecision decision : allDecisions) {
            switch (decision.decisionStatus) {
                case YES: {
                    finalDecisionStatus = DecisionStatus.YES;
                    break;
                }
                case NO: {
                    finalDecisionStatus = DecisionStatus.NO;
                    return new ConcurrentSearchDecision(finalDecisionStatus, "composite decision evaluated to false due to " + decision.decisionReason);
                }
            }
        }
        return new ConcurrentSearchDecision(finalDecisionStatus, "composite decision result");
    }

    @ExperimentalApi
    public static enum DecisionStatus {
        YES(0),
        NO(1),
        NO_OP(2);

        private final int id;

        private DecisionStatus(int id) {
            this.id = id;
        }
    }
}

