/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;

final class MaxTargetSliceSupplier {
    MaxTargetSliceSupplier() {
    }

    static IndexSearcher.LeafSlice[] getSlices(List<LeafReaderContext> leaves, int targetMaxSlice) {
        if (targetMaxSlice <= 0) {
            throw new IllegalArgumentException("MaxTargetSliceSupplier called with unexpected slice count of " + targetMaxSlice);
        }
        int targetSliceCount = Math.min(targetMaxSlice, leaves.size());
        ArrayList<LeafReaderContext> sortedLeaves = new ArrayList<LeafReaderContext>(leaves);
        sortedLeaves.sort(Collections.reverseOrder(Comparator.comparingInt(l -> l.reader().maxDoc())));
        ArrayList groupedLeaves = new ArrayList(targetSliceCount);
        for (int i = 0; i < targetSliceCount; ++i) {
            groupedLeaves.add(new ArrayList());
        }
        for (int idx = 0; idx < sortedLeaves.size(); ++idx) {
            int currentGroup = idx % targetSliceCount;
            ((List)groupedLeaves.get(currentGroup)).add((LeafReaderContext)sortedLeaves.get(idx));
        }
        return (IndexSearcher.LeafSlice[])groupedLeaves.stream().map(IndexSearcher.LeafSlice::new).toArray(IndexSearcher.LeafSlice[]::new);
    }
}

