/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.wlm;

import java.util.HashMap;
import java.util.Map;
import org.opensearch.core.concurrency.OpenSearchRejectedExecutionException;
import org.opensearch.wlm.stats.QueryGroupState;
import org.opensearch.wlm.stats.QueryGroupStats;

public class QueryGroupService {
    private final Map<String, QueryGroupState> queryGroupStateMap;

    public QueryGroupService() {
        this(new HashMap<String, QueryGroupState>());
    }

    public QueryGroupService(Map<String, QueryGroupState> queryGroupStateMap) {
        this.queryGroupStateMap = queryGroupStateMap;
    }

    public void incrementFailuresFor(String queryGroupId) {
        QueryGroupState queryGroupState = this.queryGroupStateMap.get(queryGroupId);
        if (queryGroupState == null) {
            return;
        }
        queryGroupState.failures.inc();
    }

    public QueryGroupStats nodeStats() {
        HashMap<String, QueryGroupStats.QueryGroupStatsHolder> statsHolderMap = new HashMap<String, QueryGroupStats.QueryGroupStatsHolder>();
        for (Map.Entry<String, QueryGroupState> queryGroupsState : this.queryGroupStateMap.entrySet()) {
            String queryGroupId = queryGroupsState.getKey();
            QueryGroupState currentState = queryGroupsState.getValue();
            statsHolderMap.put(queryGroupId, QueryGroupStats.QueryGroupStatsHolder.from(currentState));
        }
        return new QueryGroupStats(statsHolderMap);
    }

    public void rejectIfNeeded(String queryGroupId) {
        if (queryGroupId == null) {
            return;
        }
        boolean reject = false;
        StringBuilder reason = new StringBuilder();
        if (reject) {
            throw new OpenSearchRejectedExecutionException("QueryGroup " + queryGroupId + " is already contended." + reason.toString());
        }
    }
}

