/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.util;

import io.jsonwebtoken.JwtParserBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import java.security.AccessController;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.SpecialPermission;
import org.opensearch.core.common.Strings;

public class KeyUtils {
    public static JwtParserBuilder createJwtParserBuilderFromSigningKey(final String signingKey, final Logger log) {
        SecurityManager sm = System.getSecurityManager();
        JwtParserBuilder jwtParserBuilder = null;
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        jwtParserBuilder = AccessController.doPrivileged(new PrivilegedAction<JwtParserBuilder>(){

            @Override
            public JwtParserBuilder run() {
                if (Strings.isNullOrEmpty((String)signingKey)) {
                    log.error("Unable to find signing key");
                    return null;
                }
                try {
                    PublicKey key = null;
                    String minimalKeyFormat = signingKey.replace("-----BEGIN PUBLIC KEY-----\n", "").replace("-----END PUBLIC KEY-----", "").trim();
                    byte[] decoded = Base64.getDecoder().decode(minimalKeyFormat);
                    try {
                        key = KeyUtils.getPublicKey(decoded, "RSA");
                    }
                    catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                        log.debug("No public RSA key, try other algos ({})", (Object)e.toString());
                    }
                    try {
                        key = KeyUtils.getPublicKey(decoded, "EC");
                    }
                    catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                        log.debug("No public ECDSA key, try other algos ({})", (Object)e.toString());
                    }
                    if (Objects.nonNull(key)) {
                        return Jwts.parser().verifyWith(key);
                    }
                    return Jwts.parser().verifyWith(Keys.hmacShaKeyFor((byte[])decoded));
                }
                catch (Throwable e) {
                    log.error("Error while creating JWT authenticator", e);
                    throw new OpenSearchSecurityException(e.toString(), new Object[]{e});
                }
            }
        });
        return jwtParserBuilder;
    }

    private static PublicKey getPublicKey(byte[] keyBytes, String algo) throws NoSuchAlgorithmException, InvalidKeySpecException {
        X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
        KeyFactory kf = KeyFactory.getInstance(algo);
        return kf.generatePublic(spec);
    }
}

