#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (c) 2021, Cisco Systems
# GNU General Public License v3.0+ (see LICENSE or https://www.gnu.org/licenses/gpl-3.0.txt)

DOCUMENTATION = r"""
---
module: networks_meraki_auth_users_info
short_description: Information module for networks _merakiauthusers
description:
- Get all networks _merakiauthusers.
- Get networks _merakiauthusers by id.
- >
   List the users configured under Meraki Authentication for a network splash guest or RADIUS users for a wireless
   network, or client VPN users for a MX network .
- Return the Meraki Auth splash guest, RADIUS, or client VPN user.
version_added: '2.16.0'
extends_documentation_fragment:
  - cisco.meraki.module_info
author: Francisco Munoz (@fmunoz)
options:
  headers:
    description: Additional headers.
    type: dict
  networkId:
    description:
    - NetworkId path parameter. Network ID.
    type: str
  merakiAuthUserId:
    description:
    - MerakiAuthUserId path parameter. Meraki auth user ID.
    type: str
requirements:
- meraki >= 2.4.9
- python >= 3.5
seealso:
- name: Cisco Meraki documentation for networks getNetworkMerakiAuthUser
  description: Complete reference of the getNetworkMerakiAuthUser API.
  link: https://developer.cisco.com/meraki/api-v1/#!get-network-meraki-auth-user
- name: Cisco Meraki documentation for networks getNetworkMerakiAuthUsers
  description: Complete reference of the getNetworkMerakiAuthUsers API.
  link: https://developer.cisco.com/meraki/api-v1/#!get-network-meraki-auth-users
notes:
  - SDK Method used are
    networks.Networks.get_network_meraki_auth_user,
    networks.Networks.get_network_meraki_auth_users,

  - Paths used are
    get /networks/{networkId}/merakiAuthUsers,
    get /networks/{networkId}/merakiAuthUsers/{merakiAuthUserId},
"""

EXAMPLES = r"""
- name: Get all networks _merakiauthusers
  cisco.meraki.networks_meraki_auth_users_info:
    meraki_api_key: "{{meraki_api_key}}"
    meraki_base_url: "{{meraki_base_url}}"
    meraki_single_request_timeout: "{{meraki_single_request_timeout}}"
    meraki_certificate_path: "{{meraki_certificate_path}}"
    meraki_requests_proxy: "{{meraki_requests_proxy}}"
    meraki_wait_on_rate_limit: "{{meraki_wait_on_rate_limit}}"
    meraki_nginx_429_retry_wait_time: "{{meraki_nginx_429_retry_wait_time}}"
    meraki_action_batch_retry_wait_time: "{{meraki_action_batch_retry_wait_time}}"
    meraki_retry_4xx_error: "{{meraki_retry_4xx_error}}"
    meraki_retry_4xx_error_wait_time: "{{meraki_retry_4xx_error_wait_time}}"
    meraki_maximum_retries: "{{meraki_maximum_retries}}"
    meraki_output_log: "{{meraki_output_log}}"
    meraki_log_file_prefix: "{{meraki_log_file_prefix}}"
    meraki_log_path: "{{meraki_log_path}}"
    meraki_print_console: "{{meraki_print_console}}"
    meraki_suppress_logging: "{{meraki_suppress_logging}}"
    meraki_simulate: "{{meraki_simulate}}"
    meraki_be_geo_id: "{{meraki_be_geo_id}}"
    meraki_use_iterator_for_get_pages: "{{meraki_use_iterator_for_get_pages}}"
    meraki_inherit_logging_config: "{{meraki_inherit_logging_config}}"
    networkId: string
  register: result

- name: Get networks _merakiauthusers by id
  cisco.meraki.networks_meraki_auth_users_info:
    meraki_api_key: "{{meraki_api_key}}"
    meraki_base_url: "{{meraki_base_url}}"
    meraki_single_request_timeout: "{{meraki_single_request_timeout}}"
    meraki_certificate_path: "{{meraki_certificate_path}}"
    meraki_requests_proxy: "{{meraki_requests_proxy}}"
    meraki_wait_on_rate_limit: "{{meraki_wait_on_rate_limit}}"
    meraki_nginx_429_retry_wait_time: "{{meraki_nginx_429_retry_wait_time}}"
    meraki_action_batch_retry_wait_time: "{{meraki_action_batch_retry_wait_time}}"
    meraki_retry_4xx_error: "{{meraki_retry_4xx_error}}"
    meraki_retry_4xx_error_wait_time: "{{meraki_retry_4xx_error_wait_time}}"
    meraki_maximum_retries: "{{meraki_maximum_retries}}"
    meraki_output_log: "{{meraki_output_log}}"
    meraki_log_file_prefix: "{{meraki_log_file_prefix}}"
    meraki_log_path: "{{meraki_log_path}}"
    meraki_print_console: "{{meraki_print_console}}"
    meraki_suppress_logging: "{{meraki_suppress_logging}}"
    meraki_simulate: "{{meraki_simulate}}"
    meraki_be_geo_id: "{{meraki_be_geo_id}}"
    meraki_use_iterator_for_get_pages: "{{meraki_use_iterator_for_get_pages}}"
    meraki_inherit_logging_config: "{{meraki_inherit_logging_config}}"
    networkId: string
    merakiAuthUserId: string
  register: result

"""
RETURN = r"""
meraki_response:
  description: A dictionary or list with the response returned by the Cisco Meraki Python SDK
  returned: always
  type: dict
  sample: >
    {
      "accountType": "string",
      "authorizations": [
        {
          "authorizedByEmail": "string",
          "authorizedByName": "string",
          "authorizedZone": "string",
          "expiresAt": "string",
          "ssidNumber": 0
        }
      ],
      "createdAt": "string",
      "email": "string",
      "id": "string",
      "isAdmin": true,
      "name": "string"
    }
"""
