/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class XmlUtil {
    public static final int DEFAULT_INDENTATION_SIZE = 2;
    public static final String DEFAULT_LINE_SEPARATOR = System.getProperty("line.separator");

    public static boolean isXml(File f) {
        boolean bl;
        block10: {
            if (f == null) {
                throw new IllegalArgumentException("f could not be null.");
            }
            if (!f.isFile()) {
                throw new IllegalArgumentException("The file '" + f.getAbsolutePath() + "' is not a file.");
            }
            XmlStreamReader reader2 = ReaderFactory.newXmlReader(f);
            try {
                MXParser parser = new MXParser();
                parser.setInput(reader2);
                parser.nextToken();
                bl = true;
                if (reader2 == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader2 != null) {
                        try {
                            ((Reader)reader2).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e2) {
                    return false;
                }
            }
            ((Reader)reader2).close();
        }
        return bl;
    }

    public static void prettyFormat(Reader reader2, Writer writer2) throws IOException {
        XmlUtil.prettyFormat(reader2, writer2, 2, DEFAULT_LINE_SEPARATOR);
    }

    public static void prettyFormat(Reader reader2, Writer writer2, int indentSize, String lineSeparator) throws IOException {
        if (reader2 == null) {
            throw new IllegalArgumentException("The reader is null");
        }
        if (writer2 == null) {
            throw new IllegalArgumentException("The writer is null");
        }
        if (indentSize < 0) {
            indentSize = 0;
        }
        PrettyPrintXMLWriter xmlWriter = new PrettyPrintXMLWriter(writer2);
        xmlWriter.setLineIndenter(StringUtils.repeat(" ", indentSize));
        xmlWriter.setLineSeparator(lineSeparator);
        MXParser parser = new MXParser();
        try {
            parser.setInput(reader2);
            XmlUtil.prettyFormatInternal(parser, xmlWriter);
        }
        catch (XmlPullParserException e2) {
            throw new IOException("Unable to parse the XML: " + e2.getMessage());
        }
    }

    public static void prettyFormat(InputStream is2, OutputStream os) throws IOException {
        XmlUtil.prettyFormat(is2, os, 2, DEFAULT_LINE_SEPARATOR);
    }

    public static void prettyFormat(InputStream is2, OutputStream os, int indentSize, String lineSeparator) throws IOException {
        if (is2 == null) {
            throw new IllegalArgumentException("The is is null");
        }
        if (os == null) {
            throw new IllegalArgumentException("The os is null");
        }
        if (indentSize < 0) {
            indentSize = 0;
        }
        try (XmlStreamReader reader2 = ReaderFactory.newXmlReader(is2);
             OutputStreamWriter writer2 = new OutputStreamWriter(os);){
            PrettyPrintXMLWriter xmlWriter = new PrettyPrintXMLWriter(writer2);
            xmlWriter.setLineIndenter(StringUtils.repeat(" ", indentSize));
            xmlWriter.setLineSeparator(lineSeparator);
            MXParser parser = new MXParser();
            parser.setInput(reader2);
            XmlUtil.prettyFormatInternal(parser, xmlWriter);
        }
        catch (XmlPullParserException e2) {
            throw new IOException("Unable to parse the XML: " + e2.getMessage());
        }
    }

    private static void prettyFormatInternal(XmlPullParser parser, PrettyPrintXMLWriter writer2) throws XmlPullParserException, IOException {
        boolean hasTag = false;
        boolean hasComment = false;
        int eventType = parser.getEventType();
        while (eventType != 1) {
            int i;
            if (eventType == 2) {
                hasTag = true;
                if (hasComment) {
                    writer2.writeText(writer2.getLineIndenter());
                    hasComment = false;
                }
                writer2.startElement(parser.getName());
                for (i = 0; i < parser.getAttributeCount(); ++i) {
                    String key2 = parser.getAttributeName(i);
                    String value = parser.getAttributeValue(i);
                    writer2.addAttribute(key2, value);
                }
            } else if (eventType == 4) {
                String text = parser.getText();
                if (!text.trim().equals("")) {
                    text = StringUtils.removeDuplicateWhitespace(text);
                    writer2.writeText(text);
                }
            } else if (eventType == 3) {
                hasTag = false;
                writer2.endElement();
            } else if (eventType == 9) {
                hasComment = true;
                if (!hasTag) {
                    writer2.writeMarkup(writer2.getLineSeparator());
                    for (i = 0; i < writer2.getDepth(); ++i) {
                        writer2.writeMarkup(writer2.getLineIndenter());
                    }
                }
                writer2.writeMarkup("<!--" + parser.getText().trim() + " -->");
                if (!hasTag) {
                    writer2.writeMarkup(writer2.getLineSeparator());
                    for (i = 0; i < writer2.getDepth() - 1; ++i) {
                        writer2.writeMarkup(writer2.getLineIndenter());
                    }
                }
            } else if (eventType == 10) {
                writer2.writeMarkup("<!DOCTYPE" + parser.getText() + ">");
                writer2.endOfLine();
            } else if (eventType == 8) {
                writer2.writeMarkup("<?" + parser.getText() + "?>");
                writer2.endOfLine();
            } else if (eventType == 5) {
                writer2.writeMarkup("<![CDATA[" + parser.getText() + "]]>");
            } else if (eventType == 6) {
                writer2.writeMarkup("&" + parser.getName() + ";");
            }
            eventType = parser.nextToken();
        }
    }
}

