/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Map;
import org.eclipse.jetty.client.AbstractHttpClientTransport;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.io.SocketChannelEndPoint;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject
public abstract class AbstractConnectorHttpClientTransport
extends AbstractHttpClientTransport {
    private final int selectors;
    private SelectorManager selectorManager;

    protected AbstractConnectorHttpClientTransport(int selectors) {
        this.selectors = selectors;
    }

    @ManagedAttribute(value="The number of selectors", readonly=true)
    public int getSelectors() {
        return this.selectors;
    }

    @Override
    protected void doStart() throws Exception {
        HttpClient httpClient = this.getHttpClient();
        this.selectorManager = this.newSelectorManager(httpClient);
        this.selectorManager.setConnectTimeout(httpClient.getConnectTimeout());
        this.addBean(this.selectorManager);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.removeBean(this.selectorManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(InetSocketAddress address, Map<String, Object> context) {
        SocketChannel channel = null;
        try {
            channel = SocketChannel.open();
            HttpDestination destination = (HttpDestination)context.get("http.destination");
            HttpClient client2 = destination.getHttpClient();
            SocketAddress bindAddress = client2.getBindAddress();
            if (bindAddress != null) {
                channel.bind(bindAddress);
            }
            this.configure(client2, channel);
            context.put("ssl.peer.host", address.getHostString());
            context.put("ssl.peer.port", address.getPort());
            boolean connected = true;
            if (client2.isConnectBlocking()) {
                channel.socket().connect(address, (int)client2.getConnectTimeout());
                channel.configureBlocking(false);
            } else {
                channel.configureBlocking(false);
                connected = channel.connect(address);
            }
            if (connected) {
                this.selectorManager.accept(channel, context);
            } else {
                this.selectorManager.connect(channel, context);
            }
        }
        catch (Throwable x) {
            if (x.getClass() == SocketException.class) {
                x = new SocketException("Could not connect to " + address).initCause(x);
            }
            try {
                if (channel != null) {
                    channel.close();
                }
            }
            catch (IOException ignored) {
                LOG.ignore(ignored);
            }
            finally {
                this.connectFailed(context, x);
            }
        }
    }

    protected void connectFailed(Map<String, Object> context, Throwable x) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Could not connect to {}", context.get("http.destination"));
        }
        Promise promise2 = (Promise)context.get("http.connection.promise");
        promise2.failed(x);
    }

    protected void configure(HttpClient client2, SocketChannel channel) throws IOException {
        channel.socket().setTcpNoDelay(client2.isTCPNoDelay());
    }

    protected SelectorManager newSelectorManager(HttpClient client2) {
        return new ClientSelectorManager(client2, this.getSelectors());
    }

    protected SelectorManager getSelectorManager() {
        return this.selectorManager;
    }

    protected class ClientSelectorManager
    extends SelectorManager {
        private final HttpClient client;

        protected ClientSelectorManager(HttpClient client2, int selectors) {
            super(client2.getExecutor(), client2.getScheduler(), selectors);
            this.client = client2;
        }

        @Override
        protected EndPoint newEndPoint(SelectableChannel channel, ManagedSelector selector, SelectionKey key2) {
            SocketChannelEndPoint endp = new SocketChannelEndPoint(channel, selector, key2, this.getScheduler());
            endp.setIdleTimeout(this.client.getIdleTimeout());
            return endp;
        }

        @Override
        public Connection newConnection(SelectableChannel channel, EndPoint endPoint, Object attachment) throws IOException {
            Map context = (Map)attachment;
            HttpDestination destination = (HttpDestination)context.get("http.destination");
            return destination.getClientConnectionFactory().newConnection(endPoint, context);
        }

        @Override
        protected void connectionFailed(SelectableChannel channel, Throwable x, Object attachment) {
            Map context = (Map)attachment;
            AbstractConnectorHttpClientTransport.this.connectFailed(context, x);
        }
    }
}

