import { isIdentifierNode } from "../index.js";
import { findNodeAtOffset } from "../checker.js";
import { syntaxNodesToRanges, syntaxNodeToRange } from "./util.js";
export function findReferences(doc, sourceFile, position, context) {
    if (!sourceFile.symbols)
        throw "sourceFile is not bound";
    const g = sourceFile.graph;
    if (!g)
        return [];
    const offset = doc.offsetAt(position);
    const node = findNodeAtOffset(g, offset);
    if (!node)
        return [];
    if (isIdentifierNode(node)) {
        const nodeSymbol = node.symbol;
        if (!nodeSymbol)
            throw "node.symbol is not bound";
        const refs = nodeSymbol.references || [];
        let symbolRefs;
        if (context.includeDeclaration) {
            symbolRefs = [nodeSymbol.firstMention, ...refs];
        }
        else {
            if (nodeSymbol.firstMention === node) {
                symbolRefs = refs;
            }
            else {
                symbolRefs = [
                    nodeSymbol.firstMention,
                    ...refs.filter(r => r !== node),
                ];
            }
        }
        const ranges = syntaxNodesToRanges(doc, sourceFile, symbolRefs);
        const uri = doc.uri;
        return ranges.map(range => {
            return { uri, range };
        });
    }
    debugger;
    return [];
}
export function findDefinition(doc, sourceFile, position) {
    if (!sourceFile.symbols)
        throw "sourceFile is not bound";
    const g = sourceFile.graph;
    if (!g)
        return undefined;
    const offset = doc.offsetAt(position);
    const node = findNodeAtOffset(g, offset);
    if (!node)
        return undefined;
    if (isIdentifierNode(node)) {
        const nodeSymbol = node.symbol;
        if (!nodeSymbol)
            throw "node.symbol is not bound";
        const firstMention = nodeSymbol.firstMention;
        if (!firstMention)
            return undefined;
        const range = syntaxNodeToRange(doc, sourceFile, firstMention);
        return { uri: doc.uri, range };
    }
    debugger;
    return undefined;
}
//# sourceMappingURL=reference.js.map