import { TextDocument } from "vscode-languageserver-textdocument";
import { Parser } from "./parser.js";
import { bindSourceFile } from "./binder.js";
import { checkSourceFile } from "./checker.js";
import { getCompletions } from "./service/completion.js";
const text = `graph {
	node_name_a -- node_name_b [color=blue,
	];
}`;
function main() {
    const parser = new Parser();
    const sf = parser.parse(text);
    bindSourceFile(sf);
    checkSourceFile(sf);
    const doc = TextDocument.create("inmemory://model.json", "DOT", 0, text);
    const requestOffset = text.indexOf("color=blue,\n\t") + "color=blue,\n\t".length;
    const completions = getCompletions(doc, sf, doc.positionAt(requestOffset));
    console.dir(completions);
}
main();
//# sourceMappingURL=tester.js.map